/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.export;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import sun.tools.debug.DebugPassword;

public class Kicker {
    public static int DEBUG_ATTACH_TIMEOUT = 600;
    public static final int OK = 0;
    public static final int DEBUG_ERR_NONAME = -1;
    public static final int DEBUG_ERR_NOPROCESS = -2;
    public static final int DEBUG_ERR_NOATTACH = -3;
    public static final int DEBUG_ERR_ARGMISMATCH = -4;
    public static final int DEBUG_ERR_NOIPADDR = -5;
    public static final int DEBUG_ERR_NOTSTARTED = -6;
    public static final int DEBUG_ERR_NOARGS = -7;
    public static final int DEBUG_ERR_BADJVM = -8;
    public static final int DEBUG_FLOW_DEBUG = 1;
    public static final int DEBUG_FLOW_PASSTHRU = 0;
    public static final int DEBUG_FLOW_UNKNOWN = -1;
    public static boolean _remoteClientAttached;
    public static final int UIDAEMONVERSIONID = -1;
    public static final String JVMHOSTPORTPARM = "jvmhostport";
    public boolean _debug_attached = false;
    public int _debug_value;
    public int _thd_current = 0;
    public int _thd_being_debugged = 0;
    public static String _jvmHost;
    public static String _agentPassword;
    public static String _remoteAttachHost;
    public static String _remoteAttachPort;
    public static String _engineHost;
    public static BufferedReader debuggerReader;
    public static boolean _traceOutput;
    public static Kicker _kickerRef;
    public boolean _debug_engine_isrunning = false;
    public static boolean _remoteAttachClientMode;
    public static String _remoteAttachClientHost;
    public static String _remoteAttachClientPort;

    public Kicker() {
        if (System.getProperty("DER_trace") != null) {
            _traceOutput = true;
        }
    }

    public static synchronized int _debug_attach(String string2) {
        Kicker.debugOutput("calling new version of Kicker");
        if (!_remoteClientAttached && !Kicker._kickerRef._debug_attached && Kicker.chkForAttachMode()) {
            Kicker.getProperties();
            return Kicker.connectToRemoteClient();
        }
        if (_remoteClientAttached) {
            return 0;
        }
        if (!Kicker._kickerRef._debug_attached) {
            Kicker.getProperties();
            try {
                if (System.getProperty("com.ibm.debug.remote_kicker") == null) {
                    Kicker.debugOutput("launching JDE...");
                    if (!Kicker._debug_startEngine(string2)) {
                        return -6;
                    }
                } else {
                    Kicker.connectUIDaemonDirect();
                }
            }
            catch (Exception exception) {
                return -8;
            }
            try {
                int n10 = DEBUG_ATTACH_TIMEOUT;
                while (n10-- > 0) {
                    Kicker.debugOutput("Waiting for engine to connect. timeout =" + n10);
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    if (Kicker._kickerRef._debug_attached) {
                        Kicker.debugOutput("Debug engine attached");
                    } else {
                        if (_kickerRef.is_debug_engine_isrunning()) continue;
                        Kicker.debugOutput("Debug engine failed before it attached");
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {}
            if (!Kicker._kickerRef._debug_attached || !_kickerRef.is_debug_engine_isrunning()) {
                return -3;
            }
        }
        Kicker._kickerRef._thd_current = Thread.currentThread().hashCode();
        Kicker.debugOutput("successful return from _debug_attach");
        return 0;
    }

    public static synchronized int _debug_attach(String string2, String string3, String string4) {
        String string5 = "";
        _remoteAttachHost = string2;
        _remoteAttachPort = string3;
        string5 = string2 != null && !string2.equals("") ? String.valueOf(string5) + " -qhost=" + string2 : String.valueOf(string5) + " -qhost=localhost";
        string5 = string3 != null && !string3.equals("") ? String.valueOf(string5) + " -quiport=" + string3 : String.valueOf(string5) + " -quiport=8001";
        if (string4 != null && !string4.equals("")) {
            string5 = String.valueOf(string5) + " -qpid=" + string4;
        }
        if (_jvmHost != null && !_jvmHost.equals("") && string4 != null && !string4.equals("")) {
            string5 = String.valueOf(string5) + " -qtitle=" + _jvmHost + ":" + string4;
        }
        Kicker.debugOutput("_debug_attach() args=" + string5);
        return Kicker._debug_attach(string5);
    }

    public static synchronized int _debug_attached() {
        Kicker.debugOutput("_debug_attached() attached=" + Kicker._kickerRef._debug_attached);
        return Kicker._kickerRef._debug_attached ? 1 : 0;
    }

    public static synchronized void _debug_detach() {
        Kicker.debugOutput("_debug_detach()");
        Kicker.debug_detach();
    }

    public static String _debug_getEngineCommand(String string2) {
        String string3;
        String string4;
        String string5;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer(" -host=");
        stringBuffer3.append(_jvmHost);
        stringBuffer3.append(" -password=");
        stringBuffer3.append(_agentPassword);
        if (_engineHost != null && _engineHost.length() > 0) {
            stringBuffer3.append(" -qenginehost=");
            stringBuffer3.append(_engineHost);
        }
        if (string2 != null) {
            stringBuffer3.append(' ');
            stringBuffer3.append(string2);
            stringBuffer3.append(" -s");
        }
        String string6 = System.getProperty("os.name");
        String string7 = System.getProperty("JT_HOST");
        if (string7 != null && string7.length() > 0) {
            stringBuffer.append(" +DJT_HOST=");
            stringBuffer.append(string7);
        }
        if (_traceOutput || stringBuffer.length() != 0) {
            string5 = System.getProperty("file.separator");
            string4 = System.getProperty("user.home");
            stringBuffer2.append(" +DJT_EVT=1 -dbg=");
            if (string6.startsWith("Windows")) {
                if (string4.endsWith("\\")) {
                    stringBuffer2.append(String.valueOf('\"') + string4 + "debug_java.log" + '\"');
                } else {
                    stringBuffer2.append(String.valueOf('\"') + string4 + string5 + "debug_java.log" + '\"');
                }
            } else {
                stringBuffer2.append(String.valueOf(string4) + string5 + "debug_java.log");
            }
        }
        if ((string5 = System.getProperty("java.home")) != null) {
            stringBuffer2.append(" -qjavahome=");
            if (string6.startsWith("Windows")) {
                stringBuffer2.append('\"');
                stringBuffer2.append(string5);
                stringBuffer2.append('\"');
            } else {
                stringBuffer2.append(string5);
            }
        }
        if ((string4 = System.getProperty("sun.boot.class.path")) != null) {
            stringBuffer2.append(" -qbootclasspath=");
            if (string6.startsWith("Windows")) {
                stringBuffer2.append('\"');
                stringBuffer2.append(string4);
                stringBuffer2.append('\"');
            } else {
                stringBuffer2.append(string4);
            }
        }
        if ((string3 = System.getProperty("env.class.path")) != null) {
            stringBuffer2.append(" -qsourcepath=");
            if (string6.startsWith("Windows")) {
                stringBuffer2.append('\"');
                stringBuffer2.append(string3);
                stringBuffer2.append('\"');
            } else {
                stringBuffer2.append(string3);
            }
        }
        StringBuffer stringBuffer4 = string6.startsWith("Windows") ? new StringBuffer("cmd /c start /wait irmtdbgj") : new StringBuffer("irmtdbgj");
        if (stringBuffer.length() > 0) {
            stringBuffer4.append(stringBuffer.toString());
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer4.append(stringBuffer2.toString());
        }
        stringBuffer4.append(stringBuffer3.toString());
        Kicker.debugOutput("cmd = " + stringBuffer4.toString());
        return stringBuffer4.toString();
    }

    public static synchronized void _debug_resume(int n10, int n11, int n12) {
        Kicker.debugOutput("_debug_resume() call_depth=" + n10 + " initial=" + n11 + " return=" + n12);
        if (Kicker._kickerRef._thd_being_debugged != 0 && Thread.currentThread().hashCode() != Kicker._kickerRef._thd_being_debugged) {
            Kicker.debugOutput("wrong thread, returning");
            return;
        }
        Kicker._kickerRef._thd_current = Thread.currentThread().hashCode();
        Kicker.debug_resume(n10, n11, n12);
    }

    public static synchronized void _debug_start(int n10) {
        Kicker.debugOutput("_debug_start() call_depth=" + n10);
        Kicker._kickerRef._thd_current = Thread.currentThread().hashCode();
        Kicker.debug_start(n10);
    }

    public static synchronized void _debug_startabs(String string2, String string3) {
        Kicker.debugOutput("_debug_startabs() cls=" + string2 + " mtd=" + string3);
        Kicker._kickerRef._thd_current = Thread.currentThread().hashCode();
        Kicker.debug_startabs(string2, string3);
    }

    public static boolean _debug_startEngine(String string2) {
        ss ss2 = new ss(Kicker._debug_getEngineCommand(string2));
        if (ss2 == null) {
            return false;
        }
        ss2.setDaemon(true);
        ss2.setName("EngineStarter");
        Kicker.debugOutput("Start engine monitor thread");
        ss2.start();
        Kicker.debugOutput("Engine monitor thread started");
        return true;
    }

    public static synchronized int _debug_stop(int n10) {
        Kicker.debugOutput("_debug_stop() call_depth=" + n10);
        Object var1_1 = null;
        Kicker._kickerRef._debug_value = -1;
        Kicker.debug_stop(n10);
        return Kicker._kickerRef._debug_value;
    }

    public static synchronized int _debug_suspend(int n10) {
        Kicker.debugOutput("_debug_suspend() call_depth=" + n10);
        if (Thread.currentThread().hashCode() != Kicker._kickerRef._thd_being_debugged) {
            Kicker.debugOutput("wrong thread, returning");
            return -1;
        }
        Object var1_1 = null;
        Kicker._kickerRef._debug_value = -1;
        Kicker.debug_suspend(n10);
        return Kicker._kickerRef._debug_value;
    }

    public static synchronized void debug_detach() {
    }

    public static synchronized void debug_resume(int n10, int n11, int n12) {
    }

    public static synchronized void debug_start(int n10) {
    }

    public static synchronized void debug_startabs(String string2, String string3) {
    }

    public static synchronized void debug_stop(int n10) {
    }

    public static synchronized void debug_suspend(int n10) {
    }

    private static synchronized void debugOutput(String string2) {
        if (_traceOutput) {
            System.out.println("KICKER> (" + Thread.currentThread().getName() + ") (" + Thread.currentThread().hashCode() + ") " + string2);
        }
    }

    public boolean is_debug_engine_isrunning() {
        return this._debug_engine_isrunning;
    }

    public void set_debug_engine_isrunning(boolean bl2) {
        this._debug_engine_isrunning = bl2;
    }

    public static synchronized void setHostAndPassword(String string2, String string3) {
    }

    public static synchronized void _debug_breakpoint() {
        Kicker._debug_start(0);
    }

    private static synchronized int writeAsciiString(ByteArrayOutputStream byteArrayOutputStream, String string2) {
        byte[] byArray;
        try {
            byArray = string2.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string2.getBytes();
            Kicker.debugOutput("Warning: ascii encoding is not supported on this platform!");
        }
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        return byArray.length;
    }

    private static void connectUIDaemonDirect() throws Exception {
        Socket socket = new Socket(_remoteAttachHost, Integer.parseInt(_remoteAttachPort));
        OutputStream outputStream = socket.getOutputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n10 = 0;
        n10 += Kicker.writeAsciiString(byteArrayOutputStream, "\n");
        n10 += Kicker.writeAsciiString(byteArrayOutputStream, "\n");
        n10 += Kicker.writeAsciiString(byteArrayOutputStream, "\n");
        n10 += Kicker.writeAsciiString(byteArrayOutputStream, "5\n");
        n10 += Kicker.writeAsciiString(byteArrayOutputStream, "-a0\n");
        n10 += Kicker.writeAsciiString(byteArrayOutputStream, "-qengine=java\n");
        n10 += Kicker.writeAsciiString(byteArrayOutputStream, "-host=" + _jvmHost + "\n");
        n10 += Kicker.writeAsciiString(byteArrayOutputStream, "-password=" + _agentPassword + "\n");
        byte[] byArray = new byte[4];
        short s10 = (short)(n10 += Kicker.writeAsciiString(byteArrayOutputStream, "-s\n"));
        short s11 = (short)(n10 >> 16);
        byArray[3] = (byte)s10;
        byArray[2] = (byte)(s10 >> 8);
        byArray[1] = (byte)s11;
        byArray[0] = (byte)(s11 >> 8);
        outputStream.write(byArray, 0, 4);
        byteArrayOutputStream.writeTo(outputStream);
        outputStream.flush();
        socket.close();
        _kickerRef.set_debug_engine_isrunning(true);
    }

    private static boolean chkForAttachMode() {
        String string2 = System.getProperty("com.ibm.debug.remoteattach");
        if (string2 != null && string2 != "") {
            Kicker.debugOutput("remoteAttach property = >" + string2 + "<");
            int n10 = string2.indexOf(58);
            if (n10 == 0) {
                _remoteAttachClientHost = "localhost";
                _remoteAttachClientPort = string2.substring(1, string2.length());
            } else if (n10 > 1) {
                _remoteAttachClientHost = string2.substring(0, n10);
                _remoteAttachClientPort = string2.substring(n10 + 1, string2.length());
            } else {
                _remoteAttachClientMode = false;
                return _remoteAttachClientMode;
            }
            _remoteAttachClientMode = true;
        } else {
            _remoteAttachClientMode = false;
        }
        if (_remoteAttachClientMode) {
            Kicker.debugOutput("Host = >" + _remoteAttachClientHost + ":" + _remoteAttachClientPort + "<");
        }
        return _remoteAttachClientMode;
    }

    private static int connectToRemoteClient() {
        Kicker.debugOutput("Attached already? " + _remoteClientAttached);
        if (!_remoteClientAttached) {
            Socket socket = null;
            try {
                Kicker.debugOutput("Establish connection with remote client");
                socket = new Socket(_remoteAttachClientHost, Integer.parseInt(_remoteAttachClientPort));
                DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                Kicker.debugOutput("Connected to remote client");
                Kicker.debugOutput("Version is " + -1);
                dataOutputStream.writeInt(-1);
                dataOutputStream.writeInt(1);
                dataOutputStream.writeUTF(JVMHOSTPORTPARM);
                dataOutputStream.writeUTF(String.valueOf(_jvmHost) + ":" + _agentPassword);
                socket.setSoTimeout(10000);
                Kicker.debugOutput("waiting for client to respond");
                int n10 = dataInputStream.readInt();
                int n11 = dataInputStream.readInt();
                Kicker.debugOutput("Number of return code parms =" + n11);
                int n12 = 0;
                while (n12 < n11) {
                    Kicker.debugOutput("Return parm name =" + dataInputStream.readUTF());
                    Kicker.debugOutput("Return parm value =" + dataInputStream.readUTF());
                    ++n12;
                }
                socket.close();
                if (n10 != 0) {
                    Kicker.debugOutput("Return code from debug client is " + n10);
                    return -3;
                }
                _remoteClientAttached = true;
            }
            catch (InterruptedIOException interruptedIOException) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
                Kicker.debugOutput("client didn't respond in time, ending connection");
                return -3;
            }
            catch (Exception exception) {
                try {
                    socket.close();
                }
                catch (Exception exception2) {}
                Kicker.debugOutput("failed to connect remote debug client");
                return -3;
            }
        }
        return 0;
    }

    private static void getProperties() {
        block6: {
            Object object;
            String string2;
            String string3 = System.getProperty("java.version");
            Kicker.debugOutput("java.version = " + string3);
            _agentPassword = string3.startsWith("1.1.") ? DebugPassword.getAgentPassword() : ((string2 = System.getProperty("com.ibm.debug.jdwpport")) != null && string2.length() != 0 ? string2 : (string3.startsWith("1.2.") ? sun.tools.agent.DebugPassword.getAgentPassword() : null));
            Kicker.debugOutput("port/password is: " + _agentPassword);
            string2 = System.getProperty("com.ibm.debug.localhost");
            if (string2 != null && string2.length() != 0) {
                Kicker.debugOutput("local host is: " + string2);
                _jvmHost = string2;
                _engineHost = string2;
            } else {
                try {
                    object = InetAddress.getLocalHost();
                    _jvmHost = object != null ? ((InetAddress)object).getHostAddress() : "localhost";
                }
                catch (UnknownHostException unknownHostException) {
                    _jvmHost = "localhost";
                }
            }
            object = System.getProperty("ATTACH_TIMEOUT");
            if (object == null || ((String)object).equals("")) break block6;
            try {
                DEBUG_ATTACH_TIMEOUT = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                DEBUG_ATTACH_TIMEOUT = 600;
            }
        }
    }

    static {
        _kickerRef = new Kicker();
    }
}

