/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.model;

import com.ibm.debug.model.DebuggeeException;
import com.ibm.debug.model.DebuggeeProcess;
import com.ibm.debug.model.Language;
import com.ibm.debug.model.Model;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DebugEngine
extends av {
    public boolean _dateBreakpointsEnabled = false;
    public boolean _entryBreakpointsAutoSetEnabled = false;
    public String _localSourcePath;
    public boolean _isLoaded = false;
    public boolean _hasBeenInitialized = false;
    public au _host;
    public a5 _connection;
    public bd _EPDCReplyProcessor;
    public Thread _EPDCReplyProcessorThread;
    public DebuggeeProcess _process;
    public Vector _viewsByType = new Vector();
    public eb[] _supportedViews;
    public Vector _eventListeners = new Vector();
    public aw _replySemaphore;
    public aw _lockSemaphore = new aw();
    public aw _requestSemaphore = new aw(1);
    public ba _mostRecentReply;
    public az _currentLock;
    public a3 _eventManager = new a3();
    public Thread _callbackThread;
    public ek _capabilities;
    public ax _mostRecentRequest;
    public akk _currentClient;
    public d0 _privilegedListener;
    public Vector _languages = new Vector();
    public ec[] _repNames;
    public DebuggeeException[] _exceptionInfo;
    public Vector _stackDetailColumns;
    public Vector _registerGroups;
    public int _numberOfStackDetailColumns;
    public int _numberOfRegisterGroups;
    public s7[] _processListColumnDetails;
    public gw _debuggeeStartupOptions;
    public static tm _debuggeeStartupController = new tm();
    public static Hashtable _engineSpecificRestorableObjects = new Hashtable();
    public static final char[] _engineTypeMnemonics = new char[8];
    public a8 _errorOccurredEventForFileNotFound;
    public a1 _idleEvent;
    public short _engineID;
    public short _platformID;
    public byte _dominantLanguage;
    public boolean _saveAndRestoreExceptionFilters = false;
    public int _changeFlags;
    public static final int DEFAULT_DATA_REPRESENTATIONS_HAVE_CHANGED = 0x2000000;
    public static final int EXCEPTION_FILTERS_HAVE_CHANGED = 0x1000000;
    public byte _stateFlags;
    public transient st _engineSession = new st();
    public static final int MIN_SUPPORTED_EPDC_VERSION = 305;
    public static final int MAX_SUPPORTED_EPDC_VERSION = 307;
    public int _maximumViewFileCacheSize = 500;
    public static final byte debugEngineIsBusyFlag = 1;
    public static final byte modelIsBeingUpdatedFlag = 2;
    public static final byte queuedEventsAreBeingFiredFlag = 4;
    public static final byte savedObjectsAreBeingRestoredFlag = 8;
    public static final int sendReceiveDefault = 0;
    public static final int sendReceiveSynchronously = 1;
    public static final int sendReceiveDoNotProcessReply = 2;
    public static final int sendReceiveCallerWillCompleteModelUpdates = 4;

    public DebugEngine(au au2) {
        this._host = au2;
        au2.a(this);
    }

    public void connect(ks ks2, boolean bl2) throws IOException {
        a5 a52 = ks2.c();
        if (a52 != null) {
            this.setConnection(a52);
        } else {
            this.setConnection(ks2.a(a5.a, bl2));
        }
        this.connection().a();
    }

    public void connect(ks ks2) throws IOException {
        this.connect(ks2, false);
    }

    public short getEngineID() {
        return this._engineID;
    }

    public short getPlatformID() {
        return this._platformID;
    }

    public void addEventListener(d1 d12) {
        this._eventListeners.addElement(d12);
    }

    public void removeEventListener(d1 d12) {
        int n10;
        if (Model.b()) {
            Model.b.c(1, "DebugEngine.removeEventListener(" + d12 + ")");
        }
        if ((n10 = this._eventListeners.indexOf(d12)) != -1) {
            try {
                this._eventListeners.setElementAt(null, n10);
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
        }
    }

    public au host() {
        return this._host;
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public void setIsLoaded(boolean bl2) {
        this._isLoaded = bl2;
    }

    public DebuggeeProcess process() {
        return this._process;
    }

    public void handleError(int n10, String string2) {
        ax ax2;
        if (this.savedObjectsAreBeingRestored() && Model.f()) {
            return;
        }
        Vector<d5> vector = this._eventListeners;
        if (n10 == 322) {
            if (this._mostRecentReply instanceof cl) {
                if (Model.c()) {
                    vector = new Vector<d5>(1);
                    vector.addElement((d5)((Object)new dz()));
                }
            } else if (this._mostRecentRequest instanceof nf && Model.d()) {
                vector = new Vector(1);
                vector.addElement((d5)((Object)new d4()));
            }
        } else if (n10 == 329 || n10 == 126) {
            if (Model.b() && n10 == 329) {
                Model.b.d(1, "ERROR!!! Engine does not support UTF-8 encoded EStdStrings.");
            }
            vector.addElement(new d5());
        } else if (this._mostRecentRequest instanceof sz || this._mostRecentRequest instanceof s2 || this._mostRecentRequest instanceof s4) {
            vector.addElement(new d5());
        } else if (n10 == 7 && (ax2 = this.getMostRecentRequest()) instanceof px) {
            a8 a82 = new a8((Object)this, n10, string2, this._mostRecentReply.c());
            this.saveErrorOccurredEventForFileNotFound(a82);
            return;
        }
        this._eventManager.a(new a8((Object)this, n10, string2, this._mostRecentReply.c()), vector);
    }

    public void sendMessage(String string2) {
        if (this.savedObjectsAreBeingRestored() && Model.g()) {
            return;
        }
        this._eventManager.a(new g1(this, string2, this._mostRecentReply.c()), this._eventListeners);
    }

    public void add(DebuggeeProcess debuggeeProcess) {
        this.addEventListener(_debuggeeStartupController);
        this._process = debuggeeProcess;
        this._eventManager.a(new ed(this, debuggeeProcess, this._mostRecentReply.c()), this._eventListeners);
    }

    public void remove(DebuggeeProcess debuggeeProcess) {
        debuggeeProcess.prepareToDie();
        this._process = null;
    }

    public void setConnection(a5 a52) {
        this._connection = a52;
    }

    public a5 connection() {
        return this._connection;
    }

    public boolean initialize(byte by2, String string2, String string3, String string4, int n10) throws IOException {
        int n11 = 66;
        if (!this.prepareForEPDCRequest(n11, 1)) {
            if (Model.b()) {
                Model.b.d(4, String.valueOf(this) + ".initialize() fails in DebugEngine.prepareForEPDCRequest(Remote_Initialize_Debug_Engine)");
            }
            return false;
        }
        if (this._hasBeenInitialized) {
            if (Model.b()) {
                Model.b.d(4, String.valueOf(this) + " has been initialized");
            }
            this.cancelEPDCRequest(n11);
            return false;
        }
        if (this._EPDCReplyProcessor == null && this._isLoaded && this._connection != null) {
            this._replySemaphore = new aw();
            this._EPDCReplyProcessor = new bd(this, this._replySemaphore, this._engineSession);
            this._EPDCReplyProcessorThread = new Thread(this._EPDCReplyProcessor);
            this._EPDCReplyProcessorThread.start();
        }
        if (!this.processEPDCRequest(new sv(307), 1)) {
            return false;
        }
        this._engineSession.f = 0;
        if (this._mostRecentReply.m() == 1) {
            if (Model.b()) {
                Model.b.d(1, "ERROR!!! UI's EPDC support is too down-level for engine to work with");
            }
            this._host.b(this);
            this._eventManager.a();
            return false;
        }
        int n12 = ((cg)this._mostRecentReply).aj();
        if (n12 < 305) {
            if (Model.b()) {
                Model.b.d(1, "ERROR!!! Engine's EPDC support is too down-level for UI to work with");
            }
            this.terminate(1);
            return false;
        }
        this._engineSession.f = n12 < 307 ? n12 : 307;
        n11 = 29;
        if (!this.prepareForEPDCRequest(n11, n10)) {
            if (Model.b()) {
                Model.b.d(4, String.valueOf(this) + ".initialize() fails in DebugEngine.prepareForEPDCRequest(Remote_Initialize_Debug_Engine)");
            }
            return false;
        }
        if (Model.b()) {
            Model.b.c(1, "Sending EPDC request: Remote_Initialize_Debug_Engine");
        }
        this._dominantLanguage = by2;
        return this.processEPDCRequest(new sw(this._dominantLanguage, string2, string3, string4), n10);
    }

    public boolean initialize(byte by2, String string2, int n10) throws IOException {
        return this.initialize(by2, string2, null, null, n10);
    }

    public void setHasBeenInitialized(be be2) {
        this._supportedViews = new eb[be2.aj()];
        bh[] bhArray = be2.ak();
        int n10 = 0;
        while (n10 < bhArray.length) {
            this.add(new eb(bhArray[n10], (short)(n10 + 1)), (short)n10);
            ++n10;
        }
        this._repNames = new ec[be2.al()];
        bg[] bgArray = be2.am();
        n10 = 0;
        while (n10 < bgArray.length) {
            this.add(new ec(bgArray[n10], (short)(n10 + 1)), (short)n10);
            ++n10;
        }
        bi[] biArray = be2.an();
        n10 = 0;
        while (n10 < biArray.length) {
            this.add(new Language(biArray[n10], this), biArray[n10].m());
            ++n10;
        }
        this._exceptionInfo = new DebuggeeException[be2.ao()];
        bj[] bjArray = be2.ap();
        if (bjArray != null) {
            n10 = 0;
            while (n10 < bjArray.length) {
                this.add(new DebuggeeException(bjArray[n10], this), n10);
                ++n10;
            }
        }
        this._engineID = be2.aq();
        this._platformID = be2.ar();
        boolean bl2 = this._engineID == 7;
        switch (this._platformID) {
            case 1: {
                this._host.a((byte)1, bl2);
                break;
            }
            case 2: 
            case 3: {
                this._host.a((byte)7, bl2);
                break;
            }
            case 4: {
                this._host.a((byte)6, bl2);
                break;
            }
            case 5: {
                this._host.a((byte)4, bl2);
                break;
            }
            case 6: {
                this._host.a((byte)2, bl2);
                break;
            }
            case 7: {
                this._host.a((byte)8, bl2);
                break;
            }
            case 8: {
                this._host.a((byte)9, bl2);
                break;
            }
        }
        int n11 = be2.as();
        this._dateBreakpointsEnabled = (n11 & 0x8000000) != 0;
        this._entryBreakpointsAutoSetEnabled = (n11 & 0x20000000) != 0;
        this._hasBeenInitialized = true;
    }

    public boolean hasBeenInitialized() {
        return this._hasBeenInitialized;
    }

    public boolean terminate(int n10) throws IOException {
        int n11 = 42;
        if (!this.prepareForEPDCRequest(n11, n10)) {
            if (Model.b()) {
                Model.b.d(4, String.valueOf(this) + ".terminate() fails in DebugEngine.prepareForEPDCRequest(Remote_Terminate_Debug_Engine)");
            }
            return false;
        }
        if (Model.b()) {
            Model.b.c(1, "Sending EPDC request: Remote_Terminate_Debug_Engine");
        }
        return this.processEPDCRequest(new a4(), n10);
    }

    public boolean commandLogExecute(String string2, int n10) throws IOException {
        int n11;
        if (string2 == null || string2.equals("")) {
            string2 = " ";
        }
        if (!this.prepareForEPDCRequest(n11 = 44, n10)) {
            if (Model.b()) {
                Model.b.d(4, String.valueOf(this) + ".commandLogExecute() fails in DebugEngine.prepareForEPDCRequest(Remote_CommandLogExecute)");
            }
            return false;
        }
        if (Model.b()) {
            Model.b.c(1, "Sending EPDC request: Remote_CommandLog");
        }
        return this.processEPDCRequest(new sx(string2), n10);
    }

    public void commandLogResponse(String[] stringArray, int n10) {
        this._eventManager.a(new gr((Object)this, this, n10, stringArray), this._eventListeners);
    }

    public boolean prepareProgram(gv gv2, int n10) throws IOException {
        int n11;
        if (gv2 == null) {
            if (this._debuggeeStartupOptions == null) {
                return false;
            }
            if (!(this._debuggeeStartupOptions instanceof gv)) {
                return false;
            }
        } else {
            this._debuggeeStartupOptions = gv2;
        }
        if (!this.prepareForEPDCRequest(n11 = 30, n10)) {
            if (Model.b()) {
                Model.b.d(4, String.valueOf(this) + ".prepareProgram() fails in DebugEngine.prepareForEPDCRequest(Remote_PreparePgm)");
            }
            return false;
        }
        if (!this._hasBeenInitialized || this._process != null || !this.getCapabilities().a().a() && !((gv)this._debuggeeStartupOptions).b()) {
            if (Model.b()) {
                Model.b.d(4, String.valueOf(this) + ".prepareProgram() fails due to DebugEngine.hasNotBeenInitialized");
            }
            this.cancelEPDCRequest(n11);
            return false;
        }
        if (Model.b()) {
            Model.b.c(1, "Sending EPDC request: Remote_PreparePgm");
        }
        sz sz2 = null;
        sz2 = this._engineSession.f == 305 ? new sz(this._debuggeeStartupOptions.e(), ((gv)this._debuggeeStartupOptions).a(), ((gv)this._debuggeeStartupOptions).c(), ((gv)this._debuggeeStartupOptions).b(), 0) : new sz(this._debuggeeStartupOptions.e(), ((gv)this._debuggeeStartupOptions).a(), ((gv)this._debuggeeStartupOptions).c(), ((gv)this._debuggeeStartupOptions).b(), ((gv)this._debuggeeStartupOptions).d());
        return this.processEPDCRequest(sz2, n10);
    }

    public Document getEngineSettings(int n10) throws IOException, SAXException {
        s0 s02;
        if (!this.prepareForEPDCRequest(229, n10)) {
            return null;
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_GetEngineSettings");
        }
        if (!this.processEPDCRequest(s02 = new s0(), n10)) {
            return null;
        }
        cp cp2 = (cp)this.getMostRecentReply();
        if (cp2 == null || cp2.m() != 0) {
            return null;
        }
        String string2 = cp2.aj();
        if (string2 == null) {
            return null;
        }
        string2 = string2.replace('\n', ' ');
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes(cq.o()));
        InputSource inputSource = new InputSource(byteArrayInputStream);
        DOMParser dOMParser = new DOMParser();
        dOMParser.parse(inputSource);
        Document document = dOMParser.getDocument();
        return document;
    }

    public Document putEngineSettings(Document document, int n10) throws IOException, SAXException {
        s1 s12;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, cq.o()));
        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        OutputFormat outputFormat = new OutputFormat(document);
        outputFormat.setEncoding(null);
        outputFormat.setLineWidth(200);
        XMLSerializer xMLSerializer = new XMLSerializer((Writer)printWriter, outputFormat);
        xMLSerializer.serialize(document);
        xMLSerializer.endDocument();
        if (byteArrayOutputStream == null) {
            return null;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (!this.prepareForEPDCRequest(230, n10)) {
            return null;
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_PutEngineSettings");
        }
        if (!this.processEPDCRequest(s12 = new s1(byArray), n10)) {
            return null;
        }
        cr cr2 = (cr)this.getMostRecentReply();
        if (cr2 == null) {
            return null;
        }
        String string2 = null;
        if (cr2.m() != 0) {
            string2 = cr2.aj();
            if (string2 == null) {
                return null;
            }
            string2 = string2.replace('\n', ' ');
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes(cq.o()));
            InputSource inputSource = new InputSource(byteArrayInputStream);
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(inputSource);
            document = dOMParser.getDocument();
            return document;
        }
        return null;
    }

    public boolean attach(gx gx2, int n10) throws IOException {
        ax ax2;
        int n11;
        if (gx2 == null) {
            return false;
        }
        this._debuggeeStartupOptions = gx2;
        s3 s32 = gx2.c();
        if (s32 == null) {
            n11 = 46;
            ax2 = this._engineSession.f == 305 ? new s2(gx2.a(), gx2.e(), gx2.b(), 0) : new s2(gx2.a(), gx2.e(), gx2.b(), gx2.j());
        } else {
            n11 = 49;
            ax2 = this._engineSession.f == 305 ? new s4(s32.b(), gx2.e(), 0) : new s4(s32.b(), gx2.e(), gx2.j());
        }
        if (!this.prepareForEPDCRequest(n11, n10)) {
            if (Model.b()) {
                Model.b.d(4, String.valueOf(this) + ".attach() fails in DebugEngine.prepareForEPDCRequest(Remote_PreparePgm)");
            }
            return false;
        }
        if (!this._hasBeenInitialized || this._process != null || !this.getCapabilities().c().c()) {
            if (Model.b()) {
                Model.b.d(4, String.valueOf(this) + ".attach() fails due to DebugEngine.hasNotBeenInitialized");
            }
            this.cancelEPDCRequest(n11);
            return false;
        }
        if (Model.b()) {
            Model.b.c(1, "Sending EPDC request: Remote_ProcessAttach");
        }
        return this.processEPDCRequest(ax2, n10);
    }

    public Vector getSystemProcessList() throws IOException {
        int n10 = 48;
        if (!this.prepareForEPDCRequest(n10, 1)) {
            return null;
        }
        if (!this.getCapabilities().c().c()) {
            this.cancelEPDCRequest(n10);
            return null;
        }
        if (Model.b()) {
            Model.b.c(3, "Sending EPDC request: Remote_ProcessListGet");
        }
        if (!this.processEPDCRequest(new s5(), 1)) {
            return null;
        }
        cj cj2 = (cj)this.getMostRecentReply();
        if (cj2 == null || cj2.m() != 0) {
            return null;
        }
        Vector vector = cj2.aj();
        if (vector != null) {
            int n11 = vector.size();
            int n12 = 0;
            while (n12 < n11) {
                vector.setElementAt(new s3((String[])vector.elementAt(n12), n12 + 1), n12);
                ++n12;
            }
        }
        return vector;
    }

    public s7[] getProcessListColumnDetails() throws IOException {
        if (this._processListColumnDetails == null) {
            int n10 = 219;
            if (!this.prepareForEPDCRequest(n10, 1)) {
                return null;
            }
            if (!this.getCapabilities().c().c()) {
                this.cancelEPDCRequest(n10);
                return null;
            }
            if (Model.b()) {
                Model.b.c(3, "Sending EPDC request: Remote_ProcessDetailsGet");
            }
            if (!this.processEPDCRequest(new s6(), 1)) {
                return null;
            }
            ch ch2 = (ch)this.getMostRecentReply();
            if (ch2 == null || ch2.m() != 0) {
                return null;
            }
            Vector vector = ch2.aj();
            int n11 = 0;
            if (vector != null && (n11 = vector.size()) > 0) {
                Vector vector2 = new Vector(n11);
                int n12 = 0;
                int n13 = 0;
                while (n12 < n11) {
                    ci ci2 = (ci)vector.elementAt(n12);
                    av.a((Object)new s7(ci2), vector2, ci2.o());
                    ++n12;
                }
                this._processListColumnDetails = new s7[n11];
                int n14 = vector2.size();
                n12 = 0;
                while (n12 < n14) {
                    if (vector2.elementAt(n12) != null) {
                        this._processListColumnDetails[n13++] = (s7)vector2.elementAt(n12);
                    }
                    ++n12;
                }
            }
        }
        return this._processListColumnDetails;
    }

    public synchronized boolean isBusy() {
        return (this._stateFlags & 1) != 0;
    }

    public synchronized boolean queuedEventsAreBeingFired() {
        return (this._stateFlags & 4) != 0;
    }

    public synchronized boolean modelIsBeingUpdated() {
        return (this._stateFlags & 2) != 0;
    }

    public synchronized boolean savedObjectsAreBeingRestored() {
        return (this._stateFlags & 8) != 0;
    }

    public synchronized boolean isAcceptingSynchronousRequests() {
        return !this.isBusy() && !this.modelIsBeingUpdated() && (!this.queuedEventsAreBeingFired() || Thread.currentThread() == this._callbackThread);
    }

    public synchronized boolean isAcceptingAsynchronousRequests() {
        return !this.isBusy() && !this.modelIsBeingUpdated() && !this.queuedEventsAreBeingFired();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean prepareForEPDCRequest(int n10, int n11) {
        this._requestSemaphore.a();
        byte by2 = this._stateFlags;
        aw aw2 = this._lockSemaphore;
        synchronized (aw2) {
            if (!this._isLoaded || this._connection == null) {
                this._requestSemaphore.b();
                return false;
            }
            if (n10 == 204) {
                if (this.isBusy() && this._mostRecentRequest != null && this._mostRecentRequest.c() == 2) {
                    return true;
                }
                this._requestSemaphore.b();
                return false;
            }
            if ((n11 & 1) != 0) {
                if (!this.isAcceptingSynchronousRequests()) {
                    this._requestSemaphore.b();
                    return false;
                }
            } else if (!this.isAcceptingAsynchronousRequests()) {
                this._requestSemaphore.b();
                return false;
            }
            if (this._currentLock != null && this._currentLock.a() != Thread.currentThread()) {
                this._requestSemaphore.b();
                return false;
            }
            this._stateFlags = (byte)(this._stateFlags | 1);
            if (this._idleEvent != null) {
                this._idleEvent.a(true);
                this._idleEvent.c();
                this._idleEvent.a(false);
            }
        }
        this._eventManager.b(new a1(this, this, by2, this._stateFlags, n10), this._eventListeners);
        return true;
    }

    public void cancelEPDCRequest(int n10) {
        byte by2 = this._stateFlags;
        if (this.isBusy()) {
            aw aw2 = this._lockSemaphore;
            synchronized (aw2) {
                this._stateFlags = (byte)(this._stateFlags ^ 1);
                this._lockSemaphore.b();
            }
            this._eventManager.b(new a1(this, this, by2, this._stateFlags, n10), this._eventListeners);
        }
        this._requestSemaphore.b();
    }

    public boolean processEPDCRequest(ax ax2, int n10) throws IOException {
        this.processEPDCRequestWithReply(ax2, null, null, n10, null);
        return true;
    }

    public boolean processEPDCRequest(ax ax2, int n10, Object object) throws IOException {
        this.processEPDCRequestWithReply(ax2, null, null, n10, object);
        return true;
    }

    public boolean processEPDCRequest(ax ax2, akk akk2, d0 d02, int n10) throws IOException {
        this.processEPDCRequestWithReply(ax2, akk2, d02, n10, null);
        return true;
    }

    public ba processEPDCRequestWithReply(ax ax2, int n10) throws IOException {
        return this.processEPDCRequestWithReply(ax2, null, null, n10, null);
    }

    public ba processEPDCRequestWithReply(ax ax2, akk akk2, d0 d02, int n10, Object object) throws IOException {
        ax2.a(this._engineSession);
        this.setRequestProperty(object);
        try {
            ax2.a(this._connection);
        }
        catch (IOException iOException) {
            this.handleLostConnection(iOException);
        }
        if (ax2.c() != 204) {
            this._mostRecentReply = null;
            this._mostRecentRequest = ax2;
            this._currentClient = akk2;
            this._privilegedListener = d02;
        }
        this._requestSemaphore.b();
        if (ax2.c() == 204) {
            return null;
        }
        ba ba2 = null;
        this._EPDCReplyProcessor.a();
        if ((n10 & 1) != 0) {
            ba2 = this._EPDCReplyProcessor.b();
            this.setModelIsBeingUpdated(true);
            this._EPDCReplyProcessor.a(ba2);
            this.setRequestProperty(null);
            if ((n10 & 4) == 0) {
                this.setModelIsBeingUpdated(false);
            }
        } else {
            this._replySemaphore.b();
        }
        return ba2;
    }

    public void handleLostConnection(IOException iOException) throws IOException {
        this.setIsLoaded(false);
        this._eventManager.b(new a8((Object)this, 316, null, -1), this._eventListeners);
        this._eventManager.a((byte)2);
        this._host.b(this);
        throw iOException;
    }

    public void setModelIsBeingUpdated(boolean bl2) {
        int n10 = this._mostRecentReply.c();
        byte by2 = this._stateFlags;
        if (bl2) {
            aw aw2 = this._lockSemaphore;
            synchronized (aw2) {
                this._stateFlags = (byte)(this._stateFlags ^ 1);
                this._stateFlags = (byte)(this._stateFlags | 2);
            }
            this._eventManager.b(new a1(this, this, by2, this._stateFlags, n10), this._eventListeners);
            return;
        }
        aw aw3 = this._lockSemaphore;
        synchronized (aw3) {
            this._stateFlags = (byte)(this._stateFlags ^ 2);
            this._stateFlags = (byte)(this._stateFlags | 4);
            this._callbackThread = Thread.currentThread();
        }
        this._eventManager.b(new a1(this, this, by2, this._stateFlags, n10), this._eventListeners);
        if ((by2 & 4) == 0) {
            this._eventManager.a();
            by2 = this._stateFlags;
            aw3 = this._lockSemaphore;
            synchronized (aw3) {
                this._stateFlags = (byte)(this._stateFlags ^ 4);
                this._callbackThread = null;
                this._idleEvent = new a1(this, this, by2, this._stateFlags, n10);
                this._lockSemaphore.b();
            }
            this._eventManager.b(this._idleEvent, this._eventListeners);
        }
    }

    public void setSavedObjectsAreBeingRestored(boolean bl2) {
        byte by2 = this._stateFlags;
        if (bl2 && (this._stateFlags & 8) == 0) {
            this._stateFlags = (byte)(this._stateFlags | 8);
            this._eventManager.b(new a1(this, this, by2, this._stateFlags, -1), this._eventListeners);
            return;
        }
        if ((this._stateFlags & 8) != 0) {
            this._stateFlags = (byte)(this._stateFlags ^ 8);
            this._eventManager.b(new a1(this, this, by2, this._stateFlags, -1), this._eventListeners);
        }
    }

    public void setMostRecentReply(ba ba2) {
        this._mostRecentReply = ba2;
    }

    public ba getMostRecentReply() {
        return this._mostRecentReply;
    }

    public ax getMostRecentRequest() {
        return this._mostRecentRequest;
    }

    public void setRequestProperty(Object object) {
        this._eventManager.a(object);
    }

    public Object getRequestProperty() {
        return this._eventManager.c();
    }

    public a3 getEventManager() {
        return this._eventManager;
    }

    public short numberOfSupportedViews() {
        return (short)(this._supportedViews == null ? 0 : this._supportedViews.length);
    }

    public eb[] supportedViews() {
        return this._supportedViews;
    }

    public ec[] representations() {
        return this._repNames;
    }

    public Language[] getLanguages() {
        if (this._languages == null) {
            return null;
        }
        int n10 = this._languages.size();
        if (n10 == 0) {
            return null;
        }
        Object[] objectArray = new Language[n10];
        this._languages.copyInto(objectArray);
        return objectArray;
    }

    public DebuggeeException[] getExceptions() {
        return this._exceptionInfo;
    }

    public void setExceptions(DebuggeeException[] debuggeeExceptionArray) {
        this._exceptionInfo = debuggeeExceptionArray;
    }

    public az getLock(boolean bl2) {
        aw aw2 = this._lockSemaphore;
        synchronized (aw2) {
            if (!this.canCreateNewLock()) {
                if (bl2) {
                    while (!this.canCreateNewLock()) {
                        this._lockSemaphore.a();
                        this._lockSemaphore.c();
                    }
                } else {
                    az az2 = null;
                    Object var4_5 = null;
                    return az2;
                }
            }
            az az3 = this._currentLock = new az();
            Object var4_6 = null;
            return az3;
        }
    }

    public void releaseLock(az az2) {
        aw aw2 = this._lockSemaphore;
        synchronized (aw2) {
            az2.c();
            if (az2 == this._currentLock) {
                this._currentLock = null;
                this._lockSemaphore.b();
            }
            return;
        }
    }

    public byte getState() {
        return this._stateFlags;
    }

    public synchronized boolean canCreateNewLock() {
        return this._currentLock == null && !this.isBusy() && !this.modelIsBeingUpdated() && (!this.queuedEventsAreBeingFired() || Thread.currentThread() == this._callbackThread);
    }

    public eb getViewInformation(short s10) {
        return this._supportedViews[s10 - 1];
    }

    private void add(eb eb2, short s10) {
        this._supportedViews[s10] = eb2;
        av.a((Object)eb2, this._viewsByType, eb2.c());
    }

    public eb getViewInformationByType(short s10) {
        try {
            return (eb)this._viewsByType.elementAt(s10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public eb getSourceViewInformation() {
        return this.getViewInformationByType((short)2);
    }

    public eb getDisassemblyViewInformation() {
        return this.getViewInformationByType((short)4);
    }

    public eb getMixedViewInformation() {
        return this.getViewInformationByType((short)3);
    }

    public eb getListingViewInformation() {
        return this.getViewInformationByType((short)5);
    }

    public Language getLanguageInfo(int n10) {
        try {
            return (Language)this._languages.elementAt(n10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public void add(Language language2, int n10) {
        if (this._languages == null) {
            this._languages = new Vector();
        }
        av.a((Object)language2, this._languages, n10);
    }

    public ec getRepresentation(int n10) {
        return this._repNames[n10];
    }

    private void add(ec ec2, short s10) {
        this._repNames[s10] = ec2;
    }

    private void add(DebuggeeException debuggeeException, int n10) {
        this._exceptionInfo[n10] = debuggeeException;
    }

    public void prepareToDie() {
        if (this._EPDCReplyProcessorThread != Thread.currentThread()) {
            this._EPDCReplyProcessorThread.stop();
        }
        try {
            this._connection.h();
        }
        catch (IOException iOException) {}
        this.d();
        this._eventManager.a(new bb(this, this, this._mostRecentReply != null ? this._mostRecentReply.c() : (this._mostRecentRequest != null ? this._mostRecentRequest.c() : -1)), this._eventListeners);
    }

    public void tellChildrenThatOwnerHasBeenDeleted() {
        int n10;
        if (this._process != null) {
            this._process.e();
        }
        if (this._registerGroups != null) {
            n10 = 0;
            while (n10 < this._registerGroups.size()) {
                if (this._registerGroups.elementAt(n10) != null) {
                    ((f7)this._registerGroups.elementAt(n10)).e();
                }
                ++n10;
            }
        }
        if (this._stackDetailColumns != null) {
            n10 = 0;
            while (n10 < this._stackDetailColumns.size()) {
                if (this._stackDetailColumns.elementAt(n10) != null) {
                    ((mr)this._stackDetailColumns.elementAt(n10)).e();
                }
                ++n10;
            }
        }
        if (this._exceptionInfo != null) {
            n10 = 0;
            while (n10 < this._exceptionInfo.length) {
                if (this._exceptionInfo[n10] != null) {
                    this._exceptionInfo[n10].e();
                }
                ++n10;
            }
        }
    }

    public ek getCapabilities() {
        return this._capabilities;
    }

    public void setCapabilities(ek ek2) {
        ek ek3 = this._capabilities;
        this._capabilities = ek2;
        this._eventManager.a(new ew(this, this, ek3, ek2, this._mostRecentReply.c()), this._eventListeners);
    }

    public mr[] getStackDetails() throws IOException {
        Object object;
        if (this._stackDetailColumns == null) {
            int n10;
            if (!this.prepareForEPDCRequest(218, 1)) {
                return null;
            }
            if (!this.getCapabilities().g().d()) {
                this.cancelEPDCRequest(218);
                return null;
            }
            if (Model.b()) {
                Model.b.c(3, "Sending EPDC request: Remote_StackDetailsGet");
            }
            if (!this.processEPDCRequest(new mq(), 1)) {
                return null;
            }
            object = (by)this.getMostRecentReply();
            if (object == null || ((ba)object).m() != 0) {
                return null;
            }
            Vector vector = ((by)object).aj();
            int[] nArray = ((by)object).ak();
            if (vector != null && (this._numberOfStackDetailColumns = vector.size()) > 0) {
                this._stackDetailColumns = new Vector();
                n10 = 0;
                while (n10 < this._numberOfStackDetailColumns) {
                    bz bz2 = (bz)vector.elementAt(n10);
                    mr mr2 = new mr(bz2);
                    av.a((Object)mr2, this._stackDetailColumns, mr2.a());
                    ++n10;
                }
            }
            if (nArray != null && nArray.length > 0) {
                n10 = 0;
                while (n10 < nArray.length) {
                    ((mr)this._stackDetailColumns.elementAt(nArray[n10])).j();
                    ++n10;
                }
            }
        }
        if (this._stackDetailColumns == null || this._stackDetailColumns.size() == 0) {
            return null;
        }
        object = new mr[this._numberOfStackDetailColumns];
        int n11 = 0;
        int n12 = 0;
        while (n12 < this._stackDetailColumns.size()) {
            if (this._stackDetailColumns.elementAt(n12) != null) {
                object[n11] = (mr)this._stackDetailColumns.elementAt(n12);
                ++n11;
            }
            ++n12;
        }
        return object;
    }

    public f7[] getRegisterGroups() throws IOException {
        Object object;
        if (this._registerGroups == null) {
            int n10;
            if (!this.prepareForEPDCRequest(216, 1)) {
                return null;
            }
            if (!this.getCapabilities().g().c()) {
                this.cancelEPDCRequest(216);
                return null;
            }
            if (Model.b()) {
                Model.b.c(1, "Sending EPDC request: Remote_RegistersDetailsGet");
            }
            if (!this.processEPDCRequest(new f6(), 1)) {
                return null;
            }
            object = (ca)this.getMostRecentReply();
            if (object == null || ((ba)object).m() != 0) {
                return null;
            }
            Vector vector = ((ca)object).aj();
            int[] nArray = ((ca)object).ak();
            if (vector != null && (this._numberOfRegisterGroups = vector.size()) > 0) {
                this._registerGroups = new Vector();
                n10 = 0;
                while (n10 < this._numberOfRegisterGroups) {
                    cb cb2 = (cb)vector.elementAt(n10);
                    f7 f72 = new f7(cb2);
                    av.a((Object)f72, this._registerGroups, f72.a());
                    ++n10;
                }
            }
            if (nArray != null && nArray.length > 0) {
                n10 = 0;
                while (n10 < nArray.length) {
                    ((f7)this._registerGroups.elementAt(nArray[n10])).c();
                    ++n10;
                }
            }
        }
        if (this._registerGroups == null || this._registerGroups.size() == 0) {
            return null;
        }
        object = new f7[this._numberOfRegisterGroups];
        int n11 = 0;
        int n12 = 0;
        while (n12 < this._registerGroups.size()) {
            if (this._registerGroups.elementAt(n12) != null) {
                object[n11] = (f7)this._registerGroups.elementAt(n12);
                ++n11;
            }
            ++n12;
        }
        return object;
    }

    public f7 getRegisterGroup(int n10) throws IOException {
        this.getRegisterGroups();
        if (this._registerGroups == null) {
            return null;
        }
        try {
            return (f7)this._registerGroups.elementAt(n10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public ml switchView(ml ml2, eb eb2) throws IOException {
        if (ml2 == null || eb2 == null) {
            return null;
        }
        return this.switchView(ml2.e(), eb2);
    }

    public ml switchView(bx bx2, eb eb2) throws IOException {
        if (bx2 == null || eb2 == null) {
            return null;
        }
        short s10 = eb2.m();
        if (s10 == bx2.m()) {
            try {
                return new ml(this._process, bx2);
            }
            catch (mm mm2) {
                return null;
            }
        }
        if (!this.prepareForEPDCRequest(50, 1)) {
            return null;
        }
        if (!this.processEPDCRequest(new mo(bx2, s10), 1)) {
            return null;
        }
        b1 b12 = (b1)this.getMostRecentReply();
        if (b12 == null || b12.m() != 0) {
            return null;
        }
        try {
            return new ml(this._process, b12.aj());
        }
        catch (mm mm3) {
            return null;
        }
    }

    public boolean commitPendingExceptionStateChanges(boolean bl2) throws IOException {
        if (!this.changeExceptionStatus()) {
            return false;
        }
        s9 s92 = null;
        if (this._process != null) {
            s92 = this._process.getRestorableObjects();
        }
        this._saveAndRestoreExceptionFilters = true;
        if (s92 != null && (s92.e() & 0x1000000) != 0) {
            s92.a(true);
        }
        if (this._process != null && bl2 && (s92 = DebugEngine.findOrCreateEngineSpecificRestorableObjects(this._process)) != null) {
            s92.a(this._exceptionInfo);
        }
        return true;
    }

    public boolean changeExceptionStatus() throws IOException {
        if (this._exceptionInfo != null && this._exceptionInfo.length != 0) {
            if (!this.prepareForEPDCRequest(213, 1)) {
                return false;
            }
            if (!this.getCapabilities().i().a()) {
                this.cancelEPDCRequest(213);
                return false;
            }
            int n10 = this._exceptionInfo.length;
            int[] nArray = new int[n10];
            int n11 = 0;
            while (n11 < n10) {
                nArray[n11] = this._exceptionInfo[n11].getPendingState();
                ++n11;
            }
            if (!this.processEPDCRequest(new s8(nArray), 1)) {
                return false;
            }
            cf cf2 = (cf)this.getMostRecentReply();
            if (cf2 == null || cf2.m() != 0) {
                return false;
            }
            n11 = 0;
            while (n11 < n10) {
                this._exceptionInfo[n11].commitPendingStateChange();
                ++n11;
            }
            return true;
        }
        return false;
    }

    public gw getDebuggeeStartupOptions() {
        return this._debuggeeStartupOptions;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (objectOutputStream instanceof tg) {
            int n10 = ((tg)objectOutputStream).a();
            if ((n10 & Integer.MIN_VALUE) != 0) {
                objectOutputStream.defaultWriteObject();
                return;
            }
            if ((n10 & 0x40000000) != 0) {
                objectOutputStream.writeObject(this._supportedViews);
                if ((n10 & 0x2000000) != 0) {
                    objectOutputStream.writeObject(this._languages);
                }
                if ((n10 & 0x1000000) != 0) {
                    if (this._saveAndRestoreExceptionFilters) {
                        objectOutputStream.writeObject(this._exceptionInfo);
                        return;
                    }
                    objectOutputStream.writeObject(null);
                    return;
                }
            }
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream instanceof th) {
            int n10 = ((th)objectInputStream).a();
            if ((n10 & Integer.MIN_VALUE) != 0) {
                objectInputStream.defaultReadObject();
                return;
            }
            if ((n10 & 0x40000000) != 0) {
                this._supportedViews = (eb[])objectInputStream.readObject();
                if ((n10 & 0x2000000) != 0) {
                    this._languages = (Vector)objectInputStream.readObject();
                }
                if ((n10 & 0x1000000) != 0) {
                    this._exceptionInfo = (DebuggeeException[])objectInputStream.readObject();
                    return;
                }
            }
        } else {
            objectInputStream.defaultReadObject();
        }
    }

    public void clearAllChangeFlags() {
        this._changeFlags = 0;
    }

    public void setDefaultDataRepresentationsHaveChanged(boolean bl2) {
        if (bl2) {
            this._changeFlags |= 0x2000000;
            return;
        }
        if ((this._changeFlags & 0x2000000) != 0) {
            this._changeFlags ^= 0x2000000;
        }
    }

    public void setExceptionFiltersHaveChanged(boolean bl2) {
        if (bl2) {
            this._changeFlags |= 0x1000000;
            return;
        }
        if ((this._changeFlags & 0x1000000) != 0) {
            this._changeFlags ^= 0x1000000;
        }
    }

    public boolean defaultDataRepresentationsHaveChanged() {
        return (this._changeFlags & 0x2000000) != 0;
    }

    public boolean exceptionFiltersHaveChanged() {
        return (this._changeFlags & 0x1000000) != 0;
    }

    public static s9 findOrCreateEngineSpecificRestorableObjects(DebuggeeProcess debuggeeProcess) {
        DebugEngine debugEngine = debuggeeProcess.debugEngine();
        char[] cArray = new char[]{au.a(debugEngine.getPlatformID()), DebugEngine.getEngineTypeMnemonic(debugEngine.getEngineID())};
        String string2 = new String(cArray);
        s9 s92 = (s9)_engineSpecificRestorableObjects.get(string2);
        if (s92 == null) {
            String string3;
            String string4 = "esro.@" + string2;
            gw gw2 = debugEngine.getDebuggeeStartupOptions();
            if (gw2 != null && (string3 = gw2.g()) != null && !string3.equals("")) {
                String string5 = System.getProperty("file.separator");
                if (!string3.endsWith(string5)) {
                    string3 = String.valueOf(string3) + string5;
                }
                string4 = String.valueOf(string3) + string4;
            }
            if (!(s92 = new tc(debuggeeProcess, 0, string4)).d().c()) {
                try {
                    s92.a();
                }
                catch (IOException iOException) {}
            }
            s92.a(0x3000000);
            s92.b(0x3000002);
            _engineSpecificRestorableObjects.put(string2, s92);
        }
        return s92;
    }

    public boolean getSaveAndRestoreExceptionFilters() {
        return this._saveAndRestoreExceptionFilters;
    }

    public void setSaveAndRestoreExceptionFilters(boolean bl2) {
        this._saveAndRestoreExceptionFilters = bl2;
    }

    public static char getEngineTypeMnemonic(short s10) {
        return _engineTypeMnemonics[s10];
    }

    public Vector loadParts(ex ex2, String string2) throws IOException {
        if (!this.prepareForEPDCRequest(17, 1)) {
            return null;
        }
        int n10 = 0;
        if (ex2 != null) {
            n10 = ex2.k();
        }
        ti ti2 = new ti(n10, string2);
        if (Model.b()) {
            Model.b.c(3, "Sending EPDC request Remote_PartOpen");
        }
        if (!this.processEPDCRequest(ti2, 1)) {
            return null;
        }
        ck ck2 = (ck)this.getMostRecentReply();
        if (ck2 == null || ck2.m() != 0) {
            return null;
        }
        Vector vector = ck2.aj();
        int n11 = 0;
        if (vector == null || (n11 = vector.size()) == 0) {
            return null;
        }
        e1 e12 = null;
        Short s10 = null;
        short s11 = 0;
        Vector vector2 = new Vector(n11);
        int n12 = 0;
        while (n12 < n11) {
            s10 = (Short)vector.elementAt(n12);
            if (s10 != null) {
                s11 = s10;
                e12 = this.process().getPart(s11);
                if (e12 != null) {
                    av.a((Object)e12, vector2, s11);
                }
            }
            ++n12;
        }
        return vector2;
    }

    public akk getCurrentClient() {
        return this._currentClient;
    }

    public d0 getPrivilegedEventListener() {
        return this._privilegedListener;
    }

    public bx resolveFunction(bw bw2) throws IOException {
        Vector vector;
        cm cm2;
        if (this.prepareForEPDCRequest(43, 1) && this.processEPDCRequest(new gz(bw2.c()), 1) && (cm2 = (cm)this.getMostRecentReply()).m() == 0 && (vector = cm2.aj()) != null) {
            int n10 = 0;
            while (n10 < vector.size()) {
                bx bx2 = (bx)vector.elementAt(n10);
                if (bx2 != null && bx2.p()) {
                    return bx2;
                }
                ++n10;
            }
        }
        return null;
    }

    public byte getDominantLanguage() {
        return this._dominantLanguage;
    }

    public void saveErrorOccurredEventForFileNotFound(a8 a82) {
        this._errorOccurredEventForFileNotFound = a82;
    }

    public void fireErrorOccurredEventForFileNotFound() {
        this._eventManager.b(this._errorOccurredEventForFileNotFound, this._eventListeners);
    }

    public void setLocalSourcePath(String string2) {
        this._localSourcePath = string2;
    }

    public String getLocalSourcePath() {
        if (this._localSourcePath == null || this._localSourcePath.length() == 0) {
            return null;
        }
        return this._localSourcePath;
    }

    public boolean canBeReused() {
        return Model.e();
    }

    public boolean addProgram(String string2, int n10, int n11) throws IOException {
        if (!this.prepareForEPDCRequest(52, 1)) {
            return false;
        }
        if (!this.getCapabilities().c().f()) {
            this.cancelEPDCRequest(52);
            return false;
        }
        tj tj2 = new tj(string2, n10);
        if (Model.b()) {
            Model.b.c(3, "Sending EPDC request Remote_ModuleAdd");
        }
        return this.processEPDCRequest(tj2, n11);
    }

    public boolean removeProgram(String string2, int n10) throws IOException {
        if (!this.prepareForEPDCRequest(53, 1)) {
            return false;
        }
        if (!this.getCapabilities().c().g()) {
            this.cancelEPDCRequest(53);
            return false;
        }
        Vector vector = this.process().getModules(string2);
        if (vector == null || vector.size() == 0) {
            return false;
        }
        ex ex2 = null;
        int n11 = 0;
        int n12 = 0;
        while (n12 < vector.size()) {
            ex2 = (ex)vector.elementAt(n12);
            if (ex2 != null) {
                n11 = ex2.k();
                break;
            }
            ++n12;
        }
        tk tk2 = new tk(n11);
        if (Model.b()) {
            Model.b.c(3, "Sending EPDC request Remote_ModuleRemove");
        }
        return this.processEPDCRequest(tk2, n10);
    }

    public String[] getJobsList(String string2) throws IOException {
        if (!this.prepareForEPDCRequest(215, 1)) {
            return null;
        }
        tl tl2 = new tl(string2);
        if (Model.b()) {
            Model.b.c(3, "Sending EPDC request Remote_JobsListGet");
        }
        if (!this.processEPDCRequest(tl2, 1)) {
            return null;
        }
        co co2 = (co)this.getMostRecentReply();
        if (co2 == null || co2.m() != 0) {
            return null;
        }
        String[] stringArray = co2.aj();
        return stringArray;
    }

    public boolean getDateBreakpointsEnabled() {
        return this._dateBreakpointsEnabled;
    }

    public boolean getEntryBreakpointsAutoSetEnabled() {
        return this._entryBreakpointsAutoSetEnabled;
    }

    public boolean enableDateBreakpoints(boolean bl2) throws IOException {
        return this.enableSpecialBreakpoints(bl2, this._entryBreakpointsAutoSetEnabled);
    }

    public boolean enableEntryBreakpointsAutoSet(boolean bl2) throws IOException {
        return this.enableSpecialBreakpoints(this._dateBreakpointsEnabled, bl2);
    }

    public boolean enableSpecialBreakpoints(boolean bl2, boolean bl3) throws IOException {
        if (!this.prepareForEPDCRequest(51, 1)) {
            return false;
        }
        if (Model.b()) {
            Model.b.c(3, "Sending EPDC request Remote_BreakpointEntryAutoSet2");
        }
        if (!this.processEPDCRequest(new o7(bl3, bl2), 1)) {
            return false;
        }
        ba ba2 = this.getMostRecentReply();
        if (ba2 == null || ba2.m() != 0) {
            return false;
        }
        this._dateBreakpointsEnabled = bl2;
        this._entryBreakpointsAutoSetEnabled = bl3;
        return true;
    }

    public int getEPDCVersion() {
        return this._engineSession.f;
    }

    public int getMaximumViewFileCacheSize() {
        return this._maximumViewFileCacheSize;
    }

    public void setMaximumViewFileCacheSize(int n10) {
        if (n10 <= 0) {
            return;
        }
        this._maximumViewFileCacheSize = n10;
    }

    public void cleanup() {
        this._localSourcePath = null;
        this._host = null;
        this._connection = null;
        this._EPDCReplyProcessor.c();
        this._EPDCReplyProcessor = null;
        this._EPDCReplyProcessorThread = null;
        this._process = null;
        this._viewsByType = null;
        this._supportedViews = null;
        this._eventListeners.removeAllElements();
        this._replySemaphore = null;
        this._lockSemaphore = null;
        this._requestSemaphore = null;
        this._mostRecentReply = null;
        this._currentLock = null;
        this._eventManager = null;
        this._callbackThread = null;
        this._capabilities = null;
        this._mostRecentRequest = null;
        this._currentClient = null;
        this._privilegedListener = null;
        this._repNames = null;
        this._stackDetailColumns = null;
        this._registerGroups = null;
        this._processListColumnDetails = null;
        this._debuggeeStartupOptions = null;
        this._errorOccurredEventForFileNotFound = null;
        this._idleEvent = null;
        this._engineSession = null;
    }

    static {
        bg.a("UTF8");
        cq.a("UTF8");
        DebugEngine._engineTypeMnemonics[4] = 112;
        DebugEngine._engineTypeMnemonics[6] = 119;
        DebugEngine._engineTypeMnemonics[7] = 106;
    }
}

