/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.model;

import com.ibm.debug.model.DebugEngine;
import com.ibm.debug.model.DebuggeeThread;
import com.ibm.debug.model.Language;
import com.ibm.debug.model.Model;
import com.ibm.debug.model.MonitoredExpression;
import com.ibm.debug.model.Storage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DebuggeeProcess
extends av {
    public int _processID;
    public String _qualifiedName;
    public String _profileName;
    public DebugEngine _debugEngine;
    public Vector _modules = new Vector(20, 20);
    public Vector _parts = new Vector(60, 60);
    public Vector _threads = new Vector(5, 5);
    public transient Vector _eventListeners = new Vector();
    public boolean _hasBeenRunToMainEntryPoint = false;
    public gs _processStopInfo;
    public Vector _monitoredExpressions = new Vector();
    public Vector _breakpoints = new Vector();
    public Vector _storage;
    public Hashtable _modulesByName = new Hashtable();
    public tc _restorableObjects;
    public int _changeFlags;
    public Vector _functionsByName;
    public boolean _requestByName;
    public MonitoredExpression _evaluatedExpression;
    public Vector _evaluatedExpressions = new Vector();
    public Vector _unresolvedFunctions;
    public Vector _functions = new Vector();
    public boolean _isPostMortem = false;
    public boolean _doingARestart = false;
    public static final int BREAKPOINTS_HAVE_CHANGED = 0x20000000;
    public static final int PROGRAM_MONITORS_HAVE_CHANGED = 0x10000000;
    public static final int STORAGE_MONITORS_HAVE_CHANGED = 0x4000000;

    public DebuggeeProcess(DebugEngine debugEngine, int n10, String string2, String string3) {
        if (Model.b()) {
            Model.b.c(1, "Creating DebuggeeProcess : ProcessID=" + n10 + " QualifiedName=" + string2);
        }
        this._processID = n10;
        this._qualifiedName = string2;
        this._profileName = string3;
        this._debugEngine = debugEngine;
    }

    public synchronized void addEventListener(d9 d92) {
        this._eventListeners.addElement(d92);
    }

    public synchronized void removeEventListener(d9 d92) {
        int n10 = this._eventListeners.indexOf(d92);
        if (n10 != -1) {
            try {
                this._eventListeners.setElementAt(null, n10);
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
        }
    }

    public int processID() {
        return this._processID;
    }

    public String qualifiedName() {
        return this._qualifiedName;
    }

    public DebugEngine debugEngine() {
        return this._debugEngine;
    }

    public ex[] getModulesArray() {
        if (this._modules == null) {
            return null;
        }
        int n10 = this._modules.size();
        if (n10 == 0) {
            return null;
        }
        Object[] objectArray = new ex[n10];
        this._modules.copyInto(objectArray);
        return objectArray;
    }

    public Vector getModules(String string2) {
        return (Vector)this._modulesByName.get(string2);
    }

    public fn[] getBreakpointsArray() {
        if (this._breakpoints == null) {
            return null;
        }
        int n10 = this._breakpoints.size();
        if (n10 == 0) {
            return null;
        }
        Object[] objectArray = new fn[n10];
        this._breakpoints.copyInto(objectArray);
        return objectArray;
    }

    public boolean halt(int n10) throws IOException {
        return this.halt(n10, null);
    }

    public boolean halt(int n10, Object object) throws IOException {
        int n11 = 204;
        if (!this._debugEngine.prepareForEPDCRequest(n11, n10)) {
            return false;
        }
        if (Model.b()) {
            Model.b.c(1, "Sending EPDC request: Remote_Halt");
        }
        return this._debugEngine.processEPDCRequest(new tn(), n10, object);
    }

    public DebuggeeThread[] getThreadsArray() {
        if (this._threads == null) {
            return null;
        }
        int n10 = this._threads.size();
        if (n10 == 0) {
            return null;
        }
        Object[] objectArray = new DebuggeeThread[n10];
        this._threads.copyInto(objectArray);
        return objectArray;
    }

    public MonitoredExpression[] getMonitoredExpressionsArray() {
        if (this._monitoredExpressions == null) {
            return null;
        }
        int n10 = this._monitoredExpressions.size();
        if (n10 == 0) {
            return null;
        }
        Object[] objectArray = new MonitoredExpression[n10];
        this._monitoredExpressions.copyInto(objectArray);
        return objectArray;
    }

    public Vector getStorage() {
        if (this._storage == null || this._storage.size() == 0) {
            return null;
        }
        Vector<Storage> vector = new Vector<Storage>();
        int n10 = this._storage.size();
        int n11 = 0;
        while (n11 < n10) {
            Storage storage = (Storage)this._storage.elementAt(n11);
            if (storage != null && !storage.h()) {
                vector.addElement(storage);
            }
            ++n11;
        }
        return vector;
    }

    public DebuggeeThread thread(int n10) {
        try {
            return (DebuggeeThread)this._threads.elementAt(n10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public synchronized boolean runToMainEntryPoint(int n10) throws IOException {
        int n11 = 31;
        if (!this._debugEngine.prepareForEPDCRequest(n11, n10)) {
            return false;
        }
        if (this._hasBeenRunToMainEntryPoint) {
            this._debugEngine.cancelEPDCRequest(n11);
            return false;
        }
        if (Model.b()) {
            Model.b.c(1, "Sending EPDC request: Remote_StartPgm");
        }
        return this._debugEngine.processEPDCRequest(new to(), n10);
    }

    public void setHasBeenRunToMainEntryPoint() {
        this._hasBeenRunToMainEntryPoint = true;
    }

    public boolean hasBeenRunToMainEntryPoint() {
        return this._hasBeenRunToMainEntryPoint;
    }

    public boolean forceRunToMainEntryPoint(int n10) throws IOException {
        this._hasBeenRunToMainEntryPoint = false;
        return this.runToMainEntryPoint(n10);
    }

    public synchronized void add(ex ex2) {
        av.a((Object)ex2, this._modules, ex2.k());
        av.a((Object)ex2, this._modulesByName, ex2.c());
        int n10 = this._debugEngine.getMostRecentReply().c();
        this._debugEngine.getEventManager().a(new ey(this, ex2, n10), this._eventListeners);
    }

    public synchronized void add(fn fn2) {
        av.a((Object)fn2, this._breakpoints, fn2.b());
        int n10 = this._debugEngine.getMostRecentReply().c();
        this._debugEngine.getEventManager().a(new fv(this, fn2, n10), this._eventListeners);
    }

    public synchronized void add(e1 e12) {
        av.a((Object)e12, this._parts, e12.b());
    }

    public synchronized void add(DebuggeeThread debuggeeThread) {
        av.a((Object)debuggeeThread, this._threads, debuggeeThread.debugEngineAssignedID());
        int n10 = this._debugEngine.getMostRecentReply().c();
        this._debugEngine.getEventManager().a(new e9(this, debuggeeThread, n10), this._eventListeners);
    }

    public synchronized void add(MonitoredExpression monitoredExpression) {
        av.a((Object)monitoredExpression, this._monitoredExpressions, monitoredExpression.getMonitoredExpressionAssignedID());
        int n10 = this._debugEngine.getMostRecentReply().c();
        this._debugEngine.getEventManager().a(new fk(this, monitoredExpression, n10), this._eventListeners);
    }

    public synchronized void add(Storage storage) {
        if (this._storage == null) {
            this._storage = new Vector();
        }
        av.a((Object)storage, this._storage, storage.id());
        int n10 = this._debugEngine.getMostRecentReply().c();
        this._debugEngine.getEventManager().a(new fx(this, storage, n10, this._debugEngine.getCurrentClient(), this._debugEngine.getPrivilegedEventListener()), this._eventListeners);
    }

    public synchronized void programOutput(String[] stringArray) {
        this._debugEngine.getMostRecentReply().c();
    }

    public synchronized void programError(String[] stringArray) {
        this._debugEngine.getMostRecentReply().c();
    }

    public synchronized void remove(DebuggeeThread debuggeeThread) {
        int n10 = debuggeeThread.debugEngineAssignedID();
        debuggeeThread.prepareToDie();
        debuggeeThread.d();
        try {
            this._threads.setElementAt(null, n10);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public synchronized void remove(Storage storage) {
        storage.prepareToDie();
        storage.d();
        try {
            this._storage.setElementAt(null, storage.id());
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public synchronized void removeModule(int n10) {
        ex ex2 = this.getModule(n10);
        if (ex2 == null) {
            return;
        }
        ex2.l();
        ex2.d();
        av.b(ex2, this._modulesByName, ex2.c());
        try {
            this._modules.setElementAt(null, n10);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public synchronized void removeBreakpoint(int n10) {
        fn fn2 = this.getBreakpoint(n10);
        fn2.prepareToDie();
        fn2.d();
        try {
            this._breakpoints.setElementAt(null, n10);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public synchronized void removeMonitoredExpression(int n10) {
        MonitoredExpression monitoredExpression = this.getMonitoredExpression(n10);
        monitoredExpression.prepareToDie();
        monitoredExpression.d();
        try {
            this._monitoredExpressions.setElementAt(null, n10);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public void prepareToDie() {
        this.d();
        int n10 = this._debugEngine.getMostRecentReply().c();
        this._debugEngine.getEventManager().a(new d6(this, this, n10), this._eventListeners);
        if (!this._doingARestart && !this._debugEngine.canBeReused()) {
            this.addEventListener(new d8());
        }
    }

    public ex getModule(int n10) {
        try {
            return (ex)this._modules.elementAt(n10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Model.b.d(3, "Exception{" + arrayIndexOutOfBoundsException.getMessage() + "} occurred in DebuggeeProcess[" + this.processID() + "]" + ".getModule(" + n10 + ")");
            return null;
        }
    }

    public fn getBreakpoint(int n10) {
        try {
            return (fn)this._breakpoints.elementAt(n10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Model.b.d(3, "Exception{" + arrayIndexOutOfBoundsException.getMessage() + "} occurred in DebuggeeProcess[" + this.processID() + "]" + ".getBreakpoint(" + n10 + ")");
            return null;
        }
    }

    public Storage getStorage(short s10) {
        try {
            return (Storage)this._storage.elementAt(s10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Model.b.d(3, "Exception{" + arrayIndexOutOfBoundsException.getMessage() + "} occurred in DebuggeeProcess[" + this.processID() + "]" + ".getStorage(" + s10 + ")");
            return null;
        }
    }

    public e1 getPart(int n10) {
        try {
            return (e1)this._parts.elementAt(n10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Model.b.d(3, "Exception{" + arrayIndexOutOfBoundsException.getMessage() + "} occurred in DebuggeeProcess[" + this.processID() + "]" + ".getPart(" + n10 + ")");
            return null;
        }
    }

    public DebuggeeThread getThread(int n10) {
        try {
            return (DebuggeeThread)this._threads.elementAt(n10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Model.b.d(3, "Exception{" + arrayIndexOutOfBoundsException.getMessage() + "} occurred in DebuggeeProcess[" + this.processID() + "]" + ".getThread(" + n10 + ")");
            return null;
        }
    }

    public MonitoredExpression getMonitoredExpression(int n10) {
        try {
            return (MonitoredExpression)this._monitoredExpressions.elementAt(n10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Model.b.d(3, "Exception{" + arrayIndexOutOfBoundsException.getMessage() + "} occurred in DebuggeeProcess[" + this.processID() + "]" + ".getMonitoredExpression(" + n10 + ")");
            return null;
        }
    }

    public void hasStopped(short s10, int n10, String string2, Vector vector, int n11) {
        int n12;
        DebuggeeThread debuggeeThread = null;
        if (n10 == 0) {
            int n13 = this._threads == null ? 0 : this._threads.size();
            n12 = 0;
            while (n12 < n13) {
                debuggeeThread = (DebuggeeThread)this._threads.elementAt(n12);
                if (debuggeeThread == null) {
                    ++n12;
                    continue;
                }
                break;
            }
        } else {
            debuggeeThread = this.getThread(n10);
        }
        fn[] fnArray = null;
        if (vector != null && vector.size() > 0) {
            fnArray = new fn[vector.size()];
            n12 = 0;
            while (n12 < vector.size()) {
                int n14 = ((bu)vector.elementAt(n12)).m();
                fnArray[n12] = this.getBreakpoint(n14);
                ++n12;
            }
        }
        this._processStopInfo = new gs(this, s10, debuggeeThread, string2, fnArray);
        if (s10 == 3 || s10 == 11 || s10 == 13 || s10 == 14) {
            this._debugEngine.remove(this);
            if (s10 == 14 && this._debugEngine.canBeReused()) {
                this.addEventListener(new d8());
                return;
            }
        } else {
            this._debugEngine.getEventManager().a(new gt((Object)this, this._processStopInfo, n11), this._eventListeners);
            if (s10 == 5 || s10 == 6 || s10 == 7 || s10 == 8) {
                debuggeeThread.exceptionRaised();
                this._debugEngine.getEventManager().a(new gu((Object)this, this._processStopInfo, string2, n11), this._eventListeners);
            }
        }
    }

    public gs getProcessStopInfo() {
        return this._processStopInfo;
    }

    public boolean run(int n10) throws IOException {
        if (!this._debugEngine.prepareForEPDCRequest(2, n10)) {
            return false;
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_Execute");
        }
        return this._debugEngine.processEPDCRequest(new tp(), n10);
    }

    public boolean removeAllBreakpoints(int n10) throws IOException {
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_BreakpointClear");
        }
        return this._debugEngine.prepareForEPDCRequest(32, n10) && this._debugEngine.processEPDCRequest(new tr(0), n10);
    }

    public boolean terminate(int n10) throws IOException {
        int n11 = 25;
        if (!this._debugEngine.prepareForEPDCRequest(n11, n10)) {
            return false;
        }
        if (Model.b()) {
            Model.b.c(1, "Sending EPDC request: Remote_TerminatePgm");
        }
        return this._debugEngine.processEPDCRequest(new ts(), n10);
    }

    public boolean terminateAbend(int n10) throws IOException {
        int n11 = 25;
        if (!this._debugEngine.prepareForEPDCRequest(n11, n10)) {
            return false;
        }
        if (Model.b()) {
            Model.b.c(1, "Sending EPDC request: Remote_TerminatePgm with EPDC.TerminateAbend");
        }
        return this._debugEngine.processEPDCRequest(new ts(2), n10);
    }

    public boolean detach(int n10, int n11) throws IOException {
        int n12 = 47;
        if (!this._debugEngine.prepareForEPDCRequest(n12, n11)) {
            return false;
        }
        if (Model.b()) {
            Model.b.c(1, "Sending EPDC request: Remote_ProcessDetach");
        }
        return this._debugEngine.processEPDCRequest(new tt(this._processID, n10), n11);
    }

    public boolean monitorStorage(String string2, ml ml2, DebuggeeThread debuggeeThread, int n10, int n11, p8 p82, int n12, int n13) throws IOException {
        return this.monitorStorage(string2, ml2, debuggeeThread, n10, n11, p82, n12, true, string2 != null, null, null, n13);
    }

    public boolean monitorStorage(String string2, ml ml2, DebuggeeThread debuggeeThread, int n10, int n11, p8 p82, int n12, boolean bl2, boolean bl3, akk akk2, d9 d92, int n13) throws IOException {
        da da2 = null;
        if (string2 != null) {
            da2 = new da(ml2 == null ? null : ml2.e(), string2, debuggeeThread == null ? 0 : debuggeeThread.debugEngineAssignedID(), 0);
        }
        return this.monitorStorage(da2, n10, n11, p82.a(), n12, bl2, bl3, akk2, d92, n13);
    }

    public boolean monitorStorage(String string2, ml ml2, DebuggeeThread debuggeeThread, int n10, int n11, p8 p82, int n12, boolean bl2, boolean bl3, int n13) throws IOException {
        return this.monitorStorage(string2, ml2, debuggeeThread, n10, n11, p82, n12, bl2, bl3, null, null, n13);
    }

    public boolean monitorStorage(da da2, int n10, int n11, short s10, int n12, boolean bl2, boolean bl3, akk akk2, d9 d92, int n13) throws IOException {
        int n14 = 18;
        if (!this._debugEngine.prepareForEPDCRequest(n14, n13)) {
            return false;
        }
        if (!this._debugEngine.getCapabilities().g().e()) {
            this._debugEngine.cancelEPDCRequest(n14);
            return false;
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_Storage2");
        }
        return this._debugEngine.processEPDCRequest(new tu(da2, n10, n11, s10, n12, bl2, bl3), akk2, d92, n13);
    }

    public boolean monitorStorage(int n10, int n11, p8 p82, int n12, int n13) throws IOException {
        return this.monitorStorage(null, null, null, n10, n11, p82, n12, true, false, null, null, n13);
    }

    public boolean setAddressBreakpoint(String string2, ml ml2, int n10, int n11, int n12, String string3, int n13, int n14) throws IOException {
        return this.setAddressBreakpoint(true, string2, ml2, n10, n11, n12, string3, n13, n14);
    }

    public boolean setAddressBreakpoint(boolean bl2, String string2, ml ml2, int n10, int n11, int n12, String string3, int n13, int n14) throws IOException {
        return this.setAddressBreakpoint(bl2, string2, ml2, n10, n11, n12, string3, n13, n14, null);
    }

    public boolean setAddressBreakpoint(boolean bl2, String string2, ml ml2, int n10, int n11, int n12, String string3, int n13, int n14, Object object) throws IOException {
        if (!this._debugEngine.prepareForEPDCRequest(1, n14)) {
            return false;
        }
        if (!this._debugEngine.getCapabilities().e().d()) {
            this._debugEngine.cancelEPDCRequest(1);
            return false;
        }
        c9 c92 = null;
        if (n10 != 0 || n11 != 0 || n12 != 0) {
            c92 = new c9(n10, n12, n11);
        }
        da da2 = null;
        if (string3 != null) {
            da2 = new da(null, string3, n13, 0);
        }
        bx bx2 = null;
        if (ml2 != null) {
            bx2 = ml2.e();
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_BreakpointLocation");
        }
        return this._debugEngine.processEPDCRequest(new tv(bl2 ? (short)Short.MIN_VALUE : 0, c92, string2, null, null, null, da2, n13, bx2), n14, object);
    }

    public boolean setWatchpoint(String string2, int n10, int n11, int n12, int n13, int n14, int n15) throws IOException {
        return this.setWatchpoint((short)Short.MIN_VALUE, string2, n10, n11, n12, n13, n14, null, null, null, null, n15, null);
    }

    public boolean setWatchpoint(String string2, int n10, int n11, int n12, int n13, int n14, int n15, Object object) throws IOException {
        return this.setWatchpoint((short)Short.MIN_VALUE, string2, n10, n11, n12, n13, n14, null, null, null, null, n15, object);
    }

    public boolean setWatchpoint(short s10, String string2, int n10, int n11, int n12, int n13, int n14, String string3, String string4, String string5, String string6, int n15) throws IOException {
        return this.setWatchpoint((short)Short.MIN_VALUE, string2, n10, n11, n12, n13, n14, string3, string4, string5, string6, n15, null);
    }

    public boolean setWatchpoint(short s10, String string2, int n10, int n11, int n12, int n13, int n14, String string3, String string4, String string5, String string6, int n15, Object object) throws IOException {
        if (!this._debugEngine.prepareForEPDCRequest(35, n15)) {
            return false;
        }
        if (!this._debugEngine.getCapabilities().e().e()) {
            this._debugEngine.cancelEPDCRequest(35);
            return false;
        }
        c9 c92 = n10 == 0 && n11 == 0 && n12 == 0 ? null : new c9(n10, n12, n11);
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_BreakpointEvent");
        }
        return this._debugEngine.processEPDCRequest(new tx(s10, c92, string2, string3, string4, string5, null, n13, null, n14, string6), n15, object);
    }

    public boolean setModuleLoadBreakpoint(boolean bl2, String string2, int n10, int n11, int n12, int n13, int n14) throws IOException {
        return this.setModuleLoadBreakpoint(bl2, string2, n10, n11, n12, n13, n14, null);
    }

    public boolean setModuleLoadBreakpoint(boolean bl2, String string2, int n10, int n11, int n12, int n13, int n14, Object object) throws IOException {
        if (!this._debugEngine.prepareForEPDCRequest(35, n14)) {
            return false;
        }
        if (!this._debugEngine.getCapabilities().e().f()) {
            this._debugEngine.cancelEPDCRequest(35);
            return false;
        }
        c9 c92 = n10 == 0 && n11 == 0 && n12 == 0 ? null : new c9(n10, n12, n11);
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_BreakpointEvent");
        }
        this._debugEngine.setRequestProperty(object);
        return this._debugEngine.processEPDCRequest(new tz(bl2 ? (short)Short.MIN_VALUE : 0, c92, string2, n13), n14);
    }

    public void tellChildrenThatOwnerHasBeenDeleted() {
        if (Model.b()) {
            Model.b.c(3, "Telling all modules that DebuggeeProcess[" + this.processID() + "]" + " has been deleted");
        }
        int n10 = 0;
        while (n10 < this._modules.size()) {
            if (this._modules.elementAt(n10) != null) {
                ((av)this._modules.elementAt(n10)).e();
            }
            ++n10;
        }
        if (Model.b()) {
            Model.b.c(3, "Telling all threads that DebuggeeProcess[" + this.processID() + "]" + " has been deleted");
        }
        n10 = 0;
        while (n10 < this._threads.size()) {
            if (this._threads.elementAt(n10) != null) {
                ((av)this._threads.elementAt(n10)).e();
            }
            ++n10;
        }
        if (Model.b()) {
            Model.b.c(3, "Telling all monitored expressions that DebuggeeProcess[" + this.processID() + "]" + " has been deleted");
        }
        n10 = 0;
        while (n10 < this._monitoredExpressions.size()) {
            if (this._monitoredExpressions.elementAt(n10) != null) {
                ((av)this._monitoredExpressions.elementAt(n10)).e();
            }
            ++n10;
        }
        if (Model.b()) {
            Model.b.c(3, "Telling all breakpoints that DebuggeeProcess[" + this.processID() + "]" + " has been deleted");
        }
        n10 = 0;
        while (n10 < this._breakpoints.size()) {
            if (this._breakpoints.elementAt(n10) != null) {
                ((av)this._breakpoints.elementAt(n10)).e();
            }
            ++n10;
        }
        if (Model.b()) {
            Model.b.c(3, "Telling storage that DebuggeeProcess[" + this.processID() + "]" + " has been deleted");
        }
        if (this._storage != null) {
            n10 = 0;
            while (n10 < this._storage.size()) {
                if (this._storage.elementAt(n10) != null) {
                    ((av)this._storage.elementAt(n10)).e();
                }
                ++n10;
            }
        }
    }

    public boolean setDeferredLineBreakpoint(boolean bl2, int n10, String string2, String string3, String string4, int n11, int n12, int n13, int n14, String string5, int n15) throws IOException {
        return this.setDeferredLineBreakpoint(bl2, n10, null, string2, string3, string4, n11, n12, n13, n14, string5, n15, null);
    }

    public boolean setDeferredLineBreakpoint(boolean bl2, int n10, String string2, String string3, String string4, int n11, int n12, int n13, int n14, String string5, int n15, Object object) throws IOException {
        return this.setDeferredLineBreakpoint(bl2, n10, null, string2, string3, string4, n11, n12, n13, n14, string5, n15, object);
    }

    public boolean setDeferredLineBreakpoint(boolean bl2, int n10, String string2, String string3, String string4, String string5, int n11, int n12, int n13, int n14, String string6, int n15) throws IOException {
        return this.setDeferredLineBreakpoint(bl2, n10, string2, string3, string4, string5, n11, n12, n13, n14, string6, n15, null);
    }

    public boolean setDeferredLineBreakpoint(boolean bl2, int n10, String string2, String string3, String string4, String string5, int n11, int n12, int n13, int n14, String string6, int n15, Object object) throws IOException {
        if (!this._debugEngine.prepareForEPDCRequest(1, n15)) {
            return false;
        }
        eq eq2 = this._debugEngine.getCapabilities().e();
        if (!eq2.a() || !eq2.k() && string6 != null) {
            this._debugEngine.cancelEPDCRequest(1);
            return false;
        }
        short s10 = 16384;
        if (bl2) {
            s10 = (short)(s10 ^ Short.MIN_VALUE);
        }
        c9 c92 = null;
        if (n12 != 0 || n13 != 0 || n14 != 0) {
            c92 = new c9(n12, n14, n13);
        }
        bx bx2 = new bx(0, 0, 0, n10);
        da da2 = null;
        if (string6 != null) {
            da2 = new da(bx2, string6, 0, 0);
        }
        String string7 = null;
        if (eq2.t()) {
            string7 = Integer.toString(n10);
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request Remote_BreakpointLocation");
        }
        return this._debugEngine.processEPDCRequest(new t0(s10, c92, string2, string3, string4, string5, da2, n11, string7, bx2), n15, object);
    }

    public boolean setDeferredEntryBreakpoint(boolean bl2, String string2, String string3, String string4, int n10, int n11, int n12, int n13, String string5, int n14) throws IOException {
        return this.setDeferredEntryBreakpoint(bl2, string2, string3, string4, n10, n11, n12, n13, string5, n14, null);
    }

    public boolean setDeferredEntryBreakpoint(boolean bl2, String string2, String string3, String string4, int n10, int n11, int n12, int n13, String string5, int n14, Object object) throws IOException {
        if (!this._debugEngine.prepareForEPDCRequest(1, n14)) {
            return false;
        }
        eq eq2 = this._debugEngine.getCapabilities().e();
        if (!eq2.c() || !eq2.k() && string5 != null) {
            this._debugEngine.cancelEPDCRequest(1);
            return false;
        }
        short s10 = 16384;
        if (bl2) {
            s10 = (short)(s10 ^ Short.MIN_VALUE);
        }
        c9 c92 = null;
        if (n11 != 0 || n12 != 0 || n13 != 0) {
            c92 = new c9(n11, n13, n12);
        }
        da da2 = null;
        if (string5 != null) {
            da2 = new da(null, string5, n10, 0);
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request Remote_BreakpointLocation");
        }
        return this._debugEngine.processEPDCRequest(new t1(s10, c92, string2, string3, string4, null, da2, n10, 0), n14, object);
    }

    public boolean monitorExpression(bx bx2, int n10, String string2, byte by2, short s10, String string3, String string4, String string5, int n11) throws IOException {
        e1 e12;
        e2 e22;
        e3 e32;
        ne ne2;
        String string6;
        String string7 = null;
        if (this._debugEngine.getEPDCVersion() > 305 && this._debugEngine.getCapabilities().e().t() && (string6 = (ne2 = (e32 = (e22 = (e12 = this.getPart(bx2.c())).a(bx2.m())).a(bx2.n())).b(bx2.o())).c()) != null) {
            string7 = string6.trim();
        }
        return this.monitorExpression(bx2, n10, string2, by2, s10, string3, string4, string5, string7, n11);
    }

    public boolean monitorExpression(bx bx2, int n10, String string2, byte by2, short s10, String string3, String string4, String string5, String string6, int n11) throws IOException {
        da da2 = new da(bx2, string2, n10, 0);
        if (!this._debugEngine.prepareForEPDCRequest(3, n11)) {
            return false;
        }
        ek ek2 = this._debugEngine.getCapabilities();
        if (!ek2.f().a()) {
            if ((by2 & 0xFFFFFF80) == 0) {
                this._debugEngine.cancelEPDCRequest(3);
            }
            return false;
        }
        nf nf2 = new nf(by2, 0, s10, da2, string3, string4, string5, string6);
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_Expression");
        }
        return this._debugEngine.processEPDCRequest(nf2, n11);
    }

    public boolean restart(int n10) throws IOException {
        gw gw2 = this._debugEngine.getDebuggeeStartupOptions();
        if (gw2 instanceof gv && !this.g()) {
            this._doingARestart = true;
            if (this.terminate(1) && this.f()) {
                return this._debugEngine.prepareProgram(null, n10);
            }
            this._doingARestart = false;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (objectOutputStream instanceof tg) {
            int n10 = ((tg)objectOutputStream).a();
            if ((n10 & Integer.MIN_VALUE) != 0) {
                objectOutputStream.defaultWriteObject();
                return;
            }
            if ((n10 & 0x40000000) != 0) {
                objectOutputStream.writeObject(this._debugEngine);
                objectOutputStream.writeObject(this._threads);
                if ((n10 & 0x20000000) != 0) {
                    Vector vector = new Vector();
                    int n11 = 0;
                    while (n11 < this._breakpoints.size()) {
                        if (this._breakpoints.elementAt(n11) != null && !((fn)this._breakpoints.elementAt(n11)).k()) {
                            vector.addElement(this._breakpoints.elementAt(n11));
                        }
                        ++n11;
                    }
                    objectOutputStream.writeObject(vector);
                }
                if ((n10 & 0x4000000) != 0) {
                    objectOutputStream.writeObject(this._storage);
                }
                if ((n10 & 0x10000000) != 0) {
                    objectOutputStream.writeObject(this._monitoredExpressions);
                    return;
                }
            }
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream instanceof th) {
            int n10 = ((th)objectInputStream).a();
            if ((n10 & Integer.MIN_VALUE) != 0) {
                objectInputStream.defaultReadObject();
                return;
            }
            if ((n10 & 0x40000000) != 0) {
                this._debugEngine = (DebugEngine)objectInputStream.readObject();
                this._threads = (Vector)objectInputStream.readObject();
                if ((n10 & 0x20000000) != 0) {
                    this._breakpoints = (Vector)objectInputStream.readObject();
                }
                if ((n10 & 0x4000000) != 0) {
                    this._storage = (Vector)objectInputStream.readObject();
                }
                if ((n10 & 0x10000000) != 0) {
                    this._monitoredExpressions = (Vector)objectInputStream.readObject();
                    return;
                }
            }
        } else {
            objectInputStream.defaultReadObject();
        }
    }

    public boolean saveRestorableObjects(String string2, int n10, boolean bl2) throws IOException {
        if (string2 == null) {
            if (this._restorableObjects == null) {
                return false;
            }
        } else if (this._restorableObjects == null || !this._restorableObjects.g().equals(string2)) {
            this._restorableObjects = new tc(this, n10, string2);
        }
        this._restorableObjects.a(n10);
        this._restorableObjects.a(bl2);
        return true;
    }

    public boolean restoreSavedObjects(String string2, int n10, boolean bl2) throws IOException {
        if (string2 == null) {
            if (this._restorableObjects == null) {
                return false;
            }
        } else if (this._restorableObjects == null || !this._restorableObjects.g().equals(string2)) {
            this._restorableObjects = new tc(this, n10, string2);
        }
        this._restorableObjects.b(n10);
        return this._restorableObjects.b(bl2);
    }

    public s9 getRestorableObjects() {
        return this._restorableObjects;
    }

    public void stopRestoring() {
        this._restorableObjects.f();
    }

    public void clearAllChangeFlags() {
        this._changeFlags = 0;
    }

    public void setMonitoredExpressionsHaveChanged(boolean bl2) {
        if (bl2) {
            this._changeFlags |= 0x10000000;
            return;
        }
        if ((this._changeFlags & 0x10000000) != 0) {
            this._changeFlags ^= 0x10000000;
        }
    }

    public void setBreakpointsHaveChanged(boolean bl2) {
        if (bl2) {
            this._changeFlags |= 0x20000000;
            return;
        }
        if ((this._changeFlags & 0x20000000) != 0) {
            this._changeFlags ^= 0x20000000;
        }
    }

    public void setStorageMonitorsHaveChanged(boolean bl2) {
        if (bl2) {
            this._changeFlags |= 0x4000000;
            return;
        }
        if ((this._changeFlags & 0x4000000) != 0) {
            this._changeFlags ^= 0x4000000;
        }
    }

    public boolean monitoredExpressionsHaveChanged() {
        return (this._changeFlags & 0x10000000) != 0;
    }

    public boolean breakpointsHaveChanged() {
        return (this._changeFlags & 0x20000000) != 0;
    }

    public boolean storageMonitorsHaveChanged() {
        return (this._changeFlags & 0x4000000) != 0;
    }

    public String getSaveRestoreFileName() {
        String string2 = this._debugEngine.getDebuggeeStartupOptions().g();
        if (string2 == null) {
            string2 = "";
        } else {
            String string3 = System.getProperty("file.separator");
            if (!string2.endsWith(string3)) {
                string2 = String.valueOf(string2) + string3;
            }
        }
        return String.valueOf(string2) + this._profileName + ".@" + au.a(this._debugEngine.getPlatformID()) + Language.getLanguageMnemonic(this._debugEngine.getDominantLanguage());
    }

    public Vector getFunctions(String string2) throws IOException {
        return this.getFunctions(string2, true);
    }

    public Vector getFunctions(String string2, boolean bl2) throws IOException {
        return this.getFunctions(string2, 0, bl2);
    }

    public Vector getFunctions(String string2, int n10, boolean bl2) throws IOException {
        if (string2 == null) {
            return null;
        }
        this._functionsByName = null;
        if (this._debugEngine.prepareForEPDCRequest(10, 1)) {
            if (Model.b()) {
                Model.b.c(2, "Sending EPDC request Remote_EntrySearch");
            }
            this._requestByName = true;
            this._debugEngine.processEPDCRequest(new gy((short)n10, string2, 0, bl2 ? (byte)0 : 1), 1);
            this.resolveFunctions();
        }
        this._requestByName = false;
        return this._functionsByName;
    }

    public void resolveFunctions() throws IOException {
        if (this._unresolvedFunctions == null) {
            return;
        }
        int n10 = this._unresolvedFunctions.size();
        bx bx2 = null;
        int n11 = 0;
        while (n11 < n10) {
            bw bw2 = (bw)this._unresolvedFunctions.elementAt(n11);
            bx2 = this._debugEngine.resolveFunction(bw2);
            if (bx2 != null) {
                bw2.a(bx2);
                this.addFunction(bw2);
            }
            ++n11;
        }
        this._unresolvedFunctions.removeAllElements();
    }

    public void addUnresolvedFunction(bw bw2) {
        if (this._unresolvedFunctions == null) {
            this._unresolvedFunctions = new Vector();
        }
        this._unresolvedFunctions.addElement(bw2);
    }

    public void addFunction(bw bw2) throws IOException {
        g0 g02 = this.getFunction(bw2.c(), false);
        if (g02 == null) {
            int n10;
            bx bx2 = bw2.p();
            e1 e12 = this.getPart(bx2.c());
            e2 e22 = e12.a(bx2.m());
            e3 e32 = e22.b(n10 = bx2.n());
            if (e32 == null) {
                e32 = new e3(e22, n10);
                e22.a(e32);
            }
            g02 = new g0(e32, bw2);
            av.a((Object)g02, this._functions, bw2.c());
            e32.a(g02);
        }
        if (this._requestByName) {
            if (this._functionsByName == null) {
                this._functionsByName = new Vector();
            }
            this._functionsByName.addElement(g02);
        }
    }

    public g0 getFunction(int n10, boolean bl2) throws IOException {
        g0 g02 = null;
        try {
            g02 = (g0)this._functions.elementAt(n10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (g02 == null && bl2 && this._debugEngine.prepareForEPDCRequest(10, 1)) {
            if (Model.b()) {
                Model.b.c(2, "Sending EPDC request Remote_EntrySearch");
            }
            this._debugEngine.processEPDCRequest(new gy(0, null, n10, 0), 1);
            this.resolveFunctions();
            g02 = this.getFunction(n10, false);
        }
        return g02;
    }

    public void setEvaluatedExpression(MonitoredExpression monitoredExpression) {
        this._evaluatedExpression = monitoredExpression;
    }

    public MonitoredExpression getEvaluatedExpression() {
        return this._evaluatedExpression;
    }

    public void removeEvaluatedExpression() {
        this._evaluatedExpression.d();
        this._evaluatedExpression = null;
    }

    public void addEvaluatedExpression(MonitoredExpression monitoredExpression) {
        this._evaluatedExpressions.addElement(monitoredExpression);
    }

    public void removeEvaluatedExpressions() throws IOException {
        Enumeration enumeration = this._evaluatedExpressions.elements();
        while (enumeration.hasMoreElements()) {
            MonitoredExpression monitoredExpression = (MonitoredExpression)enumeration.nextElement();
            if (monitoredExpression == null) continue;
            this._evaluatedExpression = monitoredExpression;
            monitoredExpression.remove(1);
        }
        this._evaluatedExpressions.removeAllElements();
    }

    public boolean heapCheck(boolean bl2, int n10) throws IOException {
        if (!this._debugEngine.prepareForEPDCRequest(214, n10)) {
            return false;
        }
        if (!this._debugEngine.getCapabilities().h().j()) {
            this._debugEngine.cancelEPDCRequest(214);
            return false;
        }
        if (Model.b()) {
            Model.b.c(1, "Sending EPDC request: Remote_StorageUsageCheckSet");
        }
        int n11 = bl2 ? Integer.MIN_VALUE : 0;
        return this._debugEngine.processEPDCRequest(new t6(n11), n10);
    }

    public void setIsPostMortem() {
        this._isPostMortem = true;
    }

    public boolean isPostMortem() {
        return this._isPostMortem;
    }

    public void cleanup() {
        av av2;
        int n10;
        int n11;
        this._qualifiedName = null;
        this._profileName = null;
        if (this._modules != null) {
            n11 = this._modules.size();
            n10 = 0;
            while (n10 < n11) {
                av2 = (ex)this._modules.elementAt(n10);
                if (av2 != null) {
                    ((ex)av2).m();
                }
                ++n10;
            }
            this._modules.removeAllElements();
            this._modules = null;
        }
        if (this._parts != null) {
            n11 = this._parts.size();
            n10 = 0;
            while (n10 < n11) {
                av2 = (e1)this._parts.elementAt(n10);
                if (av2 != null) {
                    ((e1)av2).n();
                }
                ++n10;
            }
            this._parts.removeAllElements();
            this._parts = null;
        }
        if (this._threads != null) {
            n11 = this._threads.size();
            n10 = 0;
            while (n10 < n11) {
                av2 = (DebuggeeThread)this._threads.elementAt(n10);
                if (av2 != null) {
                    ((DebuggeeThread)av2).cleanup();
                }
                ++n10;
            }
            this._threads.removeAllElements();
            this._threads = null;
        }
        this._eventListeners.removeAllElements();
        this._processStopInfo = null;
        this._monitoredExpressions = null;
        this._breakpoints = null;
        if (this._storage != null) {
            n11 = this._storage.size();
            n10 = 0;
            while (n10 < n11) {
                av2 = (Storage)this._storage.elementAt(n10);
                if (av2 != null) {
                    ((Storage)av2).cleanup();
                }
                ++n10;
            }
            this._storage.removeAllElements();
            this._storage = null;
        }
        this._modulesByName = null;
        this._functionsByName = null;
        this._evaluatedExpression = null;
        this._unresolvedFunctions = null;
        this._functions = null;
        this._restorableObjects = null;
    }
}

