/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.model;

import com.ibm.debug.model.DebugEngine;
import com.ibm.debug.model.DebuggeeProcess;
import com.ibm.debug.model.Model;
import com.ibm.debug.model.MonitoredExpression;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class DebuggeeThread
extends av {
    public c0 _epdcThread;
    public DebuggeeProcess _owningProcess;
    public transient Vector _eventListeners = new Vector();
    public e1 _currentPart;
    public gi _stack;
    public Vector _monRegisterGroups;
    public ef _localExpressionsMonitor;
    public boolean _isExceptionRaised = false;
    public ml[] _currentLocation;
    public e6[] _attributes;
    public e6 _nameOrTID;
    public e6 _state;
    public e6 _priority;
    public e6 _group;
    public e6 _blockingThread;

    public DebuggeeThread(DebuggeeProcess debuggeeProcess, c0 c02) {
        if (Model.b()) {
            Model.b.c(1, "Creating DebuggeeThread : OwningProcess=DebuggeeProcess[" + debuggeeProcess.processID() + "] ID=" + c02.p());
        }
        this._owningProcess = debuggeeProcess;
        this.change(c02, true);
    }

    public void addEventListener(mb mb2) {
        this._eventListeners.addElement(mb2);
    }

    public void removeEventListener(mb mb2) {
        int n10;
        if (Model.b()) {
            Model.b.c(2, "DebuggeeThread[" + this.debugEngineAssignedID() + "].removeEventListener(" + mb2 + ")");
        }
        if ((n10 = this._eventListeners.indexOf(mb2)) != -1) {
            try {
                this._eventListeners.setElementAt(null, n10);
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
        }
    }

    public void prepareToDie() {
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        int n10 = debugEngine.getMostRecentReply().c();
        debugEngine.getEventManager().a(new fa(this, this, n10), this._eventListeners);
    }

    public boolean freeze(int n10) throws IOException {
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (this.debugState() != 1) {
            if (!debugEngine.prepareForEPDCRequest(26, n10)) {
                return false;
            }
            if (Model.b()) {
                Model.b.c(2, "Sending EPDC request: Remote_ThreadFreeze");
            }
            return debugEngine.processEPDCRequest(new t7(this.debugEngineAssignedID()), n10);
        }
        return true;
    }

    public boolean thaw(int n10) throws IOException {
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (this.debugState() != 0) {
            if (!debugEngine.prepareForEPDCRequest(27, n10)) {
                return false;
            }
            if (Model.b()) {
                Model.b.c(2, "Sending EPDC request: Remote_ThreadThaw");
            }
            return debugEngine.processEPDCRequest(new t8(this.debugEngineAssignedID()), n10);
        }
        return true;
    }

    public void change(c0 c02, boolean bl2) {
        this._currentLocation = null;
        this._epdcThread = c02;
        bx[] bxArray = c02.r();
        this._currentPart = null;
        int n10 = 0;
        while (n10 < bxArray.length) {
            short s10 = bxArray[n10].c();
            if (s10 != 0) {
                this._currentPart = this._owningProcess.getPart(s10);
                break;
            }
            ++n10;
        }
        this.processAttributes();
        if (bl2) {
            return;
        }
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        int n11 = debugEngine.getMostRecentReply().c();
        debugEngine.getEventManager().a(new e7(this, this, n11), this._eventListeners);
    }

    private void processAttributes() {
        c1[] c1Array;
        int n10 = this._owningProcess.debugEngine().getEPDCVersion();
        if (n10 < 307) {
            c1Array = new c1[3];
            c1Array[0] = new c1(1, null, Integer.toString(this.systemAssignedID()));
            String string2 = Model.a("Thread.State." + this.state());
            c1Array[1] = new c1(2, null, string2);
            c1Array[2] = new c1(3, null, Integer.toString(this.priority()));
        } else {
            c1Array = this._epdcThread.s();
            if (c1Array == null) {
                c1Array = new c1[]{};
            }
        }
        this._attributes = new e6[c1Array.length];
        this._blockingThread = null;
        this._group = null;
        this._priority = null;
        this._state = null;
        this._nameOrTID = null;
        int n11 = 0;
        while (n11 < c1Array.length) {
            this._attributes[n11] = new e6(c1Array[n11]);
            switch (c1Array[n11].c()) {
                case 1: {
                    this._nameOrTID = this._attributes[n11];
                    break;
                }
                case 2: {
                    this._state = this._attributes[n11];
                    break;
                }
                case 3: {
                    this._priority = this._attributes[n11];
                    break;
                }
                case 4: {
                    this._group = this._attributes[n11];
                    break;
                }
                case 5: {
                    this._blockingThread = this._attributes[n11];
                    break;
                }
            }
            ++n11;
        }
    }

    public e6[] getAttributes() {
        return (e6[])this._attributes.clone();
    }

    public e6 getNameOrTID() {
        return this._nameOrTID;
    }

    public e6 getState() {
        return this._state;
    }

    public e6 getPriority() {
        return this._priority;
    }

    public e6 getGroup() {
        return this._group;
    }

    public e6 getBlockingThread() {
        return this._blockingThread;
    }

    public short state() {
        return this._epdcThread.c();
    }

    public short debugState() {
        return this._epdcThread.m();
    }

    public int priority() {
        return this._epdcThread.n();
    }

    public int systemAssignedID() {
        return this._epdcThread.o();
    }

    public int debugEngineAssignedID() {
        return this._epdcThread.p();
    }

    public DebuggeeProcess owningProcess() {
        return this._owningProcess;
    }

    public e1 partInWhichThreadIsCurrentlyStopped() throws IOException {
        DebugEngine debugEngine;
        if (this._currentPart == null && (debugEngine = this._owningProcess.debugEngine()).prepareForEPDCRequest(65, 1)) {
            if (Model.b()) {
                Model.b.c(2, "Sending EPDC request: Remote_ThreadInfoGet");
            }
            py py2 = new py(this.debugEngineAssignedID());
            debugEngine.processEPDCRequest(py2, 1);
        }
        return this._currentPart;
    }

    public ml currentLocationWithinView(eb eb2) throws IOException {
        if (this.partInWhichThreadIsCurrentlyStopped() == null) {
            return null;
        }
        this._owningProcess.debugEngine();
        bx bx2 = this._epdcThread.r()[eb2.m() - 1];
        e2 e22 = this._currentPart.a(eb2);
        if (e22 == null) {
            return null;
        }
        e3 e32 = e22.a(bx2.n());
        int n10 = this._currentPart.k().length;
        short s10 = eb2.m();
        if (this._currentLocation == null) {
            this._currentLocation = new ml[n10 + 1];
        }
        if (this._currentLocation[s10] == null) {
            this._currentLocation[s10] = new ml(e32, bx2.o());
        }
        return this._currentLocation[s10];
    }

    public boolean monitorExpression(ml ml2, String string2, byte by2, int n10) throws IOException {
        return this._owningProcess.monitorExpression(ml2.e(), this._epdcThread.p(), string2, by2, (short)0, null, null, null, n10);
    }

    public boolean monitorExpression(ml ml2, String string2, int n10) throws IOException {
        return this.monitorExpression(ml2, string2, (byte)-128, n10);
    }

    public MonitoredExpression evaluateExpression(ml ml2, String string2, int n10, int n11) throws IOException {
        if (!this._owningProcess.monitorExpression(ml2.e(), this._epdcThread.p(), string2, (byte)-128, (short)2, null, null, null, 1)) {
            return null;
        }
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        ba ba2 = debugEngine.getMostRecentReply();
        if (ba2 == null || ba2.c() != 3 || ba2.m() != 0) {
            return null;
        }
        MonitoredExpression monitoredExpression = this._owningProcess.getEvaluatedExpression();
        fc fc2 = monitoredExpression.getValue();
        if (fc2 instanceof fe) {
            int n12 = 1;
            ((fe)fc2).a(n12, n11, 1);
        }
        this._owningProcess.removeEvaluatedExpressions();
        return monitoredExpression;
    }

    public MonitoredExpression modifyExpression(ml ml2, String string2, String string3) throws IOException {
        if (!this._owningProcess.monitorExpression(ml2.e(), this._epdcThread.p(), string2, (byte)-128, (short)2, null, null, null, 1)) {
            return null;
        }
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        ba ba2 = debugEngine.getMostRecentReply();
        if (ba2 == null || ba2.c() != 3 || ba2.m() != 0) {
            return null;
        }
        MonitoredExpression monitoredExpression = this._owningProcess.getEvaluatedExpression();
        fc fc2 = monitoredExpression.getValue();
        if (!fc2.a(string3, 1)) {
            return null;
        }
        monitoredExpression.remove(1);
        return monitoredExpression;
    }

    public boolean monitorLocalVariables(int n10) throws IOException {
        return this.monitorLocalVariables(n10, 0);
    }

    public boolean monitorLocalVariables(int n10, gl gl2) throws IOException {
        if (gl2 == null) {
            return this.monitorLocalVariables(n10, 0);
        }
        int n11 = gl2.j().o();
        n11 = gl2.j().o();
        return this.monitorLocalVariables(n10, n11);
    }

    public boolean monitorLocalVariables(int n10, int n11) throws IOException {
        int n12 = this._epdcThread.p();
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (!debugEngine.prepareForEPDCRequest(40, n10)) {
            return false;
        }
        if (!debugEngine.getCapabilities().g().a()) {
            debugEngine.cancelEPDCRequest(40);
            return false;
        }
        if (this._localExpressionsMonitor != null) {
            debugEngine.cancelEPDCRequest(40);
            return false;
        }
        if (n11 != 0 && !debugEngine.getCapabilities().f().c()) {
            debugEngine.cancelEPDCRequest(40);
            return false;
        }
        ee ee2 = new ee(n12, n11);
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_LocalVariable for stack entry :" + n11);
        }
        return debugEngine.processEPDCRequest(ee2, n10);
    }

    public synchronized void add(MonitoredExpression monitoredExpression) {
        this._localExpressionsMonitor.a(monitoredExpression);
    }

    public void removeLocalExpressionsMonitor() {
        this._localExpressionsMonitor.b();
        this._localExpressionsMonitor.d();
        this._localExpressionsMonitor = null;
    }

    public void addLocalExpressionsMonitor() {
        this._localExpressionsMonitor = new ef(this);
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        int n10 = debugEngine.getMostRecentReply().c();
        debugEngine.getEventManager().a(new eg(this, this._localExpressionsMonitor, n10), this._eventListeners);
    }

    public ef localExpressionsMonitor() {
        return this._localExpressionsMonitor;
    }

    public boolean runToLocation(ml ml2, int n10) throws IOException {
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (!debugEngine.prepareForEPDCRequest(2, n10)) {
            return false;
        }
        if (!debugEngine.getCapabilities().h().f()) {
            debugEngine.cancelEPDCRequest(2);
            return false;
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_Execute");
        }
        return debugEngine.processEPDCRequest(new ub(this.debugEngineAssignedID(), ml2.e()), n10);
    }

    public boolean jumpToLocation(ml ml2, int n10) throws IOException {
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (!debugEngine.prepareForEPDCRequest(2, n10)) {
            return false;
        }
        if (!debugEngine.getCapabilities().h().g()) {
            debugEngine.cancelEPDCRequest(2);
            return false;
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_Execute");
        }
        return debugEngine.processEPDCRequest(new uc(this.debugEngineAssignedID(), ml2.e()), n10);
    }

    public boolean stepDebug(eb eb2, int n10) throws IOException {
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (!debugEngine.prepareForEPDCRequest(2, n10)) {
            return false;
        }
        if (!debugEngine.getCapabilities().h().d()) {
            debugEngine.cancelEPDCRequest(2);
            return false;
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_Execute");
        }
        return debugEngine.processEPDCRequest(new ud(this.debugEngineAssignedID(), eb2.m()), n10);
    }

    public boolean stepOver(eb eb2, int n10) throws IOException {
        return this.stepOver(eb2, n10, null);
    }

    public boolean stepOver(eb eb2, int n10, Object object) throws IOException {
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (!debugEngine.prepareForEPDCRequest(2, n10)) {
            return false;
        }
        if (!debugEngine.getCapabilities().h().a()) {
            debugEngine.cancelEPDCRequest(2);
            return false;
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_Execute");
        }
        return debugEngine.processEPDCRequest(new ue(this.debugEngineAssignedID(), eb2.m()), n10, object);
    }

    public boolean stepInto(eb eb2, int n10) throws IOException {
        return this.stepInto(eb2, n10, null);
    }

    public boolean stepInto(eb eb2, int n10, Object object) throws IOException {
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (!debugEngine.prepareForEPDCRequest(2, n10)) {
            return false;
        }
        if (!debugEngine.getCapabilities().h().c()) {
            debugEngine.cancelEPDCRequest(2);
            return false;
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_Execute");
        }
        return debugEngine.processEPDCRequest(new uf(this.debugEngineAssignedID(), eb2.m()), n10, object);
    }

    public boolean stepReturn(eb eb2, int n10) throws IOException {
        return this.stepReturn(eb2, n10, null);
    }

    public boolean stepReturn(eb eb2, int n10, Object object) throws IOException {
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (!debugEngine.prepareForEPDCRequest(2, n10)) {
            return false;
        }
        if (!debugEngine.getCapabilities().h().e()) {
            debugEngine.cancelEPDCRequest(2);
            return false;
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_Execute");
        }
        return debugEngine.processEPDCRequest(new ug(this.debugEngineAssignedID(), eb2.m()), n10, object);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("DU: " + this.debugEngineAssignedID());
        printWriter.print("  TID: " + this.systemAssignedID());
        printWriter.print("  State: " + this.state());
        printWriter.print("  Debug State: " + this.debugState());
        printWriter.println("  Priority: " + this.priority());
        try {
            printWriter.println("Thread Stopped in Part: " + this.partInWhichThreadIsCurrentlyStopped().c());
        }
        catch (IOException iOException) {}
        DebugEngine debugEngine = this.owningProcess().debugEngine();
        eb[] ebArray = debugEngine.supportedViews();
        int n10 = 0;
        while (n10 < ebArray.length) {
            if (ebArray[n10] != null) {
                ml ml2 = null;
                try {
                    ml2 = this.currentLocationWithinView(ebArray[n10]);
                }
                catch (IOException iOException) {}
                if (ml2 != null) {
                    printWriter.print("Thread is currently stopped in the ");
                    printWriter.print(String.valueOf(ebArray[n10].a()) + " view at this location: ");
                    ml2.a(printWriter);
                    printWriter.println();
                }
            }
            ++n10;
        }
    }

    public boolean monitorStack(int n10) throws IOException {
        if (this._stack == null) {
            DebugEngine debugEngine = this._owningProcess.debugEngine();
            if (!debugEngine.prepareForEPDCRequest(13, n10)) {
                return false;
            }
            if (!debugEngine.getCapabilities().g().d()) {
                debugEngine.cancelEPDCRequest(13);
                return false;
            }
            if (Model.b()) {
                Model.b.c(2, "Sending EPDC request: Remote_Stack");
            }
            return debugEngine.processEPDCRequest(new uh(this.debugEngineAssignedID()), n10);
        }
        return false;
    }

    public gi getStack() {
        return this._stack;
    }

    public synchronized void add(gi gi2) {
        this._stack = gi2;
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        int n10 = debugEngine.getMostRecentReply().c();
        debugEngine.getEventManager().a(new gj(this, gi2, n10), this._eventListeners);
    }

    public synchronized void removeStack() {
        this._stack.c();
        this._stack.d();
        this._stack = null;
    }

    public void tellChildrenThatOwnerHasBeenDeleted() {
        if (this._stack != null) {
            this._stack.e();
        }
        if (this._monRegisterGroups != null) {
            int n10 = 0;
            while (n10 < this._monRegisterGroups.size()) {
                if (this._monRegisterGroups.elementAt(n10) != null) {
                    ((f8)this._monRegisterGroups.elementAt(n10)).e();
                }
                ++n10;
            }
        }
    }

    public boolean monitorRegisterGroup(f7 f72, int n10) throws IOException {
        if (this.getMonRegisterGroup(f72) == null) {
            DebugEngine debugEngine = this._owningProcess.debugEngine();
            if (!debugEngine.prepareForEPDCRequest(54, n10)) {
                return false;
            }
            if (!debugEngine.getCapabilities().g().c()) {
                debugEngine.cancelEPDCRequest(54);
                return false;
            }
            if (Model.b()) {
                Model.b.c(2, "Sending EPDC request: Remote_Registers2");
            }
            return debugEngine.processEPDCRequest(new f5(this.debugEngineAssignedID(), f72.a(), Integer.MIN_VALUE), n10);
        }
        return false;
    }

    public boolean monitorAllRegisterGroups(int n10) throws IOException {
        if (this._monRegisterGroups == null) {
            DebugEngine debugEngine = this._owningProcess.debugEngine();
            if (debugEngine.getRegisterGroups() == null) {
                return false;
            }
            if (!debugEngine.prepareForEPDCRequest(54, n10)) {
                return false;
            }
            if (!debugEngine.getCapabilities().g().c()) {
                debugEngine.cancelEPDCRequest(54);
                return false;
            }
            if (Model.b()) {
                Model.b.c(2, "Sending EPDC request: Remote_Registers2");
            }
            return debugEngine.processEPDCRequest(new f5(this.debugEngineAssignedID(), 0, Integer.MIN_VALUE), n10);
        }
        return false;
    }

    public synchronized void add(f8 f82) {
        if (this._monRegisterGroups == null) {
            this._monRegisterGroups = new Vector();
        }
        av.a((Object)f82, this._monRegisterGroups, f82.a());
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        int n10 = debugEngine.getMostRecentReply().c();
        debugEngine.getEventManager().a(new f9(this, f82, n10), this._eventListeners);
    }

    public synchronized void addAllMonRegisterGroups() throws IOException {
        DebugEngine debugEngine;
        f7[] f7Array;
        if (this._monRegisterGroups == null) {
            this._monRegisterGroups = new Vector();
        }
        if ((f7Array = (debugEngine = this._owningProcess.debugEngine()).getRegisterGroups()) == null || f7Array.length == 0) {
            if (Model.b()) {
                Model.b.d(1, "RegisterGroups is null");
            }
            return;
        }
        int n10 = 0;
        while (n10 < f7Array.length) {
            this.add(new f8(this, f7Array[n10]));
            ++n10;
        }
    }

    public f8 getMonRegisterGroup(int n10) {
        if (this._monRegisterGroups == null) {
            return null;
        }
        try {
            return (f8)this._monRegisterGroups.elementAt(n10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (Model.b()) {
                Model.b.d(3, "Exception{" + arrayIndexOutOfBoundsException.getMessage() + "} occurred in DebuggeeThread.getMonRegisterGroup(" + n10 + ")");
            }
            return null;
        }
    }

    public Vector getMonRegisterGroups() {
        if (this._monRegisterGroups == null) {
            return null;
        }
        Vector vector = new Vector();
        int n10 = 0;
        while (n10 < this._monRegisterGroups.size()) {
            if (this._monRegisterGroups.elementAt(n10) != null) {
                vector.addElement(this._monRegisterGroups.elementAt(n10));
            }
            ++n10;
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public f8 getMonRegisterGroup(f7 f72) {
        return this.getMonRegisterGroup(f72.a());
    }

    public boolean stopMonitoringAllRegisterGroups(int n10) throws IOException {
        if (this.getMonRegisterGroups() != null) {
            DebugEngine debugEngine = this._owningProcess.debugEngine();
            if (!debugEngine.prepareForEPDCRequest(56, n10)) {
                return false;
            }
            if (!debugEngine.getCapabilities().g().c()) {
                debugEngine.cancelEPDCRequest(56);
                return false;
            }
            if (Model.b()) {
                Model.b.c(2, "Sending EPDC request: Remote_RegistersFree2");
            }
            return debugEngine.processEPDCRequest(new ge(this.debugEngineAssignedID(), 0), n10);
        }
        return false;
    }

    public synchronized void remove(f8 f82) {
        f82.j();
        f82.d();
        try {
            this._monRegisterGroups.setElementAt(null, f82.a());
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (Model.b()) {
                Model.b.d(3, "Exception{" + arrayIndexOutOfBoundsException.getMessage() + "} occurred in DebuggeeThread.remove(MonitoredRegisterGroup<" + f82.i().b() + ">)");
            }
            return;
        }
    }

    public synchronized void removeAllMonRegisterGroups() {
        if (this._monRegisterGroups == null) {
            return;
        }
        int n10 = 0;
        while (n10 < this._monRegisterGroups.size()) {
            if (this._monRegisterGroups.elementAt(n10) != null) {
                this.remove((f8)this._monRegisterGroups.elementAt(n10));
            }
            ++n10;
        }
        this._monRegisterGroups = null;
    }

    public boolean stepException(int n10) throws IOException {
        if (this._isExceptionRaised) {
            this._isExceptionRaised = false;
            DebugEngine debugEngine = this._owningProcess.debugEngine();
            if (!debugEngine.prepareForEPDCRequest(2, n10)) {
                return false;
            }
            if (!debugEngine.getCapabilities().i().d()) {
                debugEngine.cancelEPDCRequest(2);
                return false;
            }
            if (Model.b()) {
                Model.b.c(2, "Sending EPDC request: Remote_Execute");
            }
            return debugEngine.processEPDCRequest(new ui(this.debugEngineAssignedID(), 1), n10);
        }
        return false;
    }

    public boolean runException(int n10) throws IOException {
        if (this._isExceptionRaised) {
            this._isExceptionRaised = false;
            DebugEngine debugEngine = this._owningProcess.debugEngine();
            if (!debugEngine.prepareForEPDCRequest(2, n10)) {
                return false;
            }
            if (!debugEngine.getCapabilities().i().e()) {
                debugEngine.cancelEPDCRequest(2);
                return false;
            }
            if (Model.b()) {
                Model.b.c(2, "Sending EPDC request: Remote_Execute");
            }
            return debugEngine.processEPDCRequest(new uj(this.debugEngineAssignedID(), 1), n10);
        }
        return false;
    }

    public boolean ignoreException(int n10) throws IOException {
        if (this._isExceptionRaised) {
            this._isExceptionRaised = false;
            DebugEngine debugEngine = this._owningProcess.debugEngine();
            if (!debugEngine.prepareForEPDCRequest(2, n10)) {
                return false;
            }
            if (!debugEngine.getCapabilities().i().c()) {
                debugEngine.cancelEPDCRequest(2);
                return false;
            }
            if (Model.b()) {
                Model.b.c(2, "Sending EPDC request: Remote_Execute");
            }
            return debugEngine.processEPDCRequest(new uk(this.debugEngineAssignedID(), 1), n10);
        }
        return false;
    }

    public void exceptionRaised() {
        this._isExceptionRaised = true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (objectOutputStream instanceof tg) {
            int n10 = ((tg)objectOutputStream).a();
            if ((n10 & Integer.MIN_VALUE) != 0) {
                objectOutputStream.defaultWriteObject();
                return;
            }
            if ((n10 & 0x40000000) != 0) {
                objectOutputStream.writeObject(this._epdcThread);
                return;
            }
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream instanceof th) {
            int n10 = ((th)objectInputStream).a();
            if ((n10 & Integer.MIN_VALUE) != 0) {
                objectInputStream.defaultReadObject();
                return;
            }
            if ((n10 & 0x40000000) != 0) {
                this._epdcThread = (c0)objectInputStream.readObject();
                return;
            }
        } else {
            objectInputStream.defaultReadObject();
        }
    }

    public boolean executeForkAndFollowChild(int n10) throws IOException {
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (!debugEngine.prepareForEPDCRequest(2, n10)) {
            return false;
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_Execute (ForkFollowChild)");
        }
        ul ul2 = new ul(0);
        return debugEngine.processEPDCRequest(ul2, n10);
    }

    public boolean executeForkAndFollowParent(int n10) throws IOException {
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (!debugEngine.prepareForEPDCRequest(2, n10)) {
            return false;
        }
        if (Model.b()) {
            Model.b.c(2, "Sending EPDC request: Remote_Execute (ForkFollowParent)");
        }
        um um2 = new um(0);
        return debugEngine.processEPDCRequest(um2, n10);
    }

    public void cleanup() {
        this._epdcThread = null;
        this._owningProcess = null;
        if (this._eventListeners != null) {
            this._eventListeners.removeAllElements();
        }
        this._currentPart = null;
        this._stack = null;
        this._monRegisterGroups = null;
        this._localExpressionsMonitor = null;
        this._currentLocation = null;
        this._attributes = null;
        this._blockingThread = null;
        this._group = null;
        this._priority = null;
        this._state = null;
        this._nameOrTID = null;
    }
}

