/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.model;

import com.ibm.debug.model.DebugEngine;
import com.ibm.debug.model.DebuggeeProcess;
import com.ibm.debug.model.DebuggeeThread;
import com.ibm.debug.model.Model;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class Storage
extends av {
    public transient Vector _eventListeners = new Vector();
    public DebuggeeProcess _owningProcess;
    public short _id;
    public Vector _storageLines;
    public int _numberOfUnitsPerLine;
    public String _address;
    public short _storageStyle;
    public int _firstLineOffset;
    public int _lastLineOffset;
    public da _expression;
    public boolean _isEnabled;
    public boolean _exprIsEnabled;

    public Storage(DebuggeeProcess debuggeeProcess, dq dq2) {
        this._owningProcess = debuggeeProcess;
        this._id = dq2.o();
        debuggeeProcess.add(this);
        this.change(dq2, true);
    }

    public void addEventListener(p4 p42) {
        this._eventListeners.addElement(p42);
    }

    public void removeEventListener(p4 p42) {
        int n10 = this._eventListeners.indexOf(p42);
        if (n10 != -1) {
            try {
                this._eventListeners.setElementAt(null, n10);
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
        }
    }

    public void change(dq dq2, boolean bl2) {
        int n10;
        this._firstLineOffset = dq2.c();
        this._lastLineOffset = dq2.m();
        this._address = dq2.n();
        this._numberOfUnitsPerLine = dq2.z();
        this._storageStyle = dq2.aa();
        this._expression = dq2.ab();
        this._isEnabled = dq2.t();
        this._exprIsEnabled = dq2.u();
        dt[] dtArray = dq2.v();
        if (!bl2 && (dq2.r() || dq2.s())) {
            this._storageLines = new Vector(dtArray.length);
            DebugEngine debugEngine = this._owningProcess.debugEngine();
            n10 = debugEngine.getMostRecentReply().c();
            debugEngine.getEventManager().a(new fz(this, this, n10), this._eventListeners);
        } else if (this._storageLines == null && dtArray != null) {
            this._storageLines = new Vector(dtArray.length);
        }
        if (dtArray == null) {
            return;
        }
        int n11 = 0;
        while (n11 < dtArray.length) {
            n10 = dtArray[n11].c();
            if (n10 >= this._storageLines.size() || this._storageLines.elementAt(n10) == null) {
                f0 f02 = new f0(this, dtArray[n11], this._firstLineOffset + n10);
                av.a((Object)f02, this._storageLines, n10);
            } else {
                ((f0)this._storageLines.elementAt(n10)).a(dtArray[n11], false);
            }
            ++n11;
        }
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public boolean expressionIsEnabled() {
        return this._exprIsEnabled;
    }

    public boolean enable() throws IOException {
        if (!this._owningProcess.debugEngine().getCapabilities().d().c()) {
            if (Model.b()) {
                Model.b.d(2, "Engine does not support storage monitor enable/disable");
            }
            return false;
        }
        if (!this._isEnabled) {
            return this.changeEnablement(true, this._exprIsEnabled);
        }
        return true;
    }

    public boolean disable() throws IOException {
        if (!this._owningProcess.debugEngine().getCapabilities().d().c()) {
            if (Model.b()) {
                Model.b.d(2, "Engine does not support storage monitor enable/disable");
            }
            return false;
        }
        if (this._isEnabled) {
            return this.changeEnablement(false, this._exprIsEnabled);
        }
        return true;
    }

    public boolean enableExpression() throws IOException {
        if (!this._owningProcess.debugEngine().getCapabilities().d().d()) {
            if (Model.b()) {
                Model.b.d(2, "Engine does not support storage monitor expr enable/disable");
            }
            return false;
        }
        if (!this._exprIsEnabled) {
            return this.changeEnablement(this._isEnabled, true);
        }
        return true;
    }

    public boolean disableExpression() throws IOException {
        if (!this._owningProcess.debugEngine().getCapabilities().d().d()) {
            if (Model.b()) {
                Model.b.d(2, "Engine does not support storage monitor expr enable/disable");
            }
            return false;
        }
        if (this._exprIsEnabled) {
            return this.changeEnablement(this._isEnabled, false);
        }
        return true;
    }

    private boolean changeEnablement(boolean bl2, boolean bl3) throws IOException {
        int n10;
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (!debugEngine.prepareForEPDCRequest(n10 = 19, 1) || !debugEngine.processEPDCRequest(new uy(this._id, bl2, bl3), 1)) {
            return false;
        }
        if (debugEngine.getMostRecentReply().m() != 0) {
            return false;
        }
        this._isEnabled = bl2;
        this._exprIsEnabled = bl3;
        return true;
    }

    public boolean update(String string2, int n10, int n11, int n12, int n13, int n14) throws IOException {
        int n15;
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (!debugEngine.prepareForEPDCRequest(n15 = 23, n14)) {
            return false;
        }
        return debugEngine.processEPDCRequest(new uz(this._id, this._address, n12, n13, n11, n10, string2), n14);
    }

    public int getNumberOfUnitsPerLine() {
        return this._numberOfUnitsPerLine;
    }

    public DebuggeeProcess getOwningProcess() {
        return this._owningProcess;
    }

    public p8 getStorageStyle() {
        return p8.a(this._storageStyle);
    }

    public String getAddress() {
        return this._address;
    }

    public Vector getStorageLines() {
        return this._storageLines;
    }

    public boolean setStyle(p8 p82, int n10, int n11) throws IOException {
        int n12;
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (!debugEngine.prepareForEPDCRequest(n12 = 22, n11)) {
            return false;
        }
        return debugEngine.processEPDCRequest(new u0(this._id, this._address, p82.a(), n10), n11);
    }

    public boolean setAddress(String string2, ml ml2, DebuggeeThread debuggeeThread, int n10) throws IOException {
        return this.setAddressAndRange(string2, ml2, debuggeeThread, this._firstLineOffset, this._lastLineOffset, n10);
    }

    public boolean setAddressAndRange(String string2, ml ml2, DebuggeeThread debuggeeThread, int n10, int n11, int n12) throws IOException {
        da da2 = new da(ml2 == null ? null : ml2.e(), string2, debuggeeThread == null ? 0 : debuggeeThread.debugEngineAssignedID(), 0);
        return this.setAddressAndRange(da2, n10, n11, n12);
    }

    private boolean setAddressAndRange(da da2, int n10, int n11, int n12) throws IOException {
        int n13;
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        if (!debugEngine.prepareForEPDCRequest(n13 = 21, n12)) {
            return false;
        }
        return debugEngine.processEPDCRequest(new u1(this._id, da2, n10, n11, this._isEnabled, this._exprIsEnabled), n12);
    }

    public boolean setRange(int n10, int n11, int n12) throws IOException {
        return this.setAddressAndRange(this._expression == null || this._expression.m() == null ? new da(null, this._address, 0, 0) : this._expression, n10, n11, n12);
    }

    public boolean remove(int n10) throws IOException {
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        return debugEngine.prepareForEPDCRequest(20, n10) && debugEngine.processEPDCRequest(new u2(this._id), n10);
    }

    public void prepareToDie() {
        DebugEngine debugEngine = this._owningProcess.debugEngine();
        int n10 = debugEngine.getMostRecentReply().c();
        debugEngine.getEventManager().a(new f4(this, this, n10), this._eventListeners);
    }

    public short id() {
        return this._id;
    }

    public int getFirstLineOffset() {
        return this._firstLineOffset;
    }

    public int getLastLineOffset() {
        return this._lastLineOffset;
    }

    public String getExpression() {
        if (this._expression == null) {
            return null;
        }
        return this._expression.m();
    }

    public DebuggeeThread getExpressionThread() {
        if (this._expression == null) {
            return null;
        }
        return this._owningProcess.thread(this._expression.n());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (objectOutputStream instanceof tg) {
            int n10 = ((tg)objectOutputStream).a();
            if ((n10 & Integer.MIN_VALUE) != 0) {
                objectOutputStream.defaultWriteObject();
                return;
            }
            objectOutputStream.writeInt(this._numberOfUnitsPerLine);
            objectOutputStream.writeShort(this._storageStyle);
            objectOutputStream.writeInt(this._firstLineOffset);
            objectOutputStream.writeInt(this._lastLineOffset);
            objectOutputStream.writeObject(this._expression);
            objectOutputStream.writeBoolean(this._isEnabled);
            objectOutputStream.writeBoolean(this._exprIsEnabled);
            return;
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream instanceof th) {
            int n10 = ((th)objectInputStream).a();
            if ((n10 & Integer.MIN_VALUE) != 0) {
                objectInputStream.defaultReadObject();
                return;
            }
            this._numberOfUnitsPerLine = objectInputStream.readInt();
            this._storageStyle = objectInputStream.readShort();
            this._firstLineOffset = objectInputStream.readInt();
            this._lastLineOffset = objectInputStream.readInt();
            this._expression = (da)objectInputStream.readObject();
            this._isEnabled = objectInputStream.readBoolean();
            this._exprIsEnabled = objectInputStream.readBoolean();
            return;
        }
        objectInputStream.defaultReadObject();
    }

    public boolean restore(DebuggeeProcess debuggeeProcess, int n10) throws IOException {
        return debuggeeProcess.monitorStorage(this._expression, this._firstLineOffset, this._lastLineOffset, this._storageStyle, this._numberOfUnitsPerLine, this._isEnabled, this._exprIsEnabled, null, null, n10);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("Addr=" + this._address + " ");
        printWriter.print("Units per line=" + this._numberOfUnitsPerLine + " ");
        printWriter.print("Is enabled=" + this._isEnabled);
        printWriter.print("   Expr is enabled=" + this._exprIsEnabled);
        DebuggeeThread debuggeeThread = this.getExpressionThread();
        if (debuggeeThread != null) {
            printWriter.println("   Expr thread id=" + debuggeeThread.debugEngineAssignedID());
        }
        this.getStorageStyle().print(printWriter);
        printWriter.println();
        if (this._storageLines == null) {
            return;
        }
        int n10 = 0;
        while (n10 < this._storageLines.size()) {
            if (this._storageLines.elementAt(n10) != null) {
                ((f0)this._storageLines.elementAt(n10)).print(printWriter);
            }
            ++n10;
        }
    }

    public void cleanup() {
        if (this._eventListeners != null) {
            this._eventListeners.removeAllElements();
        }
        this._owningProcess = null;
        if (this._storageLines != null) {
            int n10 = this._storageLines.size();
            int n11 = 0;
            while (n11 < n10) {
                f0 f02 = (f0)this._storageLines.elementAt(n11);
                if (f02 != null) {
                    f02.k();
                }
                ++n11;
            }
            this._storageLines.removeAllElements();
            this._storageLines = null;
        }
        this._address = null;
        this._expression = null;
    }
}

