/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.ui;

import com.ibm.debug.model.DebugEngine;
import com.ibm.debug.model.Model;
import com.ibm.debug.ui.DebuggerConstants;
import com.ibm.debug.ui.DebuggerController;
import com.ibm.debug.ui.DebuggerInformationDialog;
import com.ibm.debug.ui.DebuggerOptionErrorDialog;
import com.ibm.debug.ui.DirectoryImageGetter;
import com.ibm.debug.ui.MessageServices;
import com.ibm.debug.ui.StartDebugSessionEvent;
import com.ibm.debug.ui.StartDebuggerEvent;
import com.ibm.debug.util.BuildInformation;
import com.ibm.debug.util.Platform;
import com.ibm.debug.util.TraceLogger;
import com.ibm.ivb.jface.util.ImageUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public final class Debugger
extends WindowAdapter
implements c,
DebuggerConstants,
PropertyChangeListener,
e {
    public static final String copyright1 = "IBM Distributed Debugger (User Interface)";
    public static final String copyright2 = "Version " + BuildInformation.c() + " (" + BuildInformation.b() + ") - Licensed Material - Property of IBM";
    public static final String copyright3 = "(c) Copyright IBM Corp 1991, 2002  All Rights Reserved";
    public static final String copyright4 = "US Government Users Restricted Rights - Use, duplication or disclosure";
    public static final String copyright5 = "restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static TraceLogger TRACE = new TraceLogger("UI");
    public static boolean daemonDialogHidden;
    public static Debugger debugger;
    public static boolean debuggerTerminating;
    public static Hashtable terminationListeners;
    public static kd splash;
    public static BuildInformation buildInformation;
    public static InetAddress _localAddress;
    public static hu application;
    public static boolean applicationInitComplete;
    public static kr startupEnvarFile;
    public static String userClasspath;
    public static final String PATHSEP;
    public static final String FILESEP;
    public static final char PATHSEP_CHAR;
    public static final char FILESEP_CHAR;
    public static final Cursor waitCursor;
    public static final Cursor readyCursor;
    public static ic ibmVaHlp;
    public static boolean debuggerHasFocus;
    public static boolean reuse;
    public static String daemonPortListensTo;
    public static boolean alwaysHaveDaemonWithDefaultPort;
    public String appKey;
    public ix debuggerFrame;
    public f daemons = new f(this);
    public w product;
    public g optionsParser;
    public String installDirectory;
    public String profileDirectory;
    public String homeDirectory;
    public String protectedHomeDirectory;
    public String helpRoot;
    public String helpDirectory;
    public String helpEnUsDirectory;
    public File errorLogFile;
    public int errorLogLimit = 100000;
    public PrintStream originalErrorStream;
    public boolean installDirectoryContainsEngine = false;
    public boolean hosted = true;
    public static int defaultSoTimeout;
    public static aa cmdLineSocketServer;
    public static hk sessionManagerClient;
    public static String thisUser;
    public static String display;
    public static int activeSessionCount;
    public static Stack activeDialog;
    public static Runtime runtime;
    public static long heapSize;
    public static final int defaultLabelHeightAdjustment = 0;
    public static final int defaultComboBoxHeightAdjustment = 4;
    public static final int defaultTextFieldHeightAdjustment = 4;
    public static int labelHeightAdjustment;
    public static int comboBoxHeightAdjustment;
    public static int textFieldHeightAdjustment;
    public boolean cleanupHasRun;
    public static /* synthetic */ Class class$com$ibm$debug$ui$Debugger;

    public void setApplicationKey(String string2) {
        this.appKey = string2;
    }

    public static BuildInformation getBuildInformation() {
        return buildInformation;
    }

    public String getApplicationKey() {
        return this.appKey;
    }

    public hu getApplication() {
        return application;
    }

    public synchronized void setActiveDialog(ac ac10) {
        ac ac11 = null;
        TRACE.c(1, "Debugger.setActiveDialog(" + (ac10 != null ? ac10.getClass().getName() : "null") + ")");
        if (ac10 == null || !ac10.isModal()) {
            return;
        }
        if (!activeDialog.empty() && activeDialog.peek() == ac10) {
            TRACE.d(2, "Debugger.setActiveDialog already the active UIDialog");
            return;
        }
        if (!activeDialog.empty()) {
            ac11 = (ac)activeDialog.peek();
        }
        activeDialog.push(ac10);
        if (this.getFrame().isEnabled()) {
            this.getFrame().setEnabled(false);
        } else if (ac11 != null) {
            ac11.setEnabled(false);
        }
        if (ar.a().aa()) {
            pw pw2 = new pw(this, ac10);
            pw2.start();
        }
    }

    public synchronized void removeActiveDialog(ac ac10) {
        TRACE.c(1, "Debugger.removeActiveDialog(" + (ac10 != null ? ac10.getClass().getName() : "null") + ")");
        if (ac10 == null || !ac10.isModal()) {
            return;
        }
        if (activeDialog.empty() || activeDialog.peek() != ac10) {
            TRACE.d(2, "Debugger.removeActiveDialog NOT the active dialog");
            return;
        }
        activeDialog.pop();
        if (activeDialog.empty() && !this.getFrame().isEnabled()) {
            this.getFrame().setEnabled(true);
            return;
        }
        if (!activeDialog.empty() && ((ac)activeDialog.peek()).isVisible()) {
            if (ar.a().aa()) {
                ((ac)activeDialog.peek()).toFront();
            }
            ((ac)activeDialog.peek()).setEnabled(true);
            if (this.getFrame().isEnabled()) {
                this.getFrame().setEnabled(false);
            }
        }
    }

    public synchronized ac getActiveDialog() {
        if (activeDialog.empty()) {
            return null;
        }
        return (ac)activeDialog.peek();
    }

    public synchronized boolean onActiveDialogStack(ac ac10) {
        if (ac10 == null) {
            return false;
        }
        return activeDialog.search(ac10) > -1;
    }

    public synchronized ac getLastVisibleActiveDialog() {
        ac ac10 = null;
        Stack stack = new Stack();
        while (!activeDialog.empty()) {
            if (((ac)activeDialog.peek()).isVisible()) {
                ac10 = (ac)activeDialog.peek();
                while (!stack.empty()) {
                    activeDialog.push(stack.pop());
                }
                break;
            }
            stack.push(activeDialog.pop());
        }
        if (activeDialog.empty() && !stack.empty()) {
            while (!stack.empty()) {
                activeDialog.push(stack.pop());
            }
        }
        return ac10;
    }

    private synchronized void buildApplication() {
        if (application != null) {
            return;
        }
        TRACE.c(1, "Debugger.buildApplication() start");
        this.setApplicationKey("com.ibm.debug.ui.Debugger");
        application = hu.b("com.ibm.debug.ui.Debugger");
        application.k("DebuggerResources");
        application.l("Workbook9.ini");
        application.h("default");
        application.m("working9");
        application.i(debugger.getHomeDirectory());
        application.j(debugger.getProtectedHomeDirectory());
        application.a(false);
        application.s();
        this.setFrame((ix)this.createApplicationFrame());
        applicationInitComplete = true;
        if (!(this.getOptionsParser().bb() || ibmVaHlp != null && ibmVaHlp.c().toLowerCase().indexOf("derhlp.cfg") <= 0)) {
            boolean bl2 = application.p().a("_JFaceGeneralShowLogo");
            bl2 = false;
            if (bl2) {
                debugger.showSplashScreen(2500);
            }
        }
        kj kj2 = new kj();
        application.a(kj2);
        TRACE.c(1, "Debugger.buildApplication() complete");
    }

    public in createApplicationFrame() {
        this.debuggerFrame = new ix(MessageServices.getMessage("MFrameTitle"));
        this.debuggerFrame.setApplicationKey(this.getApplicationKey());
        this.debuggerFrame.d("StandaloneDebugger");
        this.debuggerFrame.b("MiClose");
        this.debuggerFrame.b("MiDetachPage");
        this.debuggerFrame.b("MiPaneDetach");
        this.debuggerFrame.b("MiPaneMaximize");
        this.debuggerFrame.b("MiPaneMinimize");
        this.debuggerFrame.b("MiPaneRestore");
        this.debuggerFrame.a("MWindows");
        this.debuggerFrame.a("MSelected");
        Debugger.getDebugger().getApplication().p().a("page_detaching_disabled", true);
        this.debuggerFrame.a();
        this.debuggerFrame.c();
        this.debuggerFrame.o().setMessageHistoryEnabled(false);
        this.debuggerFrame.addWindowListener(this);
        hd hd2 = this.debuggerFrame.s().s();
        hd2.addKeyListener((DebuggerController)this.debuggerFrame.r());
        Image image = null;
        String string2 = Debugger.getDebugger().getProductDescription().e();
        if (string2 == null || string2.equals("")) {
            TRACE.d(1, "Debugger.getProductDescription().getDebuggerIcon()==null");
            string2 = MessageServices.getMessage("ProductDescription.DefaultDebuggerIcon");
        }
        if ((image = ImageUtil.loadImage(Debugger.getDebugger().getClass(), string2)) == null) {
            TRACE.d(1, "Debugger could not load icon image=" + string2);
        } else {
            ((Frame)this.debuggerFrame).setIconImage(image);
        }
        return this.debuggerFrame;
    }

    public static String getUserClasspath() {
        return userClasspath;
    }

    public static void setUserClasspath(String string2) {
        userClasspath = string2;
    }

    public f getDaemonSupport() {
        return this.daemons;
    }

    public boolean getDaemonStarted() {
        return this.getDaemonSupport().f();
    }

    public File getDebuggerResourceFile(String string2) {
        hu hu2 = this.getApplication();
        if (hu2 == null) {
            return null;
        }
        String string3 = String.valueOf(hu2.l()) + FILESEP + string2;
        File file2 = new File(string3);
        if (file2.exists()) {
            return file2;
        }
        string3 = String.valueOf(hu2.o()) + FILESEP + string2;
        file2 = new File(string3);
        if (file2.exists()) {
            return file2;
        }
        u3 u32 = new u3();
        String[] stringArray = u32.b();
        int n10 = 0;
        while (n10 < stringArray.length) {
            String string4 = stringArray[n10];
            if (string4.indexOf(".jar") == -1 && (file2 = new File(string3 = String.valueOf(string4) + FILESEP + string2)).exists()) {
                return file2;
            }
            ++n10;
        }
        return null;
    }

    public boolean checkOptions(g g10) {
        w w10 = null;
        w w11 = null;
        String[] stringArray = g10.bl();
        if (stringArray.length > 0) {
            JFrame jFrame = new JFrame();
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                System.out.println("Error loading L&F: " + exception);
            }
            ImageIcon imageIcon = new ImageIcon(DirectoryImageGetter.loadImage("images/idebug.gif"));
            ((Frame)jFrame).setIconImage(imageIcon.getImage());
            new DebuggerOptionErrorDialog(jFrame, stringArray[0]);
            return false;
        }
        if (g10.y()) {
            String[] stringArray2 = this.getProductFilesLocally();
            if (stringArray2 != null || stringArray2.length >= 1) {
                int n10 = 0;
                while (n10 < stringArray2.length) {
                    w11 = new w(this, stringArray2[n10], false);
                    if (w10 != null) {
                        w10.a(w11);
                    } else {
                        w10 = w11;
                    }
                    ++n10;
                }
            }
            JFrame jFrame = new JFrame();
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                System.out.println("Error loading L&F: " + exception);
            }
            ImageIcon imageIcon = new ImageIcon(DirectoryImageGetter.loadImage("images/idebug.gif"));
            ((Frame)jFrame).setIconImage(imageIcon.getImage());
            new DebuggerInformationDialog(jFrame, w10.f());
            System.exit(0);
        }
        return true;
    }

    public String[] getProductFilesLocally() {
        File file2 = new File(this.installDirectory);
        String[] stringArray = this.getProductFilesInDirectory(file2);
        if (stringArray != null) {
            return stringArray;
        }
        String string2 = this.installDirectory;
        string2 = string2.substring(string2.length() - 1).equals(FILESEP) ? String.valueOf(string2) + "lib" + FILESEP : String.valueOf(string2) + FILESEP + "lib" + FILESEP;
        return this.getProductFilesInDirectory(new File(string2));
    }

    public String[] getProductFilesInDirectory(File file2) {
        block3: {
            v v10 = new v();
            if (file2 == null || !file2.exists() || !file2.isDirectory()) break block3;
            try {
                String[] stringArray = file2.list(v10);
                if (stringArray != null && stringArray.length > 0) {
                    return stringArray;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public ix getFrame() {
        return this.debuggerFrame;
    }

    public void setFrame(ix ix2) {
        this.debuggerFrame = ix2;
    }

    public int getViewFilePrefetchSize() {
        switch (ar.a().y()) {
            case 0: {
                return 80;
            }
            case 1: {
                return 120;
            }
            case 2: {
                return 160;
            }
        }
        return 80;
    }

    public boolean startDebugger() {
        if (this.getFrame() == null) {
            TRACE.d(1, "Could not start the debugger.  No frame set!!");
            return false;
        }
        if (!this.checkOptions(this.getOptionsParser())) {
            TRACE.d(2, "checkOptions failed !!!");
            return false;
        }
        if (!this.startDaemons()) {
            TRACE.d(2, "startDaemons failed !!!");
            return false;
        }
        StartDebuggerEvent startDebuggerEvent = new StartDebuggerEvent(this.getFrame(), this.getOptionsParser());
        this.getFrame().a(startDebuggerEvent);
        boolean bl2 = startDebuggerEvent.isStartupSuccessful();
        return bl2;
    }

    public boolean startDebugger(String[] stringArray) {
        this.setOptionsParser(this.parseOptions(stringArray));
        return this.startDebugger();
    }

    public boolean terminateDebugger(boolean bl2) {
        f f10;
        Object object;
        Serializable serializable;
        bl2 = false;
        if (this.debuggerFrame != null) {
            ar.a().a(this.debuggerFrame.getSize());
            ar.a().a(this.debuggerFrame.getLocation());
        }
        ar.a().a();
        Vector vector = Model.a();
        if (vector != null && vector.size() != 0) {
            int n10 = 0;
            while (n10 < vector.size()) {
                serializable = (au)vector.elementAt(n10);
                if (serializable != null && (object = ((au)serializable).b()) != null && ((DebugEngine[])object).length != 0) {
                    int n11 = 0;
                    while (n11 < ((Object)object).length) {
                        Object object2 = object[n11];
                        if (object2 != null) {
                            try {
                                ((DebugEngine)object2).terminate(1);
                            }
                            catch (Exception exception) {}
                        }
                        ++n11;
                    }
                }
                ++n10;
            }
        }
        if (bl2 && this.getDaemonStarted()) {
            DebuggerController.a();
            aq.a(new hi(this));
            return false;
        }
        this.setDebuggerTerminating();
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit((boolean)false);
        if (sessionManagerClient != null) {
            sessionManagerClient.a();
            sessionManagerClient = null;
        }
        if (cmdLineSocketServer != null) {
            cmdLineSocketServer.b();
            cmdLineSocketServer = null;
        }
        if ((f10 = this.getDaemonSupport()) != null) {
            f10.e();
            f10.g();
        }
        if (application != null) {
            serializable = application.n();
            if (serializable != null) {
                object = ((Properties)serializable).propertyNames();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    if (string2 == null || !string2.startsWith("toolbar.")) continue;
                    ((Hashtable)serializable).remove(string2);
                }
            }
            application.b(0);
        }
        System.out.println("");
        System.err.println("");
        return true;
    }

    public static final int getSoTimeout() {
        if (defaultSoTimeout <= 0) {
            String string2 = System.getProperty("idebug.SO_TIMEOUT");
            if (string2 != null) {
                try {
                    defaultSoTimeout = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (defaultSoTimeout <= 0) {
                defaultSoTimeout = 10000;
            }
        }
        return defaultSoTimeout;
    }

    public boolean startDaemons() {
        return this.startDaemons(this.getOptionsParser(), false);
    }

    public boolean startDaemons(g g10, boolean bl2) {
        String string2;
        String[] stringArray;
        int n10;
        if (alwaysHaveDaemonWithDefaultPort && !g10.bf() && !g10.bh()) {
            g10.g(this.product.h());
        }
        Vector vector = this.getDaemonSupport().a(g10);
        Vector<String> vector2 = new Vector<String>();
        boolean bl3 = false;
        if (vector != null && vector.size() > 0) {
            TRACE.d(1, "Error occurred on " + this.getClass().getName() + ": createDaemons() failed to create some daemons(s)");
            bl3 = true;
            n10 = 0;
            while (n10 < vector.size()) {
                stringArray = new String[]{(String)vector.elementAt(n10)};
                string2 = MessageServices.getMessage("MBadDaemonCreation", stringArray);
                vector2.addElement(string2);
                ++n10;
            }
        }
        if ((vector = this.getDaemonSupport().d()) != null && vector.size() > 0) {
            TRACE.d(1, "Error occurred on " + this.getClass().getName() + ": startDaemons() failed to start some daemons(s)");
            bl3 = true;
            n10 = 0;
            while (n10 < vector.size()) {
                stringArray = new String[]{vector.elementAt(n10).toString()};
                string2 = MessageServices.getMessage("MBadDaemonStart", stringArray);
                vector2.addElement(string2);
                ++n10;
            }
        }
        if (!bl3 && g10.a3() && !this.getDaemonSupport().f()) {
            vector2.addElement(MessageServices.getMessage("MNoDaemonsToStart"));
            bl3 = true;
        }
        if (bl3) {
            if (bl2) {
                return false;
            }
            String[] stringArray2 = g10.a3() ? new String[vector2.size() + 1] : new String[vector2.size()];
            int n11 = 0;
            while (n11 < vector2.size()) {
                stringArray2[n11] = (String)vector2.elementAt(n11);
                ++n11;
            }
            if (g10.a3()) {
                stringArray2[vector2.size()] = MessageServices.getMessage("MBadDaemonStartup");
                JOptionPane.showMessageDialog(null, stringArray2, MessageServices.getMessage("MDialogTitle"), 0);
                return false;
            }
            JOptionPane.showMessageDialog(null, stringArray2, MessageServices.getMessage("MDialogTitle"), 1);
        }
        return true;
    }

    public void showDebuggerFrame() {
        if (this.isHosted()) {
            return;
        }
        if (this.getFrame() == null) {
            TRACE.d(1, "Could not show the debugger.  No frame set!!");
            return;
        }
        if (this.getFrame().isShowing()) {
            return;
        }
        ix ix2 = this.getFrame();
        ((Component)ix2).setSize(ar.a().ab());
        ((Component)ix2).setLocation(ar.a().ac());
        ix2.q();
        ((Component)ix2).setVisible(true);
    }

    public void hideDebuggerFrame(String string2) {
        if (this.isHosted()) {
            return;
        }
        ix ix2 = this.getFrame();
        if (ix2 == null) {
            TRACE.d(1, "Could not hide the debugger.  No frame set!!");
            return;
        }
        aq.a(new kl(ix2, string2));
    }

    public void showDaemonDialog(String string2) {
        if (this.getOptionsParser().a3()) {
            this.getDaemonSupport().a(string2);
            daemonDialogHidden = false;
        }
    }

    public void hideDaemonDialog() {
        if (this.getOptionsParser().a3()) {
            this.getDaemonSupport().h();
            daemonDialogHidden = true;
        }
    }

    public void showDebugger(int n10, String string2) {
        if (this.getOptionsParser().a3() && n10 == 0) {
            if (this.getOptionsParser().bb()) {
                this.hideDebuggerFrame(string2);
                return;
            }
            this.hideDebuggerFrame(null);
            this.showDaemonDialog(string2);
            return;
        }
        if (!this.getOptionsParser().bb()) {
            this.hideDaemonDialog();
        }
        this.updatePortsListenToStrings();
        this.showDebuggerFrame();
    }

    public boolean startDebugSession(String string2, boolean bl2) {
        TRACE.c(1, "Debugger.startDebugSession(String) " + (bl2 ? "from UI daemon " : "") + "cmdLine=" + string2);
        return this.startDebugSession(new g(string2), bl2);
    }

    public boolean startDebugSession(String[] stringArray, boolean bl2) {
        return this.startDebugSession(new g(stringArray), bl2);
    }

    public boolean startDebugSession(g g10, boolean bl2) {
        rc rc2 = null;
        ks ks2 = null;
        return this.startDebugSession(g10, rc2, ks2, bl2);
    }

    public boolean startDebugSession(g g10, rc rc2, ks ks2, boolean bl2) {
        TRACE.c(1, "Debugger.startDebugSession(DebuggerOptionsParser)");
        TRACE.c(1, "Reparsed arguments are: " + g10.bk());
        if (this.getDebuggerTerminating()) {
            return false;
        }
        if (this.getFrame() == null) {
            if (!g10.a7() && !g10.a9()) {
                TRACE.d(1, "Could not start the session.  No frame set!!");
            }
            return false;
        }
        if (!this.checkOptions(g10)) {
            return false;
        }
        if (g10.a7() || g10.a9()) {
            if (g10.a9()) {
                TRACE.c(1, "***** Debugger.startDebugSession '-qsmdterminate'");
                if (sessionManagerClient != null) {
                    sessionManagerClient.b();
                }
            }
            if (g10.a7()) {
                TRACE.c(1, "***** Debugger.startDebugSession '-qterminate'");
            }
            this.terminateDebugger(false);
            System.exit(0);
            return false;
        }
        if (g10.a3()) {
            boolean bl3 = this.startDaemons(g10, g10.a5());
            this.updatePortsListenToStrings();
            return !bl3;
        }
        if (ks2 == null || ks2.c() == null) {
            this.getFrame().a(new StartDebugSessionEvent(this.getFrame(), g10));
        } else {
            this.getFrame().a(new StartDebugSessionEvent(this.getFrame(), g10, rc2, ks2));
        }
        return true;
    }

    public void updatePortsListenToStrings() {
        this.getDaemonSupport().i();
        daemonPortListensTo = this.getDaemonSupport().toString();
    }

    public boolean startDebugSession(ix ix2, String[] stringArray, boolean bl2) {
        g g10 = this.parseOptions(stringArray);
        return this.startDebugSession(g10, bl2);
    }

    public g parseOptions(String[] stringArray) {
        return new g(stringArray);
    }

    public void setOptionsParser(g g10) {
        this.optionsParser = g10;
    }

    public g getOptionsParser() {
        return this.optionsParser;
    }

    public String getInstallDirectory() {
        if (this.installDirectory != null) {
            return this.installDirectory;
        }
        if (this.optionsParser.ac()) {
            this.installDirectory = this.optionsParser.ad();
        }
        if (this.installDirectory == null) {
            TRACE.d(1, "Installation directory not specified (jdhome)!");
        }
        return this.installDirectory;
    }

    public String getProfileDirectory() {
        return this.getHomeDirectory();
    }

    public String getHomeDirectory() {
        if (this.homeDirectory != null) {
            return this.homeDirectory;
        }
        if (this.getOptionsParser().ae()) {
            this.homeDirectory = this.getOptionsParser().af();
        }
        if (this.homeDirectory == null) {
            TRACE.d(1, "Debugger home directory not specified (jwhome)!");
        }
        return this.homeDirectory;
    }

    public String getProtectedHomeDirectory() {
        if (this.protectedHomeDirectory != null) {
            return this.protectedHomeDirectory;
        }
        String string2 = this.getInstallDirectory();
        if (string2 == null) {
            TRACE.d(1, "Debugger installation directory not specified (jdhome)!");
            return null;
        }
        this.protectedHomeDirectory = string2.endsWith(FILESEP) ? String.valueOf(string2) + "lib" + FILESEP : String.valueOf(string2) + FILESEP + "lib" + FILESEP;
        return this.protectedHomeDirectory;
    }

    public boolean installDirectoryContainsDebugEngine() {
        return this.installDirectoryContainsEngine;
    }

    public void setInstallDirectoryContainsDebugEngine(boolean bl2) {
        this.installDirectoryContainsEngine = bl2;
    }

    public String determineInstallDirectoryFromClasspath() {
        u3 u32 = new u3();
        String string2 = u32.a("derswing.jar");
        if (string2 == null) {
            return null;
        }
        File file2 = new File(string2);
        String string3 = file2.getParent();
        if (string3 != null) {
            if (string3.endsWith("lib")) {
                string3 = string3.substring(0, string3.length() - 1 - 3);
            } else if (string3.endsWith("lib" + FILESEP)) {
                string3 = string3.substring(0, string3.length() - 1 - 4);
            }
        }
        return string3;
    }

    public ic getIbmVaHelp() {
        return ibmVaHlp;
    }

    public String getHelpRoot() {
        if (this.helpRoot == null) {
            this.helpRoot = String.valueOf(this.getInstallDirectory()) + FILESEP + "help" + FILESEP;
        }
        return this.helpRoot;
    }

    public String getHelpDirectory() {
        if (this.helpDirectory == null) {
            Locale locale = Locale.getDefault();
            String string2 = locale.toString();
            if (string2.equals("ko_KO")) {
                string2 = "ko_KR";
            }
            if (string2.equals("en")) {
                string2 = "en_US";
            }
            this.helpDirectory = String.valueOf(this.getHelpRoot()) + string2 + FILESEP;
            TRACE.c(2, "Help directory is:" + this.helpDirectory);
        }
        return this.helpDirectory;
    }

    public String getHelpEnUsDirectory() {
        if (this.helpEnUsDirectory == null) {
            this.helpEnUsDirectory = String.valueOf(this.getInstallDirectory()) + FILESEP + "help" + FILESEP;
            this.helpEnUsDirectory = String.valueOf(this.helpEnUsDirectory) + "en_US" + FILESEP;
            TRACE.c(2, "Help EnUs directory is:" + this.helpEnUsDirectory);
        }
        return this.helpEnUsDirectory;
    }

    public boolean isHosted() {
        return this.hosted;
    }

    public void setHosted(boolean bl2) {
        this.hosted = bl2;
    }

    public w getProductDescription() {
        if (this.product == null) {
            this.product = w.a(this);
        }
        return this.product;
    }

    public String getDefaultBackendGroup() {
        return "picl";
    }

    public int getDefaultBackend() {
        return 4;
    }

    public int getDefaultLanguage() {
        return 2;
    }

    public final void setWaitCursor() {
        if (this.getFrame() == null || this.getFrame().getCursor() == waitCursor) {
            return;
        }
        ((Component)this.getFrame()).setCursor(waitCursor);
        this.getFrame().repaint();
    }

    public final void setReadyCursor() {
        if (this.getFrame() == null || this.getFrame().getCursor() == readyCursor) {
            return;
        }
        ((Component)this.getFrame()).setCursor(readyCursor);
        this.getFrame().repaint();
    }

    public void showSplashScreen(int n10) {
        if (splash == null) {
            splash = new kd(Debugger.getDebugger().getFrame());
            String string2 = Debugger.getDebugger().getProductDescription().d();
            if (string2 == null || string2.equals("")) {
                TRACE.d(1, "Debugger.getProductDescription().getSplashScreen()==null");
                string2 = MessageServices.getMessage("ProductDescription.DefaultSplashScreen");
            }
            if (string2 == null || string2.equals("")) {
                TRACE.d(1, "ProductDescription.DefaultSplashScreen==null");
                return;
            }
            ImageIcon imageIcon = this.getNlsImageIcon(string2);
            if (imageIcon == null) {
                TRACE.d(2, "Debugger.getProductDescription() NLS getSplashScreen()==null");
                string2 = MessageServices.getMessage("ProductDescription.DefaultSplashScreen");
                imageIcon = (ImageIcon)ImageUtil.loadIcon(class$com$ibm$debug$ui$Debugger != null ? class$com$ibm$debug$ui$Debugger : (class$com$ibm$debug$ui$Debugger = Debugger.class$("com.ibm.debug.ui.Debugger")), string2);
            }
            if (imageIcon == null) {
                TRACE.d(1, "ProductDescription SplashScreen GIF==null");
                return;
            }
            splash.a(imageIcon);
        }
        if (n10 > 0) {
            splash.a(n10);
            return;
        }
        splash.setVisible(true);
    }

    private ImageIcon getNlsImageIcon(String string2) {
        Locale locale = Locale.getDefault();
        String string3 = locale.getLanguage();
        if (string3.equalsIgnoreCase("zh") && locale.toString().equalsIgnoreCase("zh_TW")) {
            string3 = locale.toString();
        } else if (string3.equalsIgnoreCase("pt")) {
            string3 = locale.toString();
        }
        String string4 = "/" + string3 + "_" + string2;
        TRACE.c(3, "Debugger.getNlsImageIcon=" + string4);
        ImageIcon imageIcon = null;
        imageIcon = (ImageIcon)ImageUtil.loadIcon(string4);
        if (imageIcon == null) {
            TRACE.d(2, "Debugger.getNlsImageIcon icon==null");
            string4 = "/en_" + string2;
            imageIcon = (ImageIcon)ImageUtil.loadIcon(class$com$ibm$debug$ui$Debugger != null ? class$com$ibm$debug$ui$Debugger : (class$com$ibm$debug$ui$Debugger = Debugger.class$("com.ibm.debug.ui.Debugger")), string4);
        }
        return imageIcon;
    }

    public void hideSplashScreen() {
        if (splash == null) {
            return;
        }
        splash.setVisible(false);
        splash.dispose();
        splash = null;
    }

    public static Debugger createDebugger(String[] stringArray) {
        Object object;
        int n10 = TRACE.b();
        if (n10 >= 1) {
            StringBuffer stringBuffer = new StringBuffer("createDebugger UiVersion   = ");
            Debugger.getBuildInformation();
            TRACE.c(1, stringBuffer.append(BuildInformation.c()).toString());
            StringBuffer stringBuffer2 = new StringBuffer("createDebugger PiclVersion = ");
            Debugger.getBuildInformation();
            TRACE.c(1, stringBuffer2.append(BuildInformation.d()).toString());
            StringBuffer stringBuffer3 = new StringBuffer("createDebugger EpdcVersion = ");
            Debugger.getBuildInformation();
            TRACE.c(1, stringBuffer3.append(BuildInformation.e()).toString());
            StringBuffer stringBuffer4 = new StringBuffer("createDebugger BuildDate   = ");
            Debugger.getBuildInformation();
            TRACE.c(1, stringBuffer4.append(BuildInformation.a()).toString());
        }
        if (n10 >= 1) {
            TRACE.c(1, "CreateDebugger args:");
        }
        int n11 = 0;
        while (n11 < stringArray.length) {
            int n12 = stringArray[n11].indexOf(34);
            if (n12 >= 0) {
                if (n10 >= 1) {
                    TRACE.c(1, "   arg[" + n11 + "]=" + stringArray[n11]);
                }
                while (n12 >= 0) {
                    object = "";
                    if (n12 > 0) {
                        object = String.valueOf(object) + stringArray[n11].substring(0, n12);
                    }
                    stringArray[n11] = object = String.valueOf(object) + stringArray[n11].substring(n12 + 1);
                    n12 = stringArray[n11].indexOf(34);
                }
            }
            if (n10 >= 1) {
                TRACE.c(1, "   arg[" + n11 + "]=" + stringArray[n11]);
            }
            ++n11;
        }
        Debugger debugger = new Debugger();
        object = debugger.parseOptions(stringArray);
        debugger.setOptionsParser((g)object);
        debugger.setInstallDirectoryContainsDebugEngine(((g)object).ac());
        if (debugger.getInstallDirectory() == null) {
            TRACE.d(1, "Could not find installation directory!");
            return null;
        }
        MessageServices.initialize();
        if (!debugger.checkOptions((g)object)) {
            return null;
        }
        Debugger.debugger = debugger;
        if (n10 >= 1 && stringArray != null && stringArray.length != 0) {
            int n13 = 0;
            while (n13 < stringArray.length) {
                TRACE.c(1, "Debugger() j=" + n13 + " args[j]=" + stringArray[n13]);
                ++n13;
            }
        }
        debugger = Debugger.debuggerReuse(debugger, stringArray, (g)object);
        return debugger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Debugger debuggerReuse(Debugger debugger, String[] stringArray, g g10) {
        Thread thread2;
        int n10;
        boolean bl2;
        boolean bl3;
        block16: {
            w w10;
            boolean bl4 = g10.a6();
            bl3 = g10.a7() || g10.a9();
            bl2 = g10.ba();
            if (bl4) {
                bl3 = false;
            }
            if (bl4 || bl3) {
                bl2 = false;
            }
            if ((w10 = debugger.getProductDescription()) == null) {
                TRACE.c(1, "Debugger product description not found!");
                return null;
            }
            String string2 = w10.g();
            TRACE.c(1, "Debugger() stringPort=" + string2);
            n10 = 0;
            try {
                n10 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                TRACE.d(1, "Debugger() parseInt stringport exception=" + exception + ", defaulting to port=" + 0);
            }
            if (!bl2) {
                if (Platform.a()) {
                    n10 = 0;
                }
                thread2 = null;
                try {
                    thread2 = new z(n10, stringArray);
                    ((z)thread2).run();
                    if (((z)thread2).a()) {
                        if (((z)thread2).b()) {
                            TRACE.d(2, "createDebugger EXISTING Debugger Session IS NOT RESPONDING on port " + ((z)thread2).c());
                            if (n10 > 0) {
                                Debugger.displayServerFailedToStartErrorMessage(((z)thread2).c());
                            }
                            break block16;
                        }
                        if (!bl4) {
                            TRACE.c(1, "createDebugger EXISTING Debugger Session will be re-used on port " + ((z)thread2).c());
                            reuse = true;
                            Debugger.debugger = null;
                            return null;
                        }
                        Debugger.systemExit(222);
                        break block16;
                    }
                    if (bl4) {
                        Debugger.systemExit(0);
                    }
                }
                catch (Exception exception) {
                    if (bl4) {
                        Debugger.systemExit(0);
                    }
                    TRACE.d(2, "createDebugger CmdLineSocketClient failed exception=" + exception.toString());
                    int n11 = thread2 != null ? ((z)thread2).c() : n10;
                    TRACE.d(2, "createDebugger CmdLineSocketClient failed EXISTING Debugger Session NOT CONNECTING on port " + n11);
                    if (n10 <= 0) break block16;
                    Debugger.displayServerFailedToStartErrorMessage(n11);
                    Debugger.debugger = null;
                    return null;
                }
            }
        }
        if (!bl2 && !bl3) {
            TRACE.c(1, "Debugger() creating cmdLineSocketServer, port=" + n10);
            Debugger debugger2 = debugger;
            debugger2.getClass();
            thread2 = new h7(debugger2, n10);
            thread2.start();
        }
        return debugger;
    }

    private static void systemExit(int n10) {
        TRACE.c(1, "Debugger.systemExit=" + n10);
        if (n10 == 0) {
            Debugger.getDebugger().terminateDebugger(false);
        }
        System.exit(n10);
    }

    public static String userName() {
        return thisUser;
    }

    public static String getDisplay() {
        if (display == null) {
            display = System.getProperty("IBMDebug.DISPLAY");
            if (display == null) {
                display = "localhost";
                return display;
            }
            if ((display = display.toLowerCase().trim()).length() > 60) {
                display = display.substring(0, 60);
            }
            String string2 = " ~!$%^&*()-+=[]{}|:;\"',.<>?/\\";
            int n10 = string2.length();
            int n11 = 0;
            while (n11 < n10) {
                if (display.indexOf(string2.charAt(n11)) >= 0) {
                    display = display.replace(string2.charAt(n11), '_');
                }
                ++n11;
            }
        }
        return display;
    }

    public static Debugger getDebugger() {
        return debugger;
    }

    public static void main(String[] stringArray) {
        String string2;
        reuse = false;
        int n10 = TRACE.b();
        if (n10 >= 2) {
            TRACE.c(2, "os.name=" + System.getProperties().getProperty("os.name"));
            TRACE.c(2, "os.version=" + System.getProperties().getProperty("os.version"));
            TRACE.c(2, "os.arch=" + System.getProperties().getProperty("os.arch"));
            TRACE.c(2, "java.version=" + DebuggerConstants.a);
            TRACE.c(2, "java.class.version=" + System.getProperties().getProperty("java.class.version"));
            TRACE.c(2, "java.compiler=" + System.getProperties().getProperty("java.compiler"));
            TRACE.c(2, "java.home=" + System.getProperties().getProperty("java.home"));
            TRACE.c(2, "java.vendor=" + System.getProperties().getProperty("java.vendor"));
            TRACE.c(2, "user.name=" + System.getProperties().getProperty("user.name"));
            TRACE.c(2, "user.language=" + System.getProperties().getProperty("user.language"));
            TRACE.c(2, "user.region=" + System.getProperties().getProperty("user.region"));
            TRACE.c(2, "file.encoding=" + System.getProperties().getProperty("file.encoding"));
        }
        if ((string2 = System.getProperty("DER_DOUBLEBUFFER")) != null && string2.equalsIgnoreCase("NO")) {
            RepaintManager.currentManager(null).setDoubleBufferingEnabled(false);
        }
        Debugger.createDebugger(stringArray);
        Debugger debugger = Debugger.getDebugger();
        if (debugger == null) {
            if (n10 >= 1) {
                TRACE.c(1, "Did not create a new debugger. Exiting!!");
            }
            if (reuse) {
                System.exit(0);
            } else {
                System.exit(-1);
            }
        }
        if (debugger.getOptionsParser().a7() || debugger.getOptionsParser().a9()) {
            Debugger.systemExit(0);
        }
        if (debugger.isRedirectErrorsAllowed()) {
            debugger.redirectErrorsToFile();
        }
        debugger.setHeightAdjustments();
        debugger.setGenericFontSize(ar.a().f());
        ibmVaHlp.a();
        if (!debugger.getOptionsParser().bb()) {
            TRACE.a(1, "\n");
            TRACE.a(1, copyright1);
            TRACE.a(1, copyright2);
            TRACE.a(1, copyright3);
            TRACE.a(1, copyright4);
            TRACE.a(1, copyright5);
            TRACE.a(1, " ");
        }
        debugger.setHosted(false);
        debugger.buildApplication();
        boolean bl2 = debugger.startDebugger();
        if (!bl2) {
            System.exit(0);
        }
        ar.a().a(debugger);
        debugger.showDebugger(activeSessionCount, null);
        if (!Debugger.getDebugger().getOptionsParser().ae()) {
            Debugger.displayErrorMessage(MessageServices.getMessage("MOptionJWHomeNotSet"));
        } else if (!Debugger.getDebugger().getOptionsParser().n()) {
            if (n10 >= 1) {
                TRACE.c(1, MessageServices.getMessage("MOptionEnvarFileNotSet"));
            }
        } else {
            String string3 = Debugger.getDebugger().getOptionsParser().m();
            String string4 = String.valueOf(Debugger.getDebugger().getProfileDirectory()) + "Start_Up.env";
            startupEnvarFile = new kr(string3, string4);
        }
        if (!debugger.getOptionsParser().a3()) {
            debugger.startDebugSession(debugger.getOptionsParser(), false);
        }
    }

    private boolean isRedirectErrorsAllowed() {
        boolean bl2 = System.getProperty("JT_HOST") != null ? false : (System.getProperty("DER_ERROR_LOG") != null ? System.getProperty("DER_ERROR_LOG").equalsIgnoreCase("YES") : System.getProperty("JT_ERR") == null && System.getProperty("JT_EVT") == null);
        return bl2;
    }

    private boolean redirectErrorsToFile() {
        File file2;
        String string2;
        boolean bl2 = false;
        try {
            string2 = System.getProperty("DER_ERROR_LOG_LIMIT");
            if (string2 != null && string2.length() > 0) {
                this.errorLogLimit = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if ((file2 = new File(string2 = String.valueOf(this.getProfileDirectory()) + "idebug.log")) != null && !file2.isDirectory()) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                PrintStream printStream = new PrintStream(bufferedOutputStream, true);
                this.originalErrorStream = System.err;
                System.setErr(printStream);
                this.errorLogFile = file2;
                bl2 = true;
            }
            catch (IOException iOException) {}
        }
        if (bl2) {
            TRACE = new TraceLogger("UI");
            this.watchErrorLogSize();
        }
        return bl2;
    }

    private void watchErrorLogSize() {
        if (this.errorLogFile == null) {
            return;
        }
        Timer timer = new Timer(10000, new h8(this));
        timer.start();
    }

    public void windowActivated(WindowEvent windowEvent) {
        debuggerHasFocus = true;
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        debuggerHasFocus = false;
    }

    public boolean debuggerHasFocus() {
        if (debuggerHasFocus || this.getFrame().getFocusOwner() != null) {
            return true;
        }
        ac ac10 = this.getActiveDialog();
        return ac10 != null && ac10.getFocusOwner() != null;
    }

    private void setHeightAdjustments() {
        String string2 = Locale.getDefault().getLanguage();
        int n10 = string2.equalsIgnoreCase("ko") || string2.equalsIgnoreCase("zh") ? (Platform.c() ? 4 : 2) : 0;
        this.setLabelHeightAdjustment(n10);
        this.setComboBoxHeightAdjustment(n10);
        this.setTextFieldHeightAdjustment(n10);
        if (TRACE.b() > 0) {
            TRACE.c(1, "Height Adjustments");
            TRACE.c(1, "   Locale adjustment    : " + n10);
            TRACE.c(1, "   Label adjustment     : " + Debugger.getLabelHeightAdjustment());
            TRACE.c(1, "   ComboBox adjustment  : " + Debugger.getComboBoxHeightAdjustment());
            TRACE.c(1, "   TextField adjustment : " + Debugger.getTextFieldHeightAdjustment());
        }
    }

    private void setLabelHeightAdjustment(int n10) {
        String string2 = System.getProperty("DER_LABEL_HEIGHT_ADJUST");
        if (string2 != null) {
            try {
                labelHeightAdjustment = Integer.parseInt(string2);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                labelHeightAdjustment = n10;
                return;
            }
        }
        labelHeightAdjustment = n10;
    }

    public static int getLabelHeightAdjustment() {
        return labelHeightAdjustment;
    }

    private void setComboBoxHeightAdjustment(int n10) {
        String string2 = System.getProperty("DER_COMBOBOX_HEIGHT_ADJUST");
        if (string2 != null) {
            try {
                comboBoxHeightAdjustment = Integer.parseInt(string2);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                comboBoxHeightAdjustment = 4 + n10;
                return;
            }
        }
        comboBoxHeightAdjustment = 4 + n10;
    }

    public static int getComboBoxHeightAdjustment() {
        return comboBoxHeightAdjustment;
    }

    private void setTextFieldHeightAdjustment(int n10) {
        String string2 = System.getProperty("DER_TEXTFIELD_HEIGHT_ADJUST");
        if (string2 != null) {
            try {
                textFieldHeightAdjustment = Integer.parseInt(string2);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                textFieldHeightAdjustment = 4 + n10;
                return;
            }
        }
        textFieldHeightAdjustment = 4 + n10;
    }

    public static int getTextFieldHeightAdjustment() {
        return textFieldHeightAdjustment;
    }

    public int nextFontSize(Font font, int n10) {
        if (font == null) {
            return -1;
        }
        Toolkit toolkit = new Frame().getToolkit();
        boolean bl2 = false;
        String string2 = font.getFamily();
        int n11 = font.getStyle();
        String string3 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        FontMetrics fontMetrics = toolkit.getFontMetrics(font);
        int n12 = fontMetrics.stringWidth(string3);
        int n13 = fontMetrics.getHeight();
        int n14 = 2;
        int n15 = 20;
        int n16 = Platform.c() ? (n10 > 0 ? n14 : n15) : font.getSize();
        int n17 = 0;
        while (!bl2 && n17 < 28) {
            if ((n16 += n10) < n14 || n16 > n15) break;
            FontUIResource fontUIResource = new FontUIResource(string2, n11, n16);
            if (fontUIResource != null) {
                fontMetrics = toolkit.getFontMetrics(fontUIResource);
                int n18 = fontMetrics.stringWidth(string3);
                int n19 = fontMetrics.getHeight();
                bl2 = n10 > 0 ? n13 < n19 || n12 < n18 : n13 > n19 || n12 > n18;
            }
            ++n17;
        }
        if (bl2) {
            return n16;
        }
        toolkit.beep();
        return -1;
    }

    public int defaultGenericFontSize() {
        Font font = UIManager.getFont("Label.font");
        if (font == null) {
            return 12;
        }
        return font.getSize();
    }

    public void increaseGenericFontSize() {
        int n10 = ar.a().f();
        if (n10 <= 0) {
            n10 = this.defaultGenericFontSize();
        }
        if ((n10 = this.nextFontSize(UIManager.getFont("Label.font"), 1)) > 0) {
            ar.a().a(n10);
        }
    }

    public void decreaseGenericFontSize() {
        int n10 = ar.a().f();
        if (n10 <= 0) {
            n10 = this.defaultGenericFontSize();
        }
        if ((n10 = this.nextFontSize(UIManager.getFont("Label.font"), -1)) > 0) {
            ar.a().a(n10);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        TRACE.c(1, "Debugger.propertyChange(" + propertyChangeEvent.getPropertyName() + ")");
        String string2 = propertyChangeEvent.getPropertyName();
        if (string2 == "dbg.genericFontChanged" && !propertyChangeEvent.getNewValue().equals(propertyChangeEvent.getOldValue())) {
            this.setGenericFontSize(ar.a().f());
        }
    }

    public void setGenericFontSize(int n10) {
        if (n10 <= 0) {
            return;
        }
        String[] stringArray = new String[]{"Button", "ToggleButton", "RadioButton", "CheckBox", "ColorChooser", "ComboBox", "Label", "List", "MenuBar", "MenuItem", "RadioButtonMenuItem", "CheckBoxMenuItem", "Menu", "PopupMenu", "OptionPane", "Panel", "ProgressBar", "ScrollPane", "Viewport", "TabbedPane", "Table", "TableHeader", "TextField", "PasswordField", "TextArea", "TextPane", "EditorPane", "TitledBorder", "ToolBar", "ToolTip", "Tree"};
        FontUIResource fontUIResource = null;
        String string2 = "";
        int n11 = Integer.MAX_VALUE;
        boolean bl2 = false;
        int n12 = stringArray.length;
        int n13 = 0;
        while (n13 < n12) {
            String string3 = stringArray[n13];
            Font font = UIManager.getFont(String.valueOf(string3) + ".font");
            if (font != null && font.getSize() != n10) {
                int n14 = font.getStyle();
                String string4 = font.getFamily();
                if (fontUIResource != null && n14 == n11 && string4.equals(string2) || (fontUIResource = new FontUIResource(string2 = string4, n11 = n14, n10)) != null) {
                    UIManager.put(String.valueOf(string3) + ".font", fontUIResource);
                    bl2 = true;
                    h9.a();
                    ia.a();
                    ib.a();
                }
            }
            ++n13;
        }
        if (bl2 && this.getFrame() != null) {
            SwingUtilities.updateComponentTreeUI(this.getFrame());
        }
    }

    public static void displayServerFailedToStartErrorMessage(int n10) {
        String[] stringArray = new String[]{String.valueOf(n10)};
        stringArray[0] = MessageServices.getMessage("MDebuggerSocketServerNotCreated", stringArray);
        TRACE.d(1, stringArray[0]);
        if (sessionManagerClient != null) {
            stringArray[0] = thisUser;
            stringArray[0] = MessageServices.getMessage("MDebuggerSessionNotResponding", stringArray);
            MessageServices.displayErrorMessageBox(Debugger.getDebugger().getFrame(), stringArray[0]);
        }
    }

    public static void displayErrorMessage(String string2) {
        TRACE.d(1, "Debugger " + string2);
        String[] stringArray = new String[]{string2};
        MessageServices.displayErrorMessageBox(Debugger.getDebugger().getFrame(), string2);
    }

    public static InetAddress getLocalAddress() {
        block2: {
            if (_localAddress != null) break block2;
            try {
                _localAddress = InetAddress.getByName("localhost");
            }
            catch (UnknownHostException unknownHostException) {
                TRACE.d(1, "Debugger unable to determine localhost address.");
            }
        }
        return _localAddress;
    }

    public boolean getDebuggerTerminating() {
        return debuggerTerminating;
    }

    public void setDebuggerTerminating() {
        debuggerTerminating = true;
        this.fireDebuggerTerminating();
    }

    public void addTerminationListener(hj hj2) {
        if (hj2 == null) {
            return;
        }
        if (terminationListeners == null) {
            terminationListeners = new Hashtable();
        }
        terminationListeners.put(hj2, "");
    }

    public void removeTerminationListener(hj hj2) {
        if (terminationListeners != null && hj2 != null) {
            terminationListeners.remove(hj2);
        }
    }

    private void fireDebuggerTerminating() {
        if (terminationListeners == null || terminationListeners.size() <= 0) {
            return;
        }
        Enumeration enumeration = terminationListeners.keys();
        while (enumeration.hasMoreElements()) {
            hj hj2 = (hj)enumeration.nextElement();
            hj2.a(false);
        }
    }

    public static void heapStatistics() {
    }

    public static void stateSummary() {
    }

    public static void stateDetails() {
    }

    public static void gc() {
        runtime.gc();
    }

    public static void uiActionStateInfo(boolean bl2) {
    }

    public static void uiMenuStateInfo(boolean bl2) {
    }

    public final void setCleanupHasRun() {
        this.cleanupHasRun = true;
    }

    public final boolean getCleanupHasRun() {
        return this.cleanupHasRun;
    }

    public final void cleanup(Object object) {
        ButtonGroup buttonGroup;
        Enumeration<AbstractButton> enumeration;
        if (object == null) {
            return;
        }
        if (object instanceof d) {
            ((d)object).cleanup();
            return;
        }
        if (object instanceof Hashtable) {
            ((Hashtable)object).clear();
            return;
        }
        if (object instanceof Vector) {
            ((Vector)object).removeAllElements();
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n10 = objectArray.length;
            int n11 = 0;
            while (n11 < n10) {
                objectArray[n11] = null;
                ++n11;
            }
            return;
        }
        if (object instanceof JComponent) {
            this.cleanupJComponent((JComponent)object);
            return;
        }
        if (object instanceof ButtonGroup && (enumeration = (buttonGroup = (ButtonGroup)object).getElements()) != null) {
            while (enumeration.hasMoreElements()) {
                AbstractButton abstractButton = enumeration.nextElement();
                buttonGroup.remove(abstractButton);
            }
        }
    }

    public final void cleanupDeep(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n10 = objectArray.length;
            int n11 = 0;
            while (n11 < n10) {
                this.cleanupDeep(objectArray[n11]);
                objectArray[n11] = null;
                ++n11;
            }
            return;
        }
        if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            Enumeration<Object> enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                this.cleanupDeep(enumeration.nextElement());
            }
            enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                this.cleanupDeep(enumeration.nextElement());
            }
            hashtable.clear();
            return;
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n12 = vector.size() - 1;
            while (n12 >= 0) {
                this.cleanupDeep(vector.elementAt(n12));
                --n12;
            }
            vector.removeAllElements();
            return;
        }
        if (object instanceof mg) {
            mg mg2 = (mg)object;
            mg2.e();
            mg2.cleanup();
            return;
        }
        if (object instanceof ButtonGroup) {
            ButtonGroup buttonGroup = (ButtonGroup)object;
            Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    AbstractButton abstractButton = enumeration.nextElement();
                    buttonGroup.remove(abstractButton);
                    this.cleanup(abstractButton);
                }
            }
            this.cleanup(buttonGroup);
            return;
        }
        this.cleanup(object);
    }

    public final void cleanupJComponent(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        jComponent.removeAll();
    }

    public void cleanup() {
        if (this.getCleanupHasRun()) {
            return;
        }
        this.debuggerFrame.s().s().removeKeyListener((DebuggerController)this.debuggerFrame.r());
        this.setCleanupHasRun();
    }

    public static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static /* synthetic */ File access$0(Debugger debugger) {
        return debugger.errorLogFile;
    }

    public static /* synthetic */ int access$1(Debugger debugger) {
        return debugger.errorLogLimit;
    }

    public static /* synthetic */ void access$2(Debugger debugger, File file2) {
        debugger.errorLogFile = file2;
    }

    public static /* synthetic */ PrintStream access$3(Debugger debugger) {
        return debugger.originalErrorStream;
    }

    public static /* synthetic */ aa access$4() {
        return cmdLineSocketServer;
    }

    public static /* synthetic */ void access$5(aa aa10) {
        cmdLineSocketServer = aa10;
    }

    static {
        startupEnvarFile = null;
        userClasspath = null;
        PATHSEP = System.getProperty("path.separator");
        FILESEP = System.getProperty("file.separator");
        PATHSEP_CHAR = PATHSEP.charAt(0);
        FILESEP_CHAR = FILESEP.charAt(0);
        waitCursor = Cursor.getPredefinedCursor(3);
        readyCursor = Cursor.getDefaultCursor();
        ibmVaHlp = new ic();
        daemonPortListensTo = "";
        defaultSoTimeout = -1;
        cmdLineSocketServer = null;
        sessionManagerClient = null;
        thisUser = System.getProperty("user.name");
        activeDialog = new Stack();
        runtime = Runtime.getRuntime();
        heapSize = runtime.totalMemory();
        comboBoxHeightAdjustment = 4;
        textFieldHeightAdjustment = 4;
    }
}

