/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.ui;

import com.ibm.debug.ui.Debugger;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class SourceViewInputController
implements KeyListener,
MouseListener,
MouseMotionListener {
    public JScrollPane scrollPane;
    public boolean processingCTLKey = false;
    public boolean processingSHIFTKey = false;
    public boolean processScrollToLine = false;
    public nn sourceViewComponent;
    public Point lastPressedPosition;
    public static final int numPadOffset = 48;
    public boolean popupMenuShown = false;

    public SourceViewInputController(nn nn2) {
        Debugger.TRACE.c(1, "Creating SourceViewInputController");
        this.sourceViewComponent = nn2;
        nn2.addKeyListener(this);
        nn2.addMouseListener(this);
        nn2.addMouseMotionListener(this);
    }

    public void registerScrollPane(JScrollPane jScrollPane) {
        if (jScrollPane != null) {
            this.scrollPane = jScrollPane;
            jScrollPane.addKeyListener(this);
            jScrollPane.addMouseListener(this);
            jScrollPane.addMouseMotionListener(this);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.sourceViewComponent.c();
        if (!this.sourceViewComponent.isEnabled() || this.sourceViewComponent.j() == null || this.sourceViewComponent.j().l() || this.sourceViewComponent.f().e().debugEngine().isBusy()) {
            return;
        }
        int n10 = keyEvent.getKeyCode();
        if (!this.processingCTLKey && !this.processingSHIFTKey) {
            switch (n10) {
                case 27: {
                    this.sourceViewComponent.g().a();
                    return;
                }
                case 38: {
                    nr nr2 = this.sourceViewComponent.i().a();
                    this.sourceViewComponent.i().a(this.sourceViewComponent.j(), new nr(nr2.b, nr2.a - 1));
                    return;
                }
                case 40: {
                    nr nr3 = this.sourceViewComponent.i().a();
                    this.sourceViewComponent.i().a(this.sourceViewComponent.j(), new nr(nr3.b, nr3.a + 1));
                    return;
                }
                case 37: {
                    nr nr4 = this.sourceViewComponent.i().a();
                    this.sourceViewComponent.i().a(this.sourceViewComponent.j(), new nr(nr4.b - 1, nr4.a));
                    return;
                }
                case 39: {
                    nr nr5 = this.sourceViewComponent.i().a();
                    this.sourceViewComponent.i().a(this.sourceViewComponent.j(), new nr(nr5.b + 1, nr5.a));
                    return;
                }
                case 17: {
                    this.processingCTLKey = true;
                    return;
                }
                case 16: {
                    this.processingSHIFTKey = true;
                    return;
                }
            }
            if (!this.processScrollToLine) {
                this.checkForQuickScrollToLine(n10);
                return;
            }
        } else {
            if (this.processingCTLKey) {
                switch (n10) {
                    case 36: {
                        this.sourceViewComponent.i().a(this.sourceViewComponent.j(), new nr(1, 1));
                        return;
                    }
                    case 35: {
                        this.sourceViewComponent.i().a(this.sourceViewComponent.j(), new nr(1, this.sourceViewComponent.j().j()));
                        return;
                    }
                    case 27: {
                        this.processingCTLKey = false;
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (this.processingSHIFTKey) {
                switch (n10) {
                    case 37: {
                        nr nr6 = this.sourceViewComponent.i().a();
                        this.sourceViewComponent.i().a(new nr(nr6.b - 1, nr6.a));
                        return;
                    }
                    case 39: {
                        nr nr7 = this.sourceViewComponent.i().a();
                        this.sourceViewComponent.i().a(new nr(nr7.b + 1, nr7.a));
                        return;
                    }
                    case 38: {
                        nr nr8 = this.sourceViewComponent.i().a();
                        this.sourceViewComponent.i().a(new nr(nr8.b, nr8.a - 1));
                        return;
                    }
                    case 40: {
                        nr nr9 = this.sourceViewComponent.i().a();
                        this.sourceViewComponent.i().a(new nr(nr9.b, nr9.a + 1));
                        return;
                    }
                    case 27: {
                        this.processingSHIFTKey = false;
                        return;
                    }
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this.sourceViewComponent.isEnabled() || this.sourceViewComponent.j() == null || this.sourceViewComponent.j().l() || this.sourceViewComponent.f().e().debugEngine().isBusy()) {
            this.processingCTLKey = false;
            this.processingSHIFTKey = false;
            return;
        }
        if (keyEvent.getKeyCode() == 17) {
            this.processingCTLKey = false;
            return;
        }
        if (keyEvent.getKeyCode() == 16) {
            this.processingSHIFTKey = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private void checkForQuickScrollToLine(int n10) {
        if (this.sourceViewComponent.f().e().debugEngine().isBusy() || this.sourceViewComponent.e() == null || this.sourceViewComponent.e().q() == null || !this.sourceViewComponent.e().q().a().j().l()) {
            return;
        }
        String string2 = null;
        if (n10 <= 57 && n10 >= 48) {
            string2 = String.valueOf((char)n10);
        } else if (n10 >= 96 && n10 <= 105) {
            string2 = String.valueOf((char)(n10 - 48));
        }
        if (string2 != null) {
            this.processScrollToLine = true;
            vu vu2 = new vu(this.sourceViewComponent.e(), string2, true);
            vu2.setVisible(true);
            this.processScrollToLine = false;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.processingCTLKey = false;
        this.processingSHIFTKey = false;
        this.sourceViewComponent.c();
        if (!this.sourceViewComponent.isEnabled() || this.sourceViewComponent.j() == null || this.sourceViewComponent.j().l() || this.sourceViewComponent.f().e().debugEngine().isBusy()) {
            return;
        }
        no no2 = this.sourceViewComponent.g();
        np np2 = this.sourceViewComponent.h();
        this.sourceViewComponent.requestFocus();
        nr nr2 = np2.d(mouseEvent.getPoint());
        if (!no2.a(nr2)) {
            no2.a();
        }
        this.sourceViewComponent.i().a(this.sourceViewComponent.j(), nr2);
        this.lastPressedPosition = mouseEvent.getPoint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.popupMenuShown = false;
        if (!this.sourceViewComponent.isEnabled() || this.sourceViewComponent.j() == null || this.sourceViewComponent.j().l() || this.sourceViewComponent.f().e().debugEngine().isBusy()) {
            return;
        }
        if (vw.a(mouseEvent)) {
            Point point = mouseEvent.getPoint();
            this.popupMenuShown = true;
            this.sourceViewComponent.e().a(point);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.sourceViewComponent.isEnabled() || this.sourceViewComponent.j() == null || this.sourceViewComponent.j().l() || this.sourceViewComponent.f().e().debugEngine().isBusy() || this.popupMenuShown) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            Point point;
            no no2 = this.sourceViewComponent.g();
            np np2 = this.sourceViewComponent.h();
            if (np2.b(point = mouseEvent.getPoint())) {
                no2.a();
            }
            if (mouseEvent.getClickCount() > 1) {
                if (np2.b(point)) {
                    if (!no2.a(point)) {
                        this.sourceViewComponent.d(point);
                        if (ar.a().p()) {
                            this.sourceViewComponent.v();
                            return;
                        }
                    }
                } else {
                    this.sourceViewComponent.e(point);
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        np np2;
        if (!this.sourceViewComponent.isEnabled() || this.sourceViewComponent.j() == null || this.sourceViewComponent.j().l() || this.sourceViewComponent.f().e().debugEngine().isBusy()) {
            return;
        }
        if (mouseEvent.getX() < 0) {
            mouseEvent.translatePoint(-mouseEvent.getX(), 0);
        }
        if ((np2 = this.sourceViewComponent.h()).b(mouseEvent.getPoint())) {
            nr nr2 = np2.d(mouseEvent.getPoint());
            this.sourceViewComponent.i().a(nr2);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.sourceViewComponent.c();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void cleanup() {
        this.lastPressedPosition = null;
        this.sourceViewComponent = null;
        if (this.scrollPane != null) {
            this.scrollPane.removeKeyListener(this);
            this.scrollPane.removeMouseListener(this);
            this.scrollPane.removeMouseMotionListener(this);
            this.scrollPane = null;
        }
    }
}

