/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.ui;

import com.ibm.debug.ui.UIProcessStartupSettings;
import com.ibm.debug.ui.UITreeCellRenderer;
import com.ibm.debug.util.Platform;
import com.ibm.ivb.jface.util.ImageUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class UIClasspathDialog
extends ac
implements ActionListener,
ListSelectionListener,
FilenameFilter,
TreeExpansionListener,
TreeSelectionListener {
    public l rg = new l("UIClasspathDialog");
    public JButton addJarZipButton;
    public JButton addClasspathButton;
    public JButton deleteClasspathButton;
    public JButton okButton;
    public JButton cancelButton;
    public JButton helpButton;
    public boolean changesAllowed = true;
    public JList classpathList;
    public String previousClasspath;
    public JLabel selectedProgramLb;
    public JScrollPane classpathScrollPane;
    public JScrollPane treeScrollPane;
    public JScrollPane labelSrollPane;
    public DefaultMutableTreeNode rootNode;
    public DefaultMutableTreeNode previousNode;
    public JTree tree;
    public Frame parent;
    public JPanel treePanel = new JPanel();
    public v0 availableDirectories;
    public Vector classpathVector = new Vector();
    public Vector newClasspathVector = new Vector();
    public Cursor waitCursor = new Cursor(3);
    public Hashtable treeTable = new Hashtable();
    public as debuggerSettings = ar.a();
    public String stringPathSeparator = System.getProperty("path.separator");
    public ImageIcon systemIcon = (ImageIcon)ImageUtil.loadIcon(this.getClass(), this.rg.c("systemImage"));
    public ImageIcon userIcon = (ImageIcon)ImageUtil.loadIcon(this.getClass(), this.rg.c("userImage"));
    public boolean secondLevelTree;
    public boolean secondLevelCreated;
    public UIProcessStartupSettings startupSettings;
    public JPanel classpathPanel;
    public JPanel scrollPanel;
    public JPanel topTextPanel;
    public JPanel topPanel;
    public JPanel topNorthPanel;
    public JPanel selectPackagePanel;
    public JPanel bottomTextPan;
    public JPanel bottomPanel;
    public JPanel buttonsPanel;
    public JPanel southPanel;

    public UIClasspathDialog(Frame frame, UIProcessStartupSettings uIProcessStartupSettings) {
        super(frame, true, true);
        this.parent = frame;
        this.startupSettings = uIProcessStartupSettings;
        this.setTitle(this.rg.b("title"));
        ((Component)this).setSize(800, 500);
        this.setLocationRelativeTo(frame);
        this.createGui();
        this.deleteClasspathButton.addActionListener(this);
        this.loadNewClasspaths();
        this.loadSystemClasspaths();
        this.classpathList.setListData(this.classpathVector);
        this.classpathList.setCellRenderer(new vy());
        this.setLocationRelativeTo(this.parent);
        this.createEmptyTree();
    }

    public void addNotify() {
        super.addNotify();
        this.classpathList.requestFocus();
    }

    private void loadSystemClasspaths() {
        char[] cArray = this.startupSettings.getSystemClasspath().toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n10 = cArray.length - 1;
        int n11 = 0;
        while (n11 < cArray.length) {
            if (!Platform.c() || cArray[n11] != '\"') {
                stringBuffer.append(cArray[n11]);
            }
            if (cArray[n11] == this.stringPathSeparator.charAt(0) || n11 == n10) {
                if (stringBuffer.length() != 0) {
                    this.classpathVector.addElement(new JLabel(stringBuffer.toString().trim(), this.systemIcon, 2));
                }
                stringBuffer.setLength(0);
            }
            ++n11;
        }
    }

    private void loadNewClasspaths() {
        String string2 = this.startupSettings.getStartupSettings().t();
        if (string2.length() <= 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        JLabel jLabel = null;
        int n10 = 0;
        while (n10 < string2.length()) {
            stringBuffer.append(string2.charAt(n10));
            if (string2.charAt(n10) == this.stringPathSeparator.charAt(0)) {
                jLabel = new JLabel(stringBuffer.toString().trim(), this.userIcon, 2);
                this.classpathVector.addElement(jLabel);
                this.newClasspathVector.addElement(jLabel);
                stringBuffer.setLength(0);
            }
            ++n10;
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.updateLabel(treeExpansionEvent.getPath());
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        Object[] objectArray;
        TreePath treePath = treeExpansionEvent.getPath();
        this.updateLabel(treePath);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        String string2 = ((JLabel)this.classpathList.getSelectedValue()).getText().toLowerCase();
        if (string2.endsWith(".zip;") || string2.endsWith(".jar;") || (Platform.d() || Platform.c()) && (string2.endsWith(".zip:") || string2.endsWith(".jar:"))) {
            return;
        }
        if (defaultMutableTreeNode == this.previousNode || defaultMutableTreeNode.isRoot()) {
            return;
        }
        this.previousNode = defaultMutableTreeNode;
        String string3 = ((JLabel)this.classpathList.getSelectedValue()).getText();
        StringBuffer stringBuffer = new StringBuffer();
        if (string3.charAt(0) == '.' && string3.length() == 2) {
            objectArray = new File(System.getProperty("user.dir"));
            stringBuffer.append(objectArray.getAbsolutePath()).append(System.getProperty("file.separator"));
        } else {
            stringBuffer.append(string3);
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append(System.getProperty("file.separator"));
        }
        objectArray = treePath.getPath();
        int n10 = 1;
        while (n10 < objectArray.length - 1) {
            stringBuffer.append(objectArray[n10]).append(System.getProperty("file.separator"));
            ++n10;
        }
        if (objectArray.length > 1) {
            stringBuffer.append(objectArray[n10]);
        }
        File file2 = new File(stringBuffer.toString());
        defaultMutableTreeNode.removeAllChildren();
        this.createTreeNodes(defaultMutableTreeNode, file2);
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(defaultMutableTreeNode);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.updateLabel(treeSelectionEvent.getPath());
    }

    /*
     * Unable to fully structure code
     */
    public void updateLabel(TreePath var1_1) {
        var2_2 = (DefaultMutableTreeNode)var1_1.getLastPathComponent();
        var3_3 = ((vz)var2_2.getUserObject()).toString();
        this.okButton.setEnabled(false);
        this.updateSelectedProgramLabel(this.rg.c("none"));
        var4_4 = new StringBuffer();
        var5_5 = var1_1.getPath();
        var6_6 = 1;
        if (var1_1.getPathCount() != 1) ** GOTO lbl14
        this.updateSelectedProgramLabel(" <" + var5_5[0].toString() + ">");
        return;
lbl-1000:
        // 1 sources

        {
            var4_4.append(var5_5[var6_6]).append(".");
            ++var6_6;
lbl14:
            // 2 sources

            ** while (var6_6 < var1_1.getPathCount() - 1)
        }
lbl15:
        // 1 sources

        var4_4.append(var5_5[var6_6]);
        if (var3_3.indexOf(".class") < 0) {
            this.okButton.setEnabled(false);
            this.updateSelectedProgramLabel(this.rg.c("none"));
            return;
        }
        var4_4.setLength(var4_4.length() - 6);
        this.okButton.setEnabled(true);
        this.updateSelectedProgramLabel(var4_4.toString());
    }

    private void updateSelectedProgramLabel(String string2) {
        char c10 = System.getProperty("file.separator").charAt(0);
        string2 = string2.replace(c10, '.');
        this.selectedProgramLb.setText(string2);
        this.selectedProgramLb.revalidate();
    }

    public synchronized void valueChanged(ListSelectionEvent listSelectionEvent) {
        JLabel jLabel;
        String string2;
        this.okButton.setEnabled(false);
        this.updateSelectedProgramLabel(this.rg.c("none"));
        if (this.classpathList.getSelectedValue() == null) {
            return;
        }
        ((Component)this).setCursor(this.waitCursor);
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
        if (defaultListSelectionModel == this.classpathList.getSelectionModel() && (string2 = (jLabel = (JLabel)this.classpathList.getSelectedValue()).getText()) != this.previousClasspath && string2 != null) {
            if (this.newClasspathVector.contains(jLabel)) {
                this.deleteClasspathButton.setEnabled(true);
            } else {
                this.deleteClasspathButton.setEnabled(false);
            }
            if (this.treeTable.containsKey(string2)) {
                this.createAndDisplaySelectedTree((DefaultMutableTreeNode)this.treeTable.get(string2));
            } else {
                String string3 = string2.toLowerCase();
                if (string3.endsWith(".zip;") || string3.endsWith(".jar;") || (Platform.d() || Platform.c()) && (string3.endsWith(".zip:") || string3.endsWith(".jar:"))) {
                    this.zippedFileSelected(string2);
                } else {
                    this.classpathSelected(string2);
                }
            }
            this.previousClasspath = string2;
            this.updateSelectedProgramLabel(" ");
        }
        ((Component)this).setCursor(Cursor.getDefaultCursor());
    }

    private void zippedFileSelected(String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.setLength(stringBuffer.length() - 1);
        v1 v12 = new v1(stringBuffer.toString());
        this.rootNode = new DefaultMutableTreeNode(stringBuffer.toString());
        this.createZippedFileTreeNodes(this.rootNode, v12);
        this.createAndDisplaySelectedTree(this.rootNode);
        this.treeTable.put(string2, this.rootNode);
    }

    private void classpathSelected(String string2) {
        File file2 = null;
        String string3 = null;
        if (string2.charAt(0) == '.' && string2.length() == 2) {
            file2 = new File(System.getProperty("user.dir"));
            string3 = file2.getName();
        } else {
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.setLength(stringBuffer.length() - 1);
            file2 = new File(String.valueOf(stringBuffer) + System.getProperty("file.separator"));
            string3 = new File(stringBuffer.toString()).getName();
        }
        this.rootNode = new DefaultMutableTreeNode(string3);
        this.createTreeNodes(this.rootNode, file2);
        this.createAndDisplaySelectedTree(this.rootNode);
        this.treeTable.put(string2, this.rootNode);
    }

    private void createEmptyTree() {
        this.rootNode = new DefaultMutableTreeNode("");
        this.tree = new JTree(this.rootNode);
        this.rootNode.setUserObject(this.rg.b("none"));
        this.tree.setCellRenderer(new UITreeCellRenderer());
        this.treeScrollPane = new JScrollPane(this.tree);
        this.treePanel.add(this.treeScrollPane);
        this.treePanel.setPreferredSize(new Dimension(150, 150));
        this.treePanel.revalidate();
    }

    private void createAndDisplaySelectedTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("");
        }
        this.treePanel.remove(this.treeScrollPane);
        if (this.tree != null) {
            this.tree.removeTreeSelectionListener(this);
            this.tree.removeTreeExpansionListener(this);
        }
        this.tree = new JTree(defaultMutableTreeNode);
        if (defaultMutableTreeNode.getChildCount() == 0) {
            defaultMutableTreeNode.setUserObject(this.rg.c("none"));
            this.tree.setRootVisible(true);
        } else {
            this.tree.addTreeSelectionListener(this);
            this.tree.addTreeExpansionListener(this);
            this.tree.setRootVisible(false);
        }
        this.tree.setCellRenderer(new UITreeCellRenderer());
        this.treeScrollPane = new JScrollPane(this.tree);
        this.treePanel.add(this.treeScrollPane);
        this.treePanel.revalidate();
    }

    private void createZippedFileTreeNodes(DefaultMutableTreeNode defaultMutableTreeNode, v1 v12) {
        Object object;
        int n10;
        Object object2;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        v0 v02 = new v0(v12.a());
        v0 v03 = new v0(v12.b());
        char c10 = System.getProperty("file.separator").charAt(0);
        if (v03.size() > 0) {
            defaultMutableTreeNode2 = null;
            object2 = null;
            n10 = 0;
            object = null;
            String string2 = null;
            vz vz2 = null;
            Enumeration enumeration = v03.elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                vz2 = new vz((String)object, true);
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(vz2);
                Vector<String> vector = new Vector<String>();
                Enumeration enumeration2 = v02.elements();
                while (enumeration2.hasMoreElements()) {
                    string2 = (String)enumeration2.nextElement();
                    n10 = string2.lastIndexOf(c10);
                    if (n10 == -1 || !((String)object).equals(string2.substring(0, n10))) continue;
                    object2 = new DefaultMutableTreeNode(new vz(string2.substring(n10 + 1), false));
                    defaultMutableTreeNode2.add((MutableTreeNode)object2);
                    vector.addElement(string2);
                }
                if (!vector.isEmpty()) {
                    Enumeration enumeration3 = vector.elements();
                    while (enumeration3.hasMoreElements()) {
                        String string3 = (String)enumeration3.nextElement();
                        v02.remove(string3);
                    }
                }
                if (defaultMutableTreeNode2.getChildCount() == 0) {
                    vz2.a(true);
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
        if (v02.size() > 0) {
            defaultMutableTreeNode2 = null;
            object2 = null;
            n10 = 0;
            object = v02.elements();
            while (object.hasMoreElements()) {
                object2 = (String)object.nextElement();
                n10 = ((String)object2).lastIndexOf(c10);
                if (n10 != -1) continue;
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(new vz((String)object2, false));
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
    }

    private void createTreeNodes(DefaultMutableTreeNode defaultMutableTreeNode, File file2) {
        this.availableDirectories = new v0();
        this.secondLevelTree = false;
        this.secondLevelCreated = false;
        Object[] objectArray = file2.list(this);
        if (objectArray != null) {
            v0 v02 = new v0(objectArray);
            v02.copyInto(objectArray);
            if (this.availableDirectories.size() >= 1) {
                File file3 = null;
                File[] fileArray = new File[this.availableDirectories.size()];
                DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                int n10 = 0;
                Enumeration enumeration = this.availableDirectories.elements();
                while (enumeration.hasMoreElements()) {
                    fileArray[n10] = file3 = (File)enumeration.nextElement();
                    ++n10;
                }
                n10 = 0;
                while (n10 < fileArray.length) {
                    file3 = fileArray[n10];
                    if (this.isDirectoryEmpty(file3)) {
                        defaultMutableTreeNode2 = new DefaultMutableTreeNode(new vz(file3, true, true));
                    } else {
                        defaultMutableTreeNode2 = new DefaultMutableTreeNode(new vz(file3, true));
                        this.createSecondLevelNodes(defaultMutableTreeNode2, file3);
                    }
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    ++n10;
                }
            }
            int n11 = 0;
            while (n11 < objectArray.length) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(new vz((String)objectArray[n11], false)));
                ++n11;
            }
        }
    }

    private void createSecondLevelNodes(DefaultMutableTreeNode defaultMutableTreeNode, File file2) {
        this.availableDirectories = new v0();
        String[] stringArray = file2.list(this);
        if (stringArray != null && stringArray.length >= 1 || this.availableDirectories.size() >= 1) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private boolean isDirectoryEmpty(File file2) {
        this.availableDirectories = new v0();
        String[] stringArray = file2.list(this);
        return (stringArray == null || stringArray.length < 1) && this.availableDirectories.size() < 1;
    }

    public void appendClasspath(String string2) {
        if (string2 != null) {
            string2 = String.valueOf(string2) + this.stringPathSeparator;
            JLabel jLabel = new JLabel(string2, this.userIcon, 2);
            this.classpathList.setListData(new Vector());
            this.classpathVector.insertElementAt(jLabel, 0);
            this.classpathList.setListData(this.classpathVector);
            this.classpathList.setSelectedValue(jLabel, true);
            this.newClasspathVector.insertElementAt(jLabel, 0);
            this.deleteClasspathButton.setEnabled(true);
            this.startupSettings.addUserClasspath(string2);
            this.classpathList.revalidate();
        }
    }

    public void deleteSelectedClasspath() {
        JLabel jLabel = (JLabel)this.classpathList.getSelectedValue();
        String string2 = jLabel.getText();
        if (jLabel != null) {
            this.classpathList.setListData(new Vector());
            this.classpathVector.removeElement(jLabel);
            this.classpathList.setListData(this.classpathVector);
            this.newClasspathVector.removeElement(jLabel);
            if (this.treeTable.containsKey(string2)) {
                this.treeTable.remove(string2);
            }
            this.deleteClasspathButton.setEnabled(false);
            this.startupSettings.deleteUserClasspath(string2);
            this.classpathList.revalidate();
            this.rootNode = new DefaultMutableTreeNode("");
            this.createAndDisplaySelectedTree(this.rootNode);
            this.treePanel.validate();
            this.treePanel.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton;
        if (actionEvent.getSource() instanceof JButton && (jButton = (JButton)actionEvent.getSource()) == this.deleteClasspathButton) {
            this.deleteSelectedClasspath();
        }
    }

    public String getClasspath() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.classpathVector.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append((String)enumeration.nextElement());
        }
        return stringBuffer.toString();
    }

    public String getSelectedProgram() {
        return this.selectedProgramLb.getText();
    }

    public void enterPressed(ActionEvent actionEvent) {
        this.getOkButton().doClick(200);
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getAddJarZipButton() {
        return this.addJarZipButton;
    }

    public JButton getAddClasspathButton() {
        return this.addClasspathButton;
    }

    public JButton getDeleteClasspathButton() {
        return this.deleteClasspathButton;
    }

    public JButton getHelpButton() {
        return this.helpButton;
    }

    public String getNameForOKButton() {
        return this.rg.b("okButton");
    }

    public String getNameForFileChooser() {
        return this.rg.b("selectJarZipFiles");
    }

    public void setChangesAllowed(boolean bl2) {
        this.changesAllowed = bl2;
        JButton jButton = this.getAddJarZipButton();
        if (jButton != null) {
            jButton.setVisible(bl2);
        }
        if ((jButton = this.getAddClasspathButton()) != null) {
            jButton.setVisible(bl2);
        }
        if ((jButton = this.getDeleteClasspathButton()) != null) {
            jButton.setVisible(bl2);
        }
    }

    public boolean getChangesAllowed() {
        return this.changesAllowed;
    }

    public void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void createGui() {
        this.okButton = new am(this.rg.b("okButton"));
        this.cancelButton = new am(this.rg.b("cancelButton"));
        this.helpButton = new am(this.rg.b("helpButton"));
        this.addJarZipButton = new am(this.rg.b("addJarZipButton"));
        this.addClasspathButton = new am(this.rg.b("addClasspathButton"));
        this.deleteClasspathButton = new am(this.rg.b("deleteClasspathButton"));
        this.okButton.setEnabled(false);
        this.deleteClasspathButton.setEnabled(false);
        this.selectedProgramLb = new h9(this.rg.b("none"));
        this.labelSrollPane = new JScrollPane(this.selectedProgramLb);
        this.classpathList = new JList();
        this.classpathList.setSelectionMode(0);
        this.classpathList.getSelectionModel().addListSelectionListener(this);
        this.classpathScrollPane = new JScrollPane(this.classpathList);
        this.scrollPanel = new JPanel();
        this.scrollPanel.setBackground(this.classpathList.getBackground());
        this.treeScrollPane = new JScrollPane(this.scrollPanel);
        this.topTextPanel = new JPanel();
        this.topTextPanel.setLayout(new FlowLayout(0, 0, 0));
        this.topTextPanel.setBorder(new EmptyBorder(5, 0, 5, 5));
        this.topTextPanel.add(new h9(this.rg.b("selectClasspathMsg")));
        this.classpathPanel = new kn(0);
        this.classpathPanel.setBorder(new EmptyBorder(0, 5, 5, 0));
        this.addClasspathButton.setAlignmentX(1.0f);
        this.addJarZipButton.setAlignmentX(1.0f);
        this.deleteClasspathButton.setAlignmentX(1.0f);
        int n10 = Math.max(this.addClasspathButton.getPreferredSize().width, this.addJarZipButton.getPreferredSize().width);
        n10 = Math.max(n10, this.deleteClasspathButton.getPreferredSize().width);
        int n11 = Math.max(this.addClasspathButton.getPreferredSize().height, this.addJarZipButton.getPreferredSize().height);
        n11 = Math.max(n11, this.deleteClasspathButton.getPreferredSize().height);
        Dimension dimension = new Dimension(n10, n11);
        this.addClasspathButton.setMaximumSize(dimension);
        this.addJarZipButton.setMaximumSize(dimension);
        this.deleteClasspathButton.setMaximumSize(dimension);
        this.classpathPanel.add(this.addJarZipButton);
        this.classpathPanel.add(Box.createVerticalStrut(10));
        this.classpathPanel.add(this.addClasspathButton);
        this.classpathPanel.add(Box.createVerticalStrut(10));
        this.classpathPanel.add(this.deleteClasspathButton);
        this.topNorthPanel = new JPanel();
        this.topNorthPanel.setLayout(new BorderLayout());
        this.topNorthPanel.add(this.topTextPanel);
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add("North", this.topNorthPanel);
        this.topPanel.add(this.classpathScrollPane);
        this.topPanel.add("East", this.classpathPanel);
        this.selectPackagePanel = new JPanel();
        this.selectPackagePanel.setLayout(new FlowLayout(0, 0, 0));
        this.selectPackagePanel.setBorder(new EmptyBorder(15, 0, 5, 0));
        this.selectPackagePanel.add(new h9(this.rg.b("selectPackageMsg")));
        this.topPanel.add("South", this.selectPackagePanel);
        this.bottomTextPan = new JPanel();
        this.bottomTextPan.setLayout(new BorderLayout());
        this.bottomTextPan.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.bottomTextPan.add("West", new h9(String.valueOf(this.rg.b("selectedProgramMsg")) + "   "));
        this.bottomTextPan.add(this.labelSrollPane);
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new FlowLayout(2, 0, 0));
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.cancelButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.helpButton);
        this.southPanel = new kn(0);
        this.southPanel.add(this.bottomTextPan);
        this.southPanel.add(Box.createVerticalStrut(10));
        this.southPanel.add(this.buttonsPanel);
        this.southPanel.setPreferredSize(new Dimension(150, 80));
        this.treePanel.setLayout(new BorderLayout());
        this.treePanel.add(this.treeScrollPane);
        this.treePanel.setBackground(this.classpathList.getBackground());
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add(this.treePanel);
        this.bottomPanel.add("South", this.southPanel);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(this.topPanel);
        jPanel.add(this.bottomPanel);
    }

    public boolean accept(File file2, String string2) {
        if (this.secondLevelCreated) {
            return false;
        }
        File file3 = null;
        if (string2.indexOf(".class") < 0) {
            file3 = new File(file2, string2);
            if (file3.isDirectory()) {
                this.availableDirectories.a(file3);
                if (this.secondLevelTree) {
                    this.secondLevelCreated = true;
                }
            }
            return false;
        }
        if (this.secondLevelTree) {
            this.secondLevelCreated = true;
        }
        return true;
    }

    public void cleanup() {
        if (this.l()) {
            return;
        }
        this.a(this.rg);
        this.rg = null;
        this.a((Object)this.scrollPanel);
        this.scrollPanel = null;
        this.a((Object)this.topTextPanel);
        this.topTextPanel = null;
        this.a((Object)this.classpathPanel);
        this.classpathPanel = null;
        this.a((Object)this.topPanel);
        this.topPanel = null;
        this.a((Object)this.topNorthPanel);
        this.topNorthPanel = null;
        this.a((Object)this.selectPackagePanel);
        this.selectPackagePanel = null;
        this.a((Object)this.bottomTextPan);
        this.bottomTextPan = null;
        this.a((Object)this.bottomPanel);
        this.bottomPanel = null;
        this.a((Object)this.buttonsPanel);
        this.buttonsPanel = null;
        this.a((Object)this.southPanel);
        this.southPanel = null;
        this.a((Object)this.addJarZipButton);
        this.addJarZipButton = null;
        this.a((Object)this.addClasspathButton);
        this.addClasspathButton = null;
        this.a((Object)this.okButton);
        this.okButton = null;
        this.a((Object)this.cancelButton);
        this.cancelButton = null;
        if (this.deleteClasspathButton != null) {
            this.deleteClasspathButton.removeActionListener(this);
            this.a((Object)this.deleteClasspathButton);
            this.deleteClasspathButton = null;
        }
        this.a((Object)this.helpButton);
        this.helpButton = null;
        if (this.classpathList != null) {
            this.classpathList.getSelectionModel().removeListSelectionListener(this);
            this.a((Object)this.classpathList);
            this.classpathList = null;
        }
        this.previousClasspath = null;
        this.a((Object)this.selectedProgramLb);
        this.selectedProgramLb = null;
        this.a((Object)this.classpathScrollPane);
        this.classpathScrollPane = null;
        this.a((Object)this.treeScrollPane);
        this.treeScrollPane = null;
        this.a((Object)this.labelSrollPane);
        this.labelSrollPane = null;
        this.rootNode = null;
        this.previousNode = null;
        if (this.tree != null) {
            this.tree.removeTreeSelectionListener(this);
            this.tree.removeTreeExpansionListener(this);
            this.a((Object)this.tree);
            this.tree = null;
        }
        this.parent = null;
        this.a((Object)this.treePanel);
        this.treePanel = null;
        if (this.availableDirectories != null) {
            this.availableDirectories.removeAllElements();
            this.availableDirectories = null;
        }
        if (this.classpathVector != null) {
            this.classpathVector.removeAllElements();
            this.classpathVector = null;
        }
        this.waitCursor = null;
        if (this.treeTable != null) {
            this.treeTable.clear();
            this.treeTable = null;
        }
        this.debuggerSettings = null;
        this.stringPathSeparator = null;
        this.systemIcon = null;
        this.userIcon = null;
        this.startupSettings = null;
        this.removeAll();
        super.cleanup();
    }
}

