/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.jface.basic;

import com.ibm.ivb.jface.parts.CustomButton;
import com.ibm.ivb.jface.parts.Workbook;
import com.ibm.ivb.jface.plaf.WorkbookUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;

public class BasicWorkbookUI
extends WorkbookUI
implements LayoutManager,
ChangeListener,
MouseListener {
    public static final String kCBIBMCopyright = "(c) Copyright IBM Corporation 1998";
    public int firstPage = 0;
    public int lastPage = 0;
    public int currentPage = 0;
    public int tabHeight = 30;
    public int tabWidth = 50;
    public int shaftHeight = 8;
    public int arrowWidth = 75;
    public int tabGap = 0;
    public int tpad = 12;
    public int doplerShift = 3;
    public int blendOverlap = 5;
    public int leftGap = 2;
    public Font captionFont = new Font("Helvetica", 1, 12);
    public boolean drawBorder = true;
    public boolean goprevVisible = false;
    public CustomButton left;
    public CustomButton right;
    public CustomButton goprev;
    public Workbook wb;
    public hc visiblePage;
    public hc prevPage = null;
    public Insets borderInsets = new Insets(7, 5, 5, 5);
    public Insets extInsets;
    public boolean tabOverlap;
    public boolean tabHighlight;
    public int overlapWidth;
    public boolean tabSwap;
    public boolean dirty;
    public xw bh;
    public int tabStart;
    public boolean savedNested;
    public Color dark1;
    public Color dark2;
    public Color dark3;
    public Color bright1;
    public Color bright2;
    public Color bright3;

    public BasicWorkbookUI() {
        this.extInsets = new Insets(this.borderInsets.top + 10, this.borderInsets.left + 10, this.borderInsets.bottom + 10, this.borderInsets.right + 10);
        this.tabOverlap = false;
        this.tabHighlight = true;
        this.overlapWidth = 3;
        this.tabSwap = false;
        this.dirty = false;
        this.tabStart = this.borderInsets.left;
        this.savedNested = false;
        this.tabWidth = 40;
        this.tabGap = 0;
        this.tpad = 10;
    }

    public void addLayoutComponent(String string2, Component component) {
    }

    public void allPagesRemoved() {
        this.visiblePage = null;
        this.prevPage = null;
        this.currentPage = -1;
        this.wb.invalidate();
        this.wb.validate();
    }

    public void calculateArrowWidth() {
        this.arrowWidth = this.left.getPreferredSize().width + this.right.getPreferredSize().width + (this.goprev.isVisible() ? 10 + this.goprev.getPreferredSize().width : 0) + 10;
    }

    public void calculateColorShades(Color color) {
        this.dark1 = xa.b(color, 1);
        this.dark2 = xa.b(color, 2);
        this.dark3 = xa.b(color, 3);
        this.bright1 = xa.a(color, 1);
        this.bright2 = xa.a(color, 2);
        this.bright3 = xa.a(color, 3);
    }

    public Dimension calculateSize() {
        Component component;
        boolean bl2 = !this.wb.getTabsVisible();
        Component component2 = component = this.visiblePage != null ? this.visiblePage.b() : null;
        if (bl2 && component != null) {
            return component.getPreferredSize();
        }
        this.tabHeight = this.getTabHeight();
        int n10 = this.extInsets.top + this.tabHeight;
        Dimension dimension = component != null ? component.getSize() : new Dimension(0, 0);
        int n11 = this.extInsets.left + dimension.width + this.extInsets.right;
        int n12 = n10 + dimension.height + this.extInsets.bottom;
        return new Dimension(n11, n12);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicWorkbookUI();
    }

    public void flipPages(hc hc2, hc hc3) {
        Component component;
        Component component2 = hc2 != null ? hc2.b() : null;
        Component component3 = component = hc3 != null ? hc3.b() : null;
        if (hc2 == hc3 && component2 == component) {
            return;
        }
        if (component == null) {
            return;
        }
        if (component2 != null) {
            this.wb.removeComponent(component2);
            if (Workbook.jdk13) {
                try {
                    this.wb.addPage(hc2);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    try {
                        this.wb.addPage(hc2);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                        // empty catch block
                    }
                }
                this.wb.pages.removeElementAt(this.wb.pages.size() - 1);
            }
        }
        if (component != null) {
            this.wb.addComponent(component);
        }
        this.visiblePage = hc3;
        if (hc2 != null) {
            this.wb.fireItemEvent(new ItemEvent(this.wb, 701, hc2, 2));
        }
        if (hc3 != null) {
            this.wb.fireItemEvent(new ItemEvent(this.wb, 701, hc3, 1));
        }
    }

    public Rectangle getFrameRect(int n10) {
        Dimension dimension = this.wb.getSize();
        int n11 = this.borderInsets.top + n10;
        return new Rectangle(this.borderInsets.left, n11, dimension.width - this.borderInsets.left - this.borderInsets.right, dimension.height - n11 - this.borderInsets.bottom);
    }

    public Color getSelectedTextColor() {
        return Color.blue.darker().darker();
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n10) {
        return new Rectangle();
    }

    public int getTabHeight() {
        Font font = this.captionFont;
        if (font == null) {
            return 30;
        }
        FontMetrics fontMetrics = ((Component)this.wb).getFontMetrics(font);
        int n10 = fontMetrics.getHeight();
        return 6 + n10 + 5;
    }

    public void installUI(JComponent jComponent) {
        Workbook workbook = (Workbook)jComponent;
        this.left = new CustomButton(3);
        this.right = new CustomButton(4);
        this.goprev = new CustomButton(5);
        this.goprev.setVisible(this.goprevVisible);
        workbook.addComponent(this.left);
        workbook.addComponent(this.right);
        workbook.addComponent(this.goprev);
        workbook.setLayout(this);
        workbook.addChangeListener(this);
        workbook.addMouseListener(this);
        this.bh = new xw(this);
        this.left.addActionListener(this.bh);
        this.right.addActionListener(this.bh);
        this.wb = workbook;
        this.tabOverlap = true;
        this.visiblePage = workbook.getCurrentPage();
        this.prevPage = workbook.getPreviousPage();
        this.currentPage = workbook.getCurrentPageNumber();
        this.savedNested = workbook.isNested();
        this.captionFont = new Font("SansSerif", 1, 12);
    }

    public void layoutContainer(Container container) {
        Component component;
        Workbook workbook = (Workbook)container;
        Dimension dimension = workbook.getSize();
        boolean bl2 = !workbook.getTabsVisible();
        boolean bl3 = false;
        Component component2 = this.prevPage != null ? this.prevPage.b() : null;
        Component component3 = component = this.visiblePage != null ? this.visiblePage.b() : null;
        if (component2 != null && component2.getParent() == null && component != null && SwingUtilities.findFocusOwner(component2) != null) {
            bl3 = true;
        }
        if (bl2) {
            this.goprev.setVisible(false);
            this.left.setVisible(false);
            this.right.setVisible(false);
            if (this.visiblePage != null && component != null) {
                component.setLocation(0, 0);
                component.setSize(dimension.width, dimension.height);
                component.setVisible(true);
                component.validate();
                if (bl3) {
                    this.transferFocusTo(component);
                }
                return;
            }
        }
        this.tabHeight = this.getTabHeight();
        int n10 = this.extInsets.top + this.tabHeight;
        if (this.visiblePage != null && component != null) {
            component.setLocation(this.extInsets.left, n10);
            component.setSize(dimension.width - this.extInsets.left - this.extInsets.right, dimension.height - n10 - this.extInsets.bottom);
            component.setVisible(true);
            component.validate();
            if (bl3) {
                this.transferFocusTo(component);
            }
        }
        this.calculateArrowWidth();
        int n11 = dimension.width - this.borderInsets.right - this.arrowWidth;
        int n12 = this.borderInsets.top + this.tabHeight - this.shaftHeight / 2 - this.left.getPreferredSize().height;
        int n13 = n11;
        this.left.setLocation(n13, n12);
        this.left.setSize(this.left.getPreferredSize());
        this.right.setLocation(n13 += this.left.getPreferredSize().width + this.leftGap, n12);
        this.right.setSize(this.right.getPreferredSize());
        n13 += this.right.getPreferredSize().width + 10;
        if (this.goprevVisible) {
            this.goprev.setVisible(true);
            this.goprev.setLocation(n13, n12);
            this.goprev.setSize(this.goprev.getPreferredSize());
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calculateSize();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.wb.getPageCount() == 0) {
            return;
        }
        int n10 = this.firstPage;
        while (n10 <= this.lastPage) {
            hc hc2 = this.wb.getPageAt(n10);
            Rectangle rectangle = hc2.e();
            if (rectangle.contains(point)) {
                if (!this.wb.isEnabled() || !hc2.g()) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if (this.visiblePage != hc2) {
                    this.tabSwap = true;
                    this.wb.showPage(hc2);
                    this.wb.requestFocus();
                    break;
                }
                this.wb.requestFocus();
                if (mouseEvent.getClickCount() != 2) break;
                this.wb.fireActionEvent(new ActionEvent(hc2, 1001, hc2.a()));
                break;
            }
            ++n10;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void pageRemoved(hc hc2) {
        if (hc2 == this.visiblePage) {
            this.wb.fireItemEvent(new ItemEvent(this.wb, 701, hc2, 2));
            Component component = this.visiblePage.b();
            if (component != null) {
                this.wb.removeComponent(component);
            }
            this.visiblePage = null;
        }
        this.wb.invalidate();
        this.wb.validate();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (!this.wb.getTabsVisible()) {
            return;
        }
        Dimension dimension = this.wb.getSize();
        this.tabHeight = this.getTabHeight();
        this.paintBorders(graphics, this.tabHeight);
        this.paintTabShaft(graphics, false);
        this.paintTabs(graphics, dimension, false);
    }

    public void paintBorders(Graphics graphics, int n10) {
        Dimension dimension = this.wb.getSize();
        Color color = this.wb.getBackground();
        graphics.setColor(color);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        int n11 = this.extInsets.top + n10;
        Rectangle rectangle = this.getFrameRect(n10);
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        if (this.bright3 == null) {
            this.calculateColorShades(color);
        }
        graphics.setColor(this.bright3);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, n13 - 1);
        graphics.drawLine(rectangle.x, rectangle.y, n12 - 1, rectangle.y);
        graphics.setColor(this.bright2);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, n13 - 2);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, n12 - 2, rectangle.y + 1);
        graphics.setColor(this.bright1);
        graphics.drawLine(rectangle.x + 2, rectangle.y + 2, rectangle.x + 2, n13 - 3);
        graphics.drawLine(rectangle.x + 2, rectangle.y + 2, n12 - 3, rectangle.y + 2);
        graphics.setColor(this.dark3);
        graphics.drawLine(n12 - 1, rectangle.y + 1, n12 - 1, n13 - 1);
        graphics.drawLine(rectangle.x + 1, n13 - 1, n12 - 1, n13 - 1);
        graphics.setColor(this.dark2);
        graphics.drawLine(n12 - 2, rectangle.y + 2, n12 - 2, n13 - 2);
        graphics.drawLine(rectangle.x + 2, n13 - 2, n12 - 2, n13 - 2);
        graphics.setColor(this.dark1);
        graphics.drawLine(n12 - 3, rectangle.y + 3, n12 - 3, n13 - 3);
        graphics.drawLine(rectangle.x + 3, n13 - 3, n12 - 3, n13 - 3);
        if (!this.wb.isNested() && this.drawBorder) {
            this.paintWorkbookBorder(graphics, color, dimension);
        }
    }

    public boolean paintOneTab(Graphics graphics, hc hc2, int n10, int n11, int n12, int n13, boolean bl2, boolean bl3) {
        int n14;
        int n15;
        int n16;
        int n17;
        this.tabHeight = this.getTabHeight();
        Color color = this.wb.getBackground();
        Icon icon = hc2.c();
        String string2 = hc2.a();
        boolean bl4 = false;
        int n18 = n17 = n11 + this.tabHeight - 5;
        if (this.bright3 == null) {
            this.calculateColorShades(color);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n19 = n16 = string2 != null ? fontMetrics.stringWidth(string2) : 0;
        if (icon != null) {
            n16 += icon.getIconWidth() + 5;
        }
        if (n16 < this.tabWidth) {
            n16 = this.tabWidth;
        }
        int n20 = this.tpad + n16 + this.tpad;
        if (bl3) {
            n20 += this.overlapWidth + this.overlapWidth;
        }
        if (n10 + n20 > n13 - this.tabGap) {
            return false;
        }
        if (n12 == this.currentPage) {
            bl4 = true;
            n18 -= this.doplerShift;
        }
        int n21 = 0;
        int n22 = this.tabHeight;
        if (!bl4) {
            n21 = this.doplerShift;
            n22 -= n21;
            if (bl2) {
                graphics.setColor(color);
                graphics.fillRect(n10 - 1, n11 - 1, n20 + 2, n21 + 1);
                graphics.setColor(this.bright3);
                n15 = n11 + this.tabHeight;
                graphics.drawLine(n10, n15, n10 + n20, n15);
                graphics.setColor(this.bright2);
                graphics.drawLine(n10, n15 + 1, n10 + n20, n15 + 1);
                graphics.setColor(this.bright1);
                graphics.drawLine(n10, n15 + 2, n10 + n20, n15 + 2);
                if (n12 == this.firstPage) {
                    graphics.setColor(this.bright3);
                    graphics.drawLine(n10, n15, n10 + 5, n15);
                    graphics.drawLine(n10, n15, n10, n15 + 5);
                    graphics.setColor(this.bright2);
                    graphics.drawLine(n10 + 1, n15 + 1, n10 + 5, n15 + 1);
                    graphics.drawLine(n10 + 1, n15 + 1, n10 + 1, n15 + 5);
                    graphics.setColor(this.bright1);
                    graphics.drawLine(n10 + 2, n15 + 2, n10 + 5, n15 + 2);
                    graphics.drawLine(n10 + 2, n15 + 2, n10 + 2, n15 + 5);
                }
            }
        }
        graphics.setColor(color);
        n15 = bl4 ? this.doplerShift + 3 : 0;
        graphics.fillRect(n10, n11 + n21, n20, n22 + n15);
        int n23 = n10 + n20 - 1;
        int n24 = n11 + n21 - 1;
        int n25 = n24 + n22;
        Color color2 = this.bright3;
        Color color3 = this.bright2;
        Color color4 = this.bright1;
        Color color5 = this.dark3;
        Color color6 = this.dark2;
        Color color7 = this.dark1;
        if (this.tabHighlight && !bl4) {
            color2 = color3;
            color3 = color4;
            color5 = color6;
            color6 = color7;
        }
        graphics.setColor(color2);
        graphics.drawLine(n10, n24 + 2, n10, n25);
        graphics.drawLine(n10 + 2, n24, n23 - 2, n24);
        graphics.setColor(color3);
        graphics.drawLine(n10 + 1, n24 + 1, n10 + 1, n25);
        graphics.drawLine(n10 + 1, n24 + 2, n10 + 1, n25);
        graphics.drawLine(n10 + 2, n24 + 1, n23 - 2, n24 + 1);
        graphics.setColor(color4);
        graphics.drawLine(n10 + 2, n24 + 2, n10 + 2, n25);
        graphics.drawLine(n10 + 2, n24 + 2, n23 - 2, n24 + 2);
        graphics.setColor(color2);
        graphics.drawLine(n10, n24 + 2, n10 + 2, n24);
        graphics.setColor(color5);
        graphics.drawLine(n23, n24 + 2, n23, n25);
        graphics.drawLine(n23, n24 + 2, n23 - 1, n24 + 1);
        graphics.setColor(color6);
        if (!bl4) {
            graphics.drawLine(n23 - 1, n24 + 2, n23 - 1, n25);
        } else {
            graphics.drawLine(n23 - 1, n24 + 2, n23 - 1, n25 + 1);
        }
        graphics.setColor(color7);
        if (!bl4) {
            graphics.drawLine(n23 - 2, n24 + 3, n23 - 2, n25);
        } else {
            graphics.drawLine(n23 - 2, n24 + 3, n23 - 2, n25 + 2);
        }
        if (bl4) {
            graphics.setColor(color4);
            graphics.drawLine(n23 - 2, n25 + 3, n23, n25 + 3);
        }
        if (bl4) {
            if (n12 == this.firstPage) {
                n14 = n11 + n22;
                graphics.setColor(color2);
                graphics.drawLine(n10, n14, n10, n14 + 5);
                graphics.setColor(color3);
                graphics.drawLine(n10 + 1, n14, n10 + 1, n14 + 5);
                graphics.setColor(color4);
                graphics.drawLine(n10 + 2, n14, n10 + 2, n14 + 5);
            } else {
                n14 = n11 + n22;
                graphics.setColor(color2);
                graphics.drawLine(n10, n14, n10 + 1, n14);
                graphics.setColor(color3);
                graphics.drawLine(n10, n14 + 1, n10 + 2, n14 + 1);
                graphics.drawLine(n10 + 1, n14, n10 + 1, n14 + 1);
                graphics.setColor(color4);
                graphics.drawLine(n10, n14 + 2, n10 + 2, n14 + 2);
                graphics.drawLine(n10 + 2, n14, n10 + 2, n14 + 2);
            }
        }
        n14 = n10 + n20 / 2 - n16 / 2;
        if (icon != null) {
            int n26 = n11 + this.tabHeight / 2 - icon.getIconHeight() / 2;
            if (!bl4) {
                n26 += this.doplerShift;
            }
            icon.paintIcon(this.wb, graphics, n14, n26);
            n14 += 5 + icon.getIconWidth();
        }
        if (bl4) {
            graphics.setColor(this.getSelectedTextColor());
        } else {
            graphics.setColor(Color.black);
        }
        if (string2 != null) {
            if (this.wb.isEnabled() && hc2.g()) {
                graphics.drawString(string2, n14, n18);
            } else {
                graphics.setColor(color.brighter());
                graphics.drawString(string2, n14, n18);
                graphics.setColor(color.darker());
                graphics.drawString(string2, n14 - 1, n18 - 1);
            }
        }
        hc2.a(n10, n11, n20, this.tabHeight);
        return true;
    }

    public void paintTabs(Graphics graphics, Dimension dimension, boolean bl2) {
        Font font = this.captionFont;
        graphics.setColor(Color.black);
        graphics.setFont(font);
        boolean bl3 = true;
        int n10 = this.tabStart;
        int n11 = dimension.width - this.borderInsets.right - this.arrowWidth;
        int n12 = 0;
        if (this.tabOverlap) {
            n10 += this.overlapWidth;
        }
        int n13 = this.firstPage;
        while (n13 < this.wb.getPageCount()) {
            hc hc2 = this.wb.getPageAt(n13);
            if (!this.paintOneTab(graphics, hc2, n10, this.borderInsets.top, n13, n11, bl2, false)) {
                bl3 = false;
                break;
            }
            if (this.visiblePage == hc2) {
                n12 = n13;
            }
            this.lastPage = n13++;
            n10 += hc2.e().width + this.tabGap;
        }
        if (this.tabOverlap && this.visiblePage != null) {
            n10 = this.visiblePage.e().x - this.overlapWidth;
            this.paintOneTab(graphics, this.visiblePage, n10, this.borderInsets.top, n12, n11, bl2, true);
        }
        this.right.setVisible(!bl3);
        this.left.setVisible(this.firstPage != 0);
    }

    public void paintTabShaft(Graphics graphics, boolean bl2) {
        this.tabHeight = this.getTabHeight();
        Rectangle rectangle = this.getFrameRect(this.tabHeight);
        int n10 = this.borderInsets.top + this.shaftHeight;
        int n11 = rectangle.width - this.arrowWidth;
        if (bl2) {
            graphics.setColor(this.wb.getBackground());
            graphics.fillRect(this.borderInsets.left, this.borderInsets.top, n11, this.tabHeight);
        }
    }

    public void paintWorkbookBorder(Graphics graphics, Color color, Dimension dimension) {
        graphics.setColor(color.darker());
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calculateSize();
    }

    public void removeLayoutComponent(Component component) {
    }

    public void repaintTabRegion() {
        int n10 = this.getTabHeight();
        Dimension dimension = this.wb.getSize();
        int n11 = this.borderInsets.left;
        int n12 = this.borderInsets.top - this.doplerShift;
        int n13 = dimension.width - this.borderInsets.left - this.borderInsets.right;
        int n14 = n10 + 5;
        this.wb.repaint(0L, n11, n12, n13, n14);
        this.tabSwap = false;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.prevPage = this.visiblePage;
        this.flipPages(this.visiblePage, this.wb.getCurrentPage());
        Component component = null;
        Dimension dimension = null;
        if (this.savedNested != this.wb.isNested()) {
            this.savedNested = this.wb.isNested();
            this.updateNested(this.savedNested);
        }
        if (this.visiblePage != null && (component = this.visiblePage.b()) != null) {
            dimension = component.getSize();
        }
        this.wb.doLayout();
        if (component != null) {
            Dimension dimension2 = component.getSize();
            if (dimension2.width != dimension.width || dimension2.height != dimension.height) {
                component.invalidate();
                component.validate();
            }
            component.repaint();
        }
        this.currentPage = this.wb.getSelectedIndex();
        if (this.tabSwap) {
            this.repaintTabRegion();
        } else {
            this.dirty = true;
            this.wb.repaint();
        }
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n10, int n11) {
        return 0;
    }

    public void transferFocusTo(Component component) {
        boolean bl2 = true;
        if (component.isFocusTraversable()) {
            component.requestFocus();
            bl2 = false;
        } else if (component instanceof JComponent && ((JComponent)component).requestDefaultFocus()) {
            bl2 = false;
        }
        if (bl2) {
            this.wb.requestFocus();
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.wb.removeComponent(this.left);
        this.wb.removeComponent(this.right);
        this.wb.removeComponent(this.goprev);
        this.left.removeActionListener(this.bh);
        this.right.removeActionListener(this.bh);
        this.wb.setLayout(null);
        this.wb.removeChangeListener(this);
        this.wb.removeMouseListener(this);
    }

    public void updateNested(boolean bl2) {
        if (bl2) {
            this.borderInsets.top = 7;
            this.borderInsets.left = 0;
            this.borderInsets.bottom = 0;
            this.borderInsets.right = 0;
        } else {
            this.borderInsets.top = 7;
            this.borderInsets.left = 5;
            this.borderInsets.bottom = 5;
            this.borderInsets.right = 5;
        }
        this.tabStart = this.borderInsets.left;
        this.extInsets.top = this.borderInsets.top + 10;
        this.extInsets.left = this.borderInsets.left + 10;
        this.extInsets.bottom = this.borderInsets.bottom + 10;
        this.extInsets.right = this.borderInsets.right + 10;
    }
}

