/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.jface.minimal;

import com.ibm.ivb.jface.basic.BasicWorkbookUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class MinimalWorkbookUI
extends BasicWorkbookUI
implements FocusListener {
    public static final String kCBIBMCopyright = "(c) Copyright IBM Corporation 1998";

    public void calculateArrowWidth() {
        this.arrowWidth = this.left.getPreferredSize().width + this.right.getPreferredSize().width + (this.goprev.isVisible() ? 10 + this.goprev.getPreferredSize().width : 0) + 10;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MinimalWorkbookUI();
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.wb.getPageCount() == 0 || this.visiblePage == null) {
            return;
        }
        Rectangle rectangle = this.visiblePage.e();
        this.wb.repaint(rectangle);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.wb.getPageCount() == 0 || this.visiblePage == null) {
            return;
        }
        Rectangle rectangle = this.visiblePage.e();
        this.wb.repaint(rectangle);
    }

    public Color getSelectedTextColor() {
        return Color.black;
    }

    public int getTabHeight() {
        Font font = this.wb.getFont();
        if (font == null) {
            return 30;
        }
        this.captionFont = font;
        FontMetrics fontMetrics = ((Component)this.wb).getFontMetrics(font);
        int n10 = fontMetrics.getHeight();
        return 4 + n10 + 4;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.goprev.setVisible(false);
        this.tabWidth = 10;
        this.tabGap = 0;
        this.tpad = 8;
        this.borderInsets.top = 7;
        this.borderInsets.left = 3;
        this.borderInsets.right = 3;
        this.borderInsets.bottom = 3;
        this.extInsets.top = this.borderInsets.top + 6;
        this.extInsets.left = this.borderInsets.left + 6;
        this.extInsets.right = this.borderInsets.right + 6;
        this.extInsets.bottom = this.borderInsets.bottom + 6;
        this.tabStart = this.borderInsets.left;
        this.tabHighlight = true;
        this.tabOverlap = true;
        this.drawBorder = false;
        this.wb.addFocusListener(this);
        this.left.setRolloverEnabled(false);
        this.right.setRolloverEnabled(false);
        this.leftGap = 0;
    }

    public void paintBorders(Graphics graphics, int n10) {
        Dimension dimension = this.wb.getSize();
        Color color = this.wb.getBackground();
        graphics.setColor(color);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        Rectangle rectangle = this.getFrameRect(n10);
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        if (this.bright3 == null) {
            this.calculateColorShades(color);
        }
        graphics.setColor(this.bright3);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, n12 - 1);
        graphics.drawLine(rectangle.x, rectangle.y, n11 - 2, rectangle.y);
        graphics.setColor(this.bright1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, n12 - 2);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, n11 - 2, rectangle.y + 1);
        graphics.setColor(this.dark3);
        graphics.drawLine(n11 - 1, rectangle.y + 1, n11 - 1, n12 - 1);
        graphics.drawLine(rectangle.x + 1, n12 - 1, n11 - 1, n12 - 1);
        graphics.setColor(this.dark1);
        graphics.drawLine(n11 - 2, rectangle.y + 2, n11 - 2, n12 - 2);
        graphics.drawLine(rectangle.x + 2, n12 - 2, n11 - 2, n12 - 2);
        graphics.setColor(xa.c(color, -20));
        graphics.drawLine(rectangle.x, rectangle.y - 1, n11 - 2, rectangle.y - 1);
        graphics.drawLine(rectangle.x - 1, rectangle.y, rectangle.x - 1, n12 - 2);
        if (!this.wb.isNested() && this.drawBorder) {
            this.paintWorkbookBorder(graphics, color, dimension);
        }
    }

    public boolean paintOneTab(Graphics graphics, hc hc2, int n10, int n11, int n12, int n13, boolean bl2, boolean bl3) {
        int n14;
        int n15;
        int n16;
        int n17;
        this.tabHeight = this.getTabHeight();
        if (n12 != this.currentPage) {
            --n11;
        }
        Color color = this.wb.getBackground();
        Icon icon = hc2.c();
        String string2 = hc2.a();
        boolean bl4 = false;
        int n18 = n17 = n11 + this.tabHeight - 5;
        if (this.bright3 == null) {
            this.calculateColorShades(color);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n19 = n16 = string2 != null ? fontMetrics.stringWidth(string2) : 0;
        if (icon != null) {
            n16 += icon.getIconWidth() + 5;
        }
        if (n16 < this.tabWidth) {
            n16 = this.tabWidth;
        }
        int n20 = this.tpad + n16 + this.tpad;
        if (bl3) {
            n20 += this.overlapWidth + this.overlapWidth;
        }
        if (n10 + n20 > n13 - this.tabGap) {
            return false;
        }
        if (n12 == this.currentPage) {
            bl4 = true;
            n18 -= this.doplerShift;
        }
        int n21 = 0;
        int n22 = this.tabHeight;
        if (!bl4) {
            n21 = this.doplerShift;
            n22 -= n21;
            if (bl2) {
                graphics.setColor(color);
                graphics.fillRect(n10 - 1, n11 - 1, n20 + 2, n21 + 1);
                graphics.setColor(this.bright3);
                n15 = n11 + this.tabHeight;
                graphics.drawLine(n10, n15, n10 + n20, n15);
                graphics.setColor(this.bright1);
                graphics.drawLine(n10, n15 + 1, n10 + n20, n15 + 1);
                if (n12 == this.firstPage) {
                    graphics.setColor(this.bright3);
                    graphics.drawLine(n10, n15, n10 + 5, n15);
                    graphics.drawLine(n10, n15, n10, n15 + 5);
                    graphics.setColor(this.bright1);
                    graphics.drawLine(n10 + 1, n15 + 1, n10 + 5, n15 + 1);
                    graphics.drawLine(n10 + 1, n15 + 1, n10 + 1, n15 + 5);
                }
            }
        }
        graphics.setColor(color);
        n15 = bl4 ? this.doplerShift + 3 : 0;
        graphics.fillRect(n10, n11 + n21, n20, n22 + n15);
        int n23 = n10 + n20 - 1;
        int n24 = n11 + n21 - 1;
        int n25 = n24 + n22;
        Color color2 = this.bright3;
        Color color3 = this.bright1;
        Color color4 = this.dark3;
        Color color5 = this.dark1;
        graphics.setColor(color2);
        graphics.drawLine(n10, n24 + 2, n10, n25);
        graphics.drawLine(n10 + 2, n24, n23 - 2, n24);
        graphics.setColor(color3);
        graphics.drawLine(n10 + 1, n24 + 1, n10 + 1, n25);
        graphics.drawLine(n10 + 1, n24 + 2, n10 + 1, n25);
        graphics.drawLine(n10 + 2, n24 + 1, n23 - 2, n24 + 1);
        graphics.setColor(color2);
        graphics.drawLine(n10, n24 + 2, n10 + 2, n24);
        if (bl4) {
            graphics.setColor(xa.c(color, -20));
            graphics.drawLine(n10 - 1, n25 - 1, n10 - 1, n24 + 2);
            graphics.drawLine(n10 - 1, n24 + 2, n10 + 2, n24 - 1);
            graphics.drawLine(n10 + 2, n24 - 1, n23 - 2, n24 - 1);
        }
        graphics.setColor(color4);
        graphics.drawLine(n23, n24 + 2, n23, n25);
        graphics.drawLine(n23, n24 + 2, n23 - 1, n24 + 1);
        graphics.setColor(color5);
        if (!bl4) {
            graphics.drawLine(n23 - 1, n24 + 2, n23 - 1, n25);
        } else {
            graphics.drawLine(n23 - 1, n24 + 2, n23 - 1, n25 + 1);
        }
        if (bl4) {
            if (n12 == this.firstPage) {
                n14 = n11 + n22;
                graphics.setColor(color2);
                graphics.drawLine(n10, n14, n10, n14 + 5);
                graphics.setColor(color3);
                graphics.drawLine(n10 + 1, n14, n10 + 1, n14 + 5);
                graphics.setColor(xa.c(color, -20));
                graphics.drawLine(n10 - 1, n14 - 1, n10 - 1, n14 + 5);
            } else {
                n14 = n11 + n22;
                graphics.setColor(color2);
                graphics.drawLine(n10, n14, n10 + 1, n14);
                graphics.setColor(color3);
                graphics.drawLine(n10, n14 + 1, n10 + 1, n14 + 1);
                graphics.drawLine(n10 + 1, n14, n10 + 1, n14 + 1);
            }
        }
        if (bl4) {
            graphics.setColor(this.getSelectedTextColor());
        } else {
            graphics.setColor(this.wb.getForeground());
        }
        n14 = n10 + n20 / 2 - n16 / 2;
        if (icon != null) {
            int n26 = n11 + this.tabHeight / 2 - icon.getIconHeight() / 2;
            if (!bl4) {
                n26 += this.doplerShift;
            }
            icon.paintIcon(this.wb, graphics, n14, n26);
            n14 += 5 + icon.getIconWidth();
        }
        if (string2 != null) {
            if (this.wb.isEnabled() && hc2.g()) {
                graphics.drawString(string2, n14, n18);
            } else {
                graphics.setColor(color.brighter());
                graphics.drawString(string2, n14, n18);
                graphics.setColor(color.darker());
                graphics.drawString(string2, n14 - 1, n18 - 1);
            }
            if (bl4 && this.wb.hasFocus()) {
                BasicGraphicsUtils.drawDashedRect(graphics, n10 + 4, n11 + 2, n20 - 8, this.tabHeight - 3);
            }
        }
        hc2.a(n10, n11, n20, this.tabHeight);
        return true;
    }

    public void paintWorkbookBorder(Graphics graphics, Color color, Dimension dimension) {
        graphics.setColor(color.darker());
        graphics.drawLine(0, 0, dimension.width - 1, 0);
        graphics.setColor(color.brighter());
        graphics.drawLine(0, 1, dimension.width - 1, 1);
    }

    public void repaintTabRegion() {
        int n10 = this.getTabHeight();
        Dimension dimension = this.wb.getSize();
        int n11 = this.borderInsets.left - 1;
        int n12 = this.borderInsets.top - this.doplerShift - 1;
        int n13 = dimension.width - this.borderInsets.left - this.borderInsets.right + 2;
        int n14 = n10 + 5 + 3;
        this.wb.repaint(0L, n11, n12, n13, n14);
        this.tabSwap = false;
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.wb.removeFocusListener(this);
    }

    public void updateNested(boolean bl2) {
        if (bl2) {
            this.borderInsets.top = 7;
            this.borderInsets.left = 0;
            this.borderInsets.bottom = 0;
            this.borderInsets.right = 0;
        } else {
            this.borderInsets.top = 7;
            this.borderInsets.left = 3;
            this.borderInsets.bottom = 3;
            this.borderInsets.right = 3;
        }
        this.tabStart = this.borderInsets.left;
        this.extInsets.top = this.borderInsets.top + 6;
        this.extInsets.left = this.borderInsets.left + 6;
        this.extInsets.bottom = this.borderInsets.bottom + 6;
        this.extInsets.right = this.borderInsets.right + 6;
    }
}

