/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.jface.parts;

import com.ibm.ivb.jface.plaf.WorkbookUI;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JTabbedPane;

public class Workbook
extends JTabbedPane
implements ItemSelectable {
    public static final String kCBIBMCopyright = "(c) Copyright IBM Corporation 1998";
    public static final int NOTEBOOK = 1;
    public static final int WORKBOOK = 0;
    public static final int MINOR_WORKBOOK = 2;
    public Vector pages = new Vector();
    public boolean historyVisible = true;
    public boolean tabsVisible = true;
    public int mode = 0;
    public i6 nl;
    public ActionListener actionListeners;
    public ItemListener itemListeners;
    public int idCounter;
    public hc prev;
    public boolean nested = false;
    public int settingC = -1;
    public static final String jdkVersion = System.getProperty("java.version");
    public static final boolean jdk13 = jdkVersion.compareTo("1.3") >= 0;

    public Workbook() {
        this(0);
    }

    public Workbook(int n10) {
        this.updateNotebookListener(n10);
        this.mode = n10;
        this.updateUI();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners = AWTEventMulticaster.add(this.actionListeners, actionListener);
    }

    public void addComponent(Component component) {
        if (this.isAncestorOf(component)) {
            return;
        }
        this.addImpl(component, null, this.getComponentCount());
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListeners = AWTEventMulticaster.add(this.itemListeners, itemListener);
    }

    public void addPage(hc hc2) {
        this.pages.addElement(hc2);
        try {
            super.addTab(hc2.a(), hc2.c(), hc2.b());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                super.addTab(hc2.a(), hc2.c(), hc2.b());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {}
        }
        hc2.a(this);
        if (this.ui instanceof WorkbookUI) {
            ((WorkbookUI)this.ui).pageAdded(hc2);
        }
    }

    public hc findPage(String string2, String string3) {
        int n10 = this.findPageIndex(string2, string3);
        if (n10 != -1) {
            return (hc)this.pages.elementAt(n10);
        }
        return null;
    }

    public int findPageIndex(hc hc2) {
        int n10 = 0;
        while (n10 < this.pages.size()) {
            hc hc3 = (hc)this.pages.elementAt(n10);
            if (hc3 == hc2) {
                return n10;
            }
            ++n10;
        }
        return -1;
    }

    public int findPageIndex(String string2, String string3) {
        int n10 = 0;
        while (n10 < this.pages.size()) {
            hc hc2 = (hc)this.pages.elementAt(n10);
            if (hc2.d().equals(string2) && (string3 == null || hc2.a().equals(string3))) {
                return n10;
            }
            ++n10;
        }
        return -1;
    }

    public void fireActionEvent(ActionEvent actionEvent) {
        if (this.actionListeners != null) {
            this.actionListeners.actionPerformed(actionEvent);
        }
    }

    public void fireItemEvent(ItemEvent itemEvent) {
        if (this.itemListeners != null) {
            this.itemListeners.itemStateChanged(itemEvent);
        }
    }

    public Vector getAllPages() {
        return this.getPages();
    }

    public hc getCurrentPage() {
        int n10 = this.getSelectedIndex();
        if (n10 > -1 && this.pages.size() > 0) {
            return (hc)this.pages.elementAt(n10);
        }
        return null;
    }

    public int getCurrentPageNumber() {
        return this.getSelectedIndex();
    }

    public int getMode() {
        return this.mode;
    }

    public hc getPageAt(int n10) {
        if (this.pages == null || this.pages.size() == 0) {
            return null;
        }
        hc hc2 = null;
        try {
            hc2 = (hc)this.pages.elementAt(n10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                hc2 = (hc)this.pages.elementAt(n10);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {}
        }
        return hc2;
    }

    public int getPageCount() {
        return this.getTabCount();
    }

    public Vector getPages() {
        return (Vector)this.pages.clone();
    }

    public hc getPreviousPage() {
        return this.prev;
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this.getCurrentPage()};
        return objectArray;
    }

    public boolean getTabsVisible() {
        return this.tabsVisible;
    }

    public String getUIClassID() {
        if (this.mode == 1) {
            return "TabbedPaneUI";
        }
        if (this.mode == 0) {
            return "WorkbookUI";
        }
        return "MinorWorkbookUI";
    }

    public boolean isNested() {
        return this.nested;
    }

    public boolean isPageHistoryButtonVisible() {
        return this.historyVisible;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners = AWTEventMulticaster.remove(this.actionListeners, actionListener);
    }

    public void removeAllPages() {
        this.pages.removeAllElements();
        while (this.getTabCount() > 0) {
            this.removeTabAt(0);
        }
        this.prev = null;
        if (this.ui instanceof WorkbookUI) {
            ((WorkbookUI)this.ui).allPagesRemoved();
        }
        this.fireStateChanged();
    }

    public void removeComponent(Component component) {
        Component component2 = null;
        int n10 = 0;
        n10 = !jdk13 ? this.getComponentCount() : this.getTabCount();
        int n11 = 0;
        while (n11 < n10) {
            component2 = !jdk13 ? this.getComponent(n11) : this.getComponentAt(n11);
            if (component == component2) {
                ((Container)this).remove(n11);
                return;
            }
            ++n11;
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListeners = AWTEventMulticaster.remove(this.itemListeners, itemListener);
    }

    public void removePage(hc hc2) {
        int n10 = this.findPageIndex(hc2);
        if (n10 != -1) {
            if (this.ui instanceof WorkbookUI) {
                ((WorkbookUI)this.ui).pageRemoved(hc2);
            }
            if (!jdk13) {
                try {
                    this.removeTabAt(n10);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    try {
                        this.removeTabAt(n10);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {}
                }
            }
            this.pages.removeElement(hc2);
            hc2.a((Workbook)null);
            if (this.prev == hc2) {
                this.prev = null;
            }
            this.fireStateChanged();
        }
    }

    public void removePage(String string2, String string3) {
        int n10 = this.findPageIndex(string2, string3);
        if (n10 != -1) {
            hc hc2 = (hc)this.pages.elementAt(n10);
            if (this.ui instanceof WorkbookUI) {
                ((WorkbookUI)this.ui).pageRemoved(hc2);
            }
            this.removeTabAt(n10);
            hc2.a((Workbook)null);
            this.pages.removeElementAt(n10);
            if (this.prev == hc2) {
                this.prev = null;
            }
            this.fireStateChanged();
        }
    }

    public void setSelectedIndex(int n10) {
        if (this.settingC >= 0) {
            return;
        }
        this.settingC = n10;
        try {
            super.setSelectedIndex(n10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                super.setSelectedIndex(n10);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {}
        }
        this.settingC = -1;
    }

    public void setMode(int n10) {
        if (this.mode != n10) {
            this.updateNotebookListener(n10);
            this.mode = n10;
            this.updateUI();
        }
    }

    public void setNested(boolean bl2) {
        if (this.nested != bl2) {
            this.nested = bl2;
            this.fireStateChanged();
        }
    }

    public void setPageHistoryButtonVisible(boolean bl2) {
        this.historyVisible = bl2;
    }

    public void setPageHistoryToolTip(String string2) {
    }

    public void setShiftLeftToolTip(String string2) {
    }

    public void setShiftRightToolTip(String string2) {
    }

    public void setTabsVisible(boolean bl2) {
        if (this.tabsVisible != bl2) {
            this.tabsVisible = bl2;
            this.fireStateChanged();
        }
    }

    public void showPage(hc hc2) {
        this.prev = this.getCurrentPage();
        int n10 = this.findPageIndex(hc2);
        if (n10 == -1) {
            return;
        }
        try {
            this.setSelectedIndex(n10);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            try {
                this.setSelectedIndex(n10);
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2) {
                return;
            }
        }
    }

    public void showPage(String string2) {
        this.showPage(string2, null);
    }

    public void showPage(String string2, String string3) {
        int n10 = this.findPageIndex(string2, string3);
        if (n10 == -1) {
            return;
        }
        this.setSelectedIndex(n10);
    }

    public void tabModified(hc hc2) {
        if (this.ui instanceof WorkbookUI) {
            ((WorkbookUI)this.ui).tabModified(hc2);
            return;
        }
        this.fireStateChanged();
    }

    public void updateClient(hc hc2) {
        int n10 = this.findPageIndex(hc2);
        this.setComponentAt(n10, hc2.b());
    }

    private void updateNotebookListener(int n10) {
        if (this.mode == 1 && this.nl != null) {
            this.removeChangeListener(this.nl);
        }
        if (n10 == 1) {
            if (this.nl == null) {
                this.nl = new i6(this);
            }
            this.addChangeListener(this.nl);
        }
    }

    public void updateUI() {
        if (this.pages == null) {
            return;
        }
        super.updateUI();
    }
}

