/*****************************************************************/
/**                  Microsoft LAN Manager                      **/
/**            Copyright(c) Microsoft Corp., 1987-1990          **/
/*****************************************************************/

/********************************************************************
 *                                                                  *
 *  About this file ...  NCB.H                                      *
 *                                                                  *
 *  This file contains information about NCBs.  Use this file       *
 *  in conjunction with NETBIOS.H and the NetBIOS APIs to write     *
 *  programs that interact with the network via the NetBIOS         *
 *  protocol.
 *                                                                  *
 *                                                                  *
 *  NOTE:  You must include NETCONS.H before this file, since this  *
 *         file depends on values defined in NETCONS.H.             *
 *                                                                  *
 ********************************************************************/

/**INTERNAL_ONLY**/
/*
 *  IBM CHANGE LOG:  (This file is based off the 90jul02 MS LM2.0 build.)
 *  mark = ptr/dcr yymondd ver  who <Description.>
 *
 * @p01 = AZ08143 91OCT07 CAJ         <This fix supports the F7 and 4F Return i
 *                                     codes>
 * @d01 = dcr0590 92jun09 glm LS21    <Sideband. Changes marked w/ "#ifdef SB".>
 * @f01 = f000443 93feb22 glm ls.r301 <Multimedia. Also, "#ifdef SB" removed.>
 * @f06 = F  5438 94Aug08 MBB ls.r40  <Make .h files compatible with C++>
 * @d02 = d017107 95Jan12 jc  ls.r40  <add 32-bit ncb structure>
 * @d03 = d17996  95Feb28 jc  ls.r40  <NetBios prototype: change LSFAR LSPAS>
 *                                    <to FARPASCAL                         >
 *
 */
/**END_INTERNAL**/

/**INTERNAL_ONLY**/
/*
 *
 *    IMPORTANT!  IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT!
 *    READ THIS FIRST BEFORE MAKING ANY CHANGES
 *
 *    This file was modified to provide support for 32-bit code.
 *
 *    Any 32-bit module that includes this header file must define
 *    the constant INCL_32.
 *
 *    It is assumed that "netcons.h" is included before this file.
 *
 *    The following contants are defined in netcons.h as shown below:
 *
 *    #ifdef INCL_32    ( defined by 32-bit apps )
 *        #define LSFAR
 *        #define LSPAS
 *        #define LSPTR  _Seg16
 *        #define LSINT  short
 *    #else                 ( for 16-bit apps )
 *        #define LSFAR  far
 *        #define LSPAS  pascal
 *        #define LSPTR
 *        #define LSINT  int
 *    #endif
 *
 *    Do not add any keywords like far, pascal, etc. which are not recognized
 *    by the 32-bit compiler. The constants defined in netcons.h (LSFAR, LSPAS)
 *    must be used to replace these keywords.
 *
 */
/**END_INTERNAL**/


/*NOINC*/
#ifndef NETNCB_INCLUDED

#define NETNCB_INCLUDED

#ifdef  ANY_32_BIT
#pragma pack(1)
#endif
/*INC*/


/****************************************************************
 *                                                              *
 *              Data structure templates                        *
 *                                                              *
 ****************************************************************/


/**INTERNAL_ONLY**/
/* NOTE:    NCBNAMSZ is defined for backward compatibility, but programs
 *          should be using NETBIOS_NAME_LEN (which is defined in NETCONS.H).
 */
/**END_INTERNAL**/
#define NCBNAMSZ        NETBIOS_NAME_LEN    /* absolute length of a net name    */

/*
 * Network Control Block
 */

/**INTERNAL_ONLY**/
/* NOTE:    We enclose the entire structure in the #ifdef because
 *          this file is translated to a .INC file and the current
 *          build version of MASM doesn't support #ifdef in structures.
 *          When we move to a upgrade of MASM which does, this file
 *          should be modified so that only the last 14 bytes of the
 *          structure are #ifdef'd.
 *
 *              -- DannyGl, 1 March 1989
 */
#ifndef SRVNCB
/**END_INTERNAL**/
struct ncb {
    unsigned char      ncb_command;            /* command code                 */
    unsigned char      ncb_retcode;            /* return code                  */
    unsigned char      ncb_lsn;                /* local session number         */
    unsigned char      ncb_num;                /* number of our network name   */
    char LSFAR * LSPTR ncb_buffer;             /* address of message buffer    */
    unsigned short     ncb_length;             /* size of message buffer       */
    char               ncb_callname[NCBNAMSZ]; /* blank-padded name of remote  */
    char               ncb_name[NCBNAMSZ];     /* our blank-padded netname     */
    unsigned char      ncb_rto;                /* rcv timeout/retry count      */
    unsigned char      ncb_sto;                /* send timeout/sys timeout     */
    unsigned long      ncb_post;               /* Async notification handle    */
    unsigned char      ncb_lana_num;           /* lana (adapter) number        */
    unsigned char      ncb_cmd_cplt;           /* 0xff => commmand pending     */
    unsigned char      ncb_reserve[14];        /* reserved, used by BIOS       */
};      /* ncb */
/**INTERNAL_ONLY**/
#else
struct ncb {
    unsigned char      ncb_command;            /* command code                 */
    unsigned char      ncb_retcode;            /* return code                  */
    unsigned char      ncb_lsn;                /* local session number         */
    unsigned char      ncb_num;                /* number of our network name   */
    char LSFAR * LSPTR ncb_buffer;             /* address of message buffer    */
    unsigned short     ncb_length;             /* size of message buffer       */
    char               ncb_callname[NCBNAMSZ]; /* blank-padded name of remote  */
    char               ncb_name[NCBNAMSZ];     /* our blank-padded netname     */
    unsigned char      ncb_rto;                /* rcv timeout/retry count      */
    unsigned char      ncb_sto;                /* send timeout/sys timeout     */
    unsigned long      ncb_post;               /* Async notification handle    */
    unsigned char      ncb_lana_num;           /* lana (adapter) number        */
    unsigned char      ncb_cmd_cplt;           /* 0xff => commmand pending     */
    char               ncb_cmdx;               /* smb cmd to process */
    char               ncb_chardevix;          /* = 0xFF if this nb did not come */
                                               /* from a char dev queue else is */
                                               /* index to char dev to open     */
    unsigned char      ncb_serialnum;          /* session serial number */
    unsigned char      ncb_seqnum;             /* session sequence number */
    unsigned short     ncb_smbmid;             /* smb_mid value for TRANS2 */
    unsigned short     ncb_smbtid;             /* the TID for this NB */
    unsigned short     ncb_smbparams;          /* offset of ptr to params of next */
                                               /* smb to process in buffer */
    long               ncb_timestamp;          /* time we began processing this nb */
};      /* ncb */
#endif /* SRVNCB */

#define ncb_sb_sess_code   ncb_length     /* For a completed CALL/LISTEN:   */
                                          /*  0==nonSB session established. */
                                          /*  1==SB session established,    */
#define ncb_sb_xmit_rc     ncb_rto        /* For a completed SB send:       */
                                          /*  0==msg was sent SB            */
                                          /*  else not sent SB (codes below)*/
#define ncb_sb_rcv_rc      ncb_sto        /* For a completed SB rcv:        */
                                          /*  0==msg rcv'd via SB           */
                                          /*  else not rcv'd SB (codes below)*/
/*               */
/*  SB Retcodes  */
/*               */
#define SB_NOERROR         0
                                    /* Why the msg was not sent/rcvd SB...*/
#define SB_ERR_DISABLED    1              /* SB disabled on this session  */
                                          /*  NOTE: this is our indicator */
                                          /*  that SB is now disabled.    */
#define SB_ERR_TOO_LARGE   2              /* msg > MAC frame              */
#define SB_ERR_MAC_FULL    3              /* MAC too busy; sent nonSB     */
#define SB_ERR_NONSB       4              /* flowed nonSB; reason unknown */



#ifdef MM                                                         /* b@f01 */
                                       /* NCBSESSIONMODIFY specific fields  */
#define  ncb_sm_subcmd  ncb_callname      /* word subcmd (new/modify, free) */
#define  ncb_sm_rsesid  ncb_callname+2    /* dword RRS SessId               */
#define  ncb_sm_rrsrc   ncb_callname+6    /* word RRS retcode               */

#define  ncb_mbz        ncb_name+8     /* dword MBZ for future extensions   */

/*                            */
/*    ncb_sm_subcmd VALUES    */
/*                            */
#define  NCBSM_NEWMOD   1
#define  NCBSM_FREE     2

#endif /* MM */                                                   /* e@f01 */

/**END_INTERNAL**/

typedef struct ncb NCB;

/****************************************************************
 *                                                              *
 *              Special values and constants                    *
 *                                                              *
 ****************************************************************/

/*
 *      NCB Command codes
 */

#define NCBCALL         0x10            /* NCB CALL                         */
#define NCBLISTEN       0x11            /* NCB LISTEN                       */
#define NCBHANGUP       0x12            /* NCB HANG UP                      */
#define NCBSEND         0x14            /* NCB SEND                         */
#define NCBRECV         0x15            /* NCB RECEIVE                      */
#define NCBRECVANY      0x16            /* NCB RECEIVE ANY                  */
#define NCBCHAINSEND    0x17            /* NCB CHAIN SEND                   */
#define NCBDGSEND       0x20            /* NCB SEND DATAGRAM                */
#define NCBDGRECV       0x21            /* NCB RECEIVE DATAGRAM             */
#define NCBDGSENDBC     0x22            /* NCB SEND BROADCAST DATAGRAM      */
#define NCBDGRECVBC     0x23            /* NCB RECEIVE BROADCAST DATAGRAM   */
#define NCBADDNAME      0x30            /* NCB ADD NAME                     */
#define NCBDELNAME      0x31            /* NCB DELETE NAME                  */
#define NCBRESET        0x32            /* NCB RESET                        */
#define NCBASTAT        0x33            /* NCB ADAPTER STATUS               */
#define NCBSSTAT        0x34            /* NCB SESSION STATUS               */
#define NCBCANCEL       0x35            /* NCB CANCEL                       */
#define NCBADDGRNAME    0x36            /* NCB ADD GROUP NAME               */
/**INTERNAL_ONLY**/
#define NCBGATHERSEND   0x40            /* NCB GATHER SEND                  */
#define NCBSCATTERRCV   0x41            /* NCB SCATTER RECEIVE              */
#define NCBSEND_RCVANY  0x48            /* NCB TRANCEIVE                    */
#define NCBSEND_SB         0x50         /* NCB SEND to flow SB              */
#define NCBCHAINSEND_SB    0x51         /* NCB CHAIN SEND to flow SB        */
#define NCBSENDNA_SB       0x52         /* NCB SEND NO ACK to flow SB       */
#define NCBCHAINSENDNA_SB  0x53         /* NCB CHAIN SEND NO ACK to flow SB */
#define NCBSEND_RCVANY_SB  0x54         /* NCB TRANCEIVE to flow SB         */
#define NCBCONTROL_SB      0x55         /* NCB to turn on/off SB on a session */
#define NCBCALL_SB         0x56         /* NCB CALL for SB session setup    */
#define NCBLISTEN_SB       0x57         /* NCB LISTEN for SB session setup  */
#ifdef MM                                                            /* b@f01 */
#define NCBSESSIONMODIFY   0x60         /* NCB SESSION MODIFY: Reserve bandwidth */
#define NCBSEND_PRI        0x61         /* NCB SEND w/ high PRIority        */
#define NCBCHAINSEND_PRI   0x62         /* NCB CHAIN SEND w/ high PRIority  */
/* TBD  NCBSENDNA_PRI      0x63         /* NCB SEND NO ACK w/ high PRIority */
/* TBD  NCBCHAINSENDNA_PRI 0x64         /* NCB CHAIN SEND NOACK w/ high PRIo*/
#define NCBSEND_RCVANY_PRI 0x65         /* NCB TRANCEIVE w/ high PRIority   */
#define NCBGATHERSEND_PRI  0x66         /* NCB GATHER SEND w/ high PRIority */
#endif  /* MM */                                                     /* e@f01 */
/**END_INTERNAL**/
#define NCBUNLINK       0x70            /* NCB UNLINK                       */
#define NCBSENDNA       0x71            /* NCB SEND NO ACK                  */
#define NCBCHAINSENDNA  0x72            /* NCB CHAIN SEND NO ACK            */


#define NCBCALLNIU      0x74            /* UB special                       */
#define NCBRCVPKT       0x78            /* UB special                       */

#define ASYNCH          0x80            /* high bit set == asynchronous     */

/*
 *      NCB Return codes
 */

#define NRC_GOODRET     0x00    /* good return                               */
#define NRC_BUFLEN      0x01    /* illegal buffer length                     */
#define NRC_BFULL       0x02    /* buffers full, no receive issued           */
#define NRC_ILLCMD      0x03    /* illegal command                           */
#define NRC_CMDTMO      0x05    /* command timed out                         */
#define NRC_INCOMP      0x06    /* message incomplete, issue another command */
#define NRC_BADDR       0x07    /* illegal buffer address                    */
#define NRC_SNUMOUT     0x08    /* session number out of range               */
#define NRC_NORES       0x09    /* no resource available                     */
#define NRC_SCLOSED     0x0a    /* session closed                            */
#define NRC_CMDCAN      0x0b    /* command cancelled                         */
#define NRC_DMAFAIL     0x0c    /* PC DMA failed                             */
#define NRC_DUPNAME     0x0d    /* duplicate name                            */
#define NRC_NAMTFUL     0x0e    /* name table full                           */
#define NRC_ACTSES      0x0f    /* no deletions, name has active sessions    */
#define NRC_INVALID     0x10    /* name not found or no valid name           */
#define NRC_LOCTFUL     0x11    /* local session table full                  */
#define NRC_REMTFUL     0x12    /* remote session table full                 */
#define NRC_ILLNN       0x13    /* illegal name number                       */
#define NRC_NOCALL      0x14    /* no callname                               */
#define NRC_NOWILD      0x15    /* cannot put * in NCB_NAME                  */
#define NRC_INUSE       0x16    /* name in use on remote adapter             */
#define NRC_NAMERR      0x17    /* called name cannot == name or name #      */
#define NRC_SABORT      0x18    /* session ended abnormally                  */
#define NRC_NAMCONF     0x19    /* name conflict detected                    */
#define NRC_IFBUSY      0x21    /* interface busy, IRET before retrying      */
#define NRC_TOOMANY     0x22    /* too many commands outstanding, retry later*/
#define NRC_BRIDGE      0x23    /* ncb_bridge field not 00 or 01             */
#define NRC_CANOCCR     0x24    /* command completed while cancel occurring  */
#define NRC_RESNAME     0x25    /* reserved name specified                   */
#define NRC_CANCEL      0x26    /* command not valid to cancel               */
#define NRC_MULT        0x33    /* multiple requests for same session        */
#define NRC_MAXAPPS     0x36    /* max number of applications exceeded       */
#define NRC_NORESOURCES 0x38    /* requested resources are not available     */
#define NRC_SYSTEM      0x40    /* system error                              */
#define NRC_ROM         0x41    /* ROM checksum failure                      */
#define NRC_RAM         0x42    /* RAM test failure                          */
#define NRC_DLF         0x43    /* digital loopback failure                  */
#define NRC_ALF         0x44    /* analog loopback failure                   */
#define NRC_IFAIL       0x45    /* interface failure                         */
#define NRC_NET_STAT    0x4f    /* Network status error              @p01a   */
#define NRC_ADPTMALFN   0x50    /* network adapter malfunction               */

#define NRC_PENDING     0xff    /* asynchronous command is not yet finished  */

/*NOINC*/
    /* main user entry point for NetBIOS 3.0*/
API_RET_TYPE FARPASCAL
NetBios(struct ncb LSFAR *);
/*INC*/

/*
 *      Maximum datagram size
 */

#define MAX_DG_SIZE 512
/*NOINC*/
/**INTERNAL_ONLY**/

/*
 * S_TO_N()
 * Convert a C string to an NCB name.
 * String will be truncated if too long.
 *
 * ENTRY
 *  cs      - points to C string
 * EXIT
 *  nm      - contains "cs", converted to NCB format
 *
 * Copy string up to terminating NUL, then pad with blanks.
 */
#define S_TO_N(cs, nm) \
{ \
    int i; \
    for (i=0 ; i < NCBNAMSZ ; (nm)[i] = (cs)[i], i++) \
        if ((cs)[i] == '\0') \
            break; \
    while (i < NCBNAMSZ) \
        (nm)[i++] = ' '; \
}


/*
 * N_TO_S()
 * Convert an NCB name to a C string.
 * (Complement of ston().)
 *
 * ENTRY
 *  nm      - points to the NCB name
 *  cs      - points to a block of memory at least NCBNAMSZ+1 bytes
 * EXIT
 *  cs      - points to an unpadded ASCIZ equivalent of "nm"
 *
 * End the C string with a NUL;
 * Strip trailing blanks;
 * Copy name into string.
 */
#define N_TO_S(nm, cs) \
{ \
    int i = NCBNAMSZ; \
    (cs)[i] = '\0'; \
    while (--i >= 0) { \
        if ((nm)[i] != ' ') \
            break; \
        (cs)[i] = '\0'; \
    } \
    while (i >= 0) { \
        (cs)[i] = (nm)[i]; \
        i--; \
    } \
}

/**END_INTERNAL**/

#ifdef  ANY_32_BIT
#pragma pack()
#endif

#endif /* NETNCB_INCLUDED */

/**INTERNAL_ONLY**/
#ifdef IBMTHUNK
struct ncb32 {
    unsigned char      ncb_command;            /* command code                 */
    unsigned char      ncb_retcode;            /* return code                  */
    unsigned char      ncb_lsn;                /* local session number         */
    unsigned char      ncb_num;                /* number of our network name   */
    char            *  ncb_buffer;             /* address of message buffer    */
    unsigned short     ncb_length;             /* size of message buffer       */
    char               ncb_callname[NCBNAMSZ]; /* blank-padded name of remote  */
    char               ncb_name[NCBNAMSZ];     /* our blank-padded netname     */
    unsigned char      ncb_rto;                /* rcv timeout/retry count      */
    unsigned char      ncb_sto;                /* send timeout/sys timeout     */
    unsigned long      ncb_post;               /* Async notification handle    */
    unsigned char      ncb_lana_num;           /* lana (adapter) number        */
    unsigned char      ncb_cmd_cplt;           /* 0xff => commmand pending     */
    unsigned char      ncb_reserve[14];        /* reserved, used by BIOS       */
};      /* ncb32 */
#endif
/**END_INTERNAL**/
/*INC*/
