

!AbtOdbcDatabaseConnection privateMethods !

sysColumnDataForTableOrViewNamed: aName ifError: anErrorBlock
	"Answer the minimum system column data that is necessary to build 
	 a new row for that table or view specified. Answers a dictionary with the dictionary 
	 key being the column name, the value a column info object containing the system data."

	| dict rt indx cursor |

	dict := Dictionary new.
	((indx := (aName indexOf: $. startingAt: 1 ifAbsent: [nil])) isNil)
		ifTrue: [rt := self columnResultTableFromTable: aName ifError: anErrorBlock]
		ifFalse: [
			rt :=
				self
					columnResultTableFromTable: (aName copyFrom: (indx + 1) to: (aName size))
					owner: (aName copyFrom: 1 to: (indx - 1))
					ifError: anErrorBlock].
	^(rt isAbtError)
		ifTrue: [rt]
		ifFalse: [
			cursor := rt cursor.
			rt do: [:row |
				dict at: (row at: 'COLUMN_NAME') put: (self sysColumnInfoClass fromRow: row)].
	cursor freeResources.
			dict]! !