
package com.ibm.sst.examples.orbix;


/*
Prerequisites:
	-Need to download and install jdk1.1x or jdk1.2 from Sun's java site and Iona's 
	OrbixWeb from "http://www.iona.com"
	-For interoperability testing the VAST side and this Java side need to be 
	able to access a shared file system. For demonstration, we will assume that
	the directory "x:\shared" is accessible to both sides.
	
Step 1
------
Run the OrbixWeb configuration utilities and make sure that parent directory of the 
"com" directory is included in the CLASSPATH variable.

Step 2 
------

Parse the idl file using the idl parser command: 
(To be run from the parent directory of "com")

	idl  -jP com.ibm.sst.examples.orbix -jO . PingPong.idl
	
Step 2
------
Change into the directory of where the files are located:
	cd com/ibm/sst/examples/orbix
	
Step 3
------
Compile the examples:
	owjavac -depend PingPongIiopFactory.java PingPongIiopExceptionalFactory.java

Step 4
------
Run the examples (note the fully qualified name is required here). 
Running the factory:
	owjava com.ibm.sst.examples.orbix.PingPongIiopFactory x:\shared\factory.ior
	or
	owjava com.ibm.sst.examples.orbix.PingPongIiopExceptionalFactory x:\shared\factory.ior
	or
	owjava com.ibm.sst.examples.orbix.PingPongIiopInOutFactory x:\shared\factory.ior

Running ping (the client):
	owjava com.ibm.sst.examples.orbix.PingPongIiop x:\shared\factory.ior 2 "Wow"
	or
	owjava com.ibm.sst.examples.orbix.PingPongIiopExceptional x:\shared\factory.ior 2 "Wow"
	or
	owjava com.ibm.sst.examples.orbix.PingPongIiopInOut x:\shared\factory.ior 2 "Wow"

Note: due to the single threaded nature of OrbixWeb, the number of iterations cannot be
greater than 2 iteration
*/

import org.omg.CORBA.*;
import IE.Iona.OrbixWeb._CORBA;
import com.ibm.sst.examples.orbix.PingPong.*;
import com.ibm.sst.examples.orbix.support.*;

public class PingPongIiop extends _IPingPongIiopImplBase {

	IPingPongIiop remote;

public PingPongIiop () {
	
	super();}

public PingPongIiop(IPingPongIiop remote) {
	
  	super();
	this.remote = remote;}

private Any finalAction (Any value) {
	
	return value;}

public static void main (String [] args) {
	
  	IPingPongIiopFactory factory = null;
  	if (args.length != 3) {
  		System.out.println("Usage PingPongIiop <ior file> <number of iterations> <message>");
  		System.exit(1);}
  	try {	
		org.omg.CORBA.Object obj = Utils.getObjectFromIORFile(args[0]);
		factory = IPingPongIiopFactoryHelper.narrow(obj);
		PingPongIiop pingPong = new PingPongIiop();
		IPingPongIiop remote = factory.create_for(pingPong);
  		pingPong.setRemote(remote);
		Any argObj = _CORBA.Orbix.create_any();
  		argObj.insert_string(args[2]);
  		pingPong.start(Integer.parseInt(args[1]),argObj);
  		System.out.println("---------------PINGPONGIIOP COMPLETED SUCCESSFULLY--------------"); 	
		return;}
  	catch (Exception e) {
		e.printStackTrace();
		System.out.println("xxxxxxxxxxxxxxxPINGPONGIIOP FAILEDxxxxxxxxxxxxxxx");}}

public Any ping(int count, Any with) {
	
	reportAction("ping", count, with);
	if (count > 0)
		return remote.pong(count - 1, with);
	return finalAction(with);}

public Any pong(int count, Any with) {
	
  	reportAction("pong", count, with);
	if (count > 0)
		return remote.ping(count - 1, with);
	return finalAction(with);}

private void reportAction (String action, int count, Any value) {
	
	System.out.print (action + " count: ");
	System.out.print (count);
	System.out.print (" with: " + value.extract_string());
	System.out.println (" running in: " + Thread.currentThread().toString());}

public void setRemote(IPingPongIiop remote) {
	
	this.remote = remote;}	  

public Any start(int count, Any with) {
	
  	reportAction("start", count, with);
  	return remote.ping( count -1, with);}  

}