
package com.ibm.sst.examples.pbroker;


/*
Prerequisites:
	-You need to download and install jdk1.1x from Sun's java site and 
	CorbaPlus's PowerBroker Orb from "http://www.expersoft.com". 
	You also need to download and install gnu c++ prepocessor if you do not have Visual C++
	installed on your system. This is also available from the CorbaPlus's site.
	-For interoperability testing the VAST side and this Java side need to be 
	able to access a shared file system. For demonstration, we will assume that
	the directory "x:\shared" is accessible to both sides.
	
Step 1 
------
Assuming the gnu c++ prepocessor is installed in c:\gnu\bin
Parse the idl file using the idl parser command:
(To be run from the parent directory of "com")

	idlj -p com.ibm.sst.examples.pbroker -set_cpp c:\gnu\bin\cpp PingPong.idl


Note: You will need to replace the gnu directory to the correct place where your preprocessor 
is installed. Further more GNU may require you to make a root \tmp directory to store
temporary files.

Step 2
------
Change into the directory of where the files are located:
	cd com/ibm/sst/examples/pbroker
	
Step 3
------
Compile the examples:
	javac -depend PingPongIiopFactory.java PingPongIiopExceptionalFactory.java PingPong\IPingPongIiopExceptionalPackage\NoMorePingPongsExceptionFactory.java
	
Step 4
------
Run the examples (note the fully qualified name is required here). 
Running the factory:
	javac com.ibm.sst.examples.pbroker.PingPongIiopFactory x:\shared\factory.ior
	or
	javac com.ibm.sst.examples.pbroker.PingPongIiopExceptionalFactory x:\shared\factory.ior
	or
	javac com.ibm.sst.examples.pbroker.PingPongIiopInOutFactory x:\shared\factory.ior

Running ping (the client):
	javac com.ibm.sst.examples.pbroker.PingPongIiop x:\shared\factory.ior 7 "Wow"
	or
	javac com.ibm.sst.examples.pbroker.PingPongIiopExceptional x:\shared\factory.ior 7 "Wow"
	or
	javac com.ibm.sst.examples.pbroker.PingPongIiopInOut x:\shared\factory.ior 7 "Wow"
*/
import org.omg.CORBA.*;
import com.ibm.sst.examples.pbroker.PingPong.*;
import com.ibm.sst.examples.pbroker.support.*;

public class PingPongIiop extends _IPingPongIiopImplBase {
	
	IPingPongIiop remote;

public PingPongIiop () {
	
  	super();}  

public PingPongIiop(IPingPongIiop remote) {
	
  	super();
	this.remote = remote;}

private org.omg.CORBA.Any finalAction (org.omg.CORBA.Any value) {

	return value;}

public static void main (String [] args) {
 
	IPingPongIiopFactory factory = null;
  	if (args.length != 3) {
  		System.out.println("Usage PingPongIiop <ior file> <number of iterations> <message>");
  		System.exit(1);}
  	try {	
		ORB orb = ORB.init();	
  		org.omg.CORBA.Object obj = Utils.getObjectFromIORFile(args[0]);		
  		factory = IPingPongIiopFactoryHelper.narrow(obj);
  		PingPongIiop pingPong = new PingPongIiop();
  		IPingPongIiop remote = factory.create_for(pingPong);
  		pingPong.setRemote(remote);
  		Any argObj = orb.create_any();
  		argObj.insert_string(args[2]);
  		pingPong.start(Integer.parseInt(args[1]),argObj);
  		System.out.println("---------------PINGPONGIIOP COMPLETED SUCCESSFULLY--------------");}
  	catch (Exception e) {
  		e.printStackTrace();
  		System.out.println("xxxxxxxxxxxxxxxPINGPONGIIOP FAILEDxxxxxxxxxxxxxxx");}}  

public Any ping(int count, Any with) {

	reportAction("ping", count, with);
	if (count > 0)
		return remote.pong(count-1, with);
	return finalAction(with);}

public Any pong(int count, Any with) {

	reportAction("pong", count, with);
	if (count>0)
		return remote.ping(count-1, with);
	return finalAction(with);}

private void reportAction (String action, int count, Any value) {

	System.out.print (action + " count: ");
	System.out.print (count);
	System.out.print (" with: " + value.extract_string());
	System.out.println (" running in: " + Thread.currentThread().toString());}

public void setRemote(IPingPongIiop remote) {

	this.remote = remote;}	  

public Any start(int count, Any with) {
	
  	reportAction("start", count, with);
  	return remote.pong( count - 1, with);}  

}