
package com.ibm.sst.examples.vbroker;


/*
Prerequisites:
	-Need to download and install the VisiBroker free evaluation ORB from
	"http://www.visigenic.com" as well as jdk1.1x from Sun's java site
	-For interoperability testing the VAST side and this Java side need to be 
	able to access a shared file system. For demonstration, we will assume that
	the directory "x:\shared" is accessible to both sides.
	
Step 1 
------
Parse the idl file using VisiBroker idl parser command: 
(To be run from the parent directory of "com")

	idl2java -package com.ibm.sst.examples.vbroker PingPong.idl
	
Step 2
------
Change into the directory of where the files are located:
	cd com/ibm/sst/examples/vbroker
	
Step 3
------
Compile the examples:
	vbjc -depend PingPongIiopFactory.java PingPongIiopExceptionalFactory.java PingPongIiopInOutFactory.java PingPongIiopInOut.java

Step 4
------
Run the examples (note the fully qualified name is required here). 
Running the factory:
	vbj com.ibm.sst.examples.vbroker.PingPongIiopFactory x:\shared\factory.ior
	or
	vbj com.ibm.sst.examples.vbroker.PingPongIiopExceptionalFactory x:\shared\factory.ior
	or
	vbj com.ibm.sst.examples.vbroker.PingPongIiopInOutFactory x:\shared\factory.ior

Running ping (the client):
	vbj com.ibm.sst.examples.vbroker.PingPongIiop x:\shared\factory.ior 7 "Wow"
	or
	vbj com.ibm.sst.examples.vbroker.PingPongIiopExceptional x:\shared\factory.ior 7 "Wow"
	or
	vbj com.ibm.sst.examples.vbroker.PingPongIiopInOut x:\shared\factory.ior 7 "Wow"
*/

import org.omg.CORBA.*;
import com.ibm.sst.examples.vbroker.PingPong.*;
import com.ibm.sst.examples.vbroker.support.*;

public class PingPongIiop extends _IPingPongIiopImplBase {
  IPingPongIiop remote;	   	
 

public PingPongIiop () {
	
  	super();}  

public PingPongIiop(IPingPongIiop remote) {
	
  	super();
	this.remote = remote;}

private Any finalAction (Any value) {
	
	return value;}

public static void main (String [] args) {
	
  	IPingPongIiopFactory factory = null;
  	if (args.length != 3) {
  		System.out.println("Usage PingPongIiop <ior file> <number of iterations> <message>");
  		System.exit(1);}
  	try {	
		ORB orb = ORB.init();	
  		org.omg.CORBA.Object obj = Utils.getObjectFromIORFile(args[0]);		
  		factory = IPingPongIiopFactoryHelper.narrow(obj);
  		PingPongIiop pingPong = new PingPongIiop();
  		IPingPongIiop remote = factory.create_for(pingPong);
  		pingPong.setRemote(remote);
  		Any argObj = orb.create_any();
  		argObj.insert_string(args[2]);
  		pingPong.start(Integer.parseInt(args[1]),argObj);
  		System.out.println("---------------PINGPONGIIOP COMPLETED SUCESSFULLY--------------");}
  	catch (Exception e) {
  		e.printStackTrace();
  		System.out.println("xxxxxxxxxxxxxxxPINGPONGIIOP FAILEDxxxxxxxxxxxxxxx");}}  

public Any ping(int count, Any with) {
	
	reportAction("ping", count, with);
	if (count > 0)
		return remote.pong(count - 1, with);
	return finalAction(with);}

public Any pong(int count, Any with) {
  	
	reportAction("pong", count, with);
	if (count > 0)
		return remote.ping(count - 1, with);
	return finalAction(with);}

private void reportAction (String action, int count, Any value) {
	
	System.out.print (action + " count: ");
	System.out.print (count);
	System.out.print (" with: " + value.extract_string());
	System.out.println (" running in: " + Thread.currentThread().toString());}

public void setRemote(IPingPongIiop remote) {
	
	this.remote = remote;}	  

public Any start(int count, Any with) {
	
  	reportAction("start", count, with);
  	return remote.pong( count - 1, with);}  

}