
package com.ibm.sst.examples.vbroker;

import org.omg.CORBA.*;
import com.ibm.sst.examples.vbroker.PingPong.*;
import com.ibm.sst.examples.vbroker.PingPong.IPingPongIiopExceptionalPackage.*;
import com.ibm.sst.examples.vbroker.support.*;

public class PingPongIiopExceptional extends _IPingPongIiopExceptionalImplBase {

	IPingPongIiopExceptional remote;

public PingPongIiopExceptional () {
	
  	super();}  

public PingPongIiopExceptional (IPingPongIiopExceptional remote) {
	
  	super(); 
	this.remote = remote;}

private Any finalAction (Any value) 
  	throws NoMorePingPongs {

	throw new NoMorePingPongs(value);}

public static void main (String [] args) {
	
	IPingPongIiopExceptionalFactory factory = null;
	if (args.length != 3) {
		System.out.println("Usage PingPongIiopExceptional <factory ior file> <number of iterations> <message>");
		System.exit(1);}
	try {	
  		ORB orb = ORB.init();	
		org.omg.CORBA.Object obj = Utils.getObjectFromIORFile(args[0]);		
		factory = IPingPongIiopExceptionalFactoryHelper.narrow(obj);
		PingPongIiopExceptional pingPong = new PingPongIiopExceptional();
		IPingPongIiopExceptional remote = factory.create_for(pingPong);
		pingPong.setRemote(remote);
		Any argObj = orb.create_any();
		argObj.insert_string(args[2]);
		pingPong.start(Integer.parseInt(args[1]),argObj);}
	catch (java.io.IOException e) {e.printStackTrace();}  
	catch (NoMorePingPongs e) {
		System.out.println("Main caught exception: " + e);
		System.out.println("---------------PINGPONGIIOP EXCEPTION COMPLETED SUCCESFFULLY ---------");
		return;}
	System.out.println(" xxxxxxxxxxxxPINGPONGIIOP EXCEPTION FAILED xxxxxxxxxxxxxxxx");}

public Any ping(int count, Any with)
  	throws NoMorePingPongs {
	  	
	Any anyObj = null;
	reportAction("ping", count, with);
	try {
	    if (count > 0) anyObj =  remote.pong(count - 1, with);
	    else anyObj = finalAction(with);}
	catch (NoMorePingPongs e) {
		System.out.println("Ping at " + count  + " caught exception: " + e);
		throw e;}
	return anyObj;}

public Any pong(int count, Any with)
	throws NoMorePingPongs {
		
	Any anyObj = null;	
  	reportAction("pong", count, with);
	try {
		if (count > 0) anyObj = remote.ping(count - 1, with);
		else  anyObj = finalAction(with);}
	catch (NoMorePingPongs e) {
		System.out.println("Pong at " + count + " caught exception: " + e);
		throw e;}
	return anyObj;}

private void reportAction (String action, int count, Any value) {
	
	System.out.println (action + " count: " + count + " with: " + 
		value.extract_string() + " running in: " + 
		Thread.currentThread().toString());}

public void setRemote(IPingPongIiopExceptional remote) {
	
	this.remote = remote;}	  

public Any start (int count, Any with)
  	throws NoMorePingPongs {
	  	
	Any anyObj = null;
	try {
  		reportAction("start", count, with);
		anyObj = remote.pong(count - 1, with);}
	catch (NoMorePingPongs e) {
		System.out.println("Start caught exception: " + e);
		throw e;}
	return anyObj;}

}