#include <string.h>
#include "esuser.h"

EsObject sampleCStringToString PROTOTYPE((EsVMContext EsPrimVMContext,	char * str));

EsUserPrimitive(add2Numbers)
{
	I_32 i1;
	I_32 i2;
	U_32 rc;
	EsObject retVal;

	rc = EsIntegerToI32(EsPrimArgument(1), &i1);
	if (rc != EsPrimErrNoError)
		EsPrimFail(rc, 1);
	rc = EsIntegerToI32(EsPrimArgument(2), &i2);
	if (rc != EsPrimErrNoError)
		EsPrimFail(rc, 2);
	rc = EsI32ToInteger(i1 + i2, &retVal);
	if (rc != EsPrimErrNoError)
		EsPrimFail(rc, EsPrimArgNumNoArg);
	EsPrimSucceed(retVal);
}


EsUserPrimitive(exampleMakeAString)
{
	EsObject result;

	result = sampleCStringToString(EsPrimVMContext, "This is a C string");
	if (result == (EsObject) NULL)
		EsPrimFail(EsPrimErrNotEnoughMemory, EsPrimArgNumNoArg);
	EsPrimSucceed(result);
}


#ifdef USE_PROTOTYPES
EsObject sampleCStringToString(EsVMContext EsPrimVMContext,	char * str)
#else
EsObject sampleCStringToString(EsPrimVMContext, str)
	EsVMContext EsPrimVMContext;
	U_8 * str;
#endif
{
	EsObject result;
	U_32 i, size;

	size = strlen(str);
	result =
		EsAllocateObject(
			EsPrimVMContext,
			EsPrimClassString,
			size,
			0, (EsObject **) NULL);
	if (result != (EsObject) NULL)
		for (i = 0; i < size; ++i)
			EsByteAtPut(result, i + 1, (U_8) str[i]);
	return result;
}


#ifdef LINKED_USER_PRIMITIVES
EsDefinePrimitiveTable(samplePrimitiveTable)
	EsPrimitiveTableEntry("add2Numbers", add2Numbers)
	EsPrimitiveTableEntry("exampleMakeAString", exampleMakeAString)
EsEndPrimitiveTable
#endif

