#------------------------------------------------------------------
# abtwsi make file for OS/2 (VA C++; version 3.5)
#------------------------------------------------------------------
#
# Add the element $(MEMDEBUG) to the COPTS to enable memory debugging
MEMDEBUG = /Tm /DMEM_DEBUG
#
#  Add /Ti for debug mode; use /O for optimization
COPTS = /C /Ms /W3 /q /Sm /Ss /Gm+ /Gd- /DOPSYS_OS2 /O
#
#  Use /Debug for debugging
LOPTS = /PM:VIO /NOLOGO
#
LIBS = os2386.lib
#
ALL: abtwsc.dll abtwstt.dll abtwsac.exe abtwsai.dll
#
#------------------------------------------------------------------
# Core Functions DLL
#------------------------------------------------------------------

obj/abtwsc.obj: ..\source\abtwsc.c \
   {..\source\;$(INCLUDE);}abtwscos.h \
   {..\source\;$(INCLUDE);}abtwsi.h
    icc.exe $(COPTS) /Ge- /Foobj\abtwsc.obj ..\source\abtwsc.c

obj/abtwscos.obj: ..\source\abtwscos.c \
    {..\source\;$(INCLUDE);}abtwscos.h \
    {..\source\;$(INCLUDE);}abtwsi.h
    icc.exe $(COPTS) /Ge- /Foobj\abtwscos.obj ..\source\abtwscos.c

obj/abtwsc.lib: abtwsc.def
    implib.exe obj/abtwsc.lib abtwsc.def

abtwsc.dll: obj/abtwsc.obj obj/abtwscos.obj abtwsc.def
    ilink.exe @<<
     $(LOPTS) /DLL
     abtwsc.def
     obj/abtwsc.obj
     obj/abtwscos.obj
     $(LIBS)
<<

#------------------------------------------------------------------
# Base TCP/IP Transport Functions DLL
#------------------------------------------------------------------

obj/abtwstt.obj: ..\source\abtwstt.c \
    {..\source\;$(INCLUDE);}abtwstbs.h \
    {..\source\;$(INCLUDE);}abtwsi.h
    icc.exe $(COPTS) /Ge- /Foobj/abtwstt.obj ..\source\abtwstt.c

obj/abtwstbs.obj: ..\source\abtwstbs.c \
    {..\source\;$(INCLUDE);}abtwstbs.h \
    {..\source\;$(INCLUDE);}abtwsi.h
    icc.exe $(COPTS) /Ge- /Foobj/abtwstbs.obj ..\source\abtwstbs.c

obj/abtwstt.lib: abtwstt.def
    implib.exe obj/abtwstt.lib abtwstt.def

abtwstt.dll: obj/abtwstt.obj obj/abtwstbs.obj abtwstt.def obj/abtwsc.lib
    ilink.exe @<<
     $(LOPTS) /DLL
     abtwstt.def
     obj/abtwstt.obj
     obj/abtwstbs.obj
     obj/abtwsc.lib
     so32dll.lib
     tcp32dll.lib
     $(LIBS)
<<

#------------------------------------------------------------------
# CGI Executable
#------------------------------------------------------------------

obj/abtwsac.obj: ..\source\abtwsac.c \
    {..\source\;$(INCLUDE);}abtwsi.h
    icc.exe $(COPTS) /Ge+ /Foobj\abtwsac.obj ..\source\abtwsac.c

abtwsac.exe: obj/abtwsac.obj obj/abtwsc.lib
    ilink.exe @<<
      $(LOPTS) /EXEC
      abtwsac.def
      obj/abtwsac.obj
      obj/abtwsc.lib
      so32dll.lib
      tcp32dll.lib
     $(LIBS)
<<

#------------------------------------------------------------------
# IBM ICS Adapter DLL
#------------------------------------------------------------------

obj/abtwsai.obj: ..\source\abtwsai.c \
    {..\source\;$(INCLUDE);}abtwsi.h
    icc.exe $(COPTS) /Ge- /Foobj\abtwsai.obj ..\source\abtwsai.c

obj/abtwsai.lib: abtwsai.def
    implib.exe obj/abtwsai.lib abtwsai.def

abtwsai.dll: obj/abtwsai.obj abtwsai.def obj/abtwsc.lib
    ilink.exe @<<
     $(LOPTS) /DLL
     abtwsai.def
     obj/abtwsai.obj
     obj/abtwsc.lib
     httpdapi.lib
     $(LIBS)
<<

#------------------------------------------------------------------
