/*
   (C) Copyright International Business Machines Corp. 1994, 2005.  All rights reserved.
   US Government Users Restricted Rights - Use, duplication or disclosure restricted by
   GSA ADP Schedule Contract with IBM Corp.

    File generated: (5/23/2005 3:46:40 PM)
*/

#ifndef ES_H
#define ES_H


#define EsVersionMajor 4
#define EsVersionMinor 00
#define EsExtraVersionString ""
#define EsBuildVersionString "5/23/2005"
#define EsProductNameString "VisualAge Smalltalk Enterprise"
#define EsProductVersionString "Version 6.0.2"
#define EsProductStatusString ""
#define EsProductCopyright "(C) Copyright International Business Machines Corp. 1994, 2005.  All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by\nGSA ADP Schedule Contract with IBM Corp."

typedef struct ESObjectHeader {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
} ESObjectHeader;


#define OBJECT_HEADER_SWAPPER_MARK_BIT  2048
#define OBJECT_HEADER_SHAPE_CHARACTERS  32768
#define OBJECT_HEADER_SHAPE_MASK  6
#define OBJECT_HEADER_SPACE_ROM  248
#define OBJECT_HEADER_OLD  32768
#define OBJECT_HEADER_INDEXABLE  1
#define OBJECT_HEADER_ROM  2147483648
#define OBJECT_HEADER_AGE_TENURE_DEFAULT  80
#define OBJECT_HEADER_SHAPE_POINTERS  0
#define OBJECT_HEADER_MARKED  1
#define OBJECT_HEADER_AGE_MASK  248
#define OBJECT_HEADER_SHAPE_BYTES  2
#define OBJECT_HEADER_SHAPE_LONGS  6
#define OBJECT_HEADER_REMEMBERED  16384
#define OBJECT_HEADER_HASH_MASK  2147418112
#define OBJECT_HEADER_COPIED_WEAKLY  2
#define OBJECT_HEADER_FORWARDED  1
#define OBJECT_HEADER_AGE_SHIFT  3
#define OBJECT_HEADER_FIXED  4096
#define OBJECT_HEADER_WEAK  8192
#define OBJECT_HEADER_SHAPE_WORDS  4
#define OBJECT_HEADER_AGE_INCREMENT  8
#define OBJECT_HEADER_FLAGS_SAVE_MASK  4294901760

typedef struct ESIndexableObjectHeader {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
    ESObjectHeader  *contents[1];
} ESIndexableObjectHeader;


typedef struct ESByteArray {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
    U_8  contents[1];
} ESByteArray;


typedef struct ESPool {
    U_32 elementSize;
    U_16 alignment;
    U_16 flags;
    U_32 numberOfElements;
    U_32 usedElements;
    void* firstElementAddress;
    U_32* firstFreeSlot;
    struct ESPool* nextPool;
} ESPool;


struct EsMappedFileHandle; /* Forward struct declaration */
typedef struct ESMemorySegment {
    U_32 type;
    U_32 size;
    U_8* baseAddress;
    U_8* heapBase;
    U_8* heapTop;
    U_8* heapAlloc;
    U_8* heapScan;
    U_8* heapFreeHead;
    U_8* heapFreeTail;
    U_8* rememberedBase;
    U_8* rememberedTop;
    struct ESMemorySegment* nextSegment;
    U_32 timeStamp;
    struct ESMemoryComponent* component;
    U_32 dataOffset;
    U_32 segmentId;
    struct EsMappedFileHandle* mappedFileHandle;
    U_8* objectPointer;
} ESMemorySegment;


#define MEMORY_TYPE_OLD  1
#define MEMORY_TYPE_NEW_RAM  10
#define MEMORY_TYPE_ALLOCATED  512
#define MEMORY_TYPE_VMEM_FREE  256
#define MEMORY_TYPE_MASK  983168
#define MEMORY_TYPE_NEW  2
#define MEMORY_TYPE_APPLICATIONS  786432
#define MEMORY_TYPE_DYNAMICINFO  65536
#define MEMORY_TYPE_DISCARDABLE  4096
#define MEMORY_TYPE_SNAPSHOT  393216
#define MEMORY_TYPE_ATOMS  524288
#define MEMORY_TYPE_ASSOCIATIONS  655360
#define MEMORY_TYPE_OLD_ROM  5
#define MEMORY_TYPE_METHODS  128
#define MEMORY_TYPE_COMPRESSABLE  2048
#define MEMORY_TYPE_ATOMTABLE  458752
#define MEMORY_TYPE_SYMBOLS  196608
#define MEMORY_TYPE_CATEGORIES  720896
#define MEMORY_TYPE_DELETE  32768
#define MEMORY_TYPE_RAM  8
#define MEMORY_TYPE_FIXED  16
#define MEMORY_TYPE_RS  16384
#define MEMORY_TYPE_COMBINE  32768
#define MEMORY_TYPE_FIXED_RAM  24
#define MEMORY_TYPE_USER  32
#define MEMORY_TYPE_RELOCATED_ROM  1024
#define MEMORY_TYPE_CLASSES  589824
#define MEMORY_TYPE_OLD_RAM  9
#define MEMORY_TYPE_CLEAR_ON_LOAD  9984
#define MEMORY_TYPE_SYMBOLTABLE  131072
#define MEMORY_TYPE_CMINFO  262144
#define MEMORY_TYPE_CODE  64
#define MEMORY_TYPE_ROM  4
#define MEMORY_TYPE_FILEPOINTERS  327680
#define MEMORY_TYPE_FIXEDSIZE  8192

typedef struct ESDiskMemorySegment {
    U_32 type;
    U_32 size;
    U_8* baseAddress;
    U_8* heapBase;
    U_8* heapTop;
    U_8* heapAlloc;
    U_8* heapScan;
    struct ESObjectHeader* unused1;
    struct ESObjectHeader* unused2;
    U_8* rememberedBase;
    U_8* rememberedTop;
    struct ESObjectHeader* unused3;
    U_32 timeStamp;
    struct ESObjectHeader* unused4;
    U_8* objectPointer;
    U_32 segmentId;
} ESDiskMemorySegment;


typedef struct ESMemorySegmentList {
    struct ESPool* segmentPool;
    struct ESMemorySegment* nextSegment;
    struct ESMemorySegment* methodSegments;
} ESMemorySegmentList;


typedef struct ESImageFormat {
    U_32 magic;
    U_32 version;
    U_32 machineFormat;
    U_32 startOfDataOffset;
    U_32 vmContextCount;
    U_32 memorySegmentCount;
    U_32 flags;
    U_32 timeStamp;
} ESImageFormat;


#define IMAGE_flagsImage  32
#define IMAGE_flagsOptimalSaveFormat  256
#define IMAGE_flagsRomOnly  16
#define IMAGE_flagsRelocated  64
#define IMAGE_flagsReadFromBuffer  1024
#define IMAGE_flagsEBCDIC  1
#define IMAGE_flagsBigEndian  4
#define IMAGE_magic  1330923802
#define IMAGE_flagsDelete  512
#define IMAGE_flagsRead  8
#define IMAGE_flagsSearched  128
#define IMAGE_flagsFloat370  2

typedef struct ESVMStats {
    U_32 cacheHits;
    U_32 cacheMisses;
    U_32 numberOfScavenges;
    U_32 numberOfGGCs;
    U_32 totalTimeForScavenges;
    U_32 totalTimeForGGC;
    U_32 timeForLastScavenge;
    U_32 timeForLastGGC;
    U_32 bytesFlipped;
    U_32 bytesTenured;
    U_32 gcTenureAge;
    U_32 msToReadAndFixImageHeader;
    U_32 msToReadAndFixDynamicHeader;
    U_32 msToApplySegmentSizeChanges;
    U_32 msToReadMemorySegments;
    U_32 msToAllocMemorySegments;
    U_32 msToInitializeImage;
    U_32 msToRelocateImage;
    U_32 msToRelocateStack;
    U_32 msLastImageSave;
    U_32 msLastTranslation;
    U_32 msForNativeTranslation;
    U_32 methodsTranslated;
    U_32 msToRecomputeLastPC;
    U_32 msToRecomputePCs;
    U_32 recomputedPCs;
    U_32 msLastCodeCacheFlush;
    U_32 msToFlushCodeCaches;
    U_32 codeCacheFlushes;
} ESVMStats;


typedef struct ESProcess {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
    struct ESObjectHeader* returnPoint;
    struct ESObjectHeader* vmState;
    struct ESObjectHeader* stack;
    struct ESObjectHeader* priority;
    struct ESObjectHeader* state;
    struct ESObjectHeader* queue;
    struct ESObjectHeader* debugBP;
    struct ESObjectHeader* switchCount;
    struct ESObjectHeader* errorHandler;
    struct ESObjectHeader* resumeable;
    struct ESObjectHeader* breakBP;
    struct ESObjectHeader* interruptBlocks;
    struct ESObjectHeader* attributes;
    struct ESObjectHeader* terminateBlock;
    struct ESObjectHeader* processName;
    struct ESObjectHeader* blockingObject;
} ESProcess;


typedef struct ESAsyncMemoryBlock {
    struct ESObjectHeader** start;
    struct ESObjectHeader** end;
    struct ESObjectHeader** head;
    struct ESObjectHeader** tail;
} ESAsyncMemoryBlock;


typedef struct ESPrereqSegment {
    U_32 timeStamp;
    struct ESMemoryComponent* component;
    U_32 segmentId;
    U_8* bottom;
    U_8* top;
    struct ESMemorySegment* memorySegment;
    U_32 flags;
    U_32 reserved1;
} ESPrereqSegment;


typedef struct ESPrereqSegmentList {
    U_32 segmentCount;
    struct ESMemoryComponent* component;
    struct ESPrereqSegment* prereqSegments;
} ESPrereqSegmentList;


typedef struct ESComponent {
    char name[256];
    U_32 timeStamp;
    U_32 segmentCount;
    U_32 relocationCount;
    U_32 reserved1;
} ESComponent;


typedef struct ESMemoryComponent {
    char name[256];
    U_32 timeStamp;
    U_32 segmentCount;
    U_32 relocationCount;
    U_32 reserved1;
    U_32 flags;
    U_32 prerequisiteCount;
    struct ESPrereqSegmentList* prereqSegmentList;
    struct ESPrereqSegment* relocationSegments;
    void* relocationList;
    struct ESPool* prereqComponents;
    struct ESIndexableObjectHeader* cmInfo;
    struct ESIndexableObjectHeader* filePointers;
    struct ESObjectHeader* snapshot;
    struct ESMemorySegment* symbols;
    struct ESMemorySegment* symbolTable;
    struct ESMemorySegment* atoms;
    struct ESMemorySegment* atomTable;
    U_32 segmentTimeStamp;
    U_32 prereqCrc;
    I_32 fileId;
} ESMemoryComponent;


typedef struct ESCacheSlot {
    struct ESObjectHeader* class;
    struct ESObjectHeader* method;
    struct ESObjectHeader* selector;
    struct ESObjectHeader* startAddress;
} ESCacheSlot;


struct EsPlatformGlobalsStruct; /* Forward struct declaration */
struct EsDebugStruct; /* Forward struct declaration */
struct ESOSThreadInfo; /* Forward struct declaration */
struct EsMappedFileHandle; /* Forward struct declaration */
typedef struct ESGlobalInfo {
    U_32 asyncFlags;
    struct ESAsyncMemoryBlock* asyncObjects;
    struct ESAsyncMemoryBlock* asyncMessages;
    struct ESVMStats* vmStats;
    U_32 globalFlags;
    U_32 entryAndDefer;
    U_32 currentVMContext;
    U_32 imageGlobals;
    U_32 imageInfo;
    U_32 imagePrimitives;
    U_32 floatTemp1;
    U_32 floatTemp2;
    U_32 floatTemp3;
    U_32 floatTemp4;
    U_32 win16VMContext;
    U_32 threadSyncStruct;
    U_32 osThreadInfo;
    U_32 rsMutex;
    struct ESPool* componentList;
    struct ESMemorySegmentList* memorySegments;
    U_32 userField;
    U_32* gpRecovery;
    U_32* gpStorage;
    struct ESObjectHeader* saveAndDisableMutex;
    char* imageName;
    I_32 newSpaceSize;
    I_32 fixedSpaceSize;
    I_32 oldSpaceSize;
    I_32 allocationIncrement;
    I_32 lowMinimum;
    I_32 memoryMax;
    I_32 allowMergedSpaces;
    I_32 codeCacheSize;
    U_32 carry;
    U_32 overflow;
    U_32 minus;
    U_32 esArgc;
    char** esArgv;
    struct ESObjectHeader* delayReceiver;
    struct ESObjectHeader* delaySelector;
    struct EsPlatformGlobalsStruct* EsPlatformGlobals;
    struct EsDebugStruct* debugStruct;
    U_8* contextBlocks;
    U_32 memoryOption;
    struct ESOSThreadInfo* freeOSThreadInfoList;
    U_8* OSThreadInfoBlocks;
    U_32* globalMutex;
    void* sleepSemaphore;
    void* EsCBScavengeStart;
    void* EsCBScavengeEnd;
    void* EsCBGGCStart;
    void* EsCBGGCEnd;
    void* EsCBAsyncPosted;
    struct ESMemorySegmentList* loadedSegments;
    void* startupMutex;
    void* vmSleepStruct;
    struct ESMemorySegment* symbolTables;
    struct ESMemorySegment* atomTables;
    U_32 mergeSegmentsOnImageSave;
    struct EsMappedFileHandle* fixedBaseAddrHandle;
    char* imagePath;
    U_32 vmInstrument;
    void* vmInstrumentData;
    void* iniKeyNames;
    char* branchMap;
    struct ESMemoryComponent* baseComponent;
    struct ESIndexableObjectHeader* dynamicComponentInfo;
    U_32 runtimeFlags;
    I_32 fixedAllocationIncrement;
    char* defaultImageName;
    void* splashDialogHandle;
    void* splashStatusLineHandle;
    U_32 messageLevel;
    void* gcControls;
    char* iniName;
    U_32 copyOnWrap;
    I_32 tenureFailedCount;
    I_32 tenureFailedGCCount;
    struct ESCacheSlot tempCacheSlot;
} ESGlobalInfo;


#define ESVM_MSG_LEVEL_RESERVED  1
#define ESVM_MSG_LEVEL_INFO  5
#define ESVM_MSG_LEVEL_NONE  0
#define ESVM_MSG_LEVEL_DEBUG  6

typedef struct ESDiskVMContext {
    struct ESObjectHeader* classUndefinedObject;
    struct ESObjectHeader* classTrue;
    struct ESObjectHeader* classFalse;
    U_32 sendReturn;
    struct ESObjectHeader* classSmallInteger;
    struct ESObjectHeader* classCharacter;
    struct ESObjectHeader* unused07;
    struct ESObjectHeader* classPointer;
    struct ESVMStack* stackObject;
    U_32* stackOverflowMark;
    struct ESObjectHeader** sp;
    struct ESObjectHeader** bp;
    U_8* pc;
    struct ESObjectHeader* literals;
    struct ESVMRegistry* registry;
    struct ESObjectHeader* unused16;
    struct ESObjectHeader* unused17;
    struct ESObjectHeader* unused18;
    struct ESObjectHeader* unused19;
    struct ESObjectHeader* unused20;
    struct ESObjectHeader* unused21;
    struct ESObjectHeader* unused22;
    struct ESObjectHeader* unused23;
    struct ESProcess* process;
    U_32* stackOverflowMark2;
    U_32 processInfo;
    struct ESObjectHeader* unused27;
    struct ESObjectHeader* unused28;
    struct ESObjectHeader* unused29;
    struct ESObjectHeader* unused30;
    struct ESObjectHeader* unused31;
    struct ESObjectHeader* unused32;
} ESDiskVMContext;


typedef struct ESVMContext {
    struct ESObjectHeader* classUndefinedObject;
    struct ESObjectHeader* classTrue;
    struct ESObjectHeader* classFalse;
    struct ESVMContext* linkNext;
    struct ESObjectHeader* classSmallInteger;
    struct ESObjectHeader* classCharacter;
    struct ESVMContext* linkPrevious;
    struct ESObjectHeader* classPointer;
    struct ESVMStack* stackObject;
    U_32* stackOverflowMark;
    struct ESObjectHeader** sp;
    struct ESObjectHeader** bp;
    U_8* pc;
    struct ESObjectHeader* literals;
    struct ESVMRegistry* registry;
    U_8* cache;
    U_32 errorCode;
    U_32 argNumber;
    U_32 floatError;
    struct ESMemorySegment* allocateSegment;
    struct ESMemorySegment* survivorSegment;
    struct ESMemorySegment* tenureSegment;
    struct ESCacheSlot* tempCacheSlot;
    struct ESProcess* process;
    U_32* stackOverflowMark2;
    U_32 processInfo;
    struct ESGlobalInfo* globalInfo;
    U_32 win16Address;
    struct ESMemorySegment* nativeCodeCache;
    U_32 sendReturn;
    U_32 osThreadInfo;
    U_32 tempSlot;
    struct ESObjectHeader* otherLiterals;
    U_32 otherPC;
    U_32 unwinding;
    U_32 unwindPC;
    U_32* unwindBP;
    struct ESObjectHeader* unwindObject;
    void* jniEnv;
} ESVMContext;


typedef struct ESVMStack {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
    ESObjectHeader  *contents[1];
} ESVMStack;


typedef struct ESVMAssoc {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
    struct ESObjectHeader* key;
    struct ESObjectHeader* value;
    ESObjectHeader  *contents[1];
} ESVMAssoc;


typedef struct ESVMRegistry {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
    struct ESObjectHeader* doesNotUnderstandSelector;
    struct ESObjectHeader* stackOverflowSelector;
    struct ESObjectHeader* mustBeBooleanSelector;
    struct ESObjectHeader* attemptedROMStoreSelector;
    struct ESObjectHeader* sendSelectorWithArgumentsTo;
    struct ESObjectHeader* startUpObject;
    struct ESObjectHeader* startUpSelector;
    struct ESVMAssoc* arrayClassAssoc;
    struct ESVMAssoc* stringClassAssoc;
    struct ESVMAssoc* symbolClassAssoc;
    struct ESVMAssoc* blockContextClassAssoc;
    struct ESVMAssoc* methodContextClassAssoc;
    struct ESVMAssoc* messageClassAssoc;
    struct ESVMAssoc* byteCodeArrayClassAssoc;
    struct ESVMAssoc* largeIntegerClassAssoc;
    struct ESVMAssoc* floatClassAssoc;
    struct ESObjectHeader* debugBytecodeMask;
    struct ESObjectHeader* cannotReturnSelector;
    struct ESObjectHeader* nmiSelector;
    struct ESObjectHeader* asyncQueueOverrunSelector;
    struct ESVMAssoc* asyncQueueAssoc;
    struct ESObjectHeader* debugInterruptSelector;
    struct ESObjectHeader* debugNotSupportedSelector;
    struct ESObjectHeader* terminateSelector;
    struct ESObjectHeader* badArgCountSelector;
    struct ESVMAssoc* blockContextTemplateClassAssoc;
    struct ESVMAssoc* sharedLibrariesAssoc;
    struct ESVMAssoc* pointClassAssoc;
    struct ESVMAssoc* byteArrayClassAssoc;
    struct ESVMAssoc* metaclassClassAssoc;
    struct ESVMAssoc* processorAssoc;
    struct ESObjectHeader* yieldSelector;
    struct ESObjectHeader* runningSelector;
    struct ESVMAssoc* currentCollateArrayAssoc;
    struct ESObjectHeader* specialSelectors;
    struct ESVMAssoc* platformFunctionClassAssoc;
    struct ESObjectHeader* weakObjectNotifyQueue;
    struct ESObjectHeader* fireInterruptBlocksSelector;
    struct ESObjectHeader* methodEnterSelector;
    struct ESVMAssoc* dbStringClassAssoc;
    struct ESObjectHeader* specialInfo;
    struct ESObjectHeader* gcEventMask;
    struct ESObjectHeader* gcEventReceiver;
    struct ESObjectHeader* gcEventSelector;
    struct ESVMAssoc* compiledMethodClassAssoc;
    struct ESObjectHeader* extraSlot;
    struct ESVMAssoc* platformFlagsAssoc;
    struct ESObjectHeader* finalizeSlotFiller;
    struct ESObjectHeader* unimplementedBytecodeSelector;
    struct ESObjectHeader* debugInfo;
    struct ESObjectHeader* dynamicImageInfo;
    struct ESObjectHeader* associationTable;
    struct ESObjectHeader* profileReceiver;
    struct ESObjectHeader* profileSelector;
    struct ESObjectHeader* breakReceiver;
    struct ESObjectHeader* breakSelector;
    struct ESVMAssoc* esMethodArrayClassAssoc;
    struct ESVMAssoc* esCompactBlockContextTemplateClassAssoc;
    struct ESVMAssoc* esCompactMethodClassAssoc;
    struct ESObjectHeader* backSlashBackslashSelector;
    struct ESObjectHeader* betweenAndSelector;
    struct ESObjectHeader* equalSelector;
    struct ESObjectHeader* greaterEqualSelector;
    struct ESObjectHeader* greaterThanSelector;
    struct ESObjectHeader* lessEqualSelector;
    struct ESObjectHeader* lessThanSelector;
    struct ESObjectHeader* minusSelector;
    struct ESObjectHeader* notSelector;
    struct ESObjectHeader* notEqualSelector;
    struct ESObjectHeader* plusSelector;
    struct ESObjectHeader* slashSlashSelector;
    struct ESObjectHeader* timesSelector;
    struct ESObjectHeader* symbolTable;
    struct ESObjectHeader* atomTable;
    struct ESVMAssoc* esEntryPointClassAssoc;
    struct ESObjectHeader* unused1;
    struct ESVMAssoc* entryPointArray;
    struct ESObjectHeader* emptyArray;
    struct ESObjectHeader* asInt8Selector;
    struct ESObjectHeader* asInt16Selector;
    struct ESObjectHeader* asInt32Selector;
    struct ESObjectHeader* asInt64Selector;
    struct ESObjectHeader* unhandledExceptionSelector;
    struct ESObjectHeader* javaExitSelector;
    struct ESVMAssoc* classClassAssoc;
    struct ESObjectHeader* snapshotID;
    struct ESObjectHeader* javaSyncExitSelector;
    struct ESObjectHeader* defaultExecutionContext;
    struct ESObjectHeader* deletedObject;
    ESObjectHeader  *contents[1];
} ESVMRegistry;


typedef struct ESBehavior {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
    struct ESObjectHeader* specialMethods;
    struct ESBehavior* superclass;
    struct ESObjectHeader* methodsArray;
    struct ESObjectHeader* namedInstVarSize;
    struct ESObjectHeader* instanceShape;
    struct ESObjectHeader* instanceLink;
    struct ESObjectHeader* classLink;
    struct ESObjectHeader* methodDictionary;
    struct ESObjectHeader* subclasses;
} ESBehavior;


typedef struct ESClass {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
    struct ESObjectHeader* specialMethods;
    struct ESClass* superclass;
    struct ESObjectHeader* methodsArray;
    struct ESObjectHeader* namedInstVarSize;
    struct ESObjectHeader* instanceShape;
    struct ESObjectHeader* instanceLink;
    struct ESObjectHeader* classLink;
    struct ESObjectHeader* methodDictionary;
    struct ESObjectHeader* subclasses;
    struct ESObjectHeader* instVarNames;
    struct ESObjectHeader* description;
    struct ESByteArray* name;
    struct ESObjectHeader* classPool;
    struct ESObjectHeader* sharedPoolNames;
} ESClass;


typedef struct ESMetaclass {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
    struct ESObjectHeader* specialMethods;
    struct ESMetaclass* superclass;
    struct ESObjectHeader* methodsArray;
    struct ESObjectHeader* namedInstVarSize;
    struct ESObjectHeader* instanceShape;
    struct ESObjectHeader* instanceLink;
    struct ESObjectHeader* classLink;
    struct ESObjectHeader* methodDictionary;
    struct ESObjectHeader* subclasses;
    struct ESObjectHeader* instVarNames;
    struct ESObjectHeader* description;
    struct ESClass* primaryInstance;
} ESMetaclass;


typedef struct ESCompiledMethod {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
    struct ESObjectHeader* bytecodes;
    struct ESObjectHeader* startPC;
    struct ESObjectHeader* methodClass;
    struct ESByteArray* selector;
    ESObjectHeader  *contents[1];
} ESCompiledMethod;


typedef struct ESEsCompactMethod {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
    struct ESObjectHeader* bytecodes;
    struct ESObjectHeader* startPC;
    struct ESObjectHeader* methodClass;
    struct ESByteArray* selector;
    ESObjectHeader  *contents[1];
} ESEsCompactMethod;


typedef struct ESBlockContextTemplate {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
    struct ESObjectHeader* methodContext;
    struct ESObjectHeader* parent;
    struct ESObjectHeader* startPC;
    struct ESObjectHeader* argsAndTemps;
    struct ESObjectHeader* nativeStartPC;
} ESBlockContextTemplate;


typedef struct ESEsCompactBlockContextTemplate {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
    struct ESObjectHeader* methodContext;
    struct ESObjectHeader* parent;
    struct ESObjectHeader* startPC;
    struct ESObjectHeader* argsAndTemps;
    struct ESObjectHeader* nativeStartPC;
    struct ESObjectHeader* memorySegment;
} ESEsCompactBlockContextTemplate;


typedef struct ESMethodContext {
    struct ESObjectHeader* class;
    U_32 flags;
    U_32 size;
    struct ESObjectHeader* methodContext;
    struct ESObjectHeader* receiver;
    struct ESObjectHeader* method;
    struct ESObjectHeader* bp;
    struct ESObjectHeader* creatingProcess;
    ESObjectHeader  *contents[1];
} ESMethodContext;


typedef struct ESTime {
    U_32 hours;
    U_32 minutes;
    U_32 seconds;
    U_32 milliseconds;
} ESTime;


typedef struct ESDate {
    U_32 year;
    U_32 month;
    U_32 day;
} ESDate;


typedef struct ESOSThreadInfo {
    struct ESOSThreadInfo* linkNext;
    struct ESOSThreadInfo* linkPrevious;
    U_8* cache;
    struct ESGlobalInfo* globalInfo;
} ESOSThreadInfo;


#endif /* ES_H */
