
package com.ibm.sst.examples.rmi;


import java.rmi.*;

public class PingPong extends java.rmi.server.UnicastRemoteObject 
	implements IPingPong {
	
	public IPingPong remote;


public PingPong () throws RemoteException {

	super();}

public PingPong (IPingPong remote) throws RemoteException {

	super();
	this.remote = remote;}

protected Object finalAction (Object value) throws java.rmi.RemoteException {
	
	System.out.println ("No more ping-pongs to go; I have the ball");
	return value;}

public static void main (String args[]) {

	if (args.length != 3) {
		System.out.println("Usage: PingPong <factory name> <times> <message>");
		return;}		
	try {
		PingPong pingPong = new PingPong();
		IPingPongFactory factory = (IPingPongFactory)Naming.lookup (args[0]);
  		pingPong.setRemote (factory.createFor (pingPong));
  		pingPong.ping (Integer.parseInt (args[1]), args[2]);}
	catch (Exception e) {
		System.out.println("Exception occurred in PingPong example");
		e.printStackTrace();}
	// Clean up the systems resources such as threads and sockets used for RMI
	finally {System.exit(0);}	
}

public Object ping (int count, Object value) throws java.rmi.RemoteException {
		
	
	reportAction ("Ping", count, value);
	if (count > 0) return remote.pong (count - 1, value);
	return finalAction (value);}

public Object pong (int count, Object value) throws java.rmi.RemoteException {

	reportAction ("Pong", count, value);
	if (count > 0) return remote.ping (count - 1, value);
	return finalAction (value);}

public void reportAction (String action, int count, Object value) {
	
	System.out.print (action + " count: ");
	System.out.print (count);
	System.out.print (" with: " + value.toString());
	System.out.println (" running in: " + Thread.currentThread().toString());}

public void setRemote (IPingPong remote) {
	
	this.remote = remote;
	return;}

}