
package com.ibm.sst.examples.rmi;


import java.rmi.*;
import java.lang.reflect.*;

public class PingPongFactory
	extends java.rmi.server.UnicastRemoteObject 
	implements IPingPongFactory {
	
	private Class pongClass;


public PingPongFactory (Class pongClass) throws RemoteException {

	super ();
	this.pongClass = pongClass;}

public IPingPong createFor (IPingPong remote) throws RemoteException {

	try {
		/* note: we cannot use remote.getClass below since that would return a Stub class and not IPingPong*/
		Class[] constructorParams = {Class.forName("com.ibm.sst.examples.rmi.IPingPong")};
		Object[] constructorArgs = {remote};
		Constructor pongConstructor = pongClass.getConstructor(constructorParams);
		return (IPingPong)pongConstructor.newInstance(constructorArgs);}
	catch (Exception e) {
		e.printStackTrace();
		return null;} }	

public static void main(String args[]) throws Exception {

	if ((args.length < 1) || (args.length > 2)) {
		System.out.println("Usage: PingPongFactory <class name of PingPong to produce> [name of factory]");
		return;}				
	try {
		Class pongClass = Class.forName(args[0]);				
		System.setSecurityManager (new RMISecurityManager ());
		String name = args.length == 2 ? args[1] : "pingPongFactory";
		Naming.rebind (name, new PingPongFactory (pongClass));
		System.out.println ("PingPongFactory (" + name + ") up and running...");}
	catch (Exception e) {
		System.out.println ("Start up error " + e.getMessage ());
		e.printStackTrace ();
		System.exit(0);}
	return;}

}