@ECHO OFF
rem *******************************************************************
rem *** %Z% %I% %W% %G% %U% [%H% %T%]
rem *** 10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
rem *** All Rights Reserved
rem *** Licensed Materials - Property of IBM
rem *** US Government Users Restricted Rights - Use, duplication or
rem *** disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
rem *** SOM Toolkit 2.0 - Create a new Emitter.
rem *** class=%1 stem=%2
rem *******************************************************************

if "%2" == "" goto error
echo ------------------    Generating  files     --------------------- 
echo Is SMINCLUDE set?
goto process

rem if EXIST makefile goto backup

:process
if "%1" == "-C++" goto CPPflags
if "%1" == "-c++" goto CPPflags
if "%1" == "-C" goto Cflags
if "%1" == "-c" goto Cflags
set cls=%1
set stem=%2
goto Cprocess

:Cflags
set cls=%2
set stem=%3
goto Cprocess

:CPPflags
set cls=%2
set stem=%3
goto CPPprocess

:Cprocess

echo interface %cls% {}; > %stem%.idl

echo %stem%.idl:
sc -aemitfile=_%stem%.idl -adeffile=%SOMBASE%\include\gen_idl.efw -sgen %stem%.idl
copy _%stem%.idl %stem%.idl > NUL
del _%stem%.idl

echo %stem%.c:
sc -aemitfile=%stem%.c -adeffile=%SOMBASE%\include\gen_c.efw -sgen %stem%.idl

echo emit%stem%.c:
sc -aemitfile=emit%stem%.c -adeffile=%SOMBASE%\include\gen_emit.efw -sgen %stem%.idl

echo Makfile:
SC -aemitfile=makfile -adeffile=%SOMBASE%\include\gen_mw32.efw -sgen %stem%.idl

echo %stem%.efw:
copy %SOMBASE%\include\gen_temp.efw %stem%.efw > NUL

echo emit%stem%.def:
sc -aemitfile=emit%stem%.def -adeffile=gen_def.efw -sgen %stem%.idl
goto end

:CPPprocess
echo interface %cls% {}; > %stem%.idl

echo %stem%.idl:
SC -aemitfile=_%stem%.idl -adeffile=%SOMBASE%\include\gen_idl.efw -sgen %stem%.idl
copy _%stem%.idl %stem%.idl > NUL
del _%stem%.idl

echo %stem%.cpp:
SC -aemitfile=%stem%.cpp -adeffile=%SOMBASE%\include\gen_cpp.efw -sgen %stem%.idl

echo emit%stem%.cpp:
SC -aemitfile=emit%stem%.cpp -adeffile=%SOMBASE%\include\gen_emit.efx -sgen %stem%.idl

echo Makfile:
SC -aemitfile=makfile -adeffile=%SOMBASE%\include\gen_mx32.efw -sgen %stem%.idl

echo %stem%.efw:
copy %SOMBASE%\include\gen_temp.efw %stem%.efw > NUL

echo emit%stem%.def:
sc -aemitfile=emit%stem%.def -adeffile=gen_def.efw -sgen %stem%.idl

goto end

:backup
copy makefile makefile.bak > NUL
del makefile
goto process

:error
echo "usage: newemit [-C | -C++] <className> <stem>"
goto end

:end
