@echo off
rem COMPONENT_NAME: somx
rem
rem ORIGINS: 27
rem
rem
rem 10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
rem All Rights Reserved
rem Licensed Materials - Property of IBM
rem US Government Users Restricted Rights - Use, duplication or
rem disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
@REM %Z% %I% %W% %G% %U% [%H% %T%] 

rem Batch file to convert to explicit stars for interface references.
rem If you intend to program with SOM using the C bindings, you
rem need to select one of the two possible forms of C bindings:
rem the strict CORBA-compliant form in which '*'s are NOT exposed
rem in object references, or the C++ form in which '*'s are visible 
rem in object references.  This second form is more appropriate if 
rem you plan to move your class implementations from C to C++ at 
rem some future point.  This choice will determine how object 
rem references will appear in all of your C programs.  For example, 
rem to declare a reference to an instance of class Foo, you would code 
rem either
rem 
rem    Foo afoo;    /* Strict CORBA compliant form */
rem
rem or
rem 
rem    Foo *afoo;   /* C++ migration or OIDL-compatible form */
rem 
rem Depending on your choice of coding style, you must run either
rem the 'somcorba' command (for the CORBA compliant form) or the
rem 'somstars' command (for the C++ form).  These commands will 
rem generate an appropriate set of C header files for the classes 
rem in the SOMobjects toolkit.  If you decide to use 'somstars', 
rem you should also set the SMADDSTAR variable in your local 
rem environment.  All subsequent use of the SOM Compiler depends 
rem on this environment variable to indicate the use of the 
rem 'somstars' style.  For example,
rem 
rem     set SMADDSTAR=1
rem 
rem If you later decide to switch from one coding style to the
rem other, any C code that you have already written will then
rem need to be converted (by you) to the other form.  Also, if
rem switching from the 'somstars' style to the 'somcorba' style,
rem the SMADDSTAR variable must be removed from your environment.
rem Note that all of the sample C programs provided with the
rem toolkit assume the use of the CORBA-compliant coding style
rem (somcorba).

rem SETLOCAL
IF "%SOMBASE%"=="" GOTO sombase
IF "%SC%"=="" GOTO somsc

rem IF "%SOMDRIVE%"=="" GOTO body
rem %SOMDRIVE%

:body
REM IF SMBINDINGS is already set, use it as the destination directory.
if  "%SMBINDINGS%"=="" goto else1
    set SOMDEST=%SMBINDINGS%
    goto endif1
:else1
set SOMDEST=%SOMBASE%\include
:endif1

REM On Windows 95, we can't use exist to test a directory
REM That's why we need this work-around.
echo Looking for destination directory %SOMDEST%
md %SOMDEST%
echo test > %SOMDEST%\somtmp.tmp
if not exist %SOMDEST%\somtmp.tmp goto nodest
del %SOMDEST%\somtmp.tmp

IF NOT EXIST %SOMBASE%\include\som.hc GOTO drive

echo Generating the SOM C Bindings:
echo (Warning, these bindings are not CORBA-compliant)
rem CD %SOMBASE%\include
IF EXIST %SOMDEST%\somcorba.bld DEL %SOMDEST%\somcorba.bld
if EXIST %SOMDEST%\som.h ATTRIB -R %SOMDEST%\som.h
if EXIST %SOMDEST%\gen_c.efw ATTRIB -R %SOMDEST%\gen_c.efw
COPY %SOMBASE%\include\som.hs       %SOMDEST%\som.h > NUL
COPY %SOMBASE%\include\gen_c.efs    %SOMDEST%\gen_c.efw  > NUL
SET SMNOADDSTAR=
%SC% -%% -maddstar -sh -D_WIN32 -d %SOMDEST% %SOMBASE%\include\*.idl
IF NOT ERRORLEVEL 0 GOTO end
IF EXIST %SOMBASE%\include\somdtype.idl %SC% -maddstar -sh -D_WIN32 -DEMIT_SOMDTYPES -d %SOMDEST% %SOMBASE%\include\somdtype.idl
echo somstars.bld > %SOMDEST%\somstars.bld
GOTO end

:sombase
    ECHO SOMBASE should be set before running somstars.
    GOTO end

:somsc
    ECHO SC should be set before running somstars.
    GOTO end

:drive
rem     ECHO SOM is not installed on the current drive, please set SOMDRIVE.
    echo Can't find *.idl files. Please check SOMBASE.
    GOTO end

:nodest
   echo Can't create/find destination directory %SOMDEST%

:end
    rem ENDLOCAL
