/****************************************************************************\
 *
 * SOURCE FILE NAME: hmtailor.h
 *
 * DESCRIPTION: This is the public include file for customized menubar. 
 *
 * COPYRIGHT =
 *   COPYRIGHT (C) SINGALAB PTE LTD 1992, 1993
 *   All Rights Reserved
 *
 ****************************************************************************/

/*************************************************************************/
/* Constants and Macro for customizing Menu Bar of Help Manager          */
/*************************************************************************/
/* Help ID for Help Manager */
#define IDH_HM_BASE              64000       /* 0xFA00 */

 /* help ID for menu bar items */
#define IDH_HM_SERVICES          (IDH_HM_BASE + 1)
#define IDH_HM_OPTIONS           (IDH_HM_BASE + 10)
#define IDH_HM_HELP              (IDH_HM_BASE + 22)

 /* help ID for search menu pulldown items */
#define IDH_HM_SEARCH            (IDH_HM_BASE + 2)
#define IDH_HM_PRINT             (IDH_HM_BASE + 4)
#define IDH_HM_CLIP_COPY         (IDH_HM_BASE + 7)
#define IDH_HM_CLIP_CF           (IDH_HM_BASE + 8)
#define IDH_HM_CLIP_AF           (IDH_HM_BASE + 9)

 /* help ID for options menu pulldown items */
#define IDH_HM_OPTION_EXPLEVEL   (IDH_HM_BASE + 11)
#define IDH_HM_OPTION_EXPBRANCH  (IDH_HM_BASE + 12)
#define IDH_HM_OPTION_EXPALL     (IDH_HM_BASE + 13)
#define IDH_HM_OPTION_COLBRANCH  (IDH_HM_BASE + 15)
#define IDH_HM_OPTION_COLALL     (IDH_HM_BASE + 14)
#define IDH_HM_TOC               (IDH_HM_BASE + 17)
#define IDH_HM_VIEWPAGES         (IDH_HM_BASE + 16)
#define IDH_HM_PREVIOUS          (IDH_HM_BASE + 18)

 /* help ID for help menu pulldown items */
#define IDH_HM_HELP_INDEX        (IDH_HM_BASE + 26)
#define IDH_HM_GENERAL_HELP      (IDH_HM_BASE + 24)
#define IDH_HM_USING_HELP        (IDH_HM_BASE + 27)
#define IDH_HM_KEYS              (IDH_HM_BASE + 30)
#define IDH_HM_VIEWPORT          (IDH_HM_BASE + 49)
#define IDH_HM_LIBRARY           (IDH_HM_BASE + 50)
#define IDH_HM_INDEX             (IDH_HM_BASE + 94)

/* Menu Bar ID */ 
#define MBID_BASE                32512             /* 0x7F00 */

#define MBID_SERVICES            MBID_BASE 
#define MBID_SEARCH              (MBID_BASE + 1)
#define MBID_PRINT               (MBID_BASE + 2)
#define MBID_NEWWINDOW           (MBID_BASE + 4)
#define MBID_COPY                (MBID_BASE + 5)
#define MBID_COPYTOFILE          (MBID_BASE + 6)
#define MBID_APPENDTOFILE        (MBID_BASE + 7)
#define MBID_CLOSE               (MBID_BASE + 8)

#define MBID_EXPONELEVEL         (MBID_BASE + 9)
#define MBID_EXPBRANCH           (MBID_BASE + 10)
#define MBID_EXPALL              (MBID_BASE + 11)
#define MBID_CLPSEBRANCH         (MBID_BASE + 12)
#define MBID_CLPSEALL            (MBID_BASE + 13)
#define MBID_CONTENTS            (MBID_BASE + 14)
#define MBID_INDEX               (MBID_BASE + 15)
#define MBID_VIEWEDPAGES         (MBID_BASE + 16)
#define MBID_LIBRARIES           (MBID_BASE + 17)
#define MBID_PREVIOUS            (MBID_BASE + 18)

#define MBID_HELPINDEX           (MBID_BASE + 19)
#define MBID_GENERALHELP         (MBID_BASE + 20)
#define MBID_USINGHELP           (MBID_BASE + 21)
#define MBID_KEYSHELP            (MBID_BASE + 22)

#define MBID_OPTIONS             (MBID_BASE + 24) 
#define MBID_HELP                (MBID_BASE + 25)  

#define MBID_USERDEFINED_FIRST   (MBID_BASE + 48)     /* 0x7F30 */
#define MBID_USERDEFINED_LAST    (MBID_BASE + 255)    /* 0x7FFF */
