#ifndef _ICOMPANY_
  #define _ICOMPANY_
/*******************************************************************************
* FILE NAME: icompany.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    ICompany - IBM sample company part.                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/
#ifndef _IVBDEFS__
#include <ivbdefs.h>
#endif

#ifndef _ISTDNTFY_
  #include <istdntfy.hpp>
#endif

#ifndef _ISTRING_
  #include <istring.hpp>
#endif

#ifdef __WINDOWS__
#ifndef _IPTR_H
  #include <iptr.h>
#endif
#endif

#ifndef _IVSEQ_H
  #include <ivseq.h>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOV03I.LIB")
    #else
       #pragma library("CPPOV03.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWV03I.LIB")
    #else
       #pragma library("CPPWV03.LIB")
    #endif
  #endif
#endif

class IAddress;
class ICustomer;
class IVSequence <ICustomer*>;

class ICompany;

typedef IElemPointer<ICompany>
  ICompanyElemPtr;

typedef IMngElemPointer<ICompany>
  ICompanyMngPtr;


/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class ICompany : public IStandardNotifier
{
typedef IStandardNotifier
  Inherited;
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------- Constructors/Destructor ----------------------------
------------------------------------------------------------------------------*/
  ICompany ();
  ICompany (const IString& aName);
  ICompany (const ICompany& partCopy);
virtual
  ~ICompany ();

/*-------------------------------- Operators -----------------------------------
|   operator ==       - Operator == (return true if equal).                    |
|   operator !=       - Operator != (return true if not equal).                |
------------------------------------------------------------------------------*/
  ICompany& operator= (const ICompany& aICompany);
Boolean
  operator == (const ICompany& aValue) const,
  operator != (const ICompany& aValue) const,
  operator == (const ICompany* aValue) const,
  operator != (const ICompany* aValue) const,
  operator < (const ICompany& aValue) const,
  operator < (const ICompany* aValue) const,
  operator < (ICompany* const& aValue) const,
  operator < (ICompanyElemPtr const& aValue) const,
  operator < (ICompanyMngPtr const& aValue) const;

virtual IString
  asString    ( ) const;

/*-------------------------------- Attributes ----------------------------------
| List of query and set members functions for this class:                      |
|                                                                              |
|   name              - Query the name (IString) attribute.                    |
|   address           - Query the address (IAddress*) attribute.               |
|   customerList      - Query the customerList (IVSequence <ICustomer*> *) attribute.             |
|   phone             - Query the phone (IString) attribute.                   |
|   setName           - Set the name (IString) attribute.                      |
|   setAddress        - Set the address (IAddress*) attribute.                 |
|   setCustomerList   - Set the customerList (IVSequence <ICustomer*> *) attribute. |
|   addCustomer                - Perform the add customer action.              |
|   removeCustomer             - Perform the remove customer action.           |
|   setPhone          - Set the phone (IString) attribute.                     |
------------------------------------------------------------------------------*/

virtual IString
  name () const;
virtual ICompany
 &setName (const IString& aName);

virtual IAddress*
  address () const;
virtual ICompany
 &setAddress (IAddress* aAddress),
 &setAddress (const IAddress& aAddress);

virtual IVSequence <ICustomer*> *
  customerList () const;
virtual ICompany
 &setCustomerList (const IVSequence <ICustomer*>& aCustomerList),
 &setCustomerList (IVSequence <ICustomer*>* aCustomerList),
 &addCustomer (ICustomer* customer),
 &addCustomer (const IString& name);

virtual IString
  phone () const;
virtual ICompany
 &setPhone (const IString& aPhone);

/*-------------------------------- Actions -------------------------------------
| List of operations or services provided by this class:                       |
|                                                                              |
|   setNameToDefault  - Perform the setNameToDefault action.                   |
|   setAddressToDefault - Perform the setAddressToDefault action.              |
|   setPhoneToDefault - Perform the setPhoneToDefault action.                  |
|   setCustomerListToDefault - Perform the setCustomerListToDefault action.    |
------------------------------------------------------------------------------*/
virtual ICompany
  &setNameToDefault (),
  &setAddressToDefault (),
  &setPhoneToDefault (),
  &setCustomerListToDefault ();

/*----------------------- Notification Event Descriptions ----------------------
| List of attribute and event notification identifiers:                        |
|                                                                              |
|   nameId            - Notification ID provided to observers when the         |
|                       name attribute changes.                                |
|   addressId         - Notification ID provided to observers when the         |
|                       address attribute changes.                             |
|   customerListId    - Notification ID provided to observers when the         |
|                       customerList attribute changes.                        |
|   phoneId           - Notification ID provided to observers when the         |
|                       phone attribute changes.                               |
|  customerAddedId     - Notification event for when customer added to customer list. |
------------------------------------------------------------------------------*/
static INotificationId const
  IVB_IMPORT nameId,
  IVB_IMPORT addressId,
  IVB_IMPORT customerListId,
  IVB_IMPORT phoneId;

static INotificationId const
  IVB_IMPORT customerAddedId;

private:
/*--------------------------- PRIVATE ----------------------------------------*/
  IString iName;                        //Data member for name attribute
  IAddress* iAddress;                   //Data member for address attribute
  IVSequence <ICustomer*> * iCustomerList; //Data member for customerList attribute
  IString iPhone;                       //Data member for phone attribute
};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
