/********************************************************************************/
/* File:   daxerrno.hpp                                                         */
/* Class:  exception error numbers                                              */
/*                                                                              */
/*                                                                              */
/********************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#ifndef _IDAERRNO_HPP_
#define _IDAERRNO_HPP_

#ifndef DAX_ADD_READONLY              // SOM converts consts to #defines

// Exception used by generated code

const short DAX_ADD_READONLY   =101;  // Add used on a readonly table/view
const short DAX_ADD_SQLERR     =102;  // SQL error occurred on add
const short DAX_UPD_READONLY   =103;  // Update used on a readonly table/view
const short DAX_UPD_SQLERR     =104;  // SQL error occurred on update
const short DAX_DEL_READONLY   =105;  // Delete used ona readonly table/view
const short DAX_DEL_SQLERR     =106;  // SQL error occurred on delete
const short DAX_RET_SQLERR     =107;  // SQL error occurred on retrieve
const short DAX_REF_SQLERR     =108;  // SQL error occurred on refresh
const short DAX_SEL_SQLERR     =109;  // SQL error occurred on select
const short DAX_ADD_NONNULL    =110;  // Add with non-nullable column not mapped
const short DAX_NUL_NONNULL    =111;  // Cannot SetToNull non-nullable column
const short DAX_DFT_READONLY   =112;  // Cannot SetReadOnly to false on a readonly table/view
const short DAX_SYS_LOCK       =113;  // Not used, but keep for backwards compatibility
const short DAX_ADD_NULL_DATAID=114;  // Add with a null DataId
const short DAX_UPD_NULL_DATAID=115;  // Update with a null DataId
const short DAX_RET_NULL_DATAID=116;  // Retrieve with a null DataId
const short DAX_DEL_NULL_DATAID=117;  // Delete with a null DataId
const short DAX_ATTR_INVLEN    =118;  // attribute set to an invalid length
const short DAX_ATTR_INVDATA   =119;  // attribute contains invalid data
const short DAX_RET_NORETRIEVE =120;  // Retrieve not allowed for this object
const short DAX_UPD_MULTROWS   =121;  // Multiple rows affected by update
const short DAX_DEL_MULTROWS   =122;  // Multiple rows affected by delete
const short DAX_OUT_OF_MEMORY  =123;  // Out of memory error

// Error ids used in the class library
const short DAX_MSG_MAX_CONNECTIONS_REACHED            =1209;
        // Maximum number of connections allowed has been reached
const short DAX_MSG_NO_CONNECT_TRANSACT_ACTIVE         =1210;
        // Cannot connect while transaction is active
const short DAX_MSG_MAX_CONNECTIONS_TO_DB_REACHED      =1211;
        // Maximum number of connections to a database has been reached
const short DAX_MSG_CONNECTION_IN_USE                  =1212;
        // The specified connection is already in use
const short DAX_MSG_NO_DISCONNECT_CONNECTION_NOT_FOUND =1213;
        // Could not disconnect because connection is not found
const short DAX_MSG_COMMIT_ERROR                       =1216;
        // An error occurred during the commit
const short DAX_MSG_ROLLBACK_ERROR                     =1217;
        // An error occurred during the rollback
const short DAX_MSG_CONNECT_ERROR                      =1219;
        // An error occurred during the connect
const short DAX_MSG_DISCONNECT_ERROR                   =1221;
        // An error occurred during the disconnect
const short DAX_MSG_CONNECT_NOT_OPEN                   =1222;
        // The specified connection is not open
const short DAX_MSG_LOGON_ERROR                        =1223;
        // An error occurred during a logon attempt
const short DAX_MSG_LOGOFF_ERROR                       =1224;
        // An error occurred during a logoff attempt
const short DAX_MSG_USERID_NOT_SPECIFIED               =1225;
        // UserId was not specified.  The logon could not be completed
const short DAX_MSG_PASSWORD_NOT_SPECIFIED             =1226;
        // Password was not specified.  The logon could not be completed
const short DAX_MSG_INCORRECT_USERID_OR_PASSWORD       =1227;
        // Userid or password provided was incorrect.  The logon could not be completed
const short DAX_MSG_LOGON_IN_PROGRESS                  =1228;
        // A logon is already in progress
const short DAX_MSG_INVALID_REMOTE_TYPE                =1229;
        // Remote type specified to UPM is not valid
const short DAX_MSG_EXECUTE_IMMEDIATE_ERROR            =1243;
        // DB2 embedded SQL excute immediate error
const short DAX_MSG_ONLY_ONE_CONNECTION_ALLOWED        =1244;
        // Only one active embedded SQL connection per application is permitted
const short DAX_MSG_OBJECT_NOT_FOUND_OR_NOT_INSERTED   =1248;
        // An object could not be found or could not be inserted
const short DAX_MSG_OBJECT_NOT_UNIQUE                  =1249;
        // An update or a del action has affected more than one row of the table
const short DAX_MSG_ERROR_IN_SQLERROR                  =1250;
        // An SQL error occurred while obtaining the SQL error information
const short DAX_MSG_ADD_NOT_IMPLEMENTED                =1251;
        // The add method is not implemented for this class
const short DAX_MSG_UPDATE_NOT_IMPLEMENTED             =1252;
        // The update method is not implemented for this class
const short DAX_MSG_DEL_NOT_IMPLEMENTED                =1253;
        // The del method is not implemented for this class
const short DAX_MSG_RETRIEVE_NOT_IMPLEMENTED           =1254;
        // The retrieve method is not implemented for this class
const short DAX_MSG_DEFAULT_READONLY                   =1255;
        // The read-only attribute for a class that is read-only by default cannot be disabled
const short DAX_MSG_RETRIEVEALL_NOT_IMPLEMENTED        =1256;
        // The retrieveAll method is not implmented for this class
const short DAX_MSG_SQLERROR                           =1260;
        // An SQL error occured
const short DAX_MSG_SELECT_NOT_IMPLEMENTED             =1261;
        // The select method is not implemented for this class
const short DAX_MSG_DATASTORE_CONNECTION_NOT_SUPPLIED  =1262;
        // The application has not provided a datastore connection for the
        // object, nor has it specified a default connection for objects of
        // the class
const short DAX_MSG_LOCK_ERROR                         =1263;
        // An operating system error occurred while in a locking call

const short DAX_MSG_UNKNOWN_EXCEPTION_OCCURRED         =1264;
        // An exception that was not an IException occurred
const short DAX_MSG_COMMIT_BIND_ERROR                  =1265;
        // An error occurred during the commit because did not bind class library
const short DAX_MSG_ROLLBACK_BIND_ERROR                =1266;
        // An error occurred during the rollback because did not bind class library

#endif

#endif
