#ifndef _IDAHNDL_HPP_
#define _IDAHNDL_HPP_

/*******************************************************************************
* FILE NAME: idahndl.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*     IDAConectionHandle - Connection Handle                                   *
*     IDAEnvironmentHandle - Environment Handle                                *
*                                                                              *
*******************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#include <istring.hpp>
#include <istdntfy.hpp>
#include <ihandle.hpp>
#include <idaenv.hpp>

#pragma pack(4)

class DAX_IMPORTEXPORT IDAConnectionHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDAConnectionHandle ( Value hdbc = 0 );

}; // class IDAConnectionHandle

class DAX_IMPORTEXPORT IDAEnvironmentHandle : public IHandle {
typedef IHandle
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDAEnvironmentHandle ( Value henv = 0 );

}; // class IDAEnvironmentHandle

#pragma pack()

inline IDAConnectionHandle :: IDAConnectionHandle ( Value hdbc )
  : IHandle( hdbc )
  {
  }

inline IDAEnvironmentHandle :: IDAEnvironmentHandle ( Value henv )
  : IHandle( henv )
  {
  }

#endif /* _IDAHNDL_HPP_ */
