#ifndef _IDAXBS_H_
#define _IDAXBS_H_
/******************************************************************************/
/* FILE NAME: idaxbs.h                                                        */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   This file contains base defines and typedefs                             */
/*                                                                            */
/******************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#define DAX_TRUE        (long)1     // UserEnvironment Option - True
#define DAX_FALSE       (long)0     // UserEnvironment Option - False

/*************  options on IDatastoreConnection *******************/

#define DAX_OPT_ACCESS_MODE              (long)100
  #define DAX_READONLY                     (long)101
  #define DAX_READWRITE                    (long)102

#define DAX_OPT_SHARE_MODE               (long)110
  #define DAX_SHARED                       (long)111
  #define DAX_EXCLUSIVE                    (long)112

#define DAX_OPT_CONNECT_STATE            (long)130
  #define DAX_OPEN                         (long)131
  #define DAX_CLOSED                       (long)132

#define DAX_OPT_AUTOCOMMIT_MODE          (long)134
  #define DAX_AUTOCOMMIT_ON                (long)135
  #define DAX_AUTOCOMMIT_OFF               (long)136

#define DAX_OPT_TRANSACTION_STATE        (long)113
  #define DAX_ACTIVE                       (long)114
  #define DAX_INACTIVE                     (long)115

#define DAX_OPT_TXN_ISOLATION            (long)116
  #define DAX_READ_UNCOMMITTED             (long)117
  #define DAX_READ_COMMITTED               (long)118
  #define DAX_REPEATABLE_READ              (long)119
  #define DAX_SERIALIZABLE                 (long)120
  #define DAX_DATABASE_DEFAULT             (long)121

#define DAX_OPT_DRIVERPROMPT_STATE       (long)140
  #define DAX_DRIVER_PROMPT                (long)141
  #define DAX_DRIVER_COMPLETE              (long)142
  #define DAX_DRIVER_COMPLETE_REQ          (long)143
  #define DAX_DRIVER_NOPROMPT              (long)144

#define DAX_OPT_DRIVER_HWND              (long)145
#define DAX_OPT_DRIVERCONNECT_STR        (long)146
#define DAX_OPT_HENV                     (long)147
#define DAX_OPT_HDBC                     (long)148

#define DAX_OPT_THREAD_CONNECT          (long)150

/*************  options on IUserEnvironment *******************/

#define DAX_OPT_OUTPUT_NTS              (long) 150

/**************************************************************/

#define DAX_COMMIT   1
#define DAX_ROLLBACK 2

/*************  options on IDDOCursor *************************/

#define DAX_ABSOLUTE                (long)200
#define DAX_RELATIVE                (long)201
#define DAX_BEGIN                   (long)202
#define DAX_END                     (long)203
#define DAX_FIRST                   (long)204
#define DAX_LAST                    (long)205
#define DAX_NEXT                    (long)206
#define DAX_PREVIOUS                (long)207

/*************  DDO *******************************************/
#define  DAX_PROPTYPE_TYPE              "type"
#define  DAX_PROPTYPE_SIZE              "size"
#define  DAX_PROPTYPE_TABLE             "table"
#define  DAX_PROPTYPE_NULLABLE          "nullable"

/*************  DO types **************************************/
#define DAX_DDO                         (long)1
#define DAX_PO                          (long)2

/*************  Datastore types *******************************/
#define DAX_DB212                "DB2/2;1.2"
#define DAX_DB221E               "DB2/2E;2.1"
#define DAX_DB2                  "DB2/2;2.1"
#define DAX_ODBC                 "ODBCDEFAULT"

#endif /* _IDAXBS_H_ */



