/********************************************************************************/
/* File:  idsclbsq.inl                                                          */
/* Class: IDSColumnBufferSequence                                               */
/*                                                                              */
/* IDSColumnBufferSequence                                                      */
/********************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#include "idsclbsq.hpp"

/*------------------------------------------------------------------------------
|   bindToStatement - bind all columns in seq to statement                     |
------------------------------------------------------------------------------*/
inline void IDSColumnBufferSequence::bindToStatement(
                                  ISQLStatement* pSqlStatement)
{
  statementInfo info(pSqlStatement);
  allElementsDo (bindColumn, &info);
}

/*------------------------------------------------------------------------------
|   bindColumn  - bind a column to a statement                                 |
------------------------------------------------------------------------------*/
inline Boolean IDSColumnBufferSequence::bindColumn (
                  IPOBufferBase*& pBuffer, void* someInfo)
{
  statementInfo* info = (statementInfo*)someInfo;
  pBuffer->bindToColumn(info->number++, info->sqlStatement);
  return true;
}
