/*******************************************************************************
* FILE NAME: idsconcv.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     IDSConnectCanvas- Connect Panel for IDatastore                           *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IDSCONCV_
#define _IDSCONCV_  

class IDSConnectCanvas;

#include <icanvas.hpp>
#include <iobservr.hpp>
#include <idsmcon.hpp>
#include <irect.hpp>
#include "idsconcv.h"
#include <ivbdefs.h>
class IVBConnectionList;

class IPushButton;
class IEntryField;
class IStaticText;
class ICheckBox;
class IMessageBox;

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

//*****************************************************************************
// Class definition for IDSConnectCanvas
//*****************************************************************************
class IDSConnectCanvas : public ICanvas, public IObserver {
public:
   //---------------------------------------------------------------------------
   // Constructors / destructors
   //---------------------------------------------------------------------------
   IDSConnectCanvas(
      unsigned long id = WND_IDSConnectCanvas,
      IWindow * parent = IWindow::desktopWindow(),
      IWindow * owner = 0,
      const IRectangle & rect = defaultFramingSpec(),
      const ICanvas::Style & style = ICanvas::defaultStyle());

   virtual  ~IDSConnectCanvas();

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   static IRectangle defaultFramingSpec();
   virtual IDSConnectCanvas & initializePart();
   IDSConnectCanvas * getCanvas() { return this; };
   IDatastore *  getDatastore() const { return iDatastore; };

   //---------------------------------------------------------------------------
   // public member data
   //---------------------------------------------------------------------------
   static const INotificationId IVB_IMPORT readyId;
   static const INotificationId IVB_IMPORT datastoreAuthentication;
   static const INotificationId IVB_IMPORT datastoreDatastoreName;
   static const INotificationId IVB_IMPORT datastoreIsConnected;
   static const INotificationId IVB_IMPORT datastoreShareModeExclusive;
   static const INotificationId IVB_IMPORT datastoreConnected;
   static const INotificationId IVB_IMPORT datastoreDisconnected;
   static const INotificationId IVB_IMPORT datastoreTransacted;
   static const INotificationId IVB_IMPORT datastoreUserName;
   static const INotificationId IVB_IMPORT datastore;

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   void makeConnections();
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent);

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IPushButton * iPushButton1;
   IPushButton * iPushButton2;
   IPushButton * iPushButton3;
   IPushButton * iPushButton4;
   IEntryField * iEntryField1;
   IEntryField * iEntryField2;
   IEntryField * iEntryField3;
   IStaticText * iStaticText1;
   IStaticText * iStaticText2;
   IStaticText * iStaticText3;
   ICheckBox * iCheckBox1;
   IMessageBox * iDatastoreMessages;
   IDatastore * iDatastore;
   IVBConnectionList * iIDSConnectCanvasConnectionList;


};   //IDSConnectCanvas


/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
