/********************************************************************************/
/* File:   idsexc.hpp                                                           */
/* Class:  exception classes                                                    */
/*                                                                              */
/*                                                                              */
/********************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#ifndef _IDSEXC_HPP_
#define _IDSEXC_HPP_

#include <ibase.hpp>
#include <iexcbase.hpp>
#include <idaerrno.hpp>
#include <string.h>
#include <istring.hpp>

// Preserved for compatability with release 1.0.
// Emulates the DB2 1.2 sqlca structure.
struct DA_sqlca
{
  long sqlcode; unsigned char sqlstate[5];
  DA_sqlca( long anSQLCODE, char* anSQLSTATE ) : sqlcode(anSQLCODE)
      { memcpy( sqlstate, anSQLSTATE, sizeof(sqlstate) ); }
};


#define IDACLASSDECLARE(child,parent) class _Export child : public parent {\
public:\
  child( const char*, \
         unsigned long b = 0,\
         Severity c = IException::unrecoverable,\
         long anSQLCODE = 0,\
         char* anSQLSTATE = 0);\
  child( const child& ); \
  virtual ~child();\
  virtual const char* name() const;\
}

// parent class for all data access exceptions:
class _Export IDAException : public IException
{
  public:
    IDAException( const char* a,
                  unsigned long b = 0,
                  Severity c = IException::unrecoverable,
                  long anSQLCODE = 0,
                  char* anSQLSTATE = 0 );
    IDAException( const IDAException& );
    IDAException( const IException& );
    IDAException();
    virtual ~IDAException();
    virtual const char* name() const;
    Boolean errorProvided() const;
    // these methods return null if ! errorProvided()
    const char* errorState() const;
    long errorCode() const;
    IString errorAsString() const;
    // for backward compatability only
    struct DA_sqlca getSqlca() const;
  protected:
    long iSQLCODE;
    IString iSQLSTATE;
    IBoolean iErrorProvided;
};

   IDACLASSDECLARE(IDAAdaptorException, IDAException);
      IDACLASSDECLARE(IDAConnectFailed, IDAAdaptorException);
      IDACLASSDECLARE(IDADisconnectError, IDAAdaptorException);
      IDACLASSDECLARE(IDAConnectionInUse, IDAAdaptorException);
      IDACLASSDECLARE(IDAConnectionNotOpen, IDAAdaptorException);

   IDACLASSDECLARE (IDALogonFailed, IDAException);
   IDACLASSDECLARE (IDALogoffFailed, IDAException);

   IDACLASSDECLARE (IDAAccessError, IDAException);
      IDACLASSDECLARE (IDADataObjectNotFound, IDAAccessError);
      IDACLASSDECLARE (IDADataObjectInvalid, IDAAccessError);
      IDACLASSDECLARE (IDADataObjectAlreadyExists, IDAAccessError);

   IDACLASSDECLARE (IDADataObjectAttributeError, IDAException);


// For backward compatibility
typedef IDAException               IDSAccessError;
typedef IDAAdaptorException        IDatastoreAdaptorException;
typedef IDAConnectFailed           IConnectFailed;
typedef IDADisconnectError         IDisconnectError;
typedef IDAConnectionInUse         IDatastoreConnectionInUse;
typedef IDAConnectionNotOpen       IDatastoreConnectionNotOpen;
typedef IDADataObjectNotFound      IDataObjectNotFound;
typedef IDADataObjectAlreadyExists IDataObjectAlreadyExist;
typedef IDALogonFailed             IDatastoreLogonFailed;
typedef IDALogoffFailed            IDatastoreLogoffFailed;
typedef IDAAccessError             IDatastoreAccessError;
typedef IDADataObjectInvalid       IDataObjectInvalid;

#endif
