#ifndef _IDSMCBS_HPP_
#define _IDSMCBS_HPP_

/*******************************************************************************
* FILE NAME: idsmcbs.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*     IDatastoreBase - Manage a datastore connection.                          *
*                                                                              *
*******************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#include <istring.hpp>
#include <istdntfy.hpp>
#include <idaenv.hpp>
#include <idsexc.hpp>

#pragma pack(4)

class DAX_IMPORTEXPORT IDatastoreBase : public IStandardNotifier
{

friend class IDatastore;
friend class IDatastoreDB2;
friend class IDatastoreODBC;
friend class IVBDatastore;
friend class IVBDatastoreDB2;
friend class IVBDatastoreODBC;

public:

virtual ~IDatastoreBase();

virtual IDatastoreBase&
   connect ();

virtual IDatastoreBase&
   connect ( const char* userName,
             const char* authentication);

virtual IDatastoreBase&
   connect ( const char* datastoreName);

virtual IDatastoreBase&
    connect ( const char* datastoreName,
              const char* userName,
              const char* authentication );

virtual IDatastoreBase&
   disconnect ();

virtual IDatastoreBase&
   commit ();

virtual IDatastoreBase&
   rollback ();

virtual Boolean
   isConnected ();

virtual IString
   asString() const;

virtual IString
   datastoreName() const;

virtual IDatastoreBase&
   setDatastoreName(const char* aDatastoreName);

virtual IString
   userName() const;

virtual IDatastoreBase&
   setUserName(const char* aUserName);

virtual IString
   authentication() const;

virtual IDatastoreBase&
   setAuthentication(const char* aAuthentication);

virtual IDatastoreBase&
   executeSQL(const char* aCmd);

static const INotificationId DatastoreNameId;
static const INotificationId UserNameId;
static const INotificationId AuthenticationId;
static const INotificationId isConnectedId;
static const INotificationId connectedId;
static const INotificationId disconnectedId;
static const INotificationId transactedId;
static const INotificationId executedId;

protected:
/*--------------------------------- PROTECTED --------------------------------*/
  IDatastoreBase();
  IDatastoreBase( const char* datastoreName );
  IDatastoreBase( const char* datastoreName,
                  const char* userName,
                  const char* authentication);

private:
/*--------------------------------- PRIVATE ----------------------------------*/

  // notify observers about connect state changes
  void NotifyAboutConnectState ( Boolean ConnectState );
  class IDatastoreMgrPrivateClient* pDatastoreMgrClient;
  class IUserEnvironment* pUserEnvironment;
  class IDatastoreConnection* pDatastoreConnection;
  virtual IString type() = 0;

  IString iDatastoreName;
  IString iUserName;
  IString iAuthentication;
  IString iType;

};

#pragma pack()

#endif /* _IDSMCBS_HPP_ */
