#ifndef _IDSMCDB_HPP_
#define _IDSMCDB_HPP_

/*******************************************************************************
* FILE NAME: idsmcdb.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*     IDatastoreDB2 - Manage a datastore connection.                           *
*                                                                              *
*******************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#include <istring.hpp>
#include <istdntfy.hpp>
#include <ihandle.hpp>
#include <idsexc.hpp>
#include <idsmcbs.hpp>
#include <idahndl.hpp>

#pragma pack(4)

class DAX_IMPORTEXPORT IDatastoreDB2 : public IDatastoreBase
{

friend class ISQLStatementProxy;

public:

  enum AccessMode {readOnly, readWrite};
  enum IsolationLevel {readUncommitted, readCommitted, repeatableRead,
                       serializable, databaseDefault};
  enum DriverPrompt {driverPromptRequest, driverComplete, driverCompleteRequired,
                     noDriverPrompt};


  IDatastoreDB2 ( const char* datastoreName,
                  const char* connectString = "" );

  IDatastoreDB2();

virtual
  ~IDatastoreDB2 ();                                 // Destructor

 virtual IDatastoreDB2&
   connect ();

 virtual IDatastoreDB2& connect ( const char* datastoreName );


 virtual IDatastoreDB2&
   connect ( const char* userName,
             const char* authentication);

 virtual IDatastoreDB2& connect ( const char* datastoreName,
                                  const char* userName,
                                  const char* authentication );

 virtual IDatastoreDB2& connect ( const char* datastoreName,
                                  const char* connectString,
                                  const char* userName,
                                  const char* authentication );

 virtual IDatastoreDB2&
   disconnect ();

 virtual IDatastoreDB2&
   commit ();

 virtual IDatastoreDB2&
   rollback ();

virtual IString
   connectString() const;

 virtual IDatastoreDB2&
   setConnectString(const char* aConnectString);

 virtual IDatastoreDB2&
   setUserName(const char* aUserName);

 virtual IDatastoreDB2&
   setAuthentication(const char* aAuthentication);

virtual IDatastoreDB2&
   setDatastoreName(const char* aDatastoreName);

 virtual IDatastoreDB2&
   executeSQL(const char* aCmd);

 virtual IDatastoreDB2::AccessMode
   accessMode() const;

 virtual IDatastoreDB2&
   setAccessMode(IDatastoreDB2::AccessMode option);

 virtual IBoolean
   isAutoCommit() const;

 virtual IDatastoreDB2&
   enableAutoCommit(IBoolean enable = True);

 virtual IDatastoreDB2::IsolationLevel
   isolationLevel() const;

 virtual IDatastoreDB2&
   setIsolationLevel(IDatastoreDB2::IsolationLevel option);

 virtual IDatastoreDB2::DriverPrompt
    driverPrompt() const;

 virtual IDatastoreDB2&
    setDriverPrompt(IDatastoreDB2::DriverPrompt option, IWindowHandle aHandle = IWindowHandle());

static const INotificationId readyId;
static const INotificationId connectStringId;
static const INotificationId accessModeId;
static const INotificationId autoCommitId;
static const INotificationId isolationLevelId;
static const INotificationId driverPromptId;

  virtual IDatastoreDB2& initializePart();

  IDAEnvironmentHandle environmentHandle();
  IDAConnectionHandle connectionHandle();

protected:
/*--------------------------------- PROTECTED --------------------------------*/
   Boolean makeConnections();

private:
/*--------------------------------- PRIVATE ----------------------------------*/
   IString type();
   IString iConnectString;
   IDatastoreDB2::AccessMode eAccessMode;
   IBoolean eAutoCommit;
   IDatastoreDB2::IsolationLevel eIsolationLevel;
   IDatastoreDB2::DriverPrompt eDriverPrompt;


};

#pragma pack()

#endif /* _IDSMCDB_HPP_ */
