#ifndef _IDSMCOD_HPP_
#define _IDSMCOD_HPP_

/*******************************************************************************
* FILE NAME: idsmcod.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*     IDatastoreODBC - Manage a datastore connection.                          *
*                                                                              *
*******************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#include <istring.hpp>
#include <istdntfy.hpp>
#include <ihandle.hpp>
#include <idsexc.hpp>
#include <idsmcbs.hpp>
#include <ihandle.hpp>
#include <idahndl.hpp>

#pragma pack(4)

class DAX_IMPORTEXPORT IDatastoreODBC : public IDatastoreBase
{

friend class ISQLStatementProxy;

public:

  enum AccessMode {readOnly, readWrite};
  enum IsolationLevel {readUncommitted, readCommitted, repeatableRead,
                       serializable, databaseDefault};
  enum DriverPrompt {driverPromptRequest, driverComplete, driverCompleteRequired,
                     noDriverPrompt};

  IDatastoreODBC ( const char* datastoreName,
                   const char* connectString = "" );

  IDatastoreODBC();

virtual
  ~IDatastoreODBC ();                                 // Destructor

 virtual IDatastoreODBC&
   connect ();

 virtual IDatastoreODBC& connect ( const char* datastoreName );

 virtual IDatastoreODBC&
   connect ( const char* userName,
             const char* authentication);

 virtual IDatastoreODBC& connect ( const char* datastoreName,
                                   const char* userName,
                                   const char* authentication );

 virtual IDatastoreODBC& connect ( const char* datastoreName,
                                   const char* connectString,
                                   const char* userName,
                                   const char* authentication );

 virtual IDatastoreODBC&
   disconnect ();

 virtual IDatastoreODBC&
   commit ();

 virtual IDatastoreODBC&
   rollback ();

virtual IString
   connectString() const;

 virtual IDatastoreODBC&
   setConnectString(const char* aConnectString);

 virtual IDatastoreODBC&
   setUserName(const char* aUserName);

 virtual IDatastoreODBC&
   setAuthentication(const char* aAuthentication);

virtual IDatastoreODBC&
   setDatastoreName(const char* aDatastoreName);

 virtual IDatastoreODBC&
   executeSQL(const char* aCmd);

 virtual IDatastoreODBC::AccessMode
   accessMode() const;

 virtual IDatastoreODBC&
   setAccessMode(IDatastoreODBC::AccessMode option);

 virtual IBoolean
   isAutoCommit() const;

 virtual IDatastoreODBC&
   enableAutoCommit(IBoolean enable = True );

 virtual IDatastoreODBC::IsolationLevel
   isolationLevel() const;

 virtual IDatastoreODBC&
   setIsolationLevel(IDatastoreODBC::IsolationLevel option);

 virtual IDatastoreODBC::DriverPrompt
    driverPrompt() const;

 virtual IDatastoreODBC&
    setDriverPrompt(IDatastoreODBC::DriverPrompt option, IWindowHandle aHandle = IWindowHandle());

static const INotificationId connectStringId;
static const INotificationId accessModeId;
static const INotificationId autoCommitId;
static const INotificationId isolationLevelId;
static const INotificationId driverPromptId;
static const INotificationId readyId;

  virtual IDatastoreODBC& initializePart();

  IDAEnvironmentHandle environmentHandle();
  IDAConnectionHandle connectionHandle();

protected:
/*--------------------------------- PROTECTED --------------------------------*/
   Boolean makeConnections();

private:
/*--------------------------------- PRIVATE ----------------------------------*/
   IString iConnectString;
   IDatastoreODBC::AccessMode eAccessMode;
   IBoolean eAutoCommit;
   IDatastoreODBC::IsolationLevel eIsolationLevel;
   IDatastoreODBC::DriverPrompt eDriverPrompt;
   IString type();

};

#pragma pack()

#endif /* _IDSMCOD_HPP_ */
