#ifndef _IDSMCON_HPP_
#define _IDSMCON_HPP_

/*******************************************************************************
* FILE NAME: idsmcon.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*     IDatastore - Manage a datastore connection.                              *
*                                                                              *
* The IDatastore allows a client to establish and manage                       *
* datastore connection.                                                        *
*                                                                              *
*******************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#include <istring.hpp>
#include <istdntfy.hpp>
#include <idsexc.hpp>
#include <idsmcbs.hpp>

#pragma pack(4)

class DAX_IMPORTEXPORT IDatastore : public IDatastoreBase
{

public:

  IDatastore ();                                  // default Constructor

  IDatastore ( const char* datastoreName,
               const char* userName = "",
               const char* authentication = "");

virtual
  ~IDatastore ();                                 // Destructor

virtual IDatastore&
   connect ();

virtual IDatastore& connect ( const char* datastoreName,
                              const char* userName,
                              const char* authentication );

virtual IDatastore& connect ( const char* datastoreName );

virtual IDatastore&
   connect ( const char* userName,
             const char* authentication);

virtual IDatastore&
   disconnect ();

virtual IDatastore&
   commit ();

virtual IDatastore&
   rollback ();

virtual IDatastore&
   setUserName(const char* aUserName);

virtual IDatastore&
   setAuthentication(const char* aAuthentication);

virtual IDatastore&
   setDatastoreName(const char* aDatastoreName);

virtual IDatastore&
   executeSQL(const char* aCmd);

// returns true if Share Mode is Exclusive
virtual Boolean
   isShareModeExclusive ();

// enable Share Mode to Exclusive (or reset to Shared)
virtual IDatastore&
   enableShareModeExclusive(Boolean enable = true);


static const INotificationId readyId;
static const INotificationId shareModeExclusiveId;

  virtual IDatastore& initializePart();

protected:
/*--------------------------------- PROTECTED --------------------------------*/
   Boolean makeConnections();

private:
/*--------------------------------- PRIVATE ----------------------------------*/

   IString type();

};

#pragma pack()

#endif /* _IDSMCON_HPP_ */
