/****************************************************************************/
/* File:   idsstat.hpp                                                      */
/* Class:                                                                   */
/*         IDSStatement                                                     */
/*                                                                          */
/****************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#ifndef _IDSSTAT_HPP_
#define _IDSSTAT_HPP_

#include <iseq.h>
#include <istring.hpp>
#include "idsclbsq.hpp"
#include "idspmbsq.hpp"
#include "idssqlst.hpp"
#include "idaenv.hpp"

class _Export IDSStatement
{
  public:
    IDSStatement( const char* aStatement, IDatastoreDB2* aDatastore );
    IDSStatement( const char* aStatement, IDatastoreODBC* aDatastore );
    ~IDSStatement();

    virtual IDSStatement& execute() = 0;

  protected:
    IDSParameterBufferSequence parameterBuffers;
    IDSColumnBufferSequence columnBuffers;
    const IString iStatement;
    ISQLStatement* iSQLStatement;
};

#include "idsstat.inl"

#endif
