/******************************************************************************/
/* File:   idsstat.inl                                                        */
/* Class:                                                                     */
/*         IDSStatement                                                       */
/*                                                                            */
/******************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

//#include "idsstat.hpp"

/*-----------------------------------------------------------------+
|  Constructor                                                     |
+-----------------------------------------------------------------*/
inline IDSStatement::IDSStatement(const char* aStatement,
                                  IDatastoreDB2* aDatastore )
          :iStatement(aStatement),
           iSQLStatement( new ISQLStatement( aDatastore ) )
{

}

inline IDSStatement::IDSStatement(const char* aStatement,
                                  IDatastoreODBC* aDatastore )
          :iStatement(aStatement),
           iSQLStatement( new ISQLStatement( aDatastore ) )
{

}

/*-----------------------------------------------------------------+
|  Destructor                                                      |
+-----------------------------------------------------------------*/
inline IDSStatement::~IDSStatement()
{
  if (iSQLStatement != 0)
  {
   delete iSQLStatement;
  }
}
