/******************************************************************************/
/* File:   idsstre.inl                                                        */
/* Class:                                                                     */
/*         IDSStatementRetrieve                                               */
/*                                                                            */
/******************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

//#include "idsstre.hpp"

/*-----------------------------------------------------------------+
|  Constructor                                                     |
+-----------------------------------------------------------------*/
inline IDSStatementRetrieve::IDSStatementRetrieve(const char* aStatement,
                           IDatastoreDB2* aDatastore )
          :IDSStatement(aStatement,aDatastore)
{

}

inline IDSStatementRetrieve::IDSStatementRetrieve(const char* aStatement,
                           IDatastoreODBC* aDatastore )
          :IDSStatement(aStatement,aDatastore)
{

}

/*-----------------------------------------------------------------+
|  Destructor                                                      |
+-----------------------------------------------------------------*/
inline IDSStatementRetrieve::~IDSStatementRetrieve()
{

}

inline IDSStatementRetrieve&
IDSStatementRetrieve::execute()
{
    long code = 0;
    IString state("00000"); 

    parameterBuffers.bindToStatement(iSQLStatement);
    if(iSQLStatement->executeDirect(iStatement)) {
       iSQLStatement->getSuccessInfo(code, state);
    }
    columnBuffers.bindToStatement(iSQLStatement);
    if (iSQLStatement->fetch()) {
        IString strError = ClsEnv::daxMsg(DAX_MSG_OBJECT_NOT_FOUND_OR_NOT_INSERTED);
        IDADataObjectNotFound exc(strError,DAX_MSG_OBJECT_NOT_FOUND_OR_NOT_INSERTED,IException::unrecoverable, code, state);
        ITHROW (exc);
    }
    //  *** disable check for non-unique object ***
    //if (iSQLStatement->moreResults()) {
    //    IString strError = ClsEnv::daxMsg(DAX_MSG_OBJECT_NOT_UNIQUE);
    //    IDADataObjectInvalid exc(strError,DAX_MSG_OBJECT_NOT_UNIQUE,IException::unrecoverable, code, state);
    //    ITHROW (exc);
    //}
    return *this;
}
