/******************************************************************************/
/* File:   idsstup.inl                                                        */
/* Class:                                                                     */
/*         IDSStatementUpdate                                                 */
/*                                                                            */
/******************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

//#include "idsstup.hpp"

/*-----------------------------------------------------------------+
|  Constructor                                                     |
+-----------------------------------------------------------------*/
inline IDSStatementUpdate::IDSStatementUpdate(const char* aStatement,
                           IDatastoreDB2* aDatastore )
          :IDSStatement(aStatement,aDatastore)
{

}

inline IDSStatementUpdate::IDSStatementUpdate(const char* aStatement,
                           IDatastoreODBC* aDatastore )
          :IDSStatement(aStatement,aDatastore)
{

}

/*-----------------------------------------------------------------+
|  Destructor                                                      |
+-----------------------------------------------------------------*/
inline IDSStatementUpdate::~IDSStatementUpdate()
{

}

inline IDSStatementUpdate&
IDSStatementUpdate::execute()
{
    long code = 0;
    IString state("00000"); 

    parameterBuffers.bindToStatement( iSQLStatement );
    if(iSQLStatement->executeDirect(iStatement)) {
       iSQLStatement->getSuccessInfo(code, state);
    }
    switch (iSQLStatement->rowCount()) {
      case 0:
        {
          IString strError = ClsEnv::daxMsg(DAX_MSG_OBJECT_NOT_FOUND_OR_NOT_INSERTED);
          IDADataObjectNotFound exc(strError,DAX_MSG_OBJECT_NOT_FOUND_OR_NOT_INSERTED,IException::unrecoverable, code, state);
          ITHROW (exc);
        }
      case 1:
        break;  // OK
      default:
      {
          //ISQLStatement->rollback();
          IString strError = ClsEnv::daxMsg(DAX_MSG_OBJECT_NOT_UNIQUE);
          IDADataObjectInvalid exc(strError,DAX_MSG_OBJECT_NOT_UNIQUE,IException::unrecoverable, code, state);
          ITHROW (exc);
      }
    }
    return *this;
}
