/******************************************************************************/
/* File:   idstype.hpp                                                        */
/* Class:  IDSType and IDSCType                                               */
/*         and its derivates                                                  */
/*                                                                            */
/******************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#ifndef _IDSTYPE_HPP_
#define _IDSTYPE_HPP_

/*-----------------------------------------------------------------+
|  IDSType.hpp                                                     |
+------------------------------------------------------------------*/

class _Export IDSType
{
  private:
  public:
     virtual long sqlType() = 0;

};

class _Export IDSType_SQL_CHAR : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_NUMERIC : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_DECIMAL : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_INTEGER : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_SMALLINT : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_FLOAT : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_REAL : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_DOUBLE : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_DATE : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_TIME : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_TIMESTAMP : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_VARCHAR : public IDSType {public: long sqlType();};
/* SQL extended data types for DB2 CLI */
class _Export IDSType_SQL_LONGVARCHAR : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_BINARY : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_VARBINARY : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_LONGVARBINARY : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_BIGINT : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_TINYINT : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_BIT : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_GRAPHIC : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_VARGRAPHIC : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_LONGVARGRAPHIC : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_BLOB : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_CLOB : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_DBCLOB : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_BLOB_LOCATOR : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_CLOB_LOCATOR : public IDSType {public: long sqlType();};
class _Export IDSType_SQL_DBCLOB_LOCATOR : public IDSType {public: long sqlType();};

/*-----------------------------------------------------------------+
|  IDSCType.hpp                                                    |
+------------------------------------------------------------------*/

class _Export IDSCType
{
  private:
  public:
     virtual long sqlCType() = 0;

};

class _Export IDSCType_SQL_C_CHAR : public IDSCType     {public: long sqlCType();};
class _Export IDSCType_SQL_C_BIT : public IDSCType      {public: long sqlCType();};
class _Export IDSCType_SQL_C_STINYINT : public IDSCType {public: long sqlCType();};
class _Export IDSCType_SQL_C_UTINYINT : public IDSCType {public: long sqlCType();};
class _Export IDSCType_SQL_C_TINYINT : public IDSCType  {public: long sqlCType();};
class _Export IDSCType_SQL_C_SSHORT : public IDSCType   {public: long sqlCType();};
class _Export IDSCType_SQL_C_USHORT : public IDSCType   {public: long sqlCType();};
class _Export IDSCType_SQL_C_SHORT : public IDSCType    {public: long sqlCType();};
class _Export IDSCType_SQL_C_SLONG : public IDSCType    {public: long sqlCType();};
class _Export IDSCType_SQL_C_ULONG : public IDSCType    {public: long sqlCType();};
class _Export IDSCType_SQL_C_LONG : public IDSCType     {public: long sqlCType();};
class _Export IDSCType_SQL_C_FLOAT : public IDSCType    {public: long sqlCType();};
class _Export IDSCType_SQL_C_DOUBLE : public IDSCType   {public: long sqlCType();};
class _Export IDSCType_SQL_C_BINARY : public IDSCType   {public: long sqlCType();};
class _Export IDSCType_SQL_C_CLOB_LOCATOR : public IDSCType {public: long sqlCType();};
class _Export IDSCType_SQL_C_BLOB_LOCATOR : public IDSCType {public: long sqlCType();};
class _Export IDSCType_SQL_C_DBCLOB_LOCATOR : public IDSCType {public: long sqlCType();};
class _Export IDSCType_SQL_C_DBCHAR : public IDSCType   {public: long sqlCType();};

#endif
