#ifndef _IOrderedRecord_
#define _IOrderedRecord_
/*******************************************************************************
* FILE NAME: iordrrec.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*     IOrderedRecord - Base class for classes that represent records           *
*                      that have an ordering relationship.                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/
#ifndef _IRecord_
  #include <irecord.hpp>
#endif

#ifndef _ISTRING_
  #include <istring.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOV03I.LIB")
    #else
       #pragma library("CPPOV03.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWV03I.LIB")
    #else
       #pragma library("CPPWV03.LIB")
    #endif
  #endif
#endif

// Align classes on four byte boundary.
#pragma pack(4)

class IOrderedRecord : public IRecord {
/*******************************************************************************
*
* This is the base class for all records that have an ordering relationship.
* All the boolean comparison operators are defined.  See the description of
* the comparison operators for considerations for subclasses.
*
*******************************************************************************/

public:
/*------------------------- Constructors/Destructor ----------------------------
| You can contruct an instance of this class as follows:                       |
|   - Constructs an empty record of size 0.                                    |
|   - Constructs a record containing the 'recordData'.  The record size is     |
|     determined from the length of the IString.                               |
|   - Copies the record data from the argument record.                         |
|-----------------------------------------------------------------------------*/
IOrderedRecord ( );

IOrderedRecord ( const IString & recordData );

IOrderedRecord ( const IOrderedRecord & aRecord );

virtual ~IOrderedRecord ( );

/*--------------------------------- Testing ------------------------------------
| The following functions test for record properties:                          |
|   isOrdered - Returns true.                                                  |
------------------------------------------------------------------------------*/
IBoolean isOrdered ( ) const;

/*------------------------------- Comparison -----------------------------------
| All boolean operators are defined for ordered records.  The following        |
| operators are overloaded so that IOrderedRecords can be compared to IStrings |
| as well as to other IOrderedRecords.  The virtual operators are implemented  |
| as the corresponding IString operator.  The friend operators that include an |
| IString parameter are implemented as a call to the virtual operator.  The    |
| friend operators will never need to be overridden.  If needed, a subclass    |
| may implement its own version of the virtual operator.  A subclass can also  |
| use protected or private inheritance to hide these operators and then        |
| explicitly make public the operators and other functions it wishes to expose.|
|   operator == - True if and only if the records are identical.               |
|   operator != - True if and only if the records are not identical.           |
|   operator <  - True if and only if the first record is less than the        |
|                 second, when compared as IStrings.                           |
|   operator >  - Equivalent to '!(record1 <= record2)'.                       |
|   operator <= - Equivalent to '(record1 < record2) || (record1 == record2)'. |
|   operator >= - Equivalent to '!(record1 < record2)'.                        |
------------------------------------------------------------------------------*/
virtual IBoolean operator == ( const IOrderedRecord & aRecord ) const;
friend  IBoolean operator == ( const IOrderedRecord & record1,
                               const IString & record2 );
friend  IBoolean operator == ( const IString & record1,
                               const IOrderedRecord & record2 );

virtual IBoolean operator != ( const IOrderedRecord & aRecord ) const;
friend  IBoolean operator != ( const IOrderedRecord & record1,
                               const IString & record2 );
friend  IBoolean operator != ( const IString & record1,
                               const IOrderedRecord & record2 );

virtual IBoolean operator < ( const IOrderedRecord & aRecord ) const;
friend  IBoolean operator < ( const IOrderedRecord & record1,
                              const IString & record2 );
friend  IBoolean operator < ( const IString & record1,
                              const IOrderedRecord & record2 );

virtual IBoolean operator > ( const IOrderedRecord & aRecord ) const;
friend  IBoolean operator > ( const IOrderedRecord & record1,
                              const IString & record2 );
friend  IBoolean operator > ( const IString & record1,
                              const IOrderedRecord & record2 );

virtual IBoolean operator <= ( const IOrderedRecord & aRecord ) const;
friend  IBoolean operator <= ( const IOrderedRecord & record1,
                               const IString & record2 );
friend  IBoolean operator <= ( const IString & record1,
                               const IOrderedRecord & record2 );

virtual IBoolean operator >= ( const IOrderedRecord & aRecord ) const;
friend  IBoolean operator >= ( const IOrderedRecord & record1,
                               const IString & record2 );
friend  IBoolean operator >= ( const IString & record1,
                               const IOrderedRecord & record2 );

/*--------------------------- Assignment Operator ------------------------------
| The following operators allow the record's contents to be assigned from      |
| another record or an IString.                                                |
|   operator = - Replaces the contents of the record.  The target              |
|                IOrdered Record size will be the source IOrderedRecord        |
|                or IString size.                                              |
|-----------------------------------------------------------------------------*/
IOrderedRecord & operator = ( const IOrderedRecord & aRecord );
IOrderedRecord & operator = ( const IString & aRecord );

}; // IOrderedRecord

// Resume compiler default packing.
#pragma pack()

#endif // _IOrderedRecord_
