/****************************************************************************\
 *    
 * SOURCE FILE NAME: ipfx.h 
 *
 * DESCRIPTION: This is the public include file for ipf 
 *
 * COPYRIGHT =
 *   COPYRIGHT (C) SINGALAB PTE LTD 1992, 1993
 *   All Rights Reserved
 *
 ****************************************************************************/

#ifndef _IPFX_H
#define _IPFX_H

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif	/* __cplusplus */

#include <windows.h>

/****************************************************************************/
/* Help Manager Initialization Structure used on the                        */
/* XhCreateHelpInstance() call.                                             */
/****************************************************************************/

#ifndef PFUNC_TYPE
#define PFUNC_TYPE
#define PFUNC   FARPROC
#endif

   /************************************************************************/
   /* HelpSubTable entry structure                                         */
   /************************************************************************/
typedef unsigned short HELPSUBTABLE;
typedef HELPSUBTABLE FAR *PHELPSUBTABLE;

   /************************************************************************/
   /* HelpTable entry structure                                            */
   /*                                                                      */
   /************************************************************************/

typedef struct _HelpTableRec
{
      unsigned short  usTopic;
      PHELPSUBTABLE   pHelpSubTable;
      unsigned short  usExtPanel;
} HELPTABLE;
typedef HELPTABLE FAR * PHELPTABLE;

   /************************************************************************/
   /* IPF Initialization Structure used on the                             */
   /* XhCreateHelpInstance() call.                                         */
   /************************************************************************/

typedef struct _HELPINIT
{
      unsigned short usHelpTableID;
      PHELPTABLE    pHelpTable;
      HINSTANCE     hHelpTableModule;
      HINSTANCE     hAccelMenuBarModule;
      unsigned long ulAccelTable;
      unsigned long menuBarHierarchy;
      LPSTR         pszHelpWindowTitle;
      unsigned short usShowPanelId;
      LPSTR         pszHelpLibraryNames;
} HELPINIT;
typedef HELPINIT far *PHELPINIT;



/* AC Viewport stucture definitions                                       */
/**************************************************************************/
#if (!defined WIN32) && (!defined _WIN32)
typedef struct _RECTL { 
    LONG  lXLeft;
    LONG  lYBottom;
    LONG  lXRight;
    LONG  lYTop;
} RECTL;
typedef RECTL FAR * PRECTL;
#endif

/**************************************************************************/
/* Property name used to set help topic ID of a dialog box or a popup     */
/* menu which may require help from IPF.                                  */
/**************************************************************************/
#define PROP_HELP_TOPIC_ID             "PROP_HELP_TOPIC_ID"

/**************************************************************************/
/* Constants used to define the how the panel IDs are displayed on        */
/* help panels.                                                           */
/**************************************************************************/

#define CMIC_HIDE_PANEL_ID              0x0000
#define CMIC_SHOW_PANEL_ID              0x0001
#define CMIC_TOGGLE_PANEL_ID            0x0002

/**************************************************************************/
/* Type Flag for HM_DISPLAY_HELP                                          */
/**************************************************************************/
#define HM_RESOURCEID                   0x0000
#define HM_PANELNAME                    0x0001

/**************************************************************************/
/* Res number for the default push buttons                                */
/**************************************************************************/

#define CTRL_PREVIOUS_ID         0
#define CTRL_SEARCH_ID           1
#define CTRL_PRINT_ID            2
#define CTRL_INDEX_ID            3
#define CTRL_CONTENTS_ID         4
#define CTRL_BACK_ID             5
#define CTRL_FORWARD_ID          6
#define CTRL_TUTORIAL_ID         255

/**************************************************************************/
/* Help Manager message base.                                             */
/**************************************************************************/

#define HM_MSG_BASE                     WM_USER+0x0220

/**************************************************************************/
/* Messages applications can send to the Help Manager.                    */
/**************************************************************************/

#define HM_DISMISS_WINDOW               HM_MSG_BASE+0x0001
#define HM_DISPLAY_HELP                 HM_MSG_BASE+0x0002
#define HM_GENERAL_HELP                 HM_MSG_BASE+0x0003     
#define HM_EXT_HELP                     HM_GENERAL_HELP 
#define HM_SET_ACTIVE_WINDOW            HM_MSG_BASE+0x0004
#define HM_LOAD_HELP_TABLE              HM_MSG_BASE+0x0005
#define HM_CREATE_HELP_TABLE            HM_MSG_BASE+0x0006
#define HM_SET_HELP_WINDOW_TITLE        HM_MSG_BASE+0x0007
#define HM_SET_SHOW_PANEL_ID            HM_MSG_BASE+0x0008
#define HM_REPLACE_USING_HELP           HM_MSG_BASE+0x0009     
#define HM_HELP_INDEX                   HM_MSG_BASE+0x000a
#define HM_HELP_CONTENTS                HM_MSG_BASE+0x000b
#define HM_KEYS_HELP                    HM_MSG_BASE+0x000c
#define HM_SET_HELP_LIBRARY_NAME        HM_MSG_BASE+0x000d

/**************************************************************************/
/* Messages the Help Manager sends to the applications active window      */
/* as defined by the Help Manager.                                        */
/**************************************************************************/

#define HM_ERROR                        HM_MSG_BASE+0x000e
#define HM_QUERY_KEYS_HELP              HM_MSG_BASE+0x0010
#define HM_QUERY_GENERAL_HELP           HM_MSG_BASE+0x0012
#define HM_ACTIONBAR_COMMAND            HM_MSG_BASE+0x0013
#define HM_INFORM                       HM_MSG_BASE+0x0014

#define HM_SET_OBJCOM_WINDOW            HM_MSG_BASE+0x001a
#define HM_UPDATE_OBJCOM_WINDOW_CHAIN   HM_MSG_BASE+0x001b
#define HM_QUERY                        HM_MSG_BASE+0x001c
#define HM_SET_COVERPAGE_SIZE           HM_MSG_BASE+0x001d
#define HM_SET_USERDATA                 HM_MSG_BASE+0x0023
#define HM_NOTIFY                       HM_MSG_BASE+0x0024

#define HM_QUERY_DDF_DATA               HM_MSG_BASE+0x0025
#define HM_CONTROL                      HM_MSG_BASE+0x0026

#define HM_GENERAL_HELP_UNDEFINED       HM_MSG_BASE+0x0027
#define HM_EXT_HELP_UNDEFINED           HM_GENERAL_HELP_UNDEFINED

/**************************************************************************/
/*  Constants used to query the info from IPF in HM_QUERY message         */
/**************************************************************************/
#define HMQW_COVERPAGE           0x0001
#define HMQW_INDEX               0x0002
#define HMQW_TOC                 0x0003
#define HMQW_SEARCH              0x0004
#define HMQW_VIEWPAGES           0x0005
#define HMQW_LIBRARY             0x0006
#define HMQW_VIEWPORT            0x0007
#define HMQW_OBJCOM_WINDOW       0x0008
#define HMQW_INSTANCE            0x0009
#define HMQW_ACTIVEVIEWPORT      0x000a
#define CONTROL_SELECTED         0x000b
#define HELP_REQUESTED           0x000c

#define HMQW_GROUP_VIEWPORT      0x00f1
#define HMQW_RES_VIEWPORT        0x00f2
#define USERDATA                 0x00f3

/* param2 of HMQW_VIEWPORT */
#define HMQVP_NUMBER             0x0001
#define HMQVP_NAME               0x0002
#define HMQVP_GROUP              0x0003

#define HMERR_INVALID_APPL_WIDGET    1001  /* Invalid application widget */
#define HMERR_INVALID_HELP_WIDGET    1002  /* Invalid help instance widget */
#define HMERR_HELPTABLE_UNDEFINED    1003  /* Help table not defined */

#define HMERR_HELPITEM_NOT_FOUND     1005  /* Invalid help item */
#define HMERR_INVALID_HELPITEM_SIZE  1006  /* Invalid help item size */
#define HMERR_INVALID_HELPTABLE      1007  /* Invalise help table */
#define HMERR_INVALID_CONTROL_ID     1008  /* Invalid control id */
#define HMERR_INVALID_HELP_ID        1009  /* Invalid help id */

#define HMERR_INDEX_NOT_FOUND        1011  /* no index in file */
#define HMERR_CONTENT_NOT_FOUND      1012  /* no table of contents in file */
#define HMERR_LIB_FILE_NOT_FOUND     1013  /* cannot find the library file */
#define HMERR_OPEN_LIB_FILE          1014  /* can't open library file */
#define HMERR_INVALID_HELP_STRUCTURE 1015  /* invalid PHELPINIT structure */ 
#define HMERR_INVALID_PARAMETERS     1016  /* invalid parameters */
#define HMERR_INVALID_MESSAGE        1017  /* invalid message sent to IPF */
#define HMERR_READ_LIB_FILE          1018  /* error reading library file */
#define HMERR_CLOSE_LIB_FILE         1019  /* can't close library file */
#define HMERR_INVALID_LIB_FILE       1020  /* improper library file given */
#define HMERR_MEMORY_ERROR           1021  /* out of memory */
#define HMERR_PANEL_NOT_FOUND        1022  /* can't find requested panel */
                                           /* or it cannot be loaded   */
#define HMERR_RES_FILE_NOT_FOUND     1024  /* the UID file cannot be found */
#define HMERR_CLASS_REGISTER_FAIL    1025  /* error Registering IPF Class  */
#define HMERR_FONTSET_CREATION_FAIL  1026  /* error creating fonts */
#define HMERR_FREE_MEMORY            1027  /* error freeing memory */  

#define HMERR_OPEN_COPY_FILE         1031  /* error opening file for copy */
#define HMERR_READ_APPEND_FILE       1032  /* error reading file for append */
#define HMERR_WRITE_COPY_FILE        1033  /* error copying to file */
#define HMERR_INVALID_RES_FILE       1034  /* Resource file is not valid */ 

/*************************************************************************/
/* error codes returned by DDF API functions                             */
/*************************************************************************/
#define HMERR_DDF_MEMORY             2001  /* Not enough memory */
#define HMERR_DDF_ALIGN_TYPE         2002  /* Invalid alignment type */
#define HMERR_DDF_BACKCOLOR          2003  /* Invalid background color */
#define HMERR_DDF_FORECOLOR          2004  /* Invalid foreground color */
#define HMERR_DDF_FONTSTYLE          2005  /* Invalid font style */
#define HMERR_DDF_REFTYPE            2006  /* Invalid hyper text type */
#define HMERR_DDF_LIST_UNCLOSED      2007  /* List definition is not closed */
#define HMERR_DDF_LIST_UNINITIALIZED 2008  /* List definition is not ready */
#define HMERR_DDF_LIST_BREAKTYPE     2009  /* Invalid break type of list def */
#define HMERR_DDF_LIST_SPACING       2010  /* Invalid space type of list def */
#define HMERR_DDF_HINSTANCE          2011  /* Invalid help instance handle */
#define HMERR_DDF_EXCEED_MAX_LENGTH  2012  /* Buffer length is too large */
#define HMERR_DDF_EXCEED_MAX_INC     2013  /* Increment length is too large */
#define HMERR_DDF_INVALID_DDF        2014  /* Invalid DDF handle */
#define HMERR_DDF_FORMAT_TYPE        2015  /* Invalid format type */
#define HMERR_DDF_INVALID_PARM       2016  /* Invalid parameter */
#define HMERR_DDF_BITMAP             2017  /* Invalid bitmap handle */
#define HMERR_DDF_MAX_DDF_FONTS      2018  /* DDF fonts are too many */


/**************************************************************************/
/* Help API declarations                                                  */
/**************************************************************************/

long FAR PASCAL XhDestroyHelpInstance  ( HWND wndHelpInstance);
long FAR PASCAL XhCreateHelpInstance   ( HWND wndtAppl, PHELPINIT pHelpInit,
                                         HWND * wndHelpInstance);
long FAR PASCAL XhAssociateHelpInstance( HWND wndHelpInstance, HWND wndtAppl);
long FAR PASCAL XhQueryHelpInstance    ( HWND wndtAppl, HWND * wndHelpInstance);
long FAR PASCAL XhCallIPF              ( HWND wndHelpInstance,
                                         unsigned short usMsgType, 
                                         void FAR * param1, void FAR * param2);
long FAR PASCAL XhCreateHelpTable      ( HWND wndHelpInstance,
                                         PHELPTABLE pHelpTable);
long FAR PASCAL XhLoadHelpTable        ( HWND wndHelpInstance,
                                         unsigned short usHelpTableId,
                                         HMODULE hHelpModule);


/**************************************************************************/
/* AC Viewport stucture definitions                                       */
/**************************************************************************/
typedef struct _ACVP        /* acvp */
{
   unsigned long  cb;                 /* size of the structure */
   unsigned long  ObjectID;           /* object identifier */
   HWND           wgtParent;          /* IPF viewport handle */
   HWND           wgtOwner;           /* IPF main window handle */
   HWND           wgtACVP;            /* applications window hwnd */
} ACVP, far *PACVP;

/**************************************************************************/
/* DDF defines and prototypes                                             */
/**************************************************************************/
#ifndef PMDDF_H
   #define PMDDF_H
#endif

/*************************************************************************/
/* Define Handle to DDF                                                  */
/*************************************************************************/
typedef void *HDDF;

/* DdfHyperText Flags */
#define REFERENCE_BY_ID     0L
#define REFERENCE_BY_RES    1L

/* DdfBeginList formatting flags */
#define HMBT_NONE           1L
#define HMBT_ALL            2L
#define HMBT_FIT            3L

#define HMLS_SINGLELINE     1L
#define HMLS_DOUBLELINE     2L

/* DdfBitmap alignment flags */
#define ART_RUNIN           0x10L
#define ART_LEFT            0x01L
#define ART_RIGHT           0x02L
#define ART_CENTER          0x04L

/* DdfSetTextAlign align flags */
#define ALIGN_LEFT     0x01L
#define ALIGN_RIGHT    0x02L
#define ALIGN_CENTER   0x04L

/* DdfSetFontStyle font style flags */
#define FM_SEL_ITALIC       0x01L
#define FM_SEL_BOLD         0x02L
#define FM_SEL_UNDERSCORE   0x04L

/* DdfSetColor Color Flag */
#define CLR_UNCHANGED     -6
#define CLR_DEFAULT       -1
#define CLR_WHITE         0
#define CLR_BLUE          1
#define CLR_RED           2
#define CLR_PINK          3
#define CLR_GREEN         4
#define CLR_CYAN          5
#define CLR_YELLOW        6
#define CLR_BROWN         7
#define CLR_DARKGRAY      8
#define CLR_DARKBLUE      9
#define CLR_DARKRED      10
#define CLR_DARKPINK     11
#define CLR_DARKGREEN    12
#define CLR_DARKCYAN     13
#define CLR_BLACK        14
#define CLR_PALEGRAY     15


/*************************************************************************/
/* DDF API declarations.                                                 */
/*************************************************************************/

HDDF           FAR PASCAL   DdfInitialize   (HWND hwndHelpInstance,
                                             unsigned long cbBuffer,
                                             unsigned long ulIncrement);

unsigned short FAR PASCAL   DdfPara         (HDDF hDdf);

unsigned short FAR PASCAL   DdfSetFormat    (HDDF hDdf,
                                             unsigned long fFormatType);

unsigned short FAR PASCAL   DdfSetTextAlign (HDDF hDdf,
                                             unsigned long fAlign);

unsigned short FAR PASCAL   DdfSetColor     (HDDF hDdf,
                                             unsigned long fBackColor,
                                             unsigned long fForColor);

unsigned short FAR PASCAL   DdfInform       (HDDF hDdf, LPSTR pszText,
                                             unsigned long resInformNumber);

unsigned short FAR PASCAL   DdfSetFontStyle (HDDF hDdf,
                                             unsigned long fFontStyle);

unsigned short FAR PASCAL   DdfHyperText    (HDDF hDdf, LPSTR pszText,
                                             LPSTR pszReference,
                                             unsigned long fReferenceType);

unsigned short FAR PASCAL   DdfBeginList    (HDDF hDdf,
                                             unsigned long ulWidthDT,
                                             unsigned long fBreakType,
                                             unsigned long fSpacing);

unsigned short FAR PASCAL   DdfListItem     (HDDF hDdf, LPSTR pszTerm,
                                             LPSTR pszDescription); 

unsigned short FAR PASCAL   DdfEndList      (HDDF hDdf);

unsigned short FAR PASCAL   DdfText         (HDDF hDdf, LPSTR pszText);

unsigned short FAR PASCAL   DdfSetFont      (HDDF hDdf, LPSTR pszFaceName,
                                             unsigned long ulWidth,
                                             unsigned long ulHeight);

unsigned short FAR PASCAL   DdfBitmap       (HDDF hDdf, HBITMAP hbm,
                                             unsigned long fAlign);

#ifdef __cplusplus
}
#endif	/* __cplusplus */

#endif  /* _IPFX_H */

