/********************************************************************************/
/* File:  ipoatseq.hpp                                                          */
/* Class: IPOAttributeSequence                                                  */
/*                                                                              */
/* IPOAttributeSequence - a sequence of attributes                              */
/********************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#ifndef _IPOATSEQ_HPP_
#define _IPOATSEQ_HPP_

#include <ipoattr.hpp>
#include <iseq.h>

class IPOBufferSequence;

class _Export IPOAttributeSequence : protected ISequence <IPOAttributeBase*>
{
   public:
     IPOAttributeSequence();
     virtual ~IPOAttributeSequence();

/*------------------- Attribute Seq Functions ----------------------------------
| These methods deals with Attribute Seq functions:                            |
|   allocateBuffers - Allocate buffers                                         |
|   addAttribute   - add an attribute to sequence                              |
|   setIntoBuffers - set data into buffers                                     |
|   getFromBuffers - get data from buffers                                     |
------------------------------------------------------------------------------*/
     void allocateBuffers( IPOBufferSequence* pBuffers);
     void addAttribute (IPOAttributeBase* pAttribute );
     void setIntoBuffers ( IPOBufferSequence* pBuffers);
     void getFromBuffers ( IPOBufferSequence* pBuffers);

    private:
     static Boolean allocateBuffer( IPOAttributeBase*& pAttribute, void* pBuffers);
     static Boolean setIntoBuffer( IPOAttributeBase*& pAttribute, void* aCursor);
     static Boolean getFromBuffer( IPOAttributeBase*& pAttribute, void* aCursor);
};


#endif
