/********************************************************************************/
/* File:  ipobfseq.hpp                                                          */
/* Class: IPOBufferSequence                                                     */
/*                                                                              */
/* IPOBufferSequence - a sequence of buffers                                    */
/********************************************************************************/

/***********************************************

    Licensed Materials - Property of IBM

    5622-880   5801-AAR

    (c) Copyright IBM Corp 1991, 1996.

************************************************/

#ifndef _IPOBFSEQ_HPP_
#define _IPOBFSEQ_HPP_

#include "ipobuf.hpp"
#include <iseq.h>
#include "idssqlst.hpp"

class _Export IPOBufferSequence : public
                            ISequence<IPOBufferBase*>
{
   public:
     IPOBufferSequence(){;}
     virtual ~IPOBufferSequence(){allElementsDo(freeIPOBuffer);}

/*---------------------- Buffer Seq Functions ----------------------------------
| These methods deals with Buffer Seq functions:                               |
|   addBuffer - add buffer to sequence                                         |
------------------------------------------------------------------------------*/
     void addBuffer( IPOBufferBase* pBuffer)
                             {addAsLast(pBuffer);}
     virtual void bindToStatement(ISQLStatement* pSqlStatement) = 0;
   protected:
     struct statementInfo
     {
       long number;
       ISQLStatement* sqlStatement;
       statementInfo(ISQLStatement* aStatement) : number(1), sqlStatement(aStatement) {}
     };

    private:
     static Boolean freeIPOBuffer( IPOBufferBase*& pBfr, void *)
                                   {delete pBfr; return true;}

     friend class IPOAttributeSequence;
};


#endif
