#ifndef _IVBBOOL_
  #define _IVBBOOL_
/*******************************************************************************
* FILE NAME: ivbbool.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBBooleanPart - VB Boolean Part.                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBDTYPE_
  #include <ivbdtype.hpp>
#endif

#ifndef _ISTRING_
  #include <istring.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOV03I.LIB")
    #else
       #pragma library("CPPOV03.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWV03I.LIB")
    #else
       #pragma library("CPPWV03.LIB")
    #endif
  #endif
#endif


/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class IVBBooleanPart : public IVBDataTypePart
{
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------- Constructors/Destructor ----------------------------
------------------------------------------------------------------------------*/
  IVBBooleanPart (Boolean aValue = false);
  IVBBooleanPart (const IVBBooleanPart& partCopy);
virtual
  ~IVBBooleanPart ();

/*-------------------------------- Operators -----------------------------------
------------------------------------------------------------------------------*/
  IVBBooleanPart& operator= (const IVBBooleanPart& aIVBBooleanPart);
Boolean
  operator == (const IVBBooleanPart& aValue) const,
  operator != (const IVBBooleanPart& aValue) const,
  operator == (const IVBBooleanPart* aValue) const,
  operator != (const IVBBooleanPart* aValue) const;

virtual IString
  asString    ( ) const;

/*-------------------------------- Attributes ----------------------------------
| List of query and set members functions for this class:                      |
|                                                                              |
|   value             - Query the value (Boolean) attribute.                   |
|   notValue          - Query the notValue (Boolean) attribute.                |
|   valueAsText       - Query the valueAsText (IString) attribute.             |
|   notValueAsText    - Query the notValueAsText (IString) attribute.          |
|   defaultValue      - Query the defaultValue (Boolean) attribute.             |
|   isValueEqualDefault - Query the valueEqualDefault (Boolean) attribute.     |
|   isValueNotEqualDefault - Query the valueNotEqualDefault (Boolean) attribute. |
|   setValue          - Set the value (Boolean) attribute.                     |
|   setNotValue       - Set the notValue (Boolean) attribute.                  |
|   setValueAsText    - Set the valueAsText (IString) attribute.               |
|   setNotValueAsText - Set the notValueAsText (IString) attribute.            |
|   setDefaultValue   - Set the defaultValue (Boolean) attribute.              |
------------------------------------------------------------------------------*/

virtual Boolean
  value () const;
virtual IVBBooleanPart
 &setValue (Boolean value),
 &setValue ();

virtual Boolean
  notValue () const;
virtual IVBBooleanPart
 &setNotValue (Boolean notValue),
 &setNotValue ();

virtual IString
  valueAsText () const;
virtual IVBBooleanPart
 &setValueAsText (const IString& valueAsText);
virtual IVBBooleanPart
 &setValueAsText (const IString* valueAsText);

virtual IString
  notValueAsText () const;
virtual IVBBooleanPart
 &setNotValueAsText (const IString& notValueAsText);
virtual IVBBooleanPart
 &setNotValueAsText (const IString* notValueAsText);

virtual Boolean
  defaultValue () const;
virtual IVBBooleanPart
 &setDefaultValue (Boolean defaultValue = false);

virtual Boolean
  isValueEqualDefault () const;

virtual Boolean
  isValueNotEqualDefault () const;

/*-------------------------------- Actions -------------------------------------
| List of operations or services provided by this class:                       |
|                                                                              |
|   assignValueToTrue             - Assign the value attribute to true.        |
|   assignValueToFalse            - Assign the value attribute to false.       |
|   assignValueToDefault          - Assign the value attribute to false.       |
|   copyValueToDefault              - Copy value to default value.             |
|   logicalNotValue               - Perform logical negation on value.         |
|   logicalAndValue               - Perform logical and operator on value.     |
|   logicalOrValue                - Perform logical or operator on value.      |
------------------------------------------------------------------------------*/

virtual IVBBooleanPart
 &assignValueToTrue (),
 &assignValueToFalse (),
 &assignValueToDefault (),
 &copyValueToDefault (),
 &logicalNotValue (),
 &logicalAndValue (Boolean andValue),
 &logicalOrValue (Boolean orValue);

/*----------------------- Notification Event Descriptions ----------------------
| List of attribute and event notification identifiers:                        |
|                                                                              |
------------------------------------------------------------------------------*/


private:
/*--------------------------- PRIVATE ----------------------------------------*/
  Boolean iValue;                       //Data member for value attribute
  Boolean iDefaultValue;                //Data member for defaultValue attribute
  Boolean iValueEqualDefault;           //Data member for valueEqualDefault attribute
  Boolean iValueNotEqualDefault;        //Data member for valueNotEqualDefault attribute
};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
