#ifndef _IVBCEHDR_
#define _IVBCEHDR_
/*******************************************************************************
* FILE NAME: ivbcehdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IVBCnrEditHandler                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <icnrehdr.hpp>
#include <icnreevt.hpp>

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOOV3I.LIB")
    #else
       #pragma library("CPPOOV3.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWOV3I.LIB")
    #else
       #pragma library("CPPWOV3.LIB")
    #endif
  #endif
#endif

#pragma pack(4)
#ifdef IC_PMWIN
#pragma info(nocls)
#endif

class IVBCnrEditHandler : public ICnrEditHandler {
typedef IVBCnrEditHandler
   Inherited;

public:
/*-------------------------- Constructors ------------------------------------*/

/*-------------------------- Event Processing --------------------------------*/
virtual Boolean
  endEdit              ( ICnrEndEditEvent&       event);
};

#pragma pack()
#endif
