#ifndef _IVBCNR_
  #define _IVBCNR_
/*******************************************************************************
* FILE NAME: ivbcnr.h                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IVBContainerControl                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <icnrctl.hpp>

#include <icolobsv.hpp>
#include <irect.hpp>
#include <inotify.hpp>
#include <ivseq.h>
#include <iexcbase.hpp>
#include <ivbcnrob.hpp>


class IString;
class IWindowHandle;
template < class Element, class ViewClass, class Collection > class IVBContainerControlData;
template < class Element > class IVSequence;


#pragma implementation("ivbcnr.c")
#pragma pack(4)


template <class Element, class Collection, class CnrElement>
  class IVBContainerControl : public IContainerControl {

typedef IContainerControl
  Inherited;

#pragma define(ICollectionObserver<Element,IVBContainerControl<Element,Collection,CnrElement>,Collection>)

public:
/*------------------------- Constructors -------------------------------------*/
  IVBContainerControl ( unsigned long                       identifier,
                        IWindow*                            parent,
                        IWindow*                            owner,
                        const IRectangle&                   initial   =
                           IRectangle                         ( ),
                        const IContainerControl::Style&     style     =
                           IContainerControl::defaultStyle    ( ),
                        const IContainerControl::Attribute& attribute =
                           IContainerControl::defaultAttribute( ) );

  IVBContainerControl ( unsigned long                identifier,
                        IWindow*                     parent   );

  IVBContainerControl ( const IWindowHandle&         handle   );

virtual
 ~IVBContainerControl ( );

/*------------------------- Collection ---------------------------------------*/
virtual Collection
 *items                  ( ) const;

virtual IVBContainerControl<Element,Collection,CnrElement>
 &setItems               ( Collection* collection );

/*------------------------- Collection-Reporting Protocol --------------------*/
virtual IVBContainerControl<Element,Collection,CnrElement>
 &elementChanged         ( unsigned long   position,
                           const Element&  element  ),
 &elementAdded           ( unsigned long   position,
                           const Element&  element  ),
 &elementDeleted         ( unsigned long   position ),
 &elementsChanged        ( ),
 &collectionReplaced     ( );

/*------------------------- Removing Objects ---------------------------------*/
virtual IVBContainerControl<Element,Collection,CnrElement>
 &removeSelectedElements     ( const Boolean deleteElements = true ),
 &removeButton2Elements      ( const Boolean deleteElements = true ),
 &removeAllElements          ( const Boolean deleteElements = true );

/*------------------------- Selection ----------------------------------------*/
static const unsigned long
  noSelection;

virtual IVBContainerControl<Element,Collection,CnrElement>
 &select                      ( unsigned long   collectionPosition,
                                Boolean         select = true ),
 &deselect                    ( unsigned long   collectionPosition );

virtual Element
  selectedElement             ( ),
  button2Element              ( ),
  cursoredElement             ( );

virtual CnrElement
 *selectedCnrObject           ( );

virtual unsigned long
  selectedCollectionPosition  ( ),
  button2CollectionPosition   ( ),
  cursoredCollectionPosition  ( );

virtual IVSequence<Element>
 *selectedElements            ( ),
 *selectedElements            ( IVSequence<Element> & aSequence),           //compatibility
 *selectedElements            ( IVSequence<Element> * aSequence),
 *button2Elements             ( );

virtual IVSequence<unsigned long>
 *selectedCollectionPositions ( ),
 *selectedCollectionPositions ( IVSequence<unsigned long> * aSequence ),
 *button2CollectionPositions  ( );

virtual IVSequence<IContainerObject *>
 *selectedCnrObjects          ( ),
 *selectedCnrObjects          ( IVSequence<IContainerObject *> & cnrObjects ),   //compatibility
 *selectedCnrObjects          ( IVSequence<IContainerObject *> * cnrObjects ),
 *button2CnrObjects           ( );

unsigned long
  numberOfSelections          ( ) const,
  numberOfButton2Objects       ( ) const;

virtual IVBContainerControl<Element,Collection,CnrElement>
 &setButton2Point(const IPoint & aPoint);

virtual IPoint
 button2Point() const;

/*------------------------- Notification Members -----------------------------*/
static INotificationId const
  button2PointId,
  itemChangedId,
  itemsId;

private:
/*------------------------- Hidden Members -----------------------------------*/
  IVBContainerControl
             ( const IVBContainerControl< Element,Collection,CnrElement >& source );
IVBContainerControl<Element,Collection,CnrElement>
 &operator=  ( const IVBContainerControl< Element,Collection,CnrElement >& source );

/*------------------------- Private ------------------------------------------*/
IVBContainerControlData< Element,
                         IVBContainerControl<Element,Collection,CnrElement>,
                         Collection>
 *fVBContainerControlData;

void
  initialize ( );

static const unsigned long
  firstItem;

}; // IVBContainerControl<Element,Collection,CnrElement>


#if ! defined (__TEMPINC__)
#include <ivbcnr.c>
#endif

#pragma pack()

#endif  /*  _IVBCNR_  */
