#ifndef _IVBCONN_
  #define _IVBCONN_
/*******************************************************************************
* FILE NAME: ivbconn.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBConnection - VB variable class base.                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
*******************************************************************************/
#ifndef _IVBDEFS__
#include <ivbdefs.h>
#endif

#ifndef _IOBSERVR_
  #include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
  #include <istdntfy.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOOV3I.LIB")
    #else
       #pragma library("CPPOOV3.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWOV3I.LIB")
    #else
       #pragma library("CPPWOV3.LIB")
    #endif
  #endif
#endif

/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class IVBConnection : public IObserver {
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------ Constructors ----------------------------------------
| You can construct an instance of this class in the following ways:           |
------------------------------------------------------------------------------*/
  IVBConnection ();
virtual
  ~IVBConnection ();

/*---------------------------- Enumerations ----------------------------------*/
enum Process {
  terminated = -3,
  uninitialize = -2,
  disabled = -1,
  normal = 0,
  skip = 0,
  sourceChanged,
  targetChanged
};

virtual IString
  asString() const,
  asDebugInfo () const;

/*---------------------------- Member Functions --------------------------------
| These operations can be used to query and change the attributes:             |
|                                                                              |
|   initialize         - Initialize the connection.                            |
|   perform            - Perform the connection.                               |
|   terminate          - Terminate the connection.                             |
------------------------------------------------------------------------------*/
virtual void
  initialize               (),
  perform                  (const INotificationEvent& anEvent),
  terminate                ();

virtual int
  checkEvent               (const INotificationEvent& event) const;
virtual int
  handleException          (const INotificationEvent& event, const IException& exc);

/*-------------------------------- Events --------------------------------------
| These are notification events provided:                                      |
|   exceptionId       - exception occurred id.                                 |
|   actionResultId    - action result changed id.                              |
------------------------------------------------------------------------------*/
static INotificationId const
  IVB_IMPORT exceptionId,
  IVB_IMPORT actionResultId;

static Boolean
  isApplicationConnectionTrace(),
  isApplicationExceptionBeep(),
  isApplicationExceptionMessageBox();
  isApplicationExceptionTrace();

static void
  enableApplicationConnectionTrace(Boolean connectionTrace = true),
  enableApplicationExceptionBeep(Boolean exceptionTrace = true),
  enableApplicationExceptionMessageBox(Boolean exceptionTrace = true),
  enableApplicationExceptionTrace(Boolean exceptionTrace = true);

protected:
virtual IObserver
 &dispatchNotificationEvent(const INotificationEvent& event);

  Process iStatus;
static int flags;
};

class IVBConnectionPart : public IVBConnection, public IStandardNotifier {
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------ Constructors ----------------------------------------
| You can construct an instance of this class in the following ways:           |
------------------------------------------------------------------------------*/
  IVBConnectionPart ();
virtual
  ~IVBConnectionPart ();

/*-------------------------------- Attributes ----------------------------------
| These operations can be used to query and change the attributes:             |
|                                                                              |
|   initialize         - Initialize the connection.                            |
------------------------------------------------------------------------------*/
virtual void
  initialize               ();

virtual int
  handleException          (const INotificationEvent& event, const IException& exc);
};

class IVBActionConnection : public IVBConnection {
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------ Constructors ----------------------------------------
| You can construct an instance of this class in the following ways:           |
------------------------------------------------------------------------------*/
  IVBActionConnection (INotifier* aSource);
virtual
  ~IVBActionConnection ();

/*-------------------------------- Attributes ----------------------------------
| These operations can be used to query and change the attributes:             |
|                                                                              |
|   terminate          - Terminate the connection.                             |
------------------------------------------------------------------------------*/
virtual void
  terminate                ();

protected:
  INotifier* source;
};

class IVBActionConnectionPart : public IVBActionConnection, public IStandardNotifier {
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------ Constructors ----------------------------------------
| You can construct an instance of this class in the following ways:           |
------------------------------------------------------------------------------*/
  IVBActionConnectionPart (INotifier* aSource);
virtual
  ~IVBActionConnectionPart ();

/*-------------------------------- Actions    ----------------------------------
| These operations can be used to query and change the attributes:             |
|                                                                              |
|   initialize         - Initialize the connection.                            |
------------------------------------------------------------------------------*/
virtual void
  initialize               ();
void
  notifyActionResult       ();

virtual int
  handleException          (const INotificationEvent& event, const IException& exc);
};

class IVBCustomLogicConnection : public IVBConnection {
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------ Constructors ----------------------------------------
| You can construct an instance of this class in the following ways:           |
------------------------------------------------------------------------------*/
  IVBCustomLogicConnection ();
virtual
  ~IVBCustomLogicConnection ();
};

class IVBCustomLogicConnectionPart : public IVBCustomLogicConnection, public IStandardNotifier {
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------ Constructors ----------------------------------------
| You can construct an instance of this class in the following ways:           |
------------------------------------------------------------------------------*/
  IVBCustomLogicConnectionPart ();
virtual
  ~IVBCustomLogicConnectionPart ();

/*-------------------------------- Attributes ----------------------------------
| These operations can be used to query and change the attributes:             |
|                                                                              |
|   initialize         - Initialize the connection.                            |
------------------------------------------------------------------------------*/
virtual void
  initialize               ();

virtual int
  handleException          (const INotificationEvent& event, const IException& exc);
};

class IVBAttributeConnection : public IVBConnection {
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------ Constructors ----------------------------------------
| You can construct an instance of this class in the following ways:           |
------------------------------------------------------------------------------*/
  IVBAttributeConnection ();
virtual
  ~IVBAttributeConnection ();

/*--------------------------- Member Functions ---------------------------------
| These operations can be used to query and change the attributes:             |
|                                                                              |
|   initializeConnection - Initialize the connection.                          |
------------------------------------------------------------------------------*/
virtual void
  initialize               (),
  setSource                (),
  performSetSource         (),
  setTarget                (),
  performSetTarget         ();

virtual int
  handleSourceException    (const IException& exc),
  handleTargetException    (const IException& exc);

/*-------------------------------- Events --------------------------------------
| These are notification events provided:                                      |
|   sourceExceptionId - source exception occurred id.                          |
|   targetExceptionId - source exception occurred id.                          |
------------------------------------------------------------------------------*/
static INotificationId const
  IVB_IMPORT sourceExceptionId,
  IVB_IMPORT targetExceptionId;

protected:
virtual IObserver
 &dispatchNotificationEvent(const INotificationEvent& event);
};

class IVBAttributeConnectionPart : public IVBAttributeConnection,
                                   public IStandardNotifier {
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------ Constructors ----------------------------------------
| You can construct an instance of this class in the following ways:           |
------------------------------------------------------------------------------*/
  IVBAttributeConnectionPart ();
virtual
  ~IVBAttributeConnectionPart ();

/*-------------------------------- Attributes ----------------------------------
| These operations can be used to query and change the attributes:             |
|                                                                              |
|   initialize         - Initialize the connection.                            |
|   terminate          - Terminate the connection.                             |
------------------------------------------------------------------------------*/
virtual void
  initialize               (),
  terminate                ();

virtual int
  handleSourceException    (const IException& exc),
  handleTargetException    (const IException& exc);
};


class IVBConnectionDataList;
typedef IVBConnection*
  IVBConnectionPtr;

class _Export IVBConnectionList : public IVBase {
public:

/*---------------------------- Constructors ----------------------------------*/
  IVBConnectionList     ( );
virtual
 ~IVBConnectionList     ( );

class _Export Cursor : public IVBase {
public:
/*---------------------------- Constructors ----------------------------------*/
  Cursor ( IVBConnectionList& connectionList );
virtual
 ~Cursor ( );

/*-------------------------- Cursor Movement ---------------------------------*/
virtual Boolean
  setToFirst      ( ),
  setToNext       ( ),
  setToLast       ( ),
  setToPrevious   ( ),
  isValid         ( ) const;

virtual void
  invalidate      ( );

private:
/*--------------------------------- Private ----------------------------------*/
friend class IVBConnectionList;
void
 *fCursor;
}; //Cursor

friend class IVBConnectionList::Cursor;

/*---------------------- connection Addition and Removal -----------------------*/
virtual IVBConnection
 &elementAt       (const Cursor& cursor) const;

virtual IVBConnectionList
 &add             (IVBConnection& connection),
 &add             (IVBConnection* connection),
 &removeAt        (const Cursor& cursor),
 &remove          (const IVBConnection& connection),
 &removeAll       ();

Boolean
  isEmpty          () const;
unsigned long
  numberOfElements () const;

virtual IVBConnectionList
 &initialize       (),
 &terminate        ();

private:
/*--------------------------------- Private ----------------------------------*/
IVBConnectionDataList
  *fConnectionDataList;
/*----------------------------- Hidden Functions -----------------------------*/
IVBConnectionList ( const IVBConnectionList& connectionList );
IVBConnectionList
 &operator= (const IVBConnectionList& connectionList);

}; //IVBConnectionList

class IVBFactoryPart : public IStandardNotifier {
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------ Constructors ----------------------------------------
| You can construct an instance of this class in the following ways:           |
------------------------------------------------------------------------------*/
  IVBFactoryPart ();
virtual
  ~IVBFactoryPart ();
/*-------------------------------- Events --------------------------------------
| These are notification events provided:                                      |
|     newObjectCreatedId  - new object created id.                             |
------------------------------------------------------------------------------*/
static INotificationId const
  IVB_IMPORT newObjectCreatedId;
};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif /* _IVBCONN_ */
