#ifndef _IVBDBL_
  #define _IVBDBL_
/*******************************************************************************
* FILE NAME: ivbdbl.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*    IVBDoublePart - IBM VB sample Double part.                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM(R) VisualAge(TM) for C++                                               *
*   (C) Copyright International Business Machines Corporation 1991, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*   This program will not run in DOS mode.                                     *
*                                                                              *
* DISCLAIMER OF WARRANTIES:                                                    *
*   The following [enclosed] code is sample code created by IBM                *
*   Corporation.  This sample code is not part of any standard IBM product     *
*   and is provided to you solely for the purpose of assisting you in the      *
*   development of your applications.  The code is provided "AS IS",           *
*   without warranty of any kind.  IBM shall not be liable for any damages     *
*   arising out of your use of the sample code, even if they have been         *
*   advised of the possibility of such damages.                                *
*******************************************************************************/

#ifndef _IVBDTYPE_
  #include <ivbdtype.hpp>
#endif

  #include <float.h>

#ifndef _ISTRING_
  #include <istring.hpp>
#endif

/*-------------------------- Pragma Library Support --------------------------*/
#ifndef __NO_DEFAULT_LIBS__
  #ifdef __OS2__
    #ifdef __IMPORTLIB__
       #pragma library("CPPOV03I.LIB")
    #else
       #pragma library("CPPOV03.LIB")
    #endif
  #endif
  #ifdef __WINDOWS__
    #ifdef __IMPORTLIB__
       #pragma library("CPPWV03I.LIB")
    #else
       #pragma library("CPPWV03.LIB")
    #endif
  #endif
#endif


/*----------------------------------------------------------------------------*/
/* Align classes on four byte boundary.                                       */
/*----------------------------------------------------------------------------*/
#pragma pack(4)

class IVBDoublePart : public IVBDataTypePart
{
public:
/*--------------------------- PUBLIC -----------------------------------------*/

/*------------------------- Constructors/Destructor ----------------------------
------------------------------------------------------------------------------*/
  IVBDoublePart (double value = 0.0);
  IVBDoublePart (const IVBDoublePart& partCopy);
virtual
  ~IVBDoublePart ();

/*-------------------------------- Operators -----------------------------------
|   operator ==       - Operator == (return true if equal).                    |
|   operator !=       - Operator != (return true if not equal).                |
------------------------------------------------------------------------------*/
  IVBDoublePart& operator= (const IVBDoublePart& aIVBDoublePart);
Boolean
  operator == (const IVBDoublePart& aValue) const,
  operator != (const IVBDoublePart& aValue) const,
  operator == (const IVBDoublePart* aValue) const,
  operator != (const IVBDoublePart* aValue) const;

virtual IString
  asString    ( ) const;

/*-------------------------------- Attributes ----------------------------------
| List of query and set members functions for this class:                      |
|                                                                              |
|   value             - Query the value (double) attribute.                    |
|   valueAsText       - Query the valueAsText (IString) attribute.             |
|   valueAs1Based     - Query the valueAs1Based (double) attribute.             |
|   defaultValue      - Query the defaultValue (double) attribute.             |
|   isValueEqualDefault - Query the valueEqualDefault (Boolean) attribute.     |
|   isValueNotEqualDefault - Query the valueNotEqualDefault (Boolean) attribute. |
|   lowLimit          - Query the lowLimit (double) attribute.                 |
|   highLimit         - Query the highLimit (double) attribute.                |
|   isValueEqualLowLimit - Query the valueEqualLowLimit (Boolean) attribute.   |
|   isValueEqualHighLimit - Query the valueEqualHighLimit (Boolean) attribute. |
|   isValueBelowLowLimit - Query the valueBelowLowLimit (Boolean) attribute.   |
|   isValueAboveHighLimit - Query the valueAboveHighLimit (Boolean) attribute. |
|   isValueOutsideLimits - Query the valueOutsideLimits (Boolean) attribute.   |
|   isValueWithinLimits - Query the valueWithinLimits (Boolean) attribute.     |
|   isValueNotZero    - Query the valueNotZero (Boolean) attribute.            |
|   isValueZero       - Query the valueZero (Boolean) attribute.               |
|   isValuePositive   - Query the valuePositive (Boolean) attribute.           |
|   isValueNegative   - Query the valueNegative (Boolean) attribute.           |
|   setValue          - Set the value (double) attribute.                      |
|   setValueAsText    - Set the valueAsText (IString) attribute.               |
|   setValueAs1Based  - Set the valueAs1Based (double) attribute.              |
|   setDefaultValue   - Set the defaultValue (double) attribute.               |
|   setLowLimit       - Set the lowLimit (double) attribute.                   |
|   setHighLimit      - Set the highLimit (double) attribute.                  |
------------------------------------------------------------------------------*/

virtual double
  value () const;
virtual IVBDoublePart
 &setValue (double aValue),
 &setValue ();

virtual IString
  valueAsText () const;
virtual IVBDoublePart
 &setValueAsText (const IString& valueAsText),
 &setValueAsText (const IString* valueAsText);

virtual double
  valueAs1Based () const;
virtual IVBDoublePart
 &setValueAs1Based (double valueAs1Based);

virtual double
  defaultValue () const;
virtual IVBDoublePart
 &setDefaultValue (double defaultValue = 0);

virtual Boolean
  isValueEqualDefault () const;

virtual Boolean
  isValueNotEqualDefault () const;

virtual double
  lowLimit () const;
virtual IVBDoublePart
 &setLowLimit (double aLowLimit = DBL_MIN);

virtual double
  highLimit () const;
virtual IVBDoublePart
 &setHighLimit (double highLimit = DBL_MAX);

virtual Boolean
  isValueEqualLowLimit () const;

virtual Boolean
  isValueEqualHighLimit () const;

virtual Boolean
  isValueBelowLowLimit () const;

virtual Boolean
  isValueAboveHighLimit () const;

virtual Boolean
  isValueOutsideLimits () const;

virtual Boolean
  isValueWithinLimits () const;

virtual Boolean
  isValueNotZero () const;

virtual Boolean
  isValueZero () const;

virtual Boolean
  isValuePositive () const;

virtual Boolean
  isValueNegative () const;

/*-------------------------------- Actions -------------------------------------
| List of operations or services provided by this class:                       |
|                                                                              |
|   assignValueToZero               - Assign value attribute to 0 (false). |
|   assignValueToOne                - Assign value attribute to 1 (true).      |
|   assignValueToLowLimit           - Assign value attribute to low limit. |
|   assignValueToHighLimit          - Assign value attribute to high limit |
|   assignValueToDefault            - Assign the value attribute to false. |
|   assignValueToRandom             - Assign value to pseudo-random number |
|   copyValueToDefault              - Copy value to default value.             |
|   assignValueToPI                 - Assign value attribute to PI.            |
|   assignValueToE                  - Assign value attribute to e.             |
|   ceilValue                       - Perform ceil function on value.          |
|   floorValue                      - Perform floor function on value.         |
|   squareValue                     - Square the value attribute.              |
|   addValue                        - Perform add operator on value.           |
|   subractValue                    - Perform subract operator on value.       |
|   divideValue                     - Perform divide operator on value.        |
|   multiplyValue                   - Perform multiply operator on value.      |
------------------------------------------------------------------------------*/

virtual IVBDoublePart
 &assignValueToZero (),
 &assignValueToOne (),
 &assignValueToLowLimit (),
 &assignValueToHighLimit (),
 &assignValueToDefault (),
 &assignValueToRandom (),
 &copyValueToDefault (),
 &assignValueToPI (),
 &assignValueToE (),
 &ceilValue (),
 &floorValue (),
 &squareValue (),
 &addValue (double addValue = 1),
 &subtractValue (double subtractValue = 1),
 &multiplyValue (double multiplyValue = 2),
 &divideValue (double divideValue = 2);

/*----------------------- Notification Event Descriptions ----------------------
| List of attribute and event notification identifiers:                        |
|                                                                              |
------------------------------------------------------------------------------*/


private:
/*--------------------------- PRIVATE ----------------------------------------*/
  double iValue;                        //Data member for value attribute
  double iDefaultValue;                 //Data member for defaultValue attribute
  double iLowLimit;                     //Data member for lowLimit attribute
  double iHighLimit;                    //Data member for highLimit attribute
};

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif
